/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.refactor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import oracle.dbtools.app.Format;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.arbori.Replacements;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.refactor.Messages;
import oracle.dbtools.raptor.refactor.UndoableRefactoring;
import oracle.dbtools.util.Service;
import oracle.ide.Context;
import oracle.javatools.dialogs.MessageDialog;

public class Extractor
extends UndoableRefactoring {
    String name;
    boolean isLocal = false;
    boolean namedArguments = false;
    int start;
    int end;
    public int startOffset;
    public int endOffset;
    public boolean startEqEnd;
    private boolean debug = false;
    Map<ParseNode, ParseNode> expr2block = new TreeMap<ParseNode, ParseNode>();
    ParseNode block = null;
    ParseNode stmt1 = null;
    ParseNode stmt2 = null;
    Map<ParseNode, ParseNode> id2type = new TreeMap<ParseNode, ParseNode>();
    boolean isBody = false;
    Set<ParseNode> caseReturns = new HashSet<ParseNode>();
    Set<ParseNode> usedAfter = new TreeSet<ParseNode>();

    public Extractor(Context context) {
        super(context);
    }

    public Extractor(String string, List<LexerToken> list, ParseNode parseNode) {
        super(string, list, parseNode);
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        String string = Service.readFile(Extractor.class, (String)"test_extr.sql");
        boolean bl = 10000 < string.length();
        int n2 = string.indexOf("!");
        if (n2 != (n = string.lastIndexOf("!"))) {
            --n;
        }
        string = string.replace("!", "");
        SqlEarley.visualize = false;
        if (!bl) {
            SqlEarley.main((String[])new String[]{string});
        }
        Program.timing = bl;
        Parsed parsed = new Parsed(string, (Earley)SqlEarley.getInstance(), "sql_statements");
        Extractor extractor = new Extractor(string, parsed.getSrc(), parsed.getRoot());
        extractor.debug = true;
        Replacements replacements = extractor.runProgram(n2, n, "newVarX");
        if (replacements == null) {
            return;
        }
        System.out.println(replacements.apply());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Replacements runProgram(int n, int n2, Object object) {
        this.startOffset = LexerToken.scanner2parserOffset((List)this.src, (int)n);
        this.endOffset = LexerToken.scanner2parserOffset((List)this.src, (int)n2);
        this.startEqEnd = this.startOffset == this.endOffset;
        try {
            new SqlProgram(Extractor.class, "extractor.arbori", (Object)this).eval(new Parsed(this.text, this.src, this.root));
        }
        catch (SyntaxError syntaxError) {
            throw syntaxError;
        }
        catch (AssertionError assertionError) {
            System.err.println(((Throwable)((Object)assertionError)).getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.stmt1 == null && !this.isSeqOfStmts() && !this.isExpr()) {
            MessageDialog.information(null, (Object)Messages.getString("NeitherExprNorStmts"), (String)Messages.getString("ErrorTitle"), null);
            return null;
        }
        String string = (String)object;
        if (string == null) {
            string = this.nameDialog();
        }
        if (string == null) {
            return null;
        }
        Replacements replacements = new Replacements(this.text);
        ParseNode parseNode = null;
        ParseNode parseNode2 = null;
        for (ParseNode parseNode3 : this.expr2block.keySet()) {
            parseNode = this.expr2block.get(parseNode3);
            if (parseNode2 == null) {
                parseNode2 = parseNode3;
            }
            int n3 = parseNode3.from;
            int n4 = parseNode3.to - 1;
            if (parseNode3.contains("subquery")) {
                --n3;
                ++n4;
            }
            replacements.put(((LexerToken)this.src.get((int)n3)).begin, ((LexerToken)this.src.get((int)n4)).end, string + this.signature(false, false, false));
        }
        if (parseNode == null) {
            parseNode = this.block;
            replacements.put(((LexerToken)this.src.get((int)this.stmt1.from)).begin, ((LexerToken)this.src.get((int)(this.stmt2.to - 1))).end, string + this.signature(false, false, false) + ';');
        }
        String string2 = this.isExpr() ? this.newVarFuncDef(string, parseNode2) : this.newProcDef(string);
        this.addDeclaration(parseNode, string2, replacements);
        return replacements;
    }

    private boolean isExpr() {
        return 0 < this.expr2block.size();
    }

    private boolean isSeqOfStmts() {
        if (this.stmt1 == null) {
            return false;
        }
        return this.stmt2 != null;
    }

    private void addDeclaration(ParseNode parseNode, String string, Replacements replacements) {
        Object object;
        int n = parseNode.from;
        if (parseNode.contains("subprg_body")) {
            object = parseNode.children().iterator();
            while (object.hasNext()) {
                ParseNode parseNode2 = (ParseNode)object.next();
                if (!parseNode2.contains("'BEGIN'")) continue;
                n = parseNode2.from - 1;
            }
        }
        if ("declare".equals(object = ((LexerToken)this.src.get((int)n)).content.toLowerCase()) || parseNode.contains("subprg_body")) {
            for (ParseNode parseNode3 : parseNode.children()) {
                if (!parseNode3.contains("'BEGIN'")) continue;
                n = parseNode3.from;
                break;
            }
            if (this.isBody) {
                n = parseNode.to;
            }
            replacements.put(((LexerToken)this.src.get((int)n)).begin, ((LexerToken)this.src.get((int)n)).begin, "\n" + string + "\n");
        } else if (parseNode.contains("sql_stmt")) {
            replacements.put(((LexerToken)this.src.get((int)n)).begin, ((LexerToken)this.src.get((int)n)).begin, "with " + string + "\n");
        } else {
            replacements.put(((LexerToken)this.src.get((int)n)).begin, ((LexerToken)this.src.get((int)n)).begin, "declare\n" + string + "\n");
        }
    }

    private String newVarFuncDef(String string, ParseNode parseNode) {
        int n = ((LexerToken)this.src.get((int)parseNode.from)).begin;
        int n2 = ((LexerToken)this.src.get((int)(parseNode.to - 1))).end;
        String string2 = "";
        for (int i = 0; i < (Integer)Format.options.get(Format.identSpaces); ++i) {
            string2 = string2 + " ";
        }
        if (this.id2type.size() == 0) {
            if (parseNode.contains("subquery")) {
                return string + " as (\n" + string2 + this.text.substring(n, n2) + "\n)";
            }
            return string2 + "--refactored variable\n" + string2 + string + " " + this.expressionType(parseNode, false) + " := " + this.text.substring(n, n2) + ";";
        }
        return string2 + "--refactored function\n" + string2 + "function " + string + this.signature(true, true, false) + " return " + this.expressionType(parseNode, true) + " is\n" + string2 + "begin\n" + string2 + string2 + "return " + this.text.substring(n, n2) + ";\n" + string2 + "end " + string + ";";
    }

    private String newProcDef(String string) {
        int n = ((LexerToken)this.src.get((int)this.stmt1.from)).begin;
        int n2 = ((LexerToken)this.src.get((int)this.stmt2.to)).begin;
        String string2 = "";
        for (int i = 0; i < (Integer)Format.options.get(Format.identSpaces); ++i) {
            string2 = string2 + " ";
        }
        return string2 + "--refactored procedure\n" + string2 + "procedure " + string + this.signature(true, true, true) + " is\n" + string2 + "begin\n" + string2 + string2 + this.text.substring(n, n2) + "\n" + string2 + "end " + string + ";";
    }

    private String nameDialog() {
        String string = Messages.getString("VariableName");
        if (this.isExpr() && 0 < this.id2type.size()) {
            string = Messages.getString("FunctionName");
        }
        if (this.isSeqOfStmts()) {
            string = Messages.getString("ProcedureName");
        }
        for (ParseNode parseNode : this.expr2block.keySet()) {
            if (!parseNode.contains("subquery")) continue;
            string = Messages.getString("CTEName");
            break;
        }
        return JOptionPane.showInputDialog(null, string, Messages.getString(this.isSeqOfStmts() ? "NameStmtsDialogTitle" : "NameExprDialogTitle"), -1);
    }

    private String signature(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        HashSet<String> hashSet = new HashSet<String>();
        for (ParseNode parseNode : this.id2type.keySet()) {
            String string = parseNode.content(this.src);
            if (hashSet.contains(string)) continue;
            if (0 < ++n) {
                stringBuilder.append(", ");
            }
            hashSet.add(string);
            stringBuilder.append(string);
            if (!bl) continue;
            if (bl2) {
                stringBuilder.append(" IN");
            }
            if (bl3 && this.usedAfter.contains(parseNode)) {
                stringBuilder.append(" OUT");
            }
            stringBuilder.append(" ");
            String string2 = this.id2type.get(parseNode).content(this.src);
            stringBuilder.append(this.abbreviatedType(string2));
        }
        if (0 < stringBuilder.length()) {
            return "(" + stringBuilder.toString() + ")";
        }
        return "";
    }

    String abbreviatedType(String string) {
        int n = string.indexOf(40);
        if (0 < n) {
            string = string.substring(0, n);
        }
        return string;
    }

    String adjustedType(String string, boolean bl) {
        if (bl) {
            return this.abbreviatedType(string);
        }
        return string;
    }

    String expressionType(ParseNode parseNode, boolean bl) {
        ParseNode parseNode2 = this.id2type.get(parseNode);
        if (parseNode2 != null) {
            return this.adjustedType(parseNode2.content(this.src), bl);
        }
        if (parseNode.contains("case_expr")) {
            for (ParseNode parseNode3 : this.caseReturns) {
                String string = this.expressionType(parseNode3, bl);
                if (string.contains("/*?*/")) continue;
                return string;
            }
        }
        if (parseNode.from + 1 == parseNode.to) {
            Iterator<Object> iterator = (LexerToken)this.src.get(parseNode.from);
            if (((LexerToken)iterator).type == Token.DIGITS) {
                return "number";
            }
            if (((LexerToken)iterator).type == Token.QUOTED_STRING) {
                return this.adjustedType("varchar2(2000)", bl);
            }
        }
        for (ParseNode parseNode3 : parseNode.children()) {
            if (parseNode3.contains("'+'") || parseNode3.contains("'-'") || parseNode3.contains("'*'") || parseNode3.contains("'/'")) {
                return "number";
            }
            if (parseNode3.contains("relal_op_sim_expr_opt") || parseNode3.contains("'OR'") || parseNode3.contains("'AND'") || parseNode3.contains("'NOT'")) {
                return "boolean";
            }
            if (!parseNode3.contains("binary_add_op")) continue;
            return this.adjustedType("varchar2(2000)", bl);
        }
        return this.adjustedType("varchar2/*?*/(2000)", bl);
    }

    public void maxExprAtCursor(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println(MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
    }

    public void matchingExpressions(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println(MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        ParseNode parseNode = map.get("expr");
        ParseNode parseNode2 = map.get("block");
        this.expr2block.put(parseNode, parseNode2);
    }

    public void statements(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println(MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        this.block = map.get("block");
        this.stmt1 = map.get("stmt1");
        this.stmt2 = map.get("stmt2");
    }

    public void stmtsVars(Parsed parsed, Map<String, ParseNode> map) {
        if (this.isExpr()) {
            return;
        }
        this.variables(parsed, map);
    }

    public void exprVars(Parsed parsed, Map<String, ParseNode> map) {
        this.variables(parsed, map);
    }

    private void variables(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println(MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        ParseNode parseNode = map.get("id");
        ParseNode parseNode2 = map.get("did^");
        ParseNode parseNode3 = null;
        for (ParseNode parseNode4 : parseNode2.children()) {
            ParseNode parseNode5;
            Iterator iterator;
            if (parseNode4.contains("unconstrained_type") || parseNode4.contains("constrained_type")) {
                parseNode3 = parseNode4;
            }
            if (!parseNode4.contains("object_d_rhs") || !(iterator = parseNode4.children().iterator()).hasNext()) continue;
            parseNode3 = parseNode5 = (ParseNode)iterator.next();
            break;
        }
        this.id2type.put(parseNode, parseNode3);
    }

    public void inPkgBody(Parsed parsed, Map<String, ParseNode> map) {
        this.isBody = true;
    }

    public void caseExprType(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println(MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        ParseNode parseNode = map.get("ret");
        this.caseReturns.add(parseNode);
    }

    public void usedAfter(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("*** " + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        ParseNode parseNode = map.get("id");
        this.usedAfter.add(parseNode);
    }
}

