/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.sftp.SftpLogger;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rt.json.JSONToMap;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.file.FileSet;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleStorageCloudService;
import oracle.dbtools.transfer.task.TransferTask;
import oracle.dbtools.util.Encryption;
import oracle.ide.Ide;
import oracle.javatools.util.ModelUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class SftpUtil {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpUtil.class.getName());
    boolean completed = false;
    int _timeout = 60000;
    boolean transferTaskDone = false;

    private static Map<String, String> getResults(HttpEntity httpEntity) {
        try {
            Map map = JSONToMap.read((InputStream)httpEntity.getContent());
            return map;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean SftpPut(SftpParms sftpParms, boolean bl) {
        File file = new File(sftpParms.getLocalFile());
        if (this.SftpPut(sftpParms)) {
            if (bl) {
                try {
                    this.createDeploymentRow(sftpParms, "DEPLOY", String.valueOf(file.length()));
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void createDeploymentRow(final SftpParms sftpParms, String string, String string2) throws Exception {
        if (!SftpUtil.isSchemaServiceConnection(sftpParms.getCloudConnectionName())) {
            return;
        }
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            boolean bl;
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            oracle.dbtools.http.Session session = CConnections.getInstance().getConnection(sftpParms.getCloudConnectionName(), true);
            HttpPost httpPost = session.createPost("/create_deploy_record/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", sftpParms.getImportName()));
            arrayList.add(new BasicNameValuePair("p_file_name", sftpParms.getRemoteFile()));
            arrayList.add(new BasicNameValuePair("p_file_type", string));
            arrayList.add(new BasicNameValuePair("p_file_size", string2));
            arrayList.add(new BasicNameValuePair("service_name", session.getDefaultServiceURI().toString()));
            SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
            boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
            if (bl) {
                String string3 = ossInfo.getOssServiceName();
                String string4 = ossInfo.getOssIdentityDomain();
                String string5 = "https://" + string3 + '-' + string4 + ".storage.oraclecloud.com";
                byte[] byArray = Encryption.generateSalt((String[])new String[]{string3, string4, string5});
                String string6 = Encryption.getRandomUUID();
                String string7 = Encryption.encrypt((char[])ossInfo.getOssPassword(), (String)string6, (byte[])byArray);
                String string8 = ossInfo.getOssServiceUrl();
                String string9 = null;
                string9 = string8 != null && !string8.isEmpty() ? (string5.equals(string8) ? ossInfo.getOssUserName() : ossInfo.getOssUserName() + "@" + string8) : ossInfo.getOssUserName();
                arrayList.add(new BasicNameValuePair("p_oss_service_name", string3));
                arrayList.add(new BasicNameValuePair("p_oss_identity_domain", string4));
                arrayList.add(new BasicNameValuePair("p_oss_user", string9));
                arrayList.add(new BasicNameValuePair("p_oss_uoid", string6));
                arrayList.add(new BasicNameValuePair("p_oss_value", string7));
            } else {
                arrayList.add(new BasicNameValuePair("p_oss_service_name", null));
                arrayList.add(new BasicNameValuePair("p_oss_identity_domain", null));
                arrayList.add(new BasicNameValuePair("p_oss_user", null));
                arrayList.add(new BasicNameValuePair("p_oss_uoid", null));
                arrayList.add(new BasicNameValuePair("p_oss_value", sftpParms.getSftpFileDate()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Created Successfully  ################");
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), ExportWizArb.format("FTP_DONE_MSG", sftpParms.getCloudConnectionName()), ExportWizArb.getString("FTP_DONE_TITLE"), 1);
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getStatusCode() + ":" + httpResponse.getStatusLine().getReasonPhrase());
                    throw new RuntimeException(ExportWizArb.getString("FTP_ERROR_WRITE_DEPLOY"));
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
            throw exception;
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDeploymentStatus(String string, String string2, String string3) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            oracle.dbtools.http.Session session = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = session.createPost("/update_deploy_status/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            arrayList.add(new BasicNameValuePair("p_status", string3));
            arrayList.add(new BasicNameValuePair("user_name", "user_name"));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Successfully Updated  ################");
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeploymentLogs(String string, String string2) {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        try {
            defaultHttpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            oracle.dbtools.http.Session session = CConnections.getInstance().getConnection(string, true);
            HttpPost httpPost = session.createPost("/clear_deploy_logs/");
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
            arrayList.add(new BasicNameValuePair("p_imp_name", string2));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList));
            session.executeRequest((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandler<Object>(){

                public Object handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
                    if (httpResponse.getStatusLine().getReasonPhrase().equals("OK")) {
                        java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.INFO, "################  Deployment Logs Cleared Successfully  ################");
                        return null;
                    }
                    java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, httpResponse.getStatusLine().getReasonPhrase());
                    return null;
                }
            });
        }
        catch (Exception exception) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getMessage());
        }
        finally {
            defaultHttpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean SftpTestConnection(SftpParms sftpParms) {
        SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
        boolean bl = ossInfo != null && ossInfo.isOssEnabled();
        boolean bl2 = true;
        if (bl) {
            LOGGER.info("Testing oss Connection");
            String string = ossInfo.getOssServiceName();
            String string2 = ossInfo.getOssIdentityDomain();
            String string3 = ossInfo.getOssUserName();
            char[] cArray = ossInfo.getOssPassword();
            String string4 = ossInfo.getOssServiceUrl();
            OracleStorageCloudService oracleStorageCloudService = new OracleStorageCloudService(string, string2, string3, cArray, string4);
            try {
                oracleStorageCloudService.connect();
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getLocalizedMessage());
                bl2 = false;
            }
            return bl2;
        }
        LOGGER.info("Testing sftp Connection");
        try {
            JSch.setLogger((Logger)new SftpLogger());
            JSch jSch = new JSch();
            Session session = null;
            ChannelSftp channelSftp = null;
            try {
                LOGGER.info("Testing connection to: " + sftpParms.getHost() + ":" + sftpParms.getPort());
                if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                    LOGGER.info("Using Key File:" + sftpParms.getKeyFile());
                    URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                    if (uRL == null) {
                        throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                    }
                    URI uRI = uRL.toURI();
                    jSch.addIdentity(new File(uRI).getAbsolutePath());
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                    LOGGER.info("Using username/passwd:" + sftpParms.getUser() + "/*****");
                    session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                    session.setPassword(sftpParms.getPassString());
                }
                LOGGER.info("Connecting...");
                this.connectSession(session);
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getLocalizedMessage());
                bl2 = false;
            }
            finally {
                channelSftp.disconnect();
                session.disconnect();
            }
        }
        catch (Exception exception) {
            LOGGER.severe(exception.getLocalizedMessage());
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean SftpPut(SftpParms sftpParms) {
        SftpProgressMonitor sftpProgressMonitor;
        int n;
        InputStream inputStream;
        ChannelSftp channelSftp;
        String string;
        boolean bl;
        SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(sftpParms.getCloudConnectionName());
        boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
        if (sftpParms.getRemoteFile() == null) {
            string = Paths.get(sftpParms.getLocalFile(), new String[0]).getFileName().toString();
            sftpParms.setRemoteFile(string);
        }
        if (bl) {
            string = ossInfo.getOssServiceName();
            String string2 = ossInfo.getOssIdentityDomain();
            String string3 = ossInfo.getOssUserName();
            char[] cArray = ossInfo.getOssPassword();
            String string4 = ossInfo.getOssServiceUrl();
            final OracleStorageCloudService oracleStorageCloudService = new OracleStorageCloudService(string, string2, string3, cArray, string4);
            try {
                Location location = Location.getLocal();
                final FileSet fileSet = new FileSet();
                fileSet.add(sftpParms.getLocalFile());
                fileSet.setLocation(location);
                this.transferTaskDone = false;
                this.completed = false;
                final TransferTask transferTask = TransferManager.INSTANCE.createTransferTask("testTransferTask", IRaptorTaskRunMode.NO_GUI, fileSet, (Location)oracleStorageCloudService, "uploads");
                transferTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        super.taskFailed(raptorTaskEvent);
                        SftpUtil.this.completed = false;
                        LOGGER.info("FAILED: " + String.valueOf(transferTask));
                        this.done();
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        super.taskFinished(raptorTaskEvent);
                        SftpUtil.this.completed = true;
                        LOGGER.info("FINISHED: " + String.valueOf(transferTask));
                        this.done();
                    }

                    private void done() {
                        try {
                            fileSet.getLocation().disconnect();
                            oracleStorageCloudService.disconnect();
                        }
                        finally {
                            SftpUtil.this.transferTaskDone = true;
                        }
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)transferTask);
                while (!this.transferTaskDone) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.warning(interruptedException.getLocalizedMessage());
                    }
                }
                return this.completed;
            }
            catch (Exception exception) {
                LOGGER.severe(exception.getLocalizedMessage());
            }
            return this.completed;
        }
        try {
            JSch.setLogger((Logger)new SftpLogger());
            string = new JSch();
            Session session = null;
            channelSftp = null;
            inputStream = null;
            try {
                Comparable<URI> comparable;
                LOGGER.info("Connecting to: " + sftpParms.getHost() + ":" + sftpParms.getPort());
                if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                    LOGGER.info("Using Key File:" + sftpParms.getKeyFile());
                    URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                    if (uRL == null) {
                        throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                    }
                    comparable = uRL.toURI();
                    string.addIdentity(new File((URI)comparable).getAbsolutePath());
                    session = string.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                    LOGGER.info("Using username/passwd:" + sftpParms.getUser() + "/*****");
                    session = string.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                    session.setPassword(sftpParms.getPassString());
                }
                this.connectSession(session);
                channelSftp = (ChannelSftp)session.openChannel("sftp");
                channelSftp.connect();
                LOGGER.info("Connected...");
                boolean bl3 = false;
                LOGGER.info("Checking service name:" + sftpParms.getCloudServiceName());
                if (ModelUtil.hasLength((String)sftpParms.getCloudServiceName())) {
                    try {
                        channelSftp.cd(sftpParms.getCloudServiceName());
                        LOGGER.info("Logged into domain level and cd to service");
                    }
                    catch (SftpException sftpException) {
                        LOGGER.info("No Service Name directory:" + sftpException.getLocalizedMessage());
                    }
                    try {
                        channelSftp.cd("upload");
                        bl3 = true;
                        LOGGER.info("cd upload");
                    }
                    catch (SftpException sftpException) {
                        LOGGER.severe("No upload directory!:" + sftpException.getLocalizedMessage());
                    }
                }
                if (!bl3 && ModelUtil.hasLength((String)sftpParms.getServerDir())) {
                    channelSftp.cd(sftpParms.getServerDir());
                }
                LOGGER.info("Gathering file information");
                comparable = new File(sftpParms.getLocalFile());
                Long l = ((File)comparable).length();
                if (((File)comparable).exists()) {
                    LOGGER.info("File is valid and exists locally: " + ((File)comparable).getName() + " " + l.toString());
                    inputStream = new BufferedInputStream(new FileInputStream((File)comparable));
                    if (sftpParms.getRemoteFile() == null) {
                        sftpParms.setRemoteFile(((File)comparable).getName());
                    }
                    LOGGER.info("Validating remote file: " + sftpParms.getRemoteFile());
                    Vector vector = null;
                    try {
                        vector = channelSftp.ls(sftpParms.getRemoteFile());
                    }
                    catch (SftpException sftpException) {
                        if (sftpException.id != 2) throw sftpException;
                    }
                    if (vector != null && vector.size() > 0) {
                        LOGGER.info("Remote file exists removing it!");
                        try {
                            channelSftp.rm(sftpParms.getRemoteFile());
                        }
                        catch (Exception exception) {
                            LOGGER.severe("Unable to remove remote file exiting deployment processes!!!!");
                            boolean bl4 = false;
                            channelSftp.disconnect();
                            session.disconnect();
                            inputStream.close();
                            return bl4;
                        }
                    }
                } else {
                    LOGGER.severe("Local file not found " + ((File)comparable).getAbsolutePath());
                    boolean bl5 = false;
                    return bl5;
                }
                LOGGER.info("Loading file to FTP server: " + sftpParms.getRemoteFile());
                n = 0;
                sftpProgressMonitor = new SftpProgressMonitor(){

                    public void init(int n, String string, String string2, long l) {
                    }

                    public boolean count(long l) {
                        LOGGER.fine("Transfered :" + l);
                        return true;
                    }

                    public void end() {
                        SftpUtil.this.completed = true;
                    }
                };
            }
            catch (SftpException sftpException) {
                LOGGER.severe(" SFTP EXCEPTION: " + sftpException.getMessage());
                boolean bl6 = false;
                return bl6;
            }
            finally {
                channelSftp.disconnect();
                session.disconnect();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            LOGGER.severe("Transfer exception " + exception.getMessage());
            return false;
        }
        while (n < 3 && !this.completed) {
            try {
                if (n == 0) {
                    channelSftp.put(inputStream, sftpParms.getRemoteFile(), sftpProgressMonitor);
                    continue;
                }
                channelSftp.put(inputStream, sftpParms.getRemoteFile(), sftpProgressMonitor, 1);
            }
            catch (SftpException sftpException) {
                int n2;
                LOGGER.severe("FAILED FTP transfer " + n + " time(s). Will retry transfer 3 times.");
                LOGGER.log(Level.SEVERE, sftpException.getMessage(), sftpException);
                if (++n != 3 || (n2 = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), ExportWizArb.getString("FTP_RETRY_MSG"), ExportWizArb.getString("FTP_ERROR_TITLE"), 0, 0, null, null, null)) != 0) continue;
                n = 0;
            }
        }
        SftpATTRS sftpATTRS = channelSftp.lstat(sftpParms.getRemoteFile());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy:HH:mm");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date((long)sftpATTRS.getMTime() * 1000L);
        String string5 = simpleDateFormat.format(date);
        sftpParms.setSftpFileDate(string5);
        return this.completed;
    }

    private void connectSession(Session session) throws JSchException {
        LOGGER.info("Connecting...");
        session.setConfig("StrictHostKeyChecking", "no");
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            try {
                session.setTimeout(this._timeout);
                session.setServerAliveInterval(this._timeout);
                session.connect();
            }
            catch (JSchException jSchException) {
                if (i == 3) {
                    throw jSchException;
                }
                bl = false;
            }
            if (!bl) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteSameSize(SftpParms sftpParms) {
        JSch.setLogger((Logger)new SftpLogger());
        JSch jSch = new JSch();
        Session session = null;
        ChannelSftp channelSftp = null;
        try {
            SftpATTRS sftpATTRS;
            Long l;
            Long l2;
            Comparable<URI> comparable;
            if (ModelUtil.hasLength((String)sftpParms.getKeyFile())) {
                URL uRL = this.getClass().getClassLoader().getResource(sftpParms.getKeyFile());
                if (uRL == null) {
                    throw new RuntimeException("Key file " + sftpParms.getKeyFile() + "not found in classpath");
                }
                comparable = uRL.toURI();
                jSch.addIdentity(new File((URI)comparable).getAbsolutePath());
                session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
            } else if (ModelUtil.hasLength((String)sftpParms.getPassString())) {
                session = jSch.getSession(sftpParms.getUser(), sftpParms.getHost(), sftpParms.getPort());
                session.setPassword(sftpParms.getPassString());
            }
            this.connectSession(session);
            channelSftp = (ChannelSftp)session.openChannel("sftp");
            channelSftp.connect();
            boolean bl = false;
            if (ModelUtil.hasLength((String)sftpParms.getCloudServiceName())) {
                try {
                    channelSftp.cd(sftpParms.getCloudServiceName());
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
                try {
                    channelSftp.cd("upload");
                    bl = true;
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
            }
            if (!bl && ModelUtil.hasLength((String)sftpParms.getServerDir())) {
                channelSftp.cd(sftpParms.getServerDir());
            }
            if (!(l2 = Long.valueOf(((File)(comparable = new File(sftpParms.getLocalFile()))).length())).equals(l = Long.valueOf((sftpATTRS = channelSftp.lstat(sftpParms.getRemoteFile())).getSize()))) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
            boolean bl = false;
            return bl;
        }
        finally {
            channelSftp.disconnect();
            session.disconnect();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String string, Path path, File file) throws Exception {
        block8: {
            boolean bl;
            SessionInfo.OssInfo ossInfo = SftpUtil.getOssInfo(string);
            boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
            if (bl) {
                String string2 = ossInfo.getOssServiceName();
                String string3 = ossInfo.getOssIdentityDomain();
                String string4 = ossInfo.getOssUserName();
                char[] cArray = ossInfo.getOssPassword();
                String string5 = ossInfo.getOssServiceUrl();
                OracleStorageCloudService oracleStorageCloudService = new OracleStorageCloudService(string2, string3, string4, cArray, string5);
                oracleStorageCloudService.connect();
                try (InputStream inputStream = oracleStorageCloudService.asInputStream(path, 0L, 0L);
                     FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    int n;
                    byte[] byArray = new byte[4096];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    break block8;
                }
            }
            throw new UnsupportedOperationException("Connection must be OSS");
        }
    }

    public static SessionInfo.OssInfo getOssInfo(String string) {
        if (null == string) {
            return null;
        }
        SessionInfo sessionInfo = null;
        if (SftpUtil.isSchemaServiceConnection(string)) {
            sessionInfo = CConnections.getInstance().getConnectionInfo(string);
        }
        SessionInfo.OssInfo ossInfo = null;
        if (sessionInfo != null) {
            ossInfo = sessionInfo.getOssInfo();
        } else {
            Properties properties = Connections.getInstance().getConnectionInfo(string);
            boolean bl = Boolean.valueOf(properties.getProperty("oss.enabled"));
            if (bl) {
                String string2 = properties.getProperty("oss.password");
                char[] cArray = null == string2 ? null : string2.toCharArray();
                ossInfo = new SessionInfo.OssInfo(bl, properties.getProperty("oss.service_name"), properties.getProperty("oss.identity_domain"), properties.getProperty("oss.username"), cArray, properties.getProperty("oss.service_url"));
            }
        }
        return ossInfo;
    }

    public static boolean isSchemaServiceConnection(String string) {
        boolean bl = false;
        for (String string2 : CConnections.getInstance().listConnections()) {
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

