/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import oracle.dbtools.raptor.config.LicensingEditorConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.TriStateCheckBox;

public class LicenseUtils {
    public static boolean requiresChangeManagement(String string) {
        return License.CHANGE_MANAGEMENT.requires(string, true);
    }

    public static boolean requiresTuning(String string) {
        return License.TUNING.requires(string, true);
    }

    public static boolean requiresDiag(String string) {
        return License.DIAGNOSTICS.requires(string, true);
    }

    public static boolean requiresCompression(String string) {
        return License.ADVANCED_COMPRESSION.requires(string, true);
    }

    public static boolean requiresLicense(String string, String string2, boolean bl) {
        License license = null;
        if (string != null && (string = string.trim()).length() > 0) {
            if ("ChangeManagement".equals(string)) {
                license = License.CHANGE_MANAGEMENT;
            } else if ("Tuning".equals(string)) {
                license = License.TUNING;
            } else if ("Diagnostics".equals(string)) {
                license = License.DIAGNOSTICS;
            } else if ("AdvancedCompression".equals(string)) {
                license = License.ADVANCED_COMPRESSION;
            } else {
                Logger.warn(LicenseUtils.class, (String)("Unknown license key: " + string));
            }
        }
        return license != null ? license.requires(string2, bl) : false;
    }

    public static enum License {
        CHANGE_MANAGEMENT(LicensingEditorConfig.CHANGE_MANGEMENT_PACK, UtilsResources.getString("CHANGE_MGMT_NAME"), UtilsResources.getString("CHANGE_MGMT_TITLE"), "f1_requireschangemanagement_html"),
        TUNING(LicensingEditorConfig.TUNING_PACK, UtilsResources.getString("TUNING_NAME"), UtilsResources.getString("TUNING_TITLE"), "f1_requirestuning_html"),
        DIAGNOSTICS(LicensingEditorConfig.DIAGNOSTICS_PACK, UtilsResources.getString("DIAG_NAME"), UtilsResources.getString("DIAG_TITLE"), "f1_requiresdiag_html"),
        ADVANCED_COMPRESSION(LicensingEditorConfig.ADVANCED_COMPRESSION, UtilsResources.getString("COMPRESSION_NAME"), UtilsResources.getString("COMPRESSION_TITLE"), "f1_requirescompression_html");

        private int packType;
        private String name;
        private String title;
        private String help;

        private License(int n2, String string2, String string3, String string4) {
            this.packType = n2;
            this.name = string2;
            this.title = string3;
            this.help = string4;
        }

        public boolean requires(String string, boolean bl) {
            boolean bl2 = false;
            LicensingEditorConfig licensingEditorConfig = LicensingEditorConfig.getInstance();
            switch (licensingEditorConfig.getLicensingPackSetting(string, this.packType)) {
                case FALSE: {
                    if (!bl) break;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtilsResources.format("ERROR_MESSAGE", this.name), (String)this.title, null);
                    break;
                }
                case TRUE: {
                    bl2 = true;
                    break;
                }
                case PARTIAL: {
                    String string2 = string != null ? UtilsResources.format("MANAGEMENT_PACK_LICENSE_TEXT", this.name, Connections.getDisplayName(string)) : UtilsResources.format("LICENSE_TEXT", this.name);
                    boolean bl3 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string2, (String)this.title, (String)this.help);
                    if (bl3) {
                        bl2 = true;
                    }
                    licensingEditorConfig.setLicensingPackSetting(string, bl3 ? TriStateCheckBox.State.TRUE : TriStateCheckBox.State.FALSE, this.packType);
                }
            }
            return bl2;
        }
    }
}

