/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RelationalBGP;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SimpleBGP;
import oracle.spatial.rdf.server.TranslateEngine;
import oracle.spatial.rdf.server.UnionSPARQLTreeNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public abstract class AbstractSPARQLTreeNode
implements SPARQLTreeNode {
    protected static final String LHS_ALIAS = "r1";
    protected static final String RHS_ALIAS = "r2";
    protected static final String MAIN_ALIAS = "R";
    protected static final String RDFCT_FUNC = "SEM_APIS.COMPOSE_CANON_TERM";
    protected static final String RDFT_FUNC = "SEM_APIS.COMPOSE_RDF_TERM";
    protected static final int[] RDFT_CLOB_COLS = new int[]{0, 4, 6, 7, 5};
    protected static final int[] RDFT_VC_COLS = new int[]{0, 4, 6, 7};
    protected static final String LIT_ESC_FUNC = "SEM_APIS.unescape_rdf_value";
    protected static final String CLOB_LIT_ESC_FUNC = "SEM_APIS.unescape_clob_value";
    protected static final String TERM_ESC_FUNC = "SEM_APIS.unescape_rdf_term";
    protected static final String CLOB_TERM_ESC_FUNC = "SEM_APIS.unescape_clob_term";
    protected SQLGenContext ctx;
    protected int type;
    protected SPARQLBGP myBGP;
    protected int overloadedServiceInfo;
    protected String sparqlText;
    protected List<Filter> myFilters;
    protected int limit;
    protected boolean pushingMyBGP;
    protected String myBgpWithAlias;
    protected boolean pushingParentBGP;
    protected String parentBGPAlias;
    protected SPARQLBGP parentBGP;
    protected SPARQLTreeNode parent;
    protected List<SPARQLTreeNode> children;
    protected Set<String> projectVars;
    protected String[] varProjColumns;
    protected int vidProjIdx;
    protected String[] finalCols;
    protected int vidFinalIdx;
    protected String vid_alias = "$RDFVID";
    protected String vtype_alias = "$RDFVTYP";
    protected String prefix_alias = "$_PREFIX";
    protected String suffix_alias = "$_SUFFIX";
    protected String litType_alias = "$RDFLTYP";
    protected String langType_alias = "$RDFLANG";
    protected String longLit_alias = "$RDFCLOB";
    protected String term_alias = "$RDFTERM";
    protected String srt_alias = "$SRT";
    protected Set<String> lexVars;
    protected List<Filter> localBGPFilters;
    protected List<Filter> localNonBGPFilters;
    protected List<List<Filter>> childJoinFilters;
    protected boolean graphQuery = false;
    protected ASTTripleAtom activeGraph = null;
    protected List<Filter> rejectedBGPFilters;
    protected Set<String> plsVars;
    protected Set<String> plsLexVars;
    protected boolean unmaskGraph = false;
    private SortedSet<Integer> bindIds;
    protected boolean containsMinus = false;

    public static String buildRes2VidCall(String string, String string2, String string3, String string4) {
        return "NVL2(" + string + "," + "NVL(" + "SEM_APIS.RES2VID(" + "'" + string4 + "'," + string + "," + string2 + "," + string3 + ")," + "0)," + "NULL)";
    }

    protected static List<String> updateVnameForSubstr(List<String> list) {
        String string = QueryUtils.genVNameSubstr(list.get(0), list.get(5), list.get(7), list.get(6));
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.remove(0);
        arrayList.add(0, string);
        return arrayList;
    }

    public AbstractSPARQLTreeNode(int n, SQLGenContext sQLGenContext, int n2) {
        this.ctx = sQLGenContext;
        this.type = n;
        this.myBGP = sQLGenContext.isRdfVWModel ? new RelationalBGP(n2, sQLGenContext) : new SimpleBGP(n2, sQLGenContext);
        this.myFilters = new ArrayList<Filter>();
        this.projectVars = new HashSet<String>();
        this.varProjColumns = new String[9];
        this.varProjColumns[0] = this.vid_alias;
        this.varProjColumns[1] = "";
        this.varProjColumns[2] = this.vtype_alias;
        this.varProjColumns[3] = this.prefix_alias;
        this.varProjColumns[4] = this.suffix_alias;
        this.varProjColumns[5] = this.litType_alias;
        this.varProjColumns[6] = this.langType_alias;
        this.varProjColumns[7] = this.longLit_alias;
        this.varProjColumns[8] = this.term_alias;
        this.vidProjIdx = 0;
        this.finalCols = new String[8];
        this.finalCols[0] = "";
        this.finalCols[1] = this.vid_alias;
        this.finalCols[2] = this.prefix_alias;
        this.finalCols[3] = this.suffix_alias;
        this.finalCols[4] = this.vtype_alias;
        this.finalCols[5] = this.longLit_alias;
        this.finalCols[6] = this.litType_alias;
        this.finalCols[7] = this.langType_alias;
        this.vidFinalIdx = 1;
        this.lexVars = new HashSet<String>();
        this.pushingMyBGP = false;
        this.myBgpWithAlias = "RBGP" + n2;
        this.pushingParentBGP = false;
        this.parentBGPAlias = "";
        this.parentBGP = null;
        this.parent = null;
        this.children = new ArrayList<SPARQLTreeNode>();
        this.localBGPFilters = new ArrayList<Filter>();
        this.localNonBGPFilters = new ArrayList<Filter>();
        this.childJoinFilters = new ArrayList<List<Filter>>();
        this.limit = -1;
        this.graphQuery = false;
        this.activeGraph = null;
        this.rejectedBGPFilters = new ArrayList<Filter>();
        this.plsVars = new HashSet<String>();
        this.plsLexVars = new HashSet<String>();
        this.bindIds = new TreeSet<Integer>();
        this.containsMinus = false;
        this.overloadedServiceInfo = 0;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public void setParent(SPARQLTreeNode sPARQLTreeNode) {
        this.parent = sPARQLTreeNode;
    }

    @Override
    public void addChild(SPARQLTreeNode sPARQLTreeNode) {
        this.children.add(sPARQLTreeNode);
        if (sPARQLTreeNode.getType() == 2) {
            this.containsMinus = true;
        }
    }

    @Override
    public void addChild(SPARQLTreeNode sPARQLTreeNode, int n) {
        this.children.add(n, sPARQLTreeNode);
        if (sPARQLTreeNode.getType() == 2) {
            this.containsMinus = true;
        }
    }

    @Override
    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock) {
        this.myBGP.addTriplesBlock(sPARQLTriplesBlock);
    }

    @Override
    public void addFilter(Filter filter) {
        this.myFilters.add(filter);
    }

    @Override
    public void addUserHint(String string) {
        this.myBGP.addUserHint(string);
    }

    @Override
    public String getJoinHint(String string, String string2) {
        String string3 = "";
        if (this.myBGP.getNumTriples() > 0) {
            string3 = this.myBGP.getJoinHint(string, string2);
        } else if (this.getNumChildren() > 0) {
            string3 = this.getChild(0).getJoinHint(string, string2);
        }
        return string3;
    }

    @Override
    public String getAntiJoinHint() {
        String string = "";
        if (this.myBGP.getNumTriples() > 0) {
            string = this.myBGP.getAntiJoinHint();
        } else if (this.getNumChildren() > 0) {
            string = this.getChild(0).getAntiJoinHint();
        }
        return string;
    }

    @Override
    public void pushBGP(SPARQLBGP sPARQLBGP, String string) {
        if (this.getType() != 2) {
            if (this.myBGP.getNumTriples() > 0) {
                this.myBGP.pushBGP(sPARQLBGP, string);
            } else {
                this.pushingParentBGP = true;
                this.parentBGPAlias = string;
                this.parentBGP = sPARQLBGP;
            }
        }
    }

    @Override
    public boolean needsParentBGPPushDown() {
        boolean bl = false;
        if (this.getType() != 2) {
            if (this.myBGP.getNumTriples() > 0) {
                bl = this.myBGP.needsParentBGPPushDown();
            } else {
                for (int i = 0; i < this.getNumChildren(); ++i) {
                    SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
                    if (!sPARQLTreeNode.needsParentBGPPushDown()) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public void setIsGraphQuery(boolean bl) {
        this.graphQuery = bl;
        this.myBGP.setIsGraphQuery(bl);
    }

    @Override
    public boolean isGraphQuery() {
        return this.graphQuery;
    }

    @Override
    public void setActiveGraph(ASTTripleAtom aSTTripleAtom) {
        this.activeGraph = aSTTripleAtom;
        this.myBGP.setActiveGraph(aSTTripleAtom);
    }

    @Override
    public ASTTripleAtom getActiveGraph() {
        return this.activeGraph;
    }

    @Override
    public void addJoinVarsForHint(Set<String> set) {
        this.myBGP.addJoinVarsForHint(set);
    }

    @Override
    public void propagateLexVars() throws RDFException {
        Set<String> set = this.getAllLexVars();
        if (this.type == 1) {
            set.addAll(this.plsLexVars);
        }
        for (Filter filter : this.getAllFilters()) {
            filter.setLexVars(set);
        }
        Object object = null;
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            object = this.getChild(i);
            object.propagateLexVars();
        }
    }

    @Override
    public void setInScopeVars(Set<String> set) throws RDFException {
        this.plsVars.addAll(set);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getBGPVars());
        int n = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (int i = 0; i < n; ++i) {
            sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.setInScopeVars(hashSet);
            hashSet.addAll(sPARQLTreeNode.getCumulativeVars());
        }
        Set<String> set2 = this.getCumulativeVars();
        HashSet<String> hashSet2 = new HashSet<String>(set2);
        if (this.type == 1) {
            set2.addAll(this.plsVars);
        }
        for (Filter filter : this.getAllFilters()) {
            filter.setInScopeVars(set2, hashSet2);
            filter.setDefBoundVars(this.getDefiniteBoundVars());
        }
    }

    @Override
    public void setInScopeLexVars(Set<String> set) throws RDFException {
        this.plsLexVars.addAll(set);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.myBGP.getAllLexVars());
        int n = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (int i = 0; i < n; ++i) {
            sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.setInScopeLexVars(hashSet);
            hashSet.addAll(sPARQLTreeNode.getAllLexVars());
        }
    }

    @Override
    public void allocateFilters() throws RDFException {
        int n;
        this.localBGPFilters = new ArrayList<Filter>();
        this.localNonBGPFilters = new ArrayList<Filter>();
        this.childJoinFilters = new ArrayList<List<Filter>>();
        Set<String> set = this.getBGPVars();
        List<Filter> list = this.getLocalFilters();
        for (Filter object2 : list) {
            if (set.containsAll(object2.getVars())) {
                this.localBGPFilters.add(object2);
                continue;
            }
            this.localNonBGPFilters.add(object2);
        }
        boolean bl = false;
        for (Filter filter : this.localBGPFilters) {
            bl = this.myBGP.addFilter(filter);
            if (bl) continue;
            this.rejectedBGPFilters.add(filter);
        }
        Object var4_7 = null;
        int n2 = this.getNumChildren();
        for (n = 0; n < n2; ++n) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(n);
            ArrayList<Filter> arrayList = new ArrayList<Filter>();
            arrayList.addAll(sPARQLTreeNode.getNonLocalFilters());
            this.childJoinFilters.add(arrayList);
        }
        for (n = 0; n < n2; ++n) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.allocateFilters();
        }
    }

    @Override
    public void setPushedBGPs() throws RDFException {
        int n;
        int n2 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            if (!sPARQLTreeNode.needsParentBGPPushDown()) continue;
            if (this.pushingParentBGP) {
                sPARQLTreeNode.pushBGP(this.parentBGP.shallowClone(), this.parentBGPAlias);
                continue;
            }
            if (this.myBGP.getNumTriples() <= 0) continue;
            this.pushingMyBGP = true;
            sPARQLTreeNode.pushBGP(this.myBGP.shallowClone(), this.myBgpWithAlias);
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setPushedBGPs();
        }
    }

    @Override
    public void setLexVars() throws RDFException {
        int n;
        Set<String> set = this.getAllLexVars();
        Set<String> set2 = null;
        int n2 = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            set2 = QueryUtils.getCommonVars(set, sPARQLTreeNode.getCumulativeVars());
            sPARQLTreeNode.addLexVars(set2);
        }
        for (n = 0; n < n2; ++n) {
            sPARQLTreeNode = this.getChild(n);
            sPARQLTreeNode.setLexVars();
        }
    }

    @Override
    public void initFilters() throws RDFException {
        for (Filter object2 : this.myFilters) {
            object2.init();
        }
        int n = this.getNumChildren();
        Object var2_4 = null;
        for (int i = 0; i < n; ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.initFilters();
        }
    }

    @Override
    public void verifyPushedBGPs() throws RDFException {
        this.myBGP.verifyPushedBGP();
        int n = this.getNumChildren();
        SPARQLTreeNode sPARQLTreeNode = null;
        for (int i = 0; i < n; ++i) {
            sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.verifyPushedBGPs();
        }
    }

    @Override
    public void markForUnmask() {
        this.unmaskGraph = true;
    }

    @Override
    public void unmarkForUnmask() {
        this.unmaskGraph = false;
    }

    @Override
    public void addProjectVars(Set<String> set) {
        this.projectVars.addAll(set);
    }

    @Override
    public void addProjectVar(String string) {
        this.projectVars.add(string);
    }

    @Override
    public Set<String> getAllLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.lexVars);
        hashSet.addAll(this.getRequiredLexVars());
        return hashSet;
    }

    @Override
    public Set<String> getRequiredLexVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getRequiredLexVars());
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            hashSet.addAll(this.getChild(i).getRequiredLexVars());
        }
        for (Filter filter : this.myFilters) {
            hashSet.addAll(filter.getRequiredLexVars());
        }
        return hashSet;
    }

    @Override
    public void addLexVar(String string) {
        this.lexVars.add(string);
    }

    @Override
    public void addLexVars(Set<String> set) {
        this.lexVars.addAll(set);
    }

    @Override
    public boolean isEmpty() {
        if (this.getParent() instanceof UnionSPARQLTreeNode) {
            return false;
        }
        if ((this.ctx.contextFlags & 3) > 0) {
            return false;
        }
        if (this.isGraphQuery()) {
            return false;
        }
        return this.getNumChildren() == 0 && (this.myBGP == null || this.myBGP.getNumTriples() == 0) && this.myFilters.isEmpty();
    }

    @Override
    public boolean containsEmptyBGP() {
        if (this.containsEmptyLocalBGP()) {
            return true;
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.containsEmptyBGP()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsEmptyLocalBGP() {
        if ((this.ctx.contextFlags & 3) > 0) {
            return false;
        }
        return this.myBGP == null || this.myBGP.getNumTriples() == 0;
    }

    @Override
    public Set<String> getDefiniteBoundVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.myBGP.getDefiniteBoundVars());
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (sPARQLTreeNode.getType() != 0) continue;
            hashSet.addAll(sPARQLTreeNode.getDefiniteBoundVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getDefiniteBoundAndPushedVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.myBGP.getDefiniteBoundAndPushedVars());
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (sPARQLTreeNode.getType() != 0) continue;
            hashSet.addAll(sPARQLTreeNode.getDefiniteBoundAndPushedVars());
        }
        return hashSet;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public SPARQLTreeNode getParent() {
        return this.parent;
    }

    @Override
    public SPARQLTreeNode getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public SPARQLTreeNode removeChild(int n) {
        return this.children.remove(n);
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public List<Filter> getLocalFilters() {
        Set<String> set = this.getCumulativeVars();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.myFilters) {
            if (!set.containsAll(filter.getVars())) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    @Override
    public List<Filter> getNonLocalFilters() {
        Set<String> set = this.getCumulativeVars();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : this.myFilters) {
            if (set.containsAll(filter.getVars())) continue;
            arrayList.add(filter);
        }
        return arrayList;
    }

    @Override
    public List<Filter> getAllFilters() {
        return this.myFilters;
    }

    @Override
    public Set<String> getBGPVars() {
        return this.myBGP.getBGPVars();
    }

    @Override
    public Set<String> getBGPAndPushedVars() {
        return this.myBGP.getBGPAndPushedVars();
    }

    @Override
    public Set<String> getCumulativeVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            if (sPARQLTreeNode.getType() == 2) continue;
            hashSet.addAll(sPARQLTreeNode.getCumulativeVars());
        }
        hashSet.addAll(this.myBGP.getBGPVars());
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeAndPushedVars() {
        HashSet<String> hashSet = new HashSet<String>();
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            if (sPARQLTreeNode.getType() == 2) continue;
            hashSet.addAll(sPARQLTreeNode.getCumulativeAndPushedVars());
        }
        hashSet.addAll(this.myBGP.getBGPAndPushedVars());
        return hashSet;
    }

    @Override
    public Set<String> getPushCandidates() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter object : this.myFilters) {
            hashSet.addAll(object.getfJoinVars());
            hashSet.addAll(object.getBindVars());
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getPushCandidates());
        }
        hashSet.addAll(this.myBGP.getBindVars());
        return hashSet;
    }

    @Override
    public Set<String> getCumulativeHintVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getHintVars());
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getCumulativeHintVars());
        }
        return hashSet;
    }

    @Override
    public Set<String> getProjectVars() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.projectVars);
        hashSet.addAll(QueryUtils.getCommonVars(this.getAllLexVars(), this.getCumulativeAndPushedVars()));
        return hashSet;
    }

    @Override
    public void genOuterSelectComponents(Set<String> set, Set<String> set2, Map<String, List<String>> map, String[] stringArray, String[] stringArray2, Map<String, String> map2) {
        this.myBGP.genOuterSelectComponents(set, set2, map, stringArray, stringArray2, map2);
    }

    @Override
    public String buildSubQForCLOB(String string, String string2, String string3) {
        return this.myBGP.buildSubQForCLOB(string, string2, string3);
    }

    @Override
    public void pushJoinVarsForHint() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getBGPAndPushedVars());
        hashSet.addAll(this.myBGP.getJoinVarsForHint());
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            sPARQLTreeNode.addJoinVarsForHint(hashSet);
            sPARQLTreeNode.pushJoinVarsForHint();
            hashSet.addAll(sPARQLTreeNode.getCumulativeAndPushedVars());
        }
    }

    @Override
    public void setLimit(int n) {
        this.limit = n;
    }

    @Override
    public void setBindIds(SortedSet<Integer> sortedSet) {
        this.bindIds = sortedSet;
    }

    @Override
    public SortedSet<Integer> getBindIds() {
        return this.bindIds;
    }

    @Override
    public Set<String> getCumulativeBindVars() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.myBGP != null) {
            hashSet.addAll(this.myBGP.getBindVars());
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            hashSet.addAll(sPARQLTreeNode.getCumulativeBindVars());
        }
        return hashSet;
    }

    @Override
    public void setSparqlText(String string) {
        this.sparqlText = string;
    }

    @Override
    public String getSparqlText() {
        return this.sparqlText;
    }

    @Override
    public void setOverloadedServiceInfo(int n) {
        this.overloadedServiceInfo = n;
    }

    @Override
    public int getOverloadedServiceInfo() {
        return this.overloadedServiceInfo;
    }

    protected Set<String> getJoinVarsForFilters(List<Filter> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter filter : list) {
            hashSet.addAll(filter.getfJoinVars());
            hashSet.addAll(filter.getBindVars());
        }
        return hashSet;
    }

    protected Set<String> getBindVarsForFilters(List<Filter> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Filter filter : list) {
            hashSet.addAll(filter.getBindVars());
        }
        return hashSet;
    }

    protected Set<ASTTripleAtom.BindVar> getBindVarObjsForFilters(List<Filter> list) {
        HashSet<ASTTripleAtom.BindVar> hashSet = new HashSet<ASTTripleAtom.BindVar>();
        for (Filter filter : list) {
            hashSet.addAll(filter.getBindVarObjs());
        }
        return hashSet;
    }

    protected void setPushedBGP() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SPARQLTreeNode sPARQLTreeNode = this.getChild(i);
            if (!sPARQLTreeNode.needsParentBGPPushDown()) continue;
            if (this.pushingParentBGP) {
                sPARQLTreeNode.pushBGP(this.parentBGP.shallowClone(), this.parentBGPAlias);
                continue;
            }
            if (this.myBGP.getNumTriples() <= 0) continue;
            this.pushingMyBGP = true;
            sPARQLTreeNode.pushBGP(this.myBGP.shallowClone(), this.myBgpWithAlias);
        }
    }

    protected String buildSelectForVar(String string, String string2, Set<String> set, Set<String> set2, Set<String> set3) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        boolean bl = false;
        if (set.contains(string2)) {
            n = 8;
            if (set2.contains(string2)) {
                if (set3.contains(string2)) {
                    bl = true;
                } else {
                    n = 9;
                }
            }
        } else {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string + "." + string2 + this.varProjColumns[i], string2 + this.varProjColumns[i]), ", ", "");
        }
        if (bl) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.composeRDFTForVar(string, string2, null, false, false, false, true), string2 + this.varProjColumns[8]), ", ", "");
        }
        return stringBuffer.toString();
    }

    protected String buildCanonRDFTForVar(String string, String string2, Map<String, List<String>> map, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.buildRDFTForVar(string, string2, map, bl, bl2, bl3, bl4, false, RDFCT_FUNC);
    }

    protected String buildRDFTForVar(String string, String string2, Map<String, List<String>> map, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.buildRDFTForVar(string, string2, map, bl, bl2, bl3, bl4, false, RDFT_FUNC);
    }

    protected String composeRDFTForVar(String string, String string2, Map<String, List<String>> map, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.buildRDFTForVar(string, string2, map, bl, bl2, bl3, bl4, true, RDFT_FUNC);
    }

    protected String buildRDFTForVar(String string, String string2, Map<String, List<String>> map, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, String string3) {
        StringBuffer stringBuffer = new StringBuffer("");
        int[] nArray = RDFT_VC_COLS;
        if (bl) {
            nArray = RDFT_CLOB_COLS;
        }
        if (!bl2) {
            List<String> list = new ArrayList<String>(8);
            list.add(string + "." + string2);
            list.add(string + "." + string2 + this.vid_alias);
            list.add(string + "." + string2 + this.prefix_alias);
            list.add(string + "." + string2 + this.suffix_alias);
            list.add(string + "." + string2 + this.vtype_alias);
            if (bl3) {
                if (bl4) {
                    list.add("NULL");
                } else {
                    list.add(this.getChild(0).buildSubQForCLOB(string2, string + "." + string2 + this.vid_alias, string + "." + string2 + this.prefix_alias));
                }
            } else {
                list.add(string + "." + string2 + this.longLit_alias);
            }
            list.add(string + "." + string2 + this.litType_alias);
            list.add(string + "." + string2 + this.langType_alias);
            if (!bl5 && !this.ctx.disableClobRDFTOpt && bl4 && !bl) {
                stringBuffer.append(string + "." + string2 + this.term_alias);
            } else if (!bl5 && !this.ctx.disableClobRDFTOpt && bl4 && bl) {
                if (this.ctx.isRdfVWModel) {
                    stringBuffer.append("TO_CLOB(" + string + "." + string2 + this.term_alias + ")");
                } else {
                    stringBuffer.append("NVL2(" + list.get(5) + "," + QueryUtils.buildFuncCall(string3, nArray, list) + "," + "TO_CLOB(" + string + "." + string2 + this.term_alias + "))");
                }
            } else if (!(this.ctx.disableInLineRDFT || this.ctx.disableClobRDFTOpt || bl4 || bl || bl5 || string3.equals(RDFCT_FUNC))) {
                stringBuffer.append(QueryUtils.buildInLineRDFT(list.get(0), list.get(4), list.get(7), list.get(6)));
            } else {
                if (!bl) {
                    list = AbstractSPARQLTreeNode.updateVnameForSubstr(list);
                }
                stringBuffer.append(QueryUtils.buildFuncCall(string3, nArray, list));
            }
        } else {
            List<String> list = map.get(string2);
            if (!(this.ctx.disableInLineRDFT || this.ctx.disableClobRDFTOpt || bl4 || bl || bl5 || string3.equals(RDFCT_FUNC))) {
                stringBuffer.append(QueryUtils.buildInLineRDFT(list.get(0), list.get(4), list.get(7), list.get(6)));
            } else {
                if (!bl) {
                    list = AbstractSPARQLTreeNode.updateVnameForSubstr(list);
                }
                stringBuffer.append(QueryUtils.buildFuncCall(string3, nArray, list));
            }
        }
        return stringBuffer.toString();
    }

    protected String buildNullValueForVar(int n, int n2, int n3) {
        String string = "NULL";
        if (n == n2) {
            string = "TO_NUMBER(NULL)";
        } else if (n == n3) {
            string = "TO_CLOB(NULL)";
        }
        return string;
    }

    protected String buildFinalValueJoinHint(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (!this.ctx.disableNoMerge) {
            stringBuffer.append(TranslateEngine.DEFAULT_Q_HINT);
        }
        if (!this.ctx.disableNoSwap) {
            stringBuffer.append(" ").append(TranslateEngine.NO_SWAP_HINT);
        }
        if (!collection.isEmpty()) {
            if ((this.ctx.finalValJoinFlag & (1 | 2)) > 0) {
                Object object = "";
                object = (this.ctx.finalValJoinFlag & 1) > 0 ? " USE_HASH" : " USE_NL";
                stringBuffer.append(" ").append((String)object).append("(");
                for (String string : collection) {
                    stringBuffer.append(string).append(" ");
                }
                stringBuffer.append(")");
            }
        }
        if (!collection.isEmpty()) {
            if ((this.ctx.finalValJoinFlag & 4) > 0) {
                for (String string : collection) {
                    stringBuffer.append(" NO_INDEX(").append(string).append(")");
                }
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "/*+ ");
            stringBuffer.append(" */");
        }
        return stringBuffer.toString();
    }

    protected String buildWithForBind() {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        for (Integer n : this.getBindIds()) {
            if (bl) {
                stringBuffer.append(",\n");
            }
            if (this.ctx.useBindValues) {
                stringBuffer.append("BV" + n + " AS " + "(SELECT :" + String.valueOf(2 * n) + " AS VALUE_ID, SDO_RDF_TERM(:" + String.valueOf(2 * n + 1) + ") AS TERM FROM DUAL)");
            } else {
                stringBuffer.append("BV" + n + " AS " + "(SELECT ? AS VALUE_ID, SDO_RDF_TERM(?) AS TERM FROM DUAL)");
            }
            bl = true;
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "WITH /*+ MATERIALIZE */\n");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected String unescapeColumn(String string, String string2) {
        return "(CASE WHEN INSTR(" + string2 + ",'\\') > 0 " + "THEN " + string + "(" + string2 + ") " + "ELSE " + string2 + " END)";
    }

    protected String wrapForUnescape(String string, List<String> list, String string2, boolean bl) {
        String string3 = CLOB_TERM_ESC_FUNC;
        if (this.ctx.vcTerms) {
            string3 = TERM_ESC_FUNC;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        String string4 = "SELECT ";
        stringBuffer.append(string4);
        for (String string5 : list) {
            if (!this.ctx.rdfTermsOnly || bl) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(LIT_ESC_FUNC, string5), string5), ",", string4);
            }
            QueryUtils.appendToList(stringBuffer, string5 + this.vid_alias, ",", string4);
            if (!this.ctx.rdfTermsOnly || bl) {
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(LIT_ESC_FUNC, string5 + this.prefix_alias), string5 + this.prefix_alias), ",", string4);
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(LIT_ESC_FUNC, string5 + this.suffix_alias), string5 + this.suffix_alias), ",", string4);
                QueryUtils.appendToList(stringBuffer, string5 + this.vtype_alias, ",", string4);
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(CLOB_LIT_ESC_FUNC, string5 + this.longLit_alias), string5 + this.longLit_alias), ",", string4);
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(LIT_ESC_FUNC, string5 + this.litType_alias), string5 + this.litType_alias), ",", string4);
                QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(LIT_ESC_FUNC, string5 + this.langType_alias), string5 + this.langType_alias), ",", string4);
            }
            if (!this.ctx.plusRDFTerms && !this.ctx.rdfTermsOnly || bl) continue;
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, this.unescapeColumn(string3, string5 + this.term_alias), string5 + this.term_alias), ",", string4);
        }
        if (string2 != null) {
            QueryUtils.appendToList(stringBuffer, QueryUtils.buildAliasExpr(this.ctx, string2, "SEM$ROWNUM"), ",", string4);
        }
        if (stringBuffer.length() == 7) {
            stringBuffer.append("1");
        }
        stringBuffer.append("\n");
        stringBuffer.append(" FROM (");
        stringBuffer.append(string);
        stringBuffer.append(") R");
        stringBuffer.append("\n");
        stringBuffer.append("WHERE (1=1)");
        return stringBuffer.toString();
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Type [" + this.type + "]\n";
        string2 = string2 + string + "Projections: " + this.projectVars + "\n";
        if (this.isGraphQuery()) {
            string2 = string2 + string + "GRAPH: [" + this.activeGraph.name + "] [unmaskGraph=" + this.unmaskGraph + "]\n";
        }
        string2 = string2 + string + "overloadedServiceInfo: [" + this.getOverloadedServiceInfo() + "]\n";
        string2 = string2 + string + "sparqlText: [" + this.getSparqlText() + "]\n";
        string2 = string2 + string + "Required Lex Vars: [";
        for (String object : this.getRequiredLexVars()) {
            string2 = string2 + object + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "Lex Vars: [";
        for (String string3 : this.getAllLexVars()) {
            string2 = string2 + string3 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "PLS Vars: [";
        for (String string4 : this.plsVars) {
            string2 = string2 + string4 + " ";
        }
        string2 = string2 + "]\n";
        string2 = string2 + string + "BGP: \n";
        string2 = string2 + this.myBGP.toString(string) + "\n";
        for (Filter filter : this.myFilters) {
            string2 = string2 + filter.toString(string) + "\n";
        }
        for (SPARQLTreeNode sPARQLTreeNode : this.children) {
            string2 = string2 + sPARQLTreeNode.toString(string + "  ") + "\n";
        }
        return string2;
    }
}

