/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import oracle.spatial.rdf.server.BlankNodesRewriteOptimizer;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructTemplate;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTQuadsNotTriples;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BNConstructRewriteOptimizer
extends BlankNodesRewriteOptimizer {
    private List<ASTTriplesBlock> tbList = new ArrayList<ASTTriplesBlock>();
    private List<ASTQuadsNotTriples> qList = new ArrayList<ASTQuadsNotTriples>();

    public Node optimizeConstructQuery(Node node) throws RDFException, ParseException {
        ASTConstructTemplate aSTConstructTemplate = (ASTConstructTemplate)node.jjtGetChild(0);
        ASTGroupGraphPattern aSTGroupGraphPattern = (ASTGroupGraphPattern)node.jjtGetChild(1);
        for (int i = 0; i < aSTConstructTemplate.jjtGetNumChildren(); ++i) {
            SimpleNode simpleNode = (SimpleNode)aSTConstructTemplate.jjtGetChild(i);
            if (simpleNode.id == 46) {
                this.expandQuad((ASTQuadsNotTriples)simpleNode);
                continue;
            }
            if (simpleNode.id != 47) continue;
            this.expandTB((ASTTriplesBlock)simpleNode);
        }
        if (this.tbList.size() > 0 || this.qList.size() > 0) {
            aSTGroupGraphPattern = this.updateGGP(aSTGroupGraphPattern);
        }
        return node;
    }

    private void expandQuad(ASTQuadsNotTriples aSTQuadsNotTriples) throws RDFException, ParseException {
        this.hasBNode = false;
        aSTQuadsNotTriples = (ASTQuadsNotTriples)this.optimizeQuery(aSTQuadsNotTriples);
        if (this.hasBNode) {
            this.qList.add(aSTQuadsNotTriples);
        }
    }

    private void expandTB(ASTTriplesBlock aSTTriplesBlock) throws RDFException, ParseException {
        this.hasBNode = false;
        aSTTriplesBlock = (ASTTriplesBlock)this.optimizeQuery(aSTTriplesBlock);
        if (this.hasBNode) {
            this.tbList.add(aSTTriplesBlock);
        }
    }

    private ASTGroupGraphPattern updateGGP(ASTGroupGraphPattern aSTGroupGraphPattern) {
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples;
        ASTGroupGraphPattern aSTGroupGraphPattern2 = new ASTGroupGraphPattern(48);
        for (int i = aSTGroupGraphPattern.jjtGetNumChildren() - 1; i >= 0; --i) {
            aSTGroupGraphPattern2.jjtAddChild(aSTGroupGraphPattern.jjtGetChild(i), i);
            aSTGroupGraphPattern.jjtGetChild(i).jjtSetParent(aSTGroupGraphPattern2);
            aSTGroupGraphPattern.jjtRemoveChild(i);
        }
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples2 = new ASTGraphPatternNotTriples(49);
        aSTGraphPatternNotTriples2.jjtAddChild(aSTGroupGraphPattern2, 0);
        aSTGroupGraphPattern2.jjtSetParent(aSTGraphPatternNotTriples2);
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples2, 0);
        aSTGraphPatternNotTriples2.jjtSetParent(aSTGroupGraphPattern);
        ASTGroupGraphPattern aSTGroupGraphPattern3 = new ASTGroupGraphPattern(48);
        int n = 0;
        for (ASTTriplesBlock simpleNode : this.tbList) {
            aSTGraphPatternNotTriples = this.triplesBlockToGPNT(simpleNode);
            aSTGroupGraphPattern3.jjtAddChild(aSTGraphPatternNotTriples, n);
            aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern3);
            ++n;
        }
        for (ASTQuadsNotTriples aSTQuadsNotTriples : this.qList) {
            aSTGraphPatternNotTriples = this.quadToGPNT(aSTQuadsNotTriples);
            aSTGroupGraphPattern3.jjtAddChild(aSTGraphPatternNotTriples, n);
            aSTGraphPatternNotTriples.jjtSetParent(aSTGroupGraphPattern3);
            ++n;
        }
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples3 = new ASTGraphPatternNotTriples(49);
        aSTGraphPatternNotTriples3.jjtAddChild(aSTGroupGraphPattern3, 0);
        aSTGroupGraphPattern3.jjtSetParent(aSTGraphPatternNotTriples3);
        aSTGroupGraphPattern.jjtAddChild(aSTGraphPatternNotTriples3, 1);
        aSTGraphPatternNotTriples3.jjtSetParent(aSTGroupGraphPattern);
        return aSTGroupGraphPattern;
    }

    private ASTGraphPatternNotTriples quadToGPNT(ASTQuadsNotTriples aSTQuadsNotTriples) {
        ASTGraphGraphPattern aSTGraphGraphPattern = new ASTGraphGraphPattern(51);
        aSTGraphGraphPattern.jjtAddChild(aSTQuadsNotTriples.jjtGetChild(0), 0);
        aSTQuadsNotTriples.jjtGetChild(0).jjtSetParent(aSTGraphGraphPattern);
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGroupGraphPattern.jjtAddChild(aSTQuadsNotTriples.jjtGetChild(1), 0);
        aSTQuadsNotTriples.jjtGetChild(1).jjtSetParent(aSTGroupGraphPattern);
        aSTGraphGraphPattern.jjtAddChild(aSTGroupGraphPattern, 1);
        aSTGroupGraphPattern.jjtSetParent(aSTGraphGraphPattern);
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        aSTGraphPatternNotTriples.jjtAddChild(aSTGraphGraphPattern, 0);
        aSTGraphGraphPattern.jjtSetParent(aSTGraphPatternNotTriples);
        return aSTGraphPatternNotTriples;
    }

    private ASTGraphPatternNotTriples triplesBlockToGPNT(ASTTriplesBlock aSTTriplesBlock) {
        ASTGroupGraphPattern aSTGroupGraphPattern = new ASTGroupGraphPattern(48);
        aSTGroupGraphPattern.jjtAddChild(aSTTriplesBlock, 0);
        aSTTriplesBlock.jjtSetParent(aSTGroupGraphPattern);
        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
        aSTGraphPatternNotTriples.jjtAddChild(aSTGroupGraphPattern, 0);
        aSTGroupGraphPattern.jjtSetParent(aSTGraphPatternNotTriples);
        return aSTGraphPatternNotTriples;
    }
}

