/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Stack;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTreeOptimizer;
import oracle.spatial.rdf.server.SelectSPARQLTreeNode;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.UnionSPARQLTreeNode;

public class EmptySPARQLTreeOptimizer
implements SPARQLTreeOptimizer {
    @Override
    public SPARQLTreeNode optimizeTree(SPARQLTreeNode sPARQLTreeNode) {
        boolean bl = true;
        while (!sPARQLTreeNode.isEmpty() && bl) {
            bl = this.removeSingleEmptyNode(sPARQLTreeNode);
        }
        bl = true;
        while (!sPARQLTreeNode.isEmpty() && bl) {
            bl = this.removeSingleNonLeafNode(sPARQLTreeNode);
        }
        return sPARQLTreeNode;
    }

    private boolean removeSingleEmptyNode(SPARQLTreeNode sPARQLTreeNode) {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.isEmpty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            for (int i = 0; i < sPARQLTreeNode2.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode3 = sPARQLTreeNode2.getChild(i);
                if (sPARQLTreeNode3.isEmpty()) {
                    sPARQLTreeNode2.removeChild(i);
                    return true;
                }
                stack.push(sPARQLTreeNode3);
            }
        }
        return false;
    }

    private boolean removeSingleNonLeafNode(SPARQLTreeNode sPARQLTreeNode) {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.isEmpty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            for (int i = 0; i < sPARQLTreeNode2.getNumChildren(); ++i) {
                SPARQLTreeNode sPARQLTreeNode3;
                SPARQLTreeNode sPARQLTreeNode4 = sPARQLTreeNode2.getChild(i);
                if (sPARQLTreeNode4.getNumChildren() == 1 && SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode4) && (sPARQLTreeNode4.getOverloadedServiceInfo() & 1) == 0 && sPARQLTreeNode4.getType() == 0 && sPARQLTreeNode4.containsEmptyLocalBGP() && sPARQLTreeNode4.getAllFilters().isEmpty() && (sPARQLTreeNode3 = sPARQLTreeNode4.getChild(0)).getType() == 0 && (SimpleSPARQLTreeNode.class.isInstance(sPARQLTreeNode3) || SelectSPARQLTreeNode.class.isInstance(sPARQLTreeNode3) || UnionSPARQLTreeNode.class.isInstance(sPARQLTreeNode3)) && (sPARQLTreeNode2.isGraphQuery() && sPARQLTreeNode3.isGraphQuery() && sPARQLTreeNode2.getActiveGraph().equals(sPARQLTreeNode3.getActiveGraph()) || !sPARQLTreeNode2.isGraphQuery() && !sPARQLTreeNode3.isGraphQuery())) {
                    sPARQLTreeNode2.removeChild(i);
                    sPARQLTreeNode2.addChild(sPARQLTreeNode3, i);
                    sPARQLTreeNode3.setParent(sPARQLTreeNode2);
                    return true;
                }
                stack.push(sPARQLTreeNode4);
            }
        }
        return false;
    }
}

