/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTModify;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class ModifyRewriteOptimizer
implements SparqlQueryOptimizer {
    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        if (((SimpleNode)node).id == 37) {
            this.rewriteModify((ASTModify)node);
        } else {
            int n = ((SimpleNode)node).jjtGetNumChildren();
            for (int i = 0; i < n; ++i) {
                this.optimizeQuery((SimpleNode)node.jjtGetChild(i));
            }
        }
        return node;
    }

    private void rewriteModify(ASTModify aSTModify) throws ParseException {
        int n = aSTModify.jjtGetNumChildren();
        List<String> list = null;
        block5: for (int i = 0; i < n; ++i) {
            SimpleNode simpleNode = (SimpleNode)aSTModify.jjtGetChild(i);
            switch (simpleNode.id) {
                case 38: {
                    if (!OptimizerUtils.hasBNVar(simpleNode)) continue block5;
                    throw new ParseException("Use of Blank nodes is not allowed inside DELETE clause");
                }
                case 39: {
                    list = OptimizerUtils.collectBNVars(simpleNode);
                    continue block5;
                }
                case 48: {
                    if (list == null || list.size() <= 0) continue block5;
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    for (int j = 0; j < simpleNode.jjtGetNumChildren(); ++j) {
                        arrayList.add(simpleNode.jjtGetChild(j));
                    }
                    List<Node> list2 = OptimizerUtils.buildBNListFromBNVars(list);
                    ASTSelectQuery aSTSelectQuery = OptimizerUtils.genSelectQuery(arrayList, list2, true, null);
                    simpleNode.jjtAddChild(aSTSelectQuery, 0);
                    aSTSelectQuery.jjtSetParent(simpleNode);
                }
            }
        }
    }
}

