/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.spatial.rdf.server.HintEngine;
import oracle.spatial.rdf.server.RDFModelStatistics;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SelectivityEstimator;
import oracle.spatial.rdf.server.TriplesBlock;

public class SimpleSelectivityEstimator
implements SelectivityEstimator {
    private static final BigDecimal VERY_RARE = BigDecimal.ONE.divide(new BigDecimal(1000000000000L));
    private static final BigDecimal RARE = BigDecimal.ONE.divide(new BigDecimal(1000000000L));
    private static final BigDecimal AVERAGE = BigDecimal.ONE.divide(new BigDecimal(1000000L));
    private static final BigDecimal COMMON = BigDecimal.ONE.divide(new BigDecimal(100L));
    private static final BigDecimal VERY_COMMON = BigDecimal.ONE.divide(BigDecimal.TEN);
    private static final BigDecimal BD_TWO = new BigDecimal(2);
    private static final String[][] IGNORED_PRED_URIS = new String[][]{{"http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type"}};
    private static final SimpleSelectivityEstimator INSTANCE = new SimpleSelectivityEstimator();
    private static boolean warned = false;

    private SimpleSelectivityEstimator() {
    }

    public static SimpleSelectivityEstimator getInstance() {
        return INSTANCE;
    }

    public void close() {
    }

    private static void log(String string, Object ... objectArray) {
        System.out.printf("[%5s] %7s: %s\n", "stats", "debug", String.format(string, objectArray));
    }

    private List<Long> getIgnoredPredIDs() {
        boolean bl = HintEngine.getSessionContext().isLogStats();
        LinkedList<Long> linkedList = new LinkedList<Long>();
        for (String[] stringArray : IGNORED_PRED_URIS) {
            Long l = RDFModelStatistics.getCanonicalID(stringArray[0], stringArray[1]);
            if (l == null) continue;
            linkedList.add(l);
            if (!bl) continue;
            SimpleSelectivityEstimator.log("ignoring pred stats for '%s%s', ID=%d", stringArray[0], stringArray[1], l);
        }
        return linkedList;
    }

    @Override
    public Set<SelectivityEstimator.Stats> getTripleStats(Set<SelectivityEstimator.Model> set, SPARQLBGP sPARQLBGP, Set<TriplesBlock> set2) throws SQLException {
        boolean bl = HintEngine.getSessionContext().isLogStats();
        HashSet<SelectivityEstimator.Stats> hashSet = new HashSet<SelectivityEstimator.Stats>();
        BigDecimal bigDecimal = new BigDecimal(this.getTotalNumTuples(set));
        BigDecimal bigDecimal2 = RDFModelStatistics.getPredicateCount(set);
        Map<Long, RDFModelStatistics.PredStats> map = this.getPredStats(set, set2);
        Map<Long, RDFModelStatistics.TermStats> map2 = this.getTermStats(set, set2);
        if (bl) {
            SimpleSelectivityEstimator.log("%10s %20s: %12d", "(estimate)", "total num triples", bigDecimal.longValue());
            SimpleSelectivityEstimator.log("%10s %20s: %12d", "(estimate)", "total num preds", bigDecimal2.longValue());
        }
        List<Long> list = this.getIgnoredPredIDs();
        for (TriplesBlock triplesBlock : set2) {
            BigDecimal bigDecimal3 = this.getSelectivity(map2, map, list, bigDecimal, bigDecimal2, set, sPARQLBGP, triplesBlock);
            long l = bigDecimal.multiply(bigDecimal3).setScale(0, RoundingMode.HALF_EVEN).longValue();
            if (bl) {
                SimpleSelectivityEstimator.log("%10s %20s: %12d %6.4f (%s)", "(estimate)", "triple selectivity", l, Float.valueOf(bigDecimal3.floatValue()), triplesBlock.toString());
            }
            hashSet.add(new SelectivityEstimator.Stats(l, bigDecimal3, triplesBlock));
        }
        return hashSet;
    }

    @Override
    public long getTotalNumTuples(Set<SelectivityEstimator.Model> set) throws SQLException {
        BigDecimal bigDecimal = RDFModelStatistics.getPredicateInstances(set);
        bigDecimal = bigDecimal != null ? bigDecimal : BigDecimal.ONE.divide(VERY_RARE);
        return bigDecimal.longValue();
    }

    private Map<Long, RDFModelStatistics.TermStats> getTermStats(Set<SelectivityEstimator.Model> set, Set<TriplesBlock> set2) {
        HashSet<Long> hashSet = new HashSet<Long>();
        boolean bl = HintEngine.getSessionContext().isLogStats();
        for (TriplesBlock triplesBlock : set2) {
            if (!(triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists())) {
                if (!bl) continue;
                System.out.printf("[%5s] %7s: %s\n", "stats", "debug", "skipping term stats collection for triple (does not exist): " + triplesBlock);
                continue;
            }
            switch (triplesBlock.getType()) {
                case EXACT_S: 
                case MISSING_O: {
                    hashSet.add(triplesBlock.getSubject().getCanonicalID());
                    break;
                }
                case EXACT_O: 
                case MISSING_S: {
                    hashSet.add(triplesBlock.getObject().getCanonicalID());
                    break;
                }
            }
        }
        return RDFModelStatistics.getTermStats(set, hashSet);
    }

    private Map<Long, RDFModelStatistics.PredStats> getPredStats(Set<SelectivityEstimator.Model> set, Set<TriplesBlock> set2) {
        HashSet<Long> hashSet = new HashSet<Long>();
        boolean bl = HintEngine.getSessionContext().isLogStats();
        for (TriplesBlock triplesBlock : set2) {
            if (!(triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists())) {
                if (!bl) continue;
                System.out.printf("[%5s] %7s: %s\n", "stats", "debug", "skipping pred stats collection for triple (does not exist): " + triplesBlock);
                continue;
            }
            switch (triplesBlock.getType()) {
                case MISSING_O: 
                case MISSING_S: 
                case EXACT_P: {
                    hashSet.add(triplesBlock.getPredicate().getCanonicalID());
                    break;
                }
            }
        }
        return RDFModelStatistics.getPredStats(set, hashSet);
    }

    private BigDecimal getSelectivity(Map<Long, RDFModelStatistics.TermStats> map, Map<Long, RDFModelStatistics.PredStats> map2, List<Long> list, BigDecimal bigDecimal, BigDecimal bigDecimal2, Set<SelectivityEstimator.Model> set, SPARQLBGP sPARQLBGP, TriplesBlock triplesBlock) throws SQLException {
        BigDecimal bigDecimal3;
        if (!(triplesBlock.getSubject().exists() && triplesBlock.getPredicate().exists() && triplesBlock.getObject().exists())) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal4 = bigDecimal;
        BigDecimal bigDecimal5 = bigDecimal3 = BigDecimal.ZERO.compareTo(bigDecimal2) == 0 ? null : bigDecimal2;
        if (BigDecimal.ZERO.compareTo(bigDecimal4) == 0) {
            return BigDecimal.ZERO;
        }
        boolean bl = list.contains(triplesBlock.getPredicate().getCanonicalID());
        switch (triplesBlock.getType()) {
            case WILDCARD: {
                return BigDecimal.ONE;
            }
            case EXACT: {
                if (bigDecimal4 != null) {
                    return this.divide(BigDecimal.ONE, bigDecimal4);
                }
                return VERY_RARE;
            }
            case EXACT_S: {
                BigDecimal bigDecimal6;
                long l = triplesBlock.getSubject().getCanonicalID();
                RDFModelStatistics.TermStats termStats = map.get(l);
                BigDecimal bigDecimal7 = bigDecimal6 = termStats == null ? null : termStats.getSubjectInstances();
                if (bigDecimal6 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal6, bigDecimal4);
                }
                if (bigDecimal3 != null && bigDecimal4 != null) {
                    return this.divide(this.divide(bigDecimal3, BD_TWO), bigDecimal4);
                }
                return RARE;
            }
            case EXACT_P: {
                BigDecimal bigDecimal8;
                long l = triplesBlock.getPredicate().getCanonicalID();
                RDFModelStatistics.PredStats predStats = map2.get(l);
                BigDecimal bigDecimal9 = bigDecimal8 = predStats == null ? null : predStats.getInstances();
                if (bigDecimal8 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal8, bigDecimal4);
                }
                if (bigDecimal3 != null) {
                    return this.divide(BigDecimal.ONE, bigDecimal3);
                }
                return COMMON;
            }
            case EXACT_O: {
                BigDecimal bigDecimal10;
                long l = triplesBlock.getObject().getCanonicalID();
                RDFModelStatistics.TermStats termStats = map.get(l);
                BigDecimal bigDecimal11 = bigDecimal10 = termStats == null ? null : termStats.getObjectInstances();
                if (bigDecimal10 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal10, bigDecimal4);
                }
                return AVERAGE;
            }
            case MISSING_S: {
                BigDecimal bigDecimal12;
                long l = triplesBlock.getObject().getCanonicalID();
                RDFModelStatistics.TermStats termStats = map.get(l);
                BigDecimal bigDecimal13 = termStats == null ? null : termStats.getObjectInstances();
                l = triplesBlock.getPredicate().getCanonicalID();
                RDFModelStatistics.PredStats predStats = map2.get(l);
                BigDecimal bigDecimal14 = predStats == null || bigDecimal13 != null && bl ? null : predStats.getInstances();
                BigDecimal bigDecimal15 = bigDecimal12 = predStats == null || bigDecimal13 != null && bl ? null : predStats.getObjectFanout();
                if (BigDecimal.ZERO.equals(bigDecimal12)) {
                    bigDecimal12 = null;
                }
                if (BigDecimal.ZERO.equals(bigDecimal14)) {
                    bigDecimal14 = null;
                }
                if (BigDecimal.ZERO.equals(bigDecimal12) || BigDecimal.ZERO.equals(bigDecimal14)) {
                    System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unusual statistics for predicate ID " + triplesBlock.getPredicate().getCanonicalID());
                }
                if ((bigDecimal14 == null || bigDecimal12 == null) && bigDecimal13 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal13, bigDecimal4);
                }
                if (bigDecimal13 == null && bigDecimal14 != null && bigDecimal12 != null && bigDecimal4 != null) {
                    return this.divide(this.divide(bigDecimal14, bigDecimal12), bigDecimal4);
                }
                if (bigDecimal14 != null && bigDecimal12 != null && bigDecimal13 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal13.min(this.divide(bigDecimal14, bigDecimal12)), bigDecimal4);
                }
                if (bl) {
                    return AVERAGE;
                }
                return RARE;
            }
            case MISSING_P: {
                return VERY_RARE;
            }
            case MISSING_O: {
                BigDecimal bigDecimal16;
                long l = triplesBlock.getPredicate().getCanonicalID();
                RDFModelStatistics.PredStats predStats = map2.get(l);
                BigDecimal bigDecimal17 = predStats == null ? null : predStats.getInstances();
                BigDecimal bigDecimal18 = predStats == null ? null : predStats.getSubjectFanout();
                l = triplesBlock.getSubject().getCanonicalID();
                RDFModelStatistics.TermStats termStats = map.get(l);
                BigDecimal bigDecimal19 = bigDecimal16 = termStats == null ? null : termStats.getSubjectInstances();
                if (BigDecimal.ZERO.equals(bigDecimal18)) {
                    bigDecimal18 = null;
                }
                if (BigDecimal.ZERO.equals(bigDecimal17)) {
                    bigDecimal17 = null;
                }
                if (BigDecimal.ZERO.equals(bigDecimal18) || BigDecimal.ZERO.equals(bigDecimal17)) {
                    System.err.printf("[%5s] %7s: %s\n", "stats", "warning", "unusual statistics for predicate ID " + triplesBlock.getPredicate().getCanonicalID());
                }
                if ((bigDecimal17 == null || bigDecimal18 == null) && bigDecimal16 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal16, bigDecimal4);
                }
                if (bigDecimal16 == null && bigDecimal17 != null && bigDecimal18 != null && bigDecimal4 != null) {
                    return this.divide(this.divide(bigDecimal17, bigDecimal18), bigDecimal4);
                }
                if (bigDecimal17 != null && bigDecimal18 != null && bigDecimal16 != null && bigDecimal4 != null) {
                    return this.divide(bigDecimal16.min(this.divide(bigDecimal17, bigDecimal18)), bigDecimal4);
                }
                return VERY_RARE;
            }
        }
        return AVERAGE;
    }

    private BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128);
    }
}

