/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.cmdline.editor;

import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Stack;
import jline.Terminal;
import jline.TerminalFactory;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.KeyMap;
import jline.console.Operation;
import jline.console.UserInterruptException;
import jline.internal.Configuration;
import jline.internal.InputStreamReader;
import jline.internal.Log;
import jline.internal.Urls;
import oracle.dbtools.raptor.console.clone.ConsoleKeys;
import oracle.dbtools.raptor.console.clone.DbtoolsNonBlockingInputStream;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiOutputStream;

public class FullScreenConsoleReader
extends ConsoleReader {
    public static final char ESC = '\u001b';
    public static final String ANSI_CLS = "\u001b[2J";
    public static final String ANSI_HOME = "\u001b[H";
    public static final String ANSI_HEAD = "\u001b[1G";
    public static final String ANSI_UP = "\u001b[P1A";
    public static final String ANSI_DOWN = "\u001b[P1B";
    private String appName;
    private String encoding;
    private final Terminal terminal;
    private final Writer out;
    private DbtoolsNonBlockingInputStream in;
    private long escapeTimeout;
    private Reader reader;
    private URL inputrcUrl;
    private ConsoleKeys consoleKeys;
    private Character mask;
    private static final int KEYMAP_LENGTH = 256;
    private boolean handleUserInterrupt = false;
    private StringBuffer searchTerm = null;
    private String previousSearchTerm = "";
    private int searchIndex = -1;
    private String prompt;
    private final CursorBuffer buf = new CursorBuffer();
    private boolean copyPasteDetection = false;
    private int promptLen;

    public static KeyMap keymap() {
        Object[] map = new Object[256];
        return null;
    }

    public FullScreenConsoleReader() throws Exception {
        this(null, new FileInputStream(FileDescriptor.in), System.out, null);
    }

    public FullScreenConsoleReader(InputStream in, OutputStream out) throws Exception {
        this(null, in, out, null);
    }

    public FullScreenConsoleReader(InputStream in, OutputStream out, Terminal term) throws Exception {
        this(null, in, out, term);
    }

    public FullScreenConsoleReader(String appName, InputStream in, OutputStream out, Terminal term) throws Exception {
        this(appName, in, out, term, null);
    }

    public FullScreenConsoleReader(String appName, InputStream in, OutputStream out, Terminal term, String encoding) throws Exception {
        this.appName = appName != null ? appName : "JLine";
        this.encoding = encoding != null ? encoding : Configuration.getEncoding();
        this.terminal = term != null ? term : TerminalFactory.getFlavor((TerminalFactory.Flavor)TerminalFactory.Flavor.UNIX);
        String outEncoding = this.terminal.getOutputEncoding() != null ? this.terminal.getOutputEncoding() : this.encoding;
        this.out = new OutputStreamWriter(this.terminal.wrapOutIfNeeded(out), outEncoding);
        this.setInput(in);
        this.inputrcUrl = this.getInputRc();
        this.consoleKeys = new ConsoleKeys(this.appName, this.inputrcUrl);
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character mask) throws IOException {
        return this.readLine(null, mask);
    }

    public String readLine(String prompt) throws IOException {
        return this.readLine(prompt, null);
    }

    void setInput(InputStream in) throws IOException {
        boolean nonBlockingEnabled;
        this.escapeTimeout = Configuration.getLong((String)"jline.esc.timeout", (long)100L);
        boolean bl = nonBlockingEnabled = this.escapeTimeout > 0L && this.terminal.isSupported() && in != null;
        if (this.in != null) {
            this.in.shutdown();
        }
        InputStream wrapped = this.terminal.wrapInIfNeeded(in);
        this.in = DbtoolsNonBlockingInputStream.getInstance(wrapped, nonBlockingEnabled);
        this.reader = new InputStreamReader((InputStream)this.in, this.encoding);
    }

    private URL getInputRc() throws IOException {
        String path = Configuration.getString((String)"jline.inputrc");
        if (path == null) {
            File f = new File(Configuration.getUserHome(), ".inputrc");
            if (!f.exists()) {
                f = new File("/etc/inputrc");
            }
            return f.toURI().toURL();
        }
        return Urls.create((String)path);
    }

    public String readLine(String prompt, Character mask) throws IOException {
        int repeatCount = 0;
        this.mask = mask;
        if (prompt != null) {
            this.setPrompt(prompt);
        } else {
            prompt = this.getPrompt();
        }
        try {
            if (prompt != null && prompt.length() > 0) {
                this.out.write(prompt);
                this.out.flush();
            }
            String originalPrompt = this.prompt;
            boolean success = true;
            StringBuilder sb = new StringBuilder();
            Stack<Character> pushBackChar = new Stack<Character>();
            while (true) {
                int c;
                int n = c = pushBackChar.isEmpty() ? this.readCharacter() : (int)((Character)pushBackChar.pop()).charValue();
                if (c == -1) {
                    String string = null;
                    return string;
                }
                sb.appendCodePoint(c);
                Object o = this.getKeys().getBound((CharSequence)sb);
                if (o == Operation.DO_LOWERCASE_VERSION) {
                    sb.setLength(sb.length() - 1);
                    sb.append(Character.toLowerCase((char)c));
                    o = this.getKeys().getBound((CharSequence)sb);
                }
                if (o instanceof KeyMap) {
                    if (c != 27 || !pushBackChar.isEmpty() || !this.in.isNonBlockingEnabled() || this.in.peek(this.escapeTimeout) != -2 || (o = ((KeyMap)o).getAnotherKey()) == null || o instanceof KeyMap) continue;
                    sb.setLength(0);
                }
                while (o == null && sb.length() > 0) {
                    c = sb.charAt(sb.length() - 1);
                    sb.setLength(sb.length() - 1);
                    Object o2 = this.getKeys().getBound((CharSequence)sb);
                    if (!(o2 instanceof KeyMap) || (o = ((KeyMap)o2).getAnotherKey()) == null) continue;
                    pushBackChar.push(Character.valueOf((char)c));
                }
                if (o == null) continue;
                Log.trace((Object[])new Object[]{"Binding: ", o});
                if (o instanceof String) {
                    String macro = (String)o;
                    for (int i = 0; i < macro.length(); ++i) {
                        pushBackChar.push(Character.valueOf(macro.charAt(macro.length() - 1 - i)));
                    }
                    sb.setLength(0);
                    continue;
                }
                if (o instanceof ActionListener) {
                    ((ActionListener)o).actionPerformed(null);
                    sb.setLength(0);
                    continue;
                }
                boolean isArgDigit = false;
                int count = repeatCount == 0 ? 1 : repeatCount;
                success = true;
                if (o instanceof Operation) {
                    Operation op = (Operation)o;
                    int cursorStart = this.buf.cursor;
                    switch (op) {
                        case COMPLETE: {
                            boolean isTabLiteral = false;
                            if (this.copyPasteDetection && c == 9 && (!pushBackChar.isEmpty() || this.in.isNonBlockingEnabled() && this.in.peek(this.escapeTimeout) != -2)) {
                                isTabLiteral = true;
                            }
                            if (!isTabLiteral) {
                                success = this.complete();
                                break;
                            }
                            this.putString(sb);
                            break;
                        }
                        case POSSIBLE_COMPLETIONS: {
                            this.printCompletionCandidates();
                            break;
                        }
                        case BEGINNING_OF_LINE: {
                            success = this.setCursorPosition(0);
                            break;
                        }
                        case YANK: {
                            success = this.yank();
                            break;
                        }
                        case YANK_POP: {
                            success = this.yankPop();
                            break;
                        }
                        case KILL_LINE: {
                            success = this.killLine();
                            break;
                        }
                        case KILL_WHOLE_LINE: {
                            success = this.setCursorPosition(0) && this.killLine();
                            break;
                        }
                        case CLEAR_SCREEN: {
                            success = this.clearScreen();
                            this.redrawLine();
                            break;
                        }
                        case OVERWRITE_MODE: {
                            this.buf.setOverTyping(!this.buf.isOverTyping());
                            break;
                        }
                        case SELF_INSERT: {
                            this.putString(sb);
                            break;
                        }
                        case ACCEPT_LINE: {
                            String string = this.accept();
                            return string;
                        }
                        case INTERRUPT: {
                            if (!this.handleUserInterrupt) break;
                            this.println();
                            this.flush();
                            String partialLine = this.buf.buffer.toString();
                            this.buf.clear();
                            throw new UserInterruptException(partialLine);
                        }
                        case BACKWARD_WORD: {
                            success = this.word(false);
                            break;
                        }
                        case FORWARD_WORD: {
                            success = this.word(true);
                            break;
                        }
                        case PREVIOUS_HISTORY: {
                            success = this.move(false);
                            break;
                        }
                        case NEXT_HISTORY: {
                            success = this.move(true);
                            break;
                        }
                        case BACKWARD_DELETE_CHAR: {
                            success = this.backspace();
                            break;
                        }
                        case EXIT_OR_DELETE_CHAR: {
                            String string = null;
                            return string;
                        }
                        case DELETE_CHAR: {
                            success = this.deleteCurrentCharacter();
                            break;
                        }
                        case BACKWARD_CHAR: {
                            success = this.moveCursor(-count) != 0;
                            break;
                        }
                        case FORWARD_CHAR: {
                            success = this.moveCursor(count) != 0;
                            break;
                        }
                        case UNIX_LINE_DISCARD: {
                            success = this.resetLine();
                            break;
                        }
                        case END_OF_LINE: {
                            success = this.moveToEnd();
                            break;
                        }
                        case TAB_INSERT: {
                            this.putString("\t");
                            break;
                        }
                    }
                }
                if (!success) {
                    this.beep();
                }
                sb.setLength(0);
                this.flush();
            }
        }
        finally {
            if (!this.terminal.isSupported()) {
                // empty if block
            }
        }
    }

    private boolean word(boolean b) {
        return false;
    }

    private boolean move(boolean down) throws IOException {
        String DOWN = "P1A";
        String UP = "P1B";
        if (down) {
            this.out.write(Ansi.ansi().cursorDown(1).toString());
            this.out.flush();
        } else {
            this.out.write(Ansi.ansi().cursorUp(1).toString());
            this.out.flush();
        }
        return false;
    }

    public void setCopyPasteDetection(boolean onoff) {
        this.copyPasteDetection = onoff;
    }

    public boolean isCopyPasteDetectionEnabled() {
        return this.copyPasteDetection;
    }

    private boolean deleteCurrentCharacter() throws IOException {
        if (this.buf.length() == 0 || this.buf.cursor == this.buf.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private void drawBuffer(int clear) throws IOException {
        if (this.buf.cursor != this.buf.length() || clear != 0) {
            char[] chars = this.buf.buffer.substring(this.buf.cursor).toCharArray();
            if (this.mask != null) {
                Arrays.fill(chars, this.mask.charValue());
            }
            if (this.terminal.hasWeirdWrap()) {
                int width = this.terminal.getWidth();
                int pos = this.getCursorPosition();
                for (int i = 0; i < chars.length; ++i) {
                    this.print((int)chars[i]);
                    if ((pos + i + 1) % width != 0) continue;
                    this.print(32);
                    this.print(13);
                }
            } else {
                this.print(chars);
            }
            this.clearAhead(clear, chars.length);
            if (this.terminal.isAnsiSupported()) {
                if (chars.length > 0) {
                    this.back(chars.length);
                }
            } else {
                this.back(chars.length);
            }
        }
        if (this.terminal.hasWeirdWrap()) {
            int width = this.terminal.getWidth();
            if (this.getCursorPosition() > 0 && this.getCursorPosition() % width == 0 && this.buf.cursor == this.buf.length() && clear == 0) {
                this.print(32);
                this.print(13);
            }
        }
    }

    private void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    int getCursorPosition() {
        return this.promptLen + this.buf.cursor;
    }

    private void print(int c) throws IOException {
        if (c == 9) {
            char[] chars = new char[8];
            Arrays.fill(chars, ' ');
            this.out.write(chars);
            return;
        }
        this.out.write(c);
    }

    private void print(char ... buff) throws IOException {
        char[] chars;
        int len = 0;
        for (char c : buff) {
            if (c == '\t') {
                len += 8;
                continue;
            }
            ++len;
        }
        if (len == buff.length) {
            chars = buff;
        } else {
            chars = new char[len];
            int pos = 0;
            for (char c : buff) {
                if (c == '\t') {
                    Arrays.fill(chars, pos, pos + 8, ' ');
                    pos += 8;
                    continue;
                }
                chars[pos] = c;
                ++pos;
            }
        }
        this.out.write(chars);
    }

    private void clearAhead(int num, int delta) throws IOException {
        if (num == 0) {
            return;
        }
        if (this.terminal.isAnsiSupported()) {
            int i;
            int width = this.terminal.getWidth();
            int screenCursorCol = this.getCursorPosition() + delta;
            this.printAnsiSequence("K");
            int curCol = screenCursorCol % width;
            int endCol = (screenCursorCol + num - 1) % width;
            int lines = num / width;
            if (endCol < curCol) {
                ++lines;
            }
            for (i = 0; i < lines; ++i) {
                this.printAnsiSequence("B");
                this.printAnsiSequence("2K");
            }
            for (i = 0; i < lines; ++i) {
                this.printAnsiSequence("A");
            }
            return;
        }
        this.print(' ', num);
        this.back(num);
    }

    private void printAnsiSequence(String sequence) throws IOException {
        this.print(27);
        this.print(91);
        this.print(sequence);
        this.flush();
    }

    private void print(char c, int num) throws IOException {
        if (num == 1) {
            this.print((int)c);
        } else {
            char[] chars = new char[num];
            Arrays.fill(chars, c);
            this.print(chars);
        }
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.promptLen = prompt == null ? 0 : this.stripAnsi(this.lastLine(prompt)).length();
    }

    private String stripAnsi(String str) {
        if (str == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AnsiOutputStream aos = new AnsiOutputStream((OutputStream)baos);
            aos.write(str.getBytes());
            aos.flush();
            return baos.toString();
        }
        catch (IOException e) {
            return str;
        }
    }

    private String lastLine(String str) {
        if (str == null) {
            return "";
        }
        int last = str.lastIndexOf("\n");
        if (last >= 0) {
            return str.substring(last + 1, str.length());
        }
        return str;
    }
}

