/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.security.pki.OraclePKIProvider;

@Restricted(level=Restricted.Level.R4)
public class SetWallet
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setwallet")) {
            Security.addProvider((Provider)new OraclePKIProvider());
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3) {
                ctx.write(Messages.getString("WALLET_USAGE"));
                return true;
            }
            if (parts[3].equalsIgnoreCase("off")) {
                System.setProperty("oracle.net.wallet_location", "");
                System.setProperty("oracle.net.tns_admin", "");
                System.setProperty("oracle.net.ssl_server_dn_match", "");
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 2; i <= parts.length; ++i) {
                    sb.append(parts[i]).append(" ");
                }
                File f = new File(sb.toString());
                if (f.exists() && f.isDirectory()) {
                    ctx.write(MessageFormat.format(Messages.getString("WALLET_LOCATION"), sb) + "\n");
                    System.setProperty("oracle.net.wallet_location", "(SOURCE=(METHOD=file)(METHOD_DATA=(DIRECTORY=" + sb.toString() + ")))");
                    System.setProperty("oracle.net.ssl_server_dn_match", "true");
                } else {
                    ctx.write(MessageFormat.format(Messages.getString("WALLET_INVALID"), f.getAbsolutePath()) + "\n");
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String message = null;
        message = System.getProperty("oracle.net.wallet_location") != null ? MessageFormat.format(Messages.getString("WALLET_LOCATION"), System.getProperty("oracle.net.wallet_location")) : Messages.getString("WALLET_NOLOCATION");
        ctx.write("");
        ctx.write(message + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"wallet"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

