/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ListPrinter;
import org.fusesource.jansi.Ansi;

public class AnsiColorListPrinter
extends ListPrinter {
    @Override
    public void printListofList(ScriptRunnerContext ctx, String title, List<List<?>> rows) {
        if (title != null) {
            ctx.write(Ansi.ansi().format(title, new Object[0]).reset() + "\n");
        }
        this.printListofList(ctx, rows);
    }

    @Override
    public void printHeaders(OutputStreamWriter out, int[] widths, int j, List<?> headers, List<Boolean> isNumber) throws IOException {
        for (Object col : headers) {
            String align;
            String string = align = isNumber != null && isNumber.get(j) != false ? "" : "-";
            if (col.toString().indexOf("@|") >= 0 && col.toString().indexOf("|@") > 0) {
                out.write(Ansi.ansi().render("%" + align + widths[j] + "s", new Object[]{Ansi.ansi().render(col.toString())}).reset().toString());
            } else {
                out.write(Ansi.ansi().a(Ansi.Attribute.UNDERLINE).a(Ansi.Attribute.INTENSITY_BOLD).format("%" + align + widths[j] + "s", new Object[]{col.toString()}).reset().toString());
            }
            out.write(" ");
            ++j;
        }
        out.write("\n");
    }

    @Override
    public void writeBoldUnderlineFormat(ScriptRunnerContext ctx, String col, int width) {
        ctx.write(Ansi.ansi().bold().a(Ansi.Attribute.UNDERLINE).format("%-" + width + "s", new Object[]{col}).reset().toString());
        ctx.write(" ");
    }

    @Override
    public void printValue(OutputStreamWriter out, int i, String val, boolean isNumber) throws IOException {
        String align = isNumber ? "" : "-";
        out.write(String.format("%" + align + i + "s", Ansi.ansi().render(val)));
        out.write(" ");
    }
}

