/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.ide.datatransfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.bm.javatools.datatransfer.Flavor;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

public class FlavorAdapter {
    private FlavorAdapter() {
    }

    public static Flavor getFlavor(HashStructure hs) {
        String primaryType = hs.getString("primaryType");
        String subType = hs.getString("subType");
        MetaClass mc = LazyClassAdapter.getInstance((HashStructure)hs).getMetaClass("representationClass");
        ClassLoader classLoader = null;
        String representationClass = null;
        if (mc != null) {
            classLoader = mc.getClassLoader();
            representationClass = mc.getClassName();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        List params = hs.getAsList("param");
        if (params != null) {
            for (Object param : params) {
                if (!(param instanceof HashStructure)) continue;
                HashStructure paramHS = (HashStructure)param;
                String key = paramHS.getString("key");
                String value = paramHS.getString("value");
                parameters.put(key, value);
            }
        }
        return new Flavor(primaryType, subType, classLoader, representationClass, parameters);
    }

    public static List<Flavor> getFlavors(List<HashStructure> list) {
        ArrayList<Flavor> flavors = new ArrayList<Flavor>();
        if (list != null) {
            for (HashStructure hs : list) {
                flavors.add(FlavorAdapter.getFlavor(hs));
            }
        }
        return flavors;
    }
}

