/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.commandline;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.osgi.boot.api.Platform;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.deferredupdate.task.CreateExtraInfoTask;
import oracle.ideimpl.deferredupdate.task.TaskContext;
import oracle.ideimpl.deferredupdate.task.TaskFailedException;
import oracle.ideimpl.webupdate.CustomTypeDefinition;
import oracle.ideimpl.webupdate.CustomUpdateType;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.InstallProgressMonitor;
import oracle.ideimpl.webupdate.InstallProgressPanel;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateHandlerHook;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.UpdateInstaller;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.ideimpl.webupdate.UpdateTool;
import oracle.ideimpl.webupdate.uninstall.CFUBundlesExtraInfo;
import oracle.ideimpl.webupdate.uninstall.ManageInstalledUpdates;
import oracle.ideimpl.webupdate.wizard.UpdateWizardModel;
import oracle.javatools.dialogs.ExceptionDialog;
import org.osgi.framework.Bundle;

public class PreInstaller {
    private UpdateWizardModel _model;
    private UpdateManager _updateManager;
    private boolean _commandLine;

    public static PreInstaller createCommandLineInstaller(Directories directories) {
        return new PreInstaller(directories);
    }

    public static PreInstaller createUpdateWizardInstaller(UpdateWizardModel model, UpdateManager updateManager) {
        return new PreInstaller(model, updateManager);
    }

    private PreInstaller(Directories directories) {
        this.getModel();
        this.getManager().setDirectories(directories);
        this._commandLine = true;
    }

    private PreInstaller(UpdateWizardModel model, UpdateManager updateManager) {
        this._model = model;
        this._updateManager = updateManager;
        this._commandLine = false;
    }

    public UpdateWizardModel getModel() {
        if (this._model == null) {
            this._model = new UpdateWizardModel(this.getManager());
        }
        return this._model;
    }

    private UpdateManager getManager() {
        if (this._updateManager == null) {
            this._updateManager = UpdateManager.getInstance();
        }
        return this._updateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        HashMap<MetaClass<UpdateInstaller>, List<UpdateInfo>> noRestartUninstalls = new HashMap<MetaClass<UpdateInstaller>, List<UpdateInfo>>();
        HashMap<MetaClass<UpdateInstaller>, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>> noRestartInstalls = new HashMap<MetaClass<UpdateInstaller>, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>>();
        ArrayList<String> updateList = new ArrayList<String>();
        if (this.getModel().getLocalBundles().size() > 0) {
            List<LocalUpdateBundle> localBundles = this.getModel().getLocalBundles();
            for (LocalUpdateBundle localUpdateBundle : localBundles) {
                this.seedInstaller(noRestartUninstalls, noRestartInstalls, updateList, localUpdateBundle.getBundle(), localUpdateBundle.getBundleFile());
            }
        } else {
            Map zipFilesByBundle = this.getModel().getDownloadedUpdates();
            if (zipFilesByBundle == null) {
                return;
            }
            for (Map.Entry entry : zipFilesByBundle.entrySet()) {
                UpdateBundle bundle = (UpdateBundle)entry.getKey();
                File zipFile = (File)entry.getValue();
                this.seedInstaller(noRestartUninstalls, noRestartInstalls, updateList, bundle, zipFile);
            }
        }
        if (!noRestartUninstalls.isEmpty() || !noRestartInstalls.isEmpty()) {
            UpdateInstaller ui;
            final HashMap<UpdateInstaller, List<UpdateInfo>> uninstalls = new HashMap<UpdateInstaller, List<UpdateInfo>>();
            final HashMap<UpdateInstaller, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>> installs = new HashMap<UpdateInstaller, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>>();
            if (!noRestartUninstalls.isEmpty()) {
                for (MetaClass mcui : noRestartUninstalls.keySet()) {
                    ui = PreInstaller.getUpdateInstaller((MetaClass<UpdateInstaller>)mcui);
                    if (ui == null) continue;
                    uninstalls.put(ui, (List<UpdateInfo>)noRestartUninstalls.get(mcui));
                }
            }
            if (!noRestartInstalls.isEmpty()) {
                for (MetaClass mcui : noRestartInstalls.keySet()) {
                    ui = PreInstaller.getUpdateInstaller((MetaClass<UpdateInstaller>)mcui);
                    if (ui == null) continue;
                    installs.put(ui, (List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>)noRestartInstalls.get(mcui));
                }
            }
            JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)IdeUtil.getMainWindow(), (String)UpdateArb.getString(222), (int)0);
            final InstallProgressPanel ipp = new InstallProgressPanel(jEWTDialog, uninstalls, installs);
            jEWTDialog.setContent((Component)ipp);
            jEWTDialog.pack();
            jEWTDialog.setPreferredSize(900, 450);
            jEWTDialog.setResizable(true);
            final InstallProgressMonitor ipm = new InstallProgressMonitor(ipp);
            ipp.setProgressMonitor(ipm);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!uninstalls.isEmpty()) {
                        for (UpdateInstaller ui : uninstalls.keySet()) {
                            try {
                                if (!ipm.isCancelled()) {
                                    ui.uninstall((List)uninstalls.get(ui), ipm);
                                    if (ipm.isCancelled()) continue;
                                    for (UpdateInfo update : (List)uninstalls.get(ui)) {
                                        ManageInstalledUpdates.deleteFromCFUExtras(update);
                                    }
                                    continue;
                                }
                                for (UpdateInfo update : (List)uninstalls.get(ui)) {
                                    ipm.setStatus(update.getID(), InstallProgressMonitor.InstallStatus.CANCELLED, "");
                                }
                            }
                            catch (Throwable th) {
                                Logger.getLogger("global").log(Level.SEVERE, "Error uninstalling update(s) for " + ui.getInstallerName() + ": " + th.getMessage());
                                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)th);
                            }
                        }
                    }
                    if (!installs.isEmpty()) {
                        for (UpdateInstaller ui : installs.keySet()) {
                            try {
                                if (!ipm.isCancelled()) {
                                    ui.install((List)installs.get(ui), ipm);
                                    if (ipm.isCancelled()) continue;
                                    for (AbstractMap.SimpleImmutableEntry updateEntry : (List)installs.get(ui)) {
                                        PreInstaller.this.writeToCFUExtras((UpdateInfo)updateEntry.getKey());
                                    }
                                    continue;
                                }
                                for (AbstractMap.SimpleImmutableEntry updateEntry : (List)installs.get(ui)) {
                                    ipm.setStatus(((UpdateInfo)updateEntry.getKey()).getID(), InstallProgressMonitor.InstallStatus.CANCELLED, "");
                                }
                            }
                            catch (Throwable th) {
                                Logger.getLogger("global").log(Level.SEVERE, "Error installing update(s) for " + ui.getInstallerName() + ": " + th.getMessage());
                                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)th);
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JPanel cards = ipp.getButtonCards();
                            CardLayout cl = (CardLayout)cards.getLayout();
                            cl.show(cards, UpdateArb.getString(224));
                        }
                    });
                }
            });
            t.start();
            jEWTDialog.runDialog();
        }
        if (!updateList.isEmpty()) {
            File duFile = UpdateManager.getInstance().getDeferredUpdatesFile();
            if (!duFile.exists()) {
                ArrayList<String> dirList = new ArrayList<String>();
                UpdateManager updateManager = UpdateManager.getInstance();
                updateManager.getDirectories().save(dirList);
                updateList.addAll(0, dirList);
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(duFile, duFile.exists()));
                    for (String line : updateList) {
                        writer.write(line);
                        writer.newLine();
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException iOException) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)iOException);
            }
        }
    }

    private void seedInstaller(Map<MetaClass<UpdateInstaller>, List<UpdateInfo>> noRestartUninstalls, Map<MetaClass<UpdateInstaller>, List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>> noRestartInstalls, List<String> updateList, UpdateBundle bundle, File zipFile) {
        UpdateTool ut;
        List<CustomUpdateType> cuts;
        MetaClass<UpdateInstaller> ui;
        UpdateTool ut2;
        boolean found;
        List<CustomUpdateType> cuts2;
        CustomTypeDefinition ctd;
        block0: for (UpdateInfo update : bundle.getUpdates()) {
            if (!ManageInstalledUpdates.isUpdateInstalled(update) || !update.getType().equals((Object)UpdateInfo.Type.CUSTOM) || update.getCustomType().equals("osgi")) continue;
            ctd = UpdateHandlerHook.getCustomTypeDefinition();
            cuts2 = ctd.getCustomUpdateTypes();
            found = false;
            for (CustomUpdateType t : cuts2) {
                if (t.getType().equals(update.getCustomType())) {
                    found = true;
                    ut2 = t.getUpdateTool();
                    if (ut2 != null && ut2.isExtensionManaged() && ut2.isUninstallSupported() && (ui = ut2.getUpdateInstallerMetaClass()) != null) {
                        List<UpdateInfo> v = noRestartUninstalls.get(ui);
                        if (v == null) {
                            v = new ArrayList<UpdateInfo>();
                        }
                        v.add(update);
                        noRestartUninstalls.put(ui, v);
                    }
                }
                if (!found) continue;
                continue block0;
            }
        }
        block2: for (UpdateInfo update : bundle.getUpdates()) {
            if (!update.getType().equals((Object)UpdateInfo.Type.CUSTOM) || update.getCustomType().equals("osgi")) continue;
            ctd = UpdateHandlerHook.getCustomTypeDefinition();
            cuts2 = ctd.getCustomUpdateTypes();
            found = false;
            for (CustomUpdateType t : cuts2) {
                if (t.getType().equals(update.getCustomType())) {
                    found = true;
                    ut2 = t.getUpdateTool();
                    if (ut2 != null && ut2.isExtensionManaged() && (ui = ut2.getUpdateInstallerMetaClass()) != null) {
                        AbstractMap.SimpleImmutableEntry<UpdateInfo, File> updateEntry = new AbstractMap.SimpleImmutableEntry<UpdateInfo, File>(update, zipFile);
                        List<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>> v = noRestartInstalls.get(ui);
                        if (v == null) {
                            v = new ArrayList<AbstractMap.SimpleImmutableEntry<UpdateInfo, File>>();
                        }
                        v.add(updateEntry);
                        noRestartInstalls.put(ui, v);
                    }
                }
                if (!found) continue;
                continue block2;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (UpdateInfo update : bundle.getUpdates()) {
            if (!ManageInstalledUpdates.isUpdateInstalled(update)) continue;
            buf.setLength(0);
            if (update.getType() == UpdateInfo.Type.EXTENSION) {
                Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(update.getID());
                buf.append("DeinstallExtensionTask=");
                buf.append(update.getID());
                buf.append(',');
                buf.append(extension.getVersion().toString());
            } else if (update.getType() == UpdateInfo.Type.CUSTOM) {
                if (update.getCustomType().equals("osgi")) {
                    Bundle osgiBundle = oracle.ide.osgi.Platform.getBundleRegistry().findBundle(update.getID());
                    buf.append("DeinstallExtensionTask=");
                    buf.append(update.getID());
                    buf.append(',');
                    buf.append(osgiBundle.getVersion().toString());
                } else {
                    boolean taskCreated = false;
                    CustomTypeDefinition ctd2 = UpdateHandlerHook.getCustomTypeDefinition();
                    cuts = ctd2.getCustomUpdateTypes();
                    for (CustomUpdateType t : cuts) {
                        if (!t.getType().equals(update.getCustomType())) continue;
                        ut = t.getUpdateTool();
                        if (ut == null || ut.isExtensionManaged() || !ut.isUninstallSupported()) break;
                        buf.append("DeinstallCustomUpdateTask=");
                        buf.append(ut.getPath() + (Platform.getPlatform() == Platform.PlatformType.ptWindows ? ".bat" : ""));
                        for (String a : ut.getUninstallArgs()) {
                            buf.append(";").append(a);
                        }
                        buf.append(";").append(t.getUpdateHelper().getInternalId(update.getID()));
                        buf.append(',');
                        buf.append(update.getID());
                        buf.append(',');
                        if (t.getUpdateHelper().getCurrentlyInstalledVersion(update.getID()) != null) {
                            buf.append(t.getUpdateHelper().getCurrentlyInstalledVersion(update.getID()));
                        } else {
                            buf.append("");
                        }
                        taskCreated = true;
                        break;
                    }
                    if (!taskCreated) continue;
                }
            }
            updateList.add(buf.toString());
        }
        for (UpdateInfo ui2 : bundle.getUpdates()) {
            buf.setLength(0);
            if (ui2.getType() == UpdateInfo.Type.EXTENSION) {
                buf.append("InstallExtensionTask=");
            } else if (ui2.getType() == UpdateInfo.Type.CUSTOM) {
                if (ui2.getCustomType().equals("osgi")) {
                    buf.append("InstallExtensionTask=");
                } else {
                    boolean taskCreated = false;
                    CustomTypeDefinition ctd3 = UpdateHandlerHook.getCustomTypeDefinition();
                    cuts = ctd3.getCustomUpdateTypes();
                    for (CustomUpdateType t : cuts) {
                        if (!t.getType().equals(ui2.getCustomType())) continue;
                        ut = t.getUpdateTool();
                        if (ut == null || ut.isExtensionManaged()) break;
                        buf.append("InstallPatchTask=");
                        buf.append(ut.getPath() + (Platform.getPlatform() == Platform.PlatformType.ptWindows ? ".bat" : ""));
                        for (String a : ut.getInstallArgs()) {
                            buf.append(";").append(a);
                        }
                        buf.append(',');
                        taskCreated = true;
                        break;
                    }
                    if (!taskCreated) continue;
                }
            }
            buf.append(zipFile.getPath());
            buf.append(',');
            if (ui2.getType() == UpdateInfo.Type.CUSTOM && !ui2.getCustomType().equals("osgi") && bundle.getInstallLocation() == null) {
                bundle.setInstallLocation("${oracle.mw.home}");
            }
            File destinationDir = this.getDestinationDir(bundle);
            buf.append(destinationDir.getPath());
            buf.append(',');
            buf.append("false");
            buf.append(',');
            buf.append(ui2.getID());
            updateList.add(buf.toString());
        }
        if (updateList.isEmpty()) {
            return;
        }
        for (UpdateInfo update : bundle.getUpdates()) {
            String postStartupHook = update.getPostStartupHookClass();
            if (postStartupHook == null || (postStartupHook = postStartupHook.trim()).length() <= 0) continue;
            buf.setLength(0);
            buf.append("ScheduleHookTask=");
            buf.append(postStartupHook);
            buf.append(',');
            buf.append(this.getInstallHookFile().getPath());
            buf.append(',');
            buf.append(update.getID());
            updateList.add(buf.toString());
        }
        for (UpdateInfo update : bundle.getUpdates()) {
            updateList.add(CFUBundlesExtraInfo.extrasToString(update));
        }
    }

    private File getInstallHookFile() {
        String homeDir = this._updateManager.getDirectories().getOracleHome();
        return new File(homeDir, "installhooks.properties");
    }

    private void replaceBundleInstallLocation(UpdateBundle bundle, String fromString, String fromPattern, String toString) {
        if (bundle.getInstallLocation().equals(fromString)) {
            bundle.setInstallLocation(toString);
        } else {
            bundle.getInstallLocation().replaceAll(fromPattern, toString);
        }
    }

    private File getDestinationDir(UpdateBundle bundle) {
        if (this._commandLine) {
            return this.getDistinationDirCommandLine(bundle);
        }
        return this.getDestinationDirIDE(bundle);
    }

    private File getDistinationDirCommandLine(UpdateBundle bundle) {
        if (bundle.getInstallLocation() != null) {
            if (bundle.getInstallLocation().contains("${oracle.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.home}", "\\$\\{oracle.home\\}", this.getManager().getDirectories().getOracleHome());
            } else if (bundle.getInstallLocation().contains("${oracle.mw.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", this.getManager().getDirectories().getOracleHome() + File.separator + "..");
            }
            return new File(bundle.getInstallLocation());
        }
        return new File(this.getManager().getDirectories().getGlobalExtensionsHome());
    }

    private File getDestinationDirIDE(UpdateBundle bundle) {
        if (bundle.getInstallLocation() != null) {
            if (bundle.getInstallLocation().contains("${oracle.home}")) {
                this.replaceBundleInstallLocation(bundle, "${oracle.home}", "\\$\\{oracle.home\\}", Ide.getOracleHomeDirectory());
            } else if (bundle.getInstallLocation().contains("${oracle.mw.home}")) {
                if (System.getProperty("oracle.mw.home") != null) {
                    this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", System.getProperty("oracle.mw.home"));
                } else {
                    this.replaceBundleInstallLocation(bundle, "${oracle.mw.home}", "\\$\\{oracle.mw.home\\}", Ide.getOracleHomeDirectory() + File.separator + "..");
                }
            }
            return new File(bundle.getInstallLocation());
        }
        Extension extension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(bundle.getUpdates().iterator().next().getID());
        if (extension == null) {
            return new File(this.getModel().isInstallForEveryone() ? UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome() : UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        ExtensionRegistry extReg = (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
        if (extReg.isUserExtension(extension.getID())) {
            return new File(UpdateManager.getInstance().getDirectories().getUserExtensionsHome());
        }
        return new File(UpdateManager.getInstance().getDirectories().getGlobalExtensionsHome());
    }

    private void writeToCFUExtras(UpdateInfo update) {
        String line = CFUBundlesExtraInfo.extrasToString(update);
        int index = line.indexOf(61);
        if (index > 0) {
            CreateExtraInfoTask cfuExtrasTask = new CreateExtraInfoTask(line.substring(index + 1));
            try {
                cfuExtrasTask.perform(new TaskContext(){

                    public oracle.ideimpl.deferredupdate.Directories getDirectories() {
                        LinkedHashMap<String, ArrayList<String>> properties = new LinkedHashMap<String, ArrayList<String>>();
                        ArrayList<String> dirList = new ArrayList<String>();
                        UpdateManager.getInstance().getDirectories().save(dirList);
                        for (String dir : dirList) {
                            int index = dir.indexOf(61);
                            if (index <= 0) continue;
                            String propertyName = dir.substring(0, index);
                            ArrayList<String> details = (ArrayList<String>)properties.get(propertyName);
                            if (details == null) {
                                details = new ArrayList<String>();
                                properties.put(propertyName, details);
                            }
                            details.add(dir.substring(index + 1));
                        }
                        return new oracle.ideimpl.deferredupdate.Directories(properties);
                    }

                    public boolean confirmOverwrite(File file) {
                        return true;
                    }
                });
            }
            catch (TaskFailedException tfe) {
                Logger.getLogger("global").log(Level.SEVERE, "Error writing to cfu extras file: " + tfe.getMessage());
            }
        }
    }

    public static UpdateInstaller getUpdateInstaller(MetaClass<UpdateInstaller> installerClass) {
        UpdateInstaller ui = null;
        try {
            ui = (UpdateInstaller)installerClass.newInstance();
        }
        catch (InstantiationException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot instantiate class for class: " + installerClass.getClassName());
        }
        catch (IllegalAccessException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot access class for class: " + installerClass.getClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Cannot find class for class: " + installerClass.getClassName());
        }
        catch (ClassCastException e) {
            Logger.getLogger("global").log(Level.SEVERE, "ClassCastException. updateInstaller for class: " + installerClass.getClassName() + ", is not of type updateInstaller");
        }
        catch (Throwable t) {
            FeedbackManager.reportException((Throwable)t);
        }
        return ui;
    }
}

