/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Narrower<T> {
    public abstract boolean isBassignableToA(T var1, T var2);

    public abstract T[] newArray(int var1);

    public List<T> narrow(Collection<T> o) {
        ArrayList<T> narrowed = new ArrayList<T>(o.size());
        for (T a : o) {
            Iterator j = narrowed.iterator();
            boolean add = true;
            while (j.hasNext()) {
                Object b = j.next();
                if (this.isBassignableToA(a, b)) {
                    add = false;
                    break;
                }
                if (!this.isBassignableToA(b, a)) continue;
                j.remove();
            }
            if (!add) continue;
            narrowed.add(a);
        }
        return narrowed;
    }

    public T[] narrow(T[] objects) {
        List<T> narrowed = this.narrow(Arrays.asList(objects));
        return narrowed.toArray(this.newArray(narrowed.size()));
    }

    public static abstract class HeirarchyBasedClassNarrower<C>
    extends Narrower<Class<C>> {
        @Override
        public boolean isBassignableToA(Class<C> a, Class<C> b) {
            return a.isAssignableFrom(b);
        }
    }

    public static abstract class HeirarchyBasedObjectNarrower<C>
    extends Narrower<C> {
        @Override
        public boolean isBassignableToA(C a, C b) {
            return a.getClass().isAssignableFrom(b.getClass());
        }
    }
}

