/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Dictionary;
import java.util.Enumeration;
import oracle.bali.share.collection.EveryOtherEnumeration;

public class ArrayMap
extends Dictionary
implements Cloneable {
    private Object[] _array;
    private int _size;
    private int _increment;

    public ArrayMap() {
        this(0, 1);
    }

    public ArrayMap(int n) {
        this(n, 1);
    }

    public ArrayMap(int n, int n2) {
        if (n2 < 1 || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 0) {
            this._array = new Object[2 * n];
        }
        this._increment = n2;
    }

    public ArrayMap(Dictionary dictionary) {
        if (dictionary != null) {
            int n = dictionary.size();
            if (n > 0) {
                this._array = new Object[n * 2];
                this._size = n;
                Enumeration enumeration = dictionary.keys();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    this._array[n2++] = k;
                    this._array[n2++] = dictionary.get(k);
                }
            }
            this._increment = 1;
        }
    }

    public Object clone() {
        try {
            ArrayMap arrayMap = (ArrayMap)super.clone();
            arrayMap._array = (Object[])this._array.clone();
            arrayMap._size = this._size;
            arrayMap._increment = this._increment;
            return arrayMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int hashCode() {
        Object[] objectArray = this._array;
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.size() * 2;
        for (int i = 0; i < n2; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            n += (object == null ? 0 : object.hashCode()) ^ (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Dictionary)) {
            return false;
        }
        Dictionary dictionary = (Dictionary)object;
        int n = this.size();
        if (dictionary.size() != n) {
            return false;
        }
        Object[] objectArray = this._array;
        for (int i = 0; i < n; ++i) {
            Object object2 = this._array[i * 2 + 1];
            Object object3 = this._array[i * 2];
            Object v = dictionary.get(object3);
            if (object2 == v || object2 != null && object2.equals(v)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public Enumeration keys() {
        int n = this._size;
        if (n == 0) {
            return null;
        }
        return new EveryOtherEnumeration(this._array, (n - 1) * 2);
    }

    public Enumeration elements() {
        int n = this._size;
        if (n == 0) {
            return null;
        }
        return new EveryOtherEnumeration(this._array, n * 2 - 1);
    }

    public Object get(Object object) {
        return ArrayMap.getByEquality(this._array, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        if (object2 == null) {
            return this.remove(object);
        }
        ArrayMap arrayMap = this;
        synchronized (arrayMap) {
            Object[] objectArray = this._array;
            Object object3 = ArrayMap.getByEquality(objectArray, object);
            if (object3 == null) {
                int n = this._size * 2;
                if (objectArray != null && n < objectArray.length) {
                    objectArray[n] = object;
                    objectArray[n + 1] = object2;
                } else {
                    this._array = ArrayMap._addToArray(objectArray, object, object2, this._increment);
                }
                ++this._size;
            } else {
                this._array = ArrayMap.put(objectArray, object, object2);
            }
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        ArrayMap arrayMap = this;
        synchronized (arrayMap) {
            Object[] objectArray = this._array;
            Object object2 = ArrayMap.get(objectArray, object);
            if (object2 != null) {
                ArrayMap.remove(objectArray, object, false);
                --this._size;
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(ArrayMap arrayMap) {
        Object[] objectArray;
        int n;
        if (arrayMap == null) {
            return false;
        }
        ArrayMap arrayMap2 = arrayMap;
        synchronized (arrayMap2) {
            n = arrayMap._size;
            if (n == 0) {
                return false;
            }
            objectArray = arrayMap._array;
        }
        arrayMap2 = this;
        synchronized (arrayMap2) {
            if (this._size == 0) {
                if (this._array != null && this._array.length > n * 2) {
                    System.arraycopy(objectArray, 0, this._array, 0, n * 2);
                } else {
                    this._array = (Object[])objectArray.clone();
                }
                this._size = n;
                return true;
            }
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (this.put(objectArray[i * 2], objectArray[i * 2 + 1]) == null) continue;
                bl = true;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayMap arrayMap = this;
        synchronized (arrayMap) {
            int n = this._size;
            if (n > 0) {
                n *= 2;
                for (int i = 0; i < n; ++i) {
                    this._array[i] = null;
                }
                this._size = 0;
            }
        }
    }

    public static Object get(Object[] objectArray, Object object) {
        Object object2 = ArrayMap.getByIdentity(objectArray, object);
        if (object2 != null) {
            return object2;
        }
        return ArrayMap.getByEquality(objectArray, object);
    }

    public static Object getByIdentity(Object[] objectArray, Object object) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                if (objectArray[i] != object) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public static Object getByEquality(Object[] objectArray, Object object) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object2 = objectArray[i];
                if (object2 == null) {
                    return null;
                }
                if (!object2.equals(object)) continue;
                return objectArray[i + 1];
            }
        }
        return null;
    }

    public static Object[] put(Object[] objectArray, Object object, Object object2) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object3 = objectArray[i];
                if ((object3 == null || !object3.equals(object)) && object3 != object) continue;
                objectArray[i + 1] = object2;
                return objectArray;
            }
        }
        return ArrayMap._addToArray(objectArray, object, object2, 1);
    }

    public static Object[] remove(Object[] objectArray, Object object) {
        return ArrayMap.remove(objectArray, object, true);
    }

    public static Object[] remove(Object[] objectArray, Object object, boolean bl) {
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object2 = objectArray[i];
                if ((object2 == null || !object2.equals(object)) && object2 != object) continue;
                Object[] objectArray2 = objectArray;
                if (bl) {
                    objectArray2 = new Object[n - 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, i);
                }
                System.arraycopy(objectArray, i + 2, objectArray2, i, n - i - 2);
                if (!bl) {
                    objectArray[n - 1] = null;
                    objectArray[n - 2] = null;
                }
                return objectArray2;
            }
        }
        return objectArray;
    }

    public static Enumeration getKeys(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return new EveryOtherEnumeration(objectArray, objectArray.length - 2);
    }

    public static Enumeration getValues(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return new EveryOtherEnumeration(objectArray, objectArray.length - 1);
    }

    private static Object[] _addToArray(Object[] objectArray, Object object, Object object2, int n) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            int n2 = objectArray.length;
            objectArray2 = new Object[n2 + 2 * n];
            System.arraycopy(objectArray, 0, objectArray2, 2, n2);
        } else {
            objectArray2 = new Object[2 * n];
        }
        objectArray2[0] = object;
        objectArray2[1] = object2;
        return objectArray2;
    }
}

