/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.GML3g;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.Logger;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class GML3 {
    static Logger logger = Logger.getLogger("oracle.spatial.util.GML3");
    protected static Connection _conn;
    protected static String _srsNameSpace;
    protected static String _srsAlias;
    private GMLVersion gmlVersion;
    private int idCount = 1;
    private static final String GML_POS_CLOSE = "</gml:pos>";
    private static final String GML_POINT_MEMBER_OPEN = "<gml:pointMember>";
    private static final String GML_POINT_MEMBER_CLOSE = "</gml:pointMember>";
    private static final String GML_OUTER_BOUNDARY_OPEN = "<gml:exterior>";
    private static final String GML_OUTER_BOUNDARY_CLOSE = "</gml:exterior>";
    private static final String GML_INNER_BOUNDARY_OPEN = "<gml:interior>";
    private static final String GML_INNER_BOUNDARY_CLOSE = "</gml:interior>";
    private static final String GML_LINEAR_RING_OPEN = "<gml:LinearRing>";
    private static final String GML_LINEAR_RING_CLOSE = "</gml:LinearRing>";
    private static final String GML_COORD_CLOSE = "</gml:posList>";

    public static void setConnection(Connection connection) {
        _conn = connection;
    }

    public static void setsrsNameSpace(String string) {
        _srsNameSpace = string;
    }

    public static void setsrsAlias(String string) {
        _srsAlias = string;
    }

    public void setGmlVersion(GMLVersion gMLVersion) {
        if (gMLVersion == null) {
            gMLVersion = GMLVersion.GML3_1_1;
        }
        this.gmlVersion = gMLVersion;
    }

    protected String getGMLNameSpace() {
        return this.gmlVersion.getNamespace();
    }

    private String getNextGMLID() {
        String string = "";
        switch (this.gmlVersion) {
            case GML3_2_1: {
                string = " gml:id=\"" + String.format("ID%04d", this.idCount++) + "\"";
            }
        }
        return string;
    }

    protected void CCWOutputRectangle(int n, double[] dArray, int n2, StringBuilder stringBuilder) throws Exception, IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuilder.append(d + " " + d3 + " " + d2 + " " + d3 + " " + d2 + " " + d4 + " " + d + " " + d4 + " " + d + " " + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            J3D_Geometry j3D_Geometry = new J3D_Geometry(3003, 0, new int[]{1, 1003, 3}, new double[]{d, d3, d5, d2, d4, d6});
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
            int[] nArray = new int[]{0};
            j3D_Geometry = elementExtractor.nextElement(nArray);
            for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length / 3; ++i) {
                stringBuilder.append(j3D_Geometry.getOrdinatesArray()[3 * i] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 1] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 2] + " ");
            }
        }
    }

    protected void CWOutputRectangle(int n, double[] dArray, int n2, StringBuilder stringBuilder) throws Exception, IOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (n == 2) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d2 = dArray[n2 + 2];
            d4 = dArray[n2 + 3];
            stringBuilder.append(d + " " + d3 + " " + d + " " + d4 + " " + d2 + " " + d4 + " " + d2 + " " + d3 + " " + d + " " + d3 + " ");
        } else if (n == 3) {
            d = dArray[n2];
            d3 = dArray[n2 + 1];
            d5 = dArray[n2 + 2];
            d2 = dArray[n2 + 3];
            d4 = dArray[n2 + 4];
            d6 = dArray[n2 + 5];
            J3D_Geometry j3D_Geometry = new J3D_Geometry(3003, 0, new int[]{1, 1003, 3}, new double[]{d, d3, d5, d2, d4, d6});
            ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry, 0, 1, 3, false);
            int[] nArray = new int[]{0};
            j3D_Geometry = elementExtractor.nextElement(nArray);
            for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length / 3; ++i) {
                stringBuilder.append(j3D_Geometry.getOrdinatesArray()[3 * i] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 1] + " " + j3D_Geometry.getOrdinatesArray()[3 * i + 2] + " ");
            }
        }
    }

    protected void outputCoordinates(int n, int n2, double[] dArray, int n3, StringBuilder stringBuilder) throws IOException {
        for (int i = 1; i <= n2; ++i) {
            stringBuilder.append(dArray[n3 + (i - 1) * n] + " " + dArray[n3 + (i - 1) * n + 1]);
            if (n == 3) {
                stringBuilder.append(" " + dArray[n3 + (i - 1) * n + 2]);
            }
            stringBuilder.append(" ");
        }
    }

    protected void outputNURBSCurve(int n, double[] dArray, int n2, StringBuilder stringBuilder) throws IOException {
        int n3;
        String string = "<gml:posList srsDimension=\"" + n + "\">";
        String string2 = GML_COORD_CLOSE;
        int n4 = Double.valueOf(dArray[n2]).intValue();
        stringBuilder.append("<gml:degree>");
        stringBuilder.append(n4);
        stringBuilder.append("</gml:degree>");
        int n5 = Double.valueOf(dArray[n2 + 1]).intValue();
        stringBuilder.append(string);
        for (n3 = 0; n3 < n5; ++n3) {
            stringBuilder.append("<gml:controlpoint>");
            stringBuilder.append("<gml:weightedpoint>");
            stringBuilder.append(dArray[n2 + 2 + n3 * (n + 1)] + " " + dArray[n2 + 3 + n3 * (n + 1)]);
            if (n == 3) {
                stringBuilder.append(" " + dArray[n2 + 4 + n3 * (n + 1)]);
            }
            stringBuilder.append("</gml:weightedpoint>");
            stringBuilder.append("<gml:weight>");
            stringBuilder.append(dArray[n2 + 1 + n + 1 + n3 * (n + 1)]);
            stringBuilder.append("</gml:weight>");
            stringBuilder.append("</gml:controlpoint>");
        }
        stringBuilder.append(string2);
        n3 = Double.valueOf(dArray[n2 + 2 + n5 * (n + 1)]).intValue();
        stringBuilder.append("<gml:knot>");
        int n6 = 1;
        for (int i = n2 + 3 + n5 * (n + 1); i < n2 + 3 + n5 * (n + 1) + n3; ++i) {
            if (n6 == 1) {
                stringBuilder.append("<gml:value>");
                stringBuilder.append(dArray[i]);
                stringBuilder.append("</gml:value>");
            }
            if (i != n2 + 2 + n5 * (n + 1) + n3 && dArray[i] == dArray[i + 1]) {
                ++n6;
                continue;
            }
            stringBuilder.append("<gml:multiplicity>");
            stringBuilder.append(n6);
            stringBuilder.append("</gml:multiplicity>");
            n6 = 1;
        }
        stringBuilder.append("</gml:knot>");
    }

    protected boolean geometryHasArcs(JGeometry jGeometry, int n) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (n != 3) {
            if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
                bl = false;
                return bl;
            }
            int n2 = jGeometry.getElemInfo().length / 3;
            for (int i = 0; i < n2 && !bl; ++i) {
                if (nArray[3 * i + 2] == 2 && nArray[3 * i + 1] % 10 > 1) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 == 3 && nArray[3 * i + 2] == 4) {
                    bl = true;
                    continue;
                }
                if (nArray[3 * i + 1] % 10 <= 3) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean geometryHasEtypeZero(JGeometry jGeometry) {
        boolean bl = false;
        int[] nArray = jGeometry.getElemInfo();
        if (jGeometry.getElemInfo() == null || jGeometry.getOrdinatesArray() == null) {
            bl = false;
            return bl;
        }
        int n = jGeometry.getElemInfo().length / 3;
        for (int i = 0; i < n && !bl; ++i) {
            if (nArray[3 * i + 1] % 10 != 0) continue;
            bl = true;
        }
        return bl;
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuilder stringBuilder) throws SQLException, IOException, DataException, Exception {
        this.toGML(n, jGeometry, stringBuilder, null);
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuilder stringBuilder, String string) throws SQLException, IOException, DataException, Exception {
        this.toGML(n, jGeometry, stringBuilder, string, _conn);
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuilder stringBuilder, String string, Connection connection) throws SQLException, IOException, DataException, Exception {
        Object object;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Object object2;
        double[] dArray;
        if (jGeometry == null) {
            throw new DataException("NULL Geometry");
        }
        if (this.gmlVersion == null) {
            this.setGmlVersion(GMLVersion.GML3_1_1);
        }
        int n2 = 0;
        int n3 = 0;
        String string2 = "Unknown";
        int n4 = 0;
        int n5 = 0;
        String string3 = "<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">";
        String string4 = "<gml:pos srsDimension=\"" + jGeometry.getDimensions() + "\">";
        int n6 = jGeometry.getType();
        int n7 = jGeometry.getSRID();
        n3 = jGeometry.getDimensions();
        int[] nArray = jGeometry.getElemInfo();
        if (nArray != null) {
            n2 = nArray.length / 3;
        }
        if ((dArray = jGeometry.getOrdinatesArray()) != null) {
            n5 = dArray.length / n3;
        }
        if (n3 == 0) {
            n3 = dArray.length % 2 == 0 ? 2 : 3;
        }
        if (!(!this.geometryHasArcs(jGeometry, n3) || n6 == 4 && n3 == 2 || n6 == 7 && n3 == 2 || n6 == 6 && n3 == 2 || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 3 && n3 == 2 || n6 == 3 && jGeometry.getElemInfo()[1] % 1000 == 5 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 2 && n3 == 2 || n6 == 2 && jGeometry.getElemInfo()[1] % 1000 == 4 && n3 == 2)) {
            throw new DataException("54554");
        }
        if (this.geometryHasEtypeZero(jGeometry)) {
            throw new DataException("Etype zero not supported in GML3.1.1");
        }
        if (jGeometry.isLRSGeometry()) {
            throw new DataException("LRS not supported in GML3.1.1");
        }
        if (n6 == 1) {
            string2 = "Point";
            if (nArray != null && nArray[2] > 1) {
                string2 = "MultiPoint";
                n6 = 5;
            }
        } else if (n6 == 2) {
            string2 = nArray[1] % 1000 == 4 ? "CompositeCurve" : "Curve";
        } else if (n6 == 3) {
            string2 = "Polygon";
            if (nArray[1] % 1000 == 6) {
                string2 = "CompositeSurface";
            }
        } else if (n6 == 4) {
            string2 = "MultiGeometry";
        } else if (n6 == 5) {
            string2 = "MultiPoint";
        } else if (n6 == 6) {
            string2 = "MultiCurve";
        } else if (n6 == 7) {
            string2 = "MultiSurface";
        } else if (n6 == 8) {
            string2 = "Solid";
            if (nArray[1] % 1000 == 8) {
                string2 = "CompositeSolid";
            }
        } else if (n6 == 9) {
            string2 = "MultiSolid";
        }
        if (n == 0) {
            if (string == null || string != null && string.equalsIgnoreCase("FALSE")) {
                if (n7 == 0) {
                    stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName=\"SDO:\" xmlns:gml=\"" + this.getGMLNameSpace() + "\">");
                } else if (_srsNameSpace == null) {
                    logger.finest("_srsNameSpace in GML3.toGML: " + _srsNameSpace);
                    object2 = null;
                    object2 = connection == null ? (n7 == 0 ? "SDO:0" : "SDO:" + n7) : (GML3.isLegacy(n7, connection) ? (n7 == 0 ? "SDO:0" : "SDO:" + n7) : "EPSG:" + n7);
                    stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName=\"" + (String)object2 + "\" xmlns:gml=\"" + this.getGMLNameSpace() + "\">");
                } else {
                    if (connection == null) {
                        throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
                    }
                    object2 = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                    preparedStatement = null;
                    resultSet = null;
                    try {
                        preparedStatement = connection.prepareStatement((String)object2);
                        preparedStatement.setString(1, _srsNameSpace);
                        preparedStatement.setInt(2, n7);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) {
                            throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                        }
                        object = resultSet.getString("srsname");
                        stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName='" + _srsAlias + ":" + (String)object + "'" + " xmlns:gml=\"" + this.getGMLNameSpace() + "" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
                    }
                    catch (DataException dataException) {
                        throw dataException;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
            } else if (string != null && string.equalsIgnoreCase("TRUE")) {
                if (n7 == 0) {
                    stringBuilder.append("<gml:" + string2 + " srsName=\"urn:ogc:def:crs:EPSG::0\" xmlns:gml=\"" + this.getGMLNameSpace() + "\">");
                } else if (_srsNameSpace == null) {
                    stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName=\"urn:ogc:def:crs:EPSG::" + n7 + "\" xmlns:gml=\"" + this.getGMLNameSpace() + "\">");
                } else {
                    if (connection == null) {
                        throw new DataException("GML Converter needs a valid connection and SrsNameSpace");
                    }
                    object2 = " select srsname   from MDSYS.SrsNameSpace_Table  where  SrsNameSpace = ? and sdo_srid = ? ";
                    preparedStatement = null;
                    resultSet = null;
                    try {
                        preparedStatement = connection.prepareStatement((String)object2);
                        preparedStatement.setString(1, _srsNameSpace);
                        preparedStatement.setInt(2, n7);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) {
                            throw new DataException("GML has unregistered SrsNameSpace/SrsName");
                        }
                        object = resultSet.getString("srsname");
                        stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName=\"urn:ogc:def:crs:" + _srsAlias + ":" + (String)object + "::" + n7 + "\"" + " xmlns:gml=\"" + this.getGMLNameSpace() + "" + "\" xmlns:" + _srsAlias + "=\"" + _srsNameSpace + "\" >");
                    }
                    catch (DataException dataException) {
                        throw dataException;
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
            } else {
                stringBuilder.append("<gml:" + string2 + this.getNextGMLID() + " srsName=\"" + string + n7 + "\" xmlns:gml=\"" + this.getGMLNameSpace() + "\">");
            }
        }
        if (n6 == 1 && dArray == null) {
            double[] dArray2;
            if (n != 0) {
                stringBuilder.append("<gml:Point" + this.getNextGMLID() + ">");
            }
            if ((dArray2 = jGeometry.getPoint()) != null) {
                n3 = dArray2.length;
                stringBuilder.append(string4);
                this.outputCoordinates(n3, 1, dArray2, 0, stringBuilder);
                stringBuilder.append("</gml:pos></gml:" + string2 + ">");
            }
        }
        if (n6 == 1 && dArray != null) {
            if (n != 0) {
                stringBuilder.append("<gml:Point" + this.getNextGMLID() + ">");
            }
            stringBuilder.append(string4);
            this.outputCoordinates(n3, 1, dArray, 0, stringBuilder);
            stringBuilder.append("</gml:pos></gml:" + string2 + ">");
        } else if (n6 == 2 && nArray[1] % 1000 == 2 && n2 == 1 && dArray != null) {
            if (n != 0) {
                stringBuilder.append("<gml:Curve" + this.getNextGMLID() + ">");
            }
            stringBuilder.append("<gml:segments>");
            if (nArray[2] == 1) {
                stringBuilder.append("<gml:LineStringSegment>");
            } else if (nArray[2] == 2) {
                stringBuilder.append("<gml:Arc>");
            } else {
                stringBuilder.append("<gml:BSplineType>");
            }
            if (nArray[2] != 3) {
                stringBuilder.append(string3);
                this.outputCoordinates(n3, n5, dArray, 0, stringBuilder);
                stringBuilder.append(GML_COORD_CLOSE);
            } else {
                this.outputNURBSCurve(n3, dArray, 0, stringBuilder);
            }
            if (nArray[2] == 1) {
                stringBuilder.append("</gml:LineStringSegment>");
            } else if (nArray[2] == 2) {
                stringBuilder.append("</gml:Arc>");
            } else {
                stringBuilder.append("</gml:BSplineType>");
            }
            stringBuilder.append("</gml:segments>");
            stringBuilder.append("</gml:" + string2 + ">");
        } else if (n6 == 2 && nArray[1] % 1000 == 4 && n2 > 1) {
            int n8 = 0;
            int n9 = 1;
            int n10 = nArray[2];
            if (n != 0) {
                stringBuilder.append("<gml:CompositeCurve" + this.getNextGMLID() + ">");
            }
            ++n8;
            while (n9 <= n10) {
                stringBuilder.append("<gml:curveMember><gml:Curve" + this.getNextGMLID() + ">" + "<gml:segments>");
                n5 = n9 == n10 ? (dArray.length - nArray[3 * n8] + 1) / n3 : (n9 != n10 && nArray[3 * (n8 + 1) + 2] == 3 ? (nArray[3 * n8 + 3] - nArray[3 * n8]) / n3 : 1 + (nArray[3 * n8 + 3] - nArray[3 * n8]) / n3);
                if (nArray[3 * n8 + 2] == 1) {
                    stringBuilder.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n8] - 1, stringBuilder);
                    stringBuilder.append("</gml:posList></gml:LineStringSegment>");
                } else if (nArray[3 * n8 + 2] == 2) {
                    stringBuilder.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n8] - 1, stringBuilder);
                    stringBuilder.append("</gml:posList></gml:Arc>");
                } else if (nArray[3 * n8 + 2] == 3) {
                    stringBuilder.append("<gml:BSplineType>");
                    this.outputNURBSCurve(n3, dArray, nArray[3 * n8] - 1, stringBuilder);
                    stringBuilder.append("</gml:BSplineType>");
                }
                stringBuilder.append("</gml:segments></gml:Curve></gml:curveMember>");
                ++n9;
                ++n8;
            }
            stringBuilder.append("</gml:CompositeCurve>");
        } else if (n6 == 3 && nArray[1] % 1000 == 3) {
            if (n != 0) {
                stringBuilder.append("<gml:Polygon" + this.getNextGMLID() + ">");
            }
            stringBuilder.append(GML_OUTER_BOUNDARY_OPEN);
            n5 = 3 >= nArray.length ? (dArray.length - nArray[0] + 1) / n3 : (nArray[3] - nArray[0]) / n3;
            n4 = 0;
            if (nArray[2] == 1 || nArray[2] == 3) {
                stringBuilder.append(GML_LINEAR_RING_OPEN + string3);
                if (nArray[2] == 3) {
                    this.CCWOutputRectangle(n3, dArray, n4, stringBuilder);
                } else {
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuilder);
                }
                stringBuilder.append("</gml:posList></gml:LinearRing>");
            } else if (nArray[2] == 4) {
                stringBuilder.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                this.outputCoordinates(n3, n5, dArray, n4, stringBuilder);
                stringBuilder.append("</gml:posList></gml:Circle>");
            } else {
                throw new DataException("54539");
            }
            stringBuilder.append(GML_OUTER_BOUNDARY_CLOSE);
            for (int i = 2; i <= n2; ++i) {
                stringBuilder.append(GML_INNER_BOUNDARY_OPEN);
                n5 = i == n2 ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * i] - nArray[3 * (i - 1)]) / n3;
                n4 = nArray[3 * (i - 1)] - 1;
                if (nArray[3 * (i - 1) + 1] == 2003 && (nArray[3 * (i - 1) + 2] == 1 || nArray[3 * (i - 1) + 2] == 3)) {
                    stringBuilder.append(GML_LINEAR_RING_OPEN + string3);
                    if (nArray[3 * (i - 1) + 2] == 3) {
                        this.CWOutputRectangle(n3, dArray, n4, stringBuilder);
                    } else {
                        this.outputCoordinates(n3, n5, dArray, n4, stringBuilder);
                    }
                    stringBuilder.append("</gml:posList></gml:LinearRing>");
                } else if (nArray[3 * (i - 1) + 1] == 2003 && nArray[3 * (i - 1) + 2] == 4) {
                    stringBuilder.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, n4, stringBuilder);
                    stringBuilder.append("</gml:posList></gml:Circle>");
                } else if (nArray[3 * (i - 1) + 1] == 2005) {
                    stringBuilder.append("<gml:Ring>");
                    int n11 = 1;
                    int n12 = nArray[3 * (i - 1) + 2];
                    ++i;
                    while (n11 <= n12) {
                        stringBuilder.append("<gml:curveMember><gml:Curve" + this.getNextGMLID() + ">" + "<gml:segments>");
                        n5 = 3 * (i - 1) + 3 >= nArray.length ? (dArray.length - nArray[3 * (i - 1)] + 1) / n3 : (nArray[3 * (i - 1) + 4] == 2003 || nArray[3 * (i - 1) + 4] == 2005 ? (nArray[3 * (i - 1) + 3] - nArray[3 * (i - 1)]) / n3 : 1 + (nArray[3 * (i - 1) + 3] - nArray[3 * (i - 1)]) / n3);
                        if (nArray[3 * (i - 1) + 2] == 1) {
                            stringBuilder.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * (i - 1)] - 1, stringBuilder);
                            stringBuilder.append("</gml:posList></gml:LineStringSegment>");
                        } else if (nArray[3 * (i - 1) + 2] == 2) {
                            stringBuilder.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * (i - 1)] - 1, stringBuilder);
                            stringBuilder.append("</gml:posList></gml:Arc>");
                        }
                        stringBuilder.append("</gml:segments></gml:Curve></gml:curveMember>");
                        ++n11;
                        ++i;
                    }
                    stringBuilder.append("</gml:Ring>");
                } else {
                    throw new DataException("54539");
                }
                stringBuilder.append(GML_INNER_BOUNDARY_CLOSE);
            }
            stringBuilder.append("</gml:" + string2 + ">");
        } else if (n6 == 3 && nArray[1] % 1000 == 5) {
            if (n != 0) {
                stringBuilder.append("<gml:Polygon" + this.getNextGMLID() + ">");
            }
            int n13 = 0;
            int n14 = 1;
            int n15 = nArray[2];
            stringBuilder.append("<gml:exterior><gml:Ring>");
            ++n13;
            while (n14 <= n15) {
                stringBuilder.append("<gml:curveMember><gml:Curve" + this.getNextGMLID() + ">" + "<gml:segments>");
                n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 4] == 2003 || nArray[3 * n13 + 4] == 2005 ? (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3 : 1 + (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3);
                if (nArray[3 * n13 + 2] == 1) {
                    stringBuilder.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                    stringBuilder.append("</gml:posList></gml:LineStringSegment>");
                } else if (nArray[3 * n13 + 2] == 2) {
                    stringBuilder.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                    stringBuilder.append("</gml:posList></gml:Arc>");
                }
                stringBuilder.append("</gml:segments></gml:Curve></gml:curveMember>");
                ++n14;
                ++n13;
            }
            stringBuilder.append("</gml:Ring></gml:exterior>");
            while (3 * n13 < nArray.length) {
                stringBuilder.append(GML_INNER_BOUNDARY_OPEN);
                if (nArray[3 * n13 + 1] == 2005) {
                    stringBuilder.append("<gml:Ring>");
                    n14 = 1;
                    n15 = nArray[3 * n13 + 2];
                    ++n13;
                    while (n14 <= n15) {
                        stringBuilder.append("<gml:curveMember><gml:Curve" + this.getNextGMLID() + ">" + "<gml:segments>");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 4] == 2003 || nArray[3 * n13 + 4] == 2005 ? (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3 : 1 + (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3);
                        if (nArray[3 * n13 + 2] == 1) {
                            stringBuilder.append("<gml:LineStringSegment><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                            stringBuilder.append("</gml:posList></gml:LineStringSegment>");
                        } else if (nArray[3 * n13 + 2] == 2) {
                            stringBuilder.append("<gml:Arc><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                            this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                            stringBuilder.append("</gml:posList></gml:Arc>");
                        }
                        stringBuilder.append("</gml:segments></gml:Curve></gml:curveMember>");
                        ++n14;
                        ++n13;
                    }
                    stringBuilder.append("</gml:Ring>");
                } else if (nArray[3 * n13 + 1] == 2003) {
                    if (nArray[3 * n13 + 2] == 1) {
                        stringBuilder.append("<gml:LinearRing><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3;
                        this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                        stringBuilder.append("</gml:posList></gml:LinearRing>");
                    } else if (nArray[3 * n13 + 2] == 3) {
                        stringBuilder.append("<gml:LinearRing><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n4 = nArray[3 * n13] - 1;
                        this.CWOutputRectangle(n3, dArray, n4, stringBuilder);
                        stringBuilder.append("</gml:posList></gml:LinearRing>");
                    } else if (nArray[3 * n13 + 2] == 4) {
                        stringBuilder.append("<gml:Circle><gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                        n5 = 3 * n13 + 3 >= nArray.length ? (dArray.length - nArray[3 * n13] + 1) / n3 : (nArray[3 * n13 + 3] - nArray[3 * n13]) / n3;
                        this.outputCoordinates(n3, n5, dArray, nArray[3 * n13] - 1, stringBuilder);
                        stringBuilder.append("</gml:posList></gml:Circle>");
                    } else {
                        throw new DataException("54539");
                    }
                    ++n13;
                } else {
                    throw new DataException("54539");
                }
                stringBuilder.append(GML_INNER_BOUNDARY_CLOSE);
            }
            stringBuilder.append("</gml:Polygon>");
        } else if (n6 == 3 && nArray[1] % 1000 == 6) {
            int n16;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[jGeometry.getElemInfo().length];
            double[] dArray3 = new double[jGeometry.getOrdinatesArray().length];
            for (n16 = 0; n16 < jGeometry.getOrdinatesArray().length; ++n16) {
                dArray3[n16] = jGeometry.getOrdinatesArray()[n16];
            }
            for (n16 = 0; n16 < jGeometry.getElemInfo().length; ++n16) {
                nArray3[n16] = jGeometry.getElemInfo()[n16];
            }
            resultSet = new J3D_Geometry(3, 0, nArray3, dArray3);
            if (n != 0) {
                stringBuilder.append("<gml:CompositeSurface" + this.getNextGMLID() + ">");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object2 = new ElementExtractor((J3D_Geometry)resultSet);
            nArray2[0] = 0;
            while ((object = object2.nextElement(nArray2)) != null) {
                arrayList.add(object);
            }
            for (n16 = 0; n16 < arrayList.size(); ++n16) {
                int n17;
                stringBuilder.append("<gml:surfaceMember>");
                object = (J3D_Geometry)arrayList.get(n16);
                int[] nArray4 = new int[object.getElemInfo().length];
                double[] dArray4 = new double[object.getOrdinatesArray().length];
                for (n17 = 0; n17 < object.getOrdinatesArray().length; ++n17) {
                    dArray4[n17] = object.getOrdinatesArray()[n17];
                }
                for (n17 = 0; n17 < object.getElemInfo().length; ++n17) {
                    nArray4[n17] = object.getElemInfo()[n17];
                }
                preparedStatement = new JGeometry(3003, 0, nArray4, dArray4);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                stringBuilder.append("</gml:surfaceMember>");
            }
            stringBuilder.append("</gml:CompositeSurface>");
        } else if (n6 == 4) {
            if (n3 == 2) {
                int n18;
                int n19 = 0;
                object = connection.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                object.execute();
                n19 = object.getInt(1);
                object.close();
                object = null;
                object2 = new ArrayList();
                int n20 = jGeometry.getSRID();
                jGeometry.setSRID(0);
                for (n18 = 1; n18 <= n19; ++n18) {
                    CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                    callableStatement.setInt(3, n18);
                    callableStatement.execute();
                    object = JGeometry.loadJS((Struct)((Struct)callableStatement.getObject(1)));
                    object.setSRID(n20);
                    object2.add(object);
                    callableStatement.close();
                    continue;
                }
                jGeometry.setSRID(n20);
                for (n18 = 0; n18 < object2.size(); ++n18) {
                    stringBuilder.append("<gml:geometryMember>");
                    preparedStatement = (JGeometry)object2.get(n18);
                    n = 0;
                    this.toGML(n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:geometryMember>");
                }
                stringBuilder.append("</gml:" + string2 + ">");
            } else {
                int n21;
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[jGeometry.getElemInfo().length];
                double[] dArray5 = new double[jGeometry.getOrdinatesArray().length];
                for (n21 = 0; n21 < jGeometry.getOrdinatesArray().length; ++n21) {
                    dArray5[n21] = jGeometry.getOrdinatesArray()[n21];
                }
                for (n21 = 0; n21 < jGeometry.getElemInfo().length; ++n21) {
                    nArray6[n21] = jGeometry.getElemInfo()[n21];
                }
                resultSet = new J3D_Geometry(4, 0, nArray6, dArray5);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                object2 = new ElementExtractor((J3D_Geometry)resultSet);
                nArray5[0] = 0;
                while ((object = object2.nextElement(nArray5)) != null) {
                    if (nArray5[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n21 = 0; n21 < arrayList.size(); ++n21) {
                    int n22;
                    stringBuilder.append("<gml:geometryMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n21);
                    int[] nArray7 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray6 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n22 = 0; n22 < j3D_Geometry.getOrdinatesArray().length; ++n22) {
                        dArray6[n22] = j3D_Geometry.getOrdinatesArray()[n22];
                    }
                    for (n22 = 0; n22 < j3D_Geometry.getElemInfo().length; ++n22) {
                        nArray7[n22] = j3D_Geometry.getElemInfo()[n22];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray7, dArray6);
                    n = 0;
                    this.toGML(n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:geometryMember>");
                }
                stringBuilder.append("</gml:MultiGeometry>");
            }
        } else if (n6 == 5) {
            if (n2 == 1 && nArray[2] > 1) {
                n5 = nArray[2];
            } else if (n2 > 1) {
                n5 = n2;
            }
            for (int i = 1; i <= n5; ++i) {
                n4 = n3 * (i - 1);
                if (nArray.length >= n4 + 2 && nArray[n4 + 2] == 0) continue;
                stringBuilder.append("<gml:pointMember><gml:Point" + this.getNextGMLID() + ">" + string4);
                this.outputCoordinates(n3, 1, dArray, n4, stringBuilder);
                stringBuilder.append("</gml:pos></gml:Point></gml:pointMember>");
            }
            stringBuilder.append("</gml:" + string2 + ">");
        } else if (n6 == 6) {
            if (n3 == 2) {
                int n23;
                int n24 = 0;
                object = connection.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                object.execute();
                n24 = object.getInt(1);
                object.close();
                object = null;
                object2 = new ArrayList();
                int n25 = jGeometry.getSRID();
                jGeometry.setSRID(0);
                for (n23 = 1; n23 <= n24; ++n23) {
                    CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                    callableStatement.setInt(3, n23);
                    callableStatement.execute();
                    object = JGeometry.loadJS((Struct)((Struct)callableStatement.getObject(1)));
                    object.setSRID(n25);
                    object2.add(object);
                    callableStatement.close();
                    continue;
                }
                jGeometry.setSRID(n25);
                for (n23 = 0; n23 < object2.size(); ++n23) {
                    stringBuilder.append("<gml:curveMember>");
                    preparedStatement = (JGeometry)object2.get(n23);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:curveMember>");
                }
                stringBuilder.append("</gml:" + string2 + ">");
            } else {
                int n26;
                int[] nArray8 = new int[1];
                int[] nArray9 = new int[jGeometry.getElemInfo().length];
                double[] dArray7 = new double[jGeometry.getOrdinatesArray().length];
                for (n26 = 0; n26 < jGeometry.getOrdinatesArray().length; ++n26) {
                    dArray7[n26] = jGeometry.getOrdinatesArray()[n26];
                }
                for (n26 = 0; n26 < jGeometry.getElemInfo().length; ++n26) {
                    nArray9[n26] = jGeometry.getElemInfo()[n26];
                }
                resultSet = new J3D_Geometry(6, 0, nArray9, dArray7);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                object2 = new ElementExtractor((J3D_Geometry)resultSet);
                nArray8[0] = 0;
                while ((object = object2.nextElement(nArray8)) != null) {
                    if (nArray8[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n26 = 0; n26 < arrayList.size(); ++n26) {
                    int n27;
                    stringBuilder.append("<gml:curveMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n26);
                    int[] nArray10 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray8 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n27 = 0; n27 < j3D_Geometry.getOrdinatesArray().length; ++n27) {
                        dArray8[n27] = j3D_Geometry.getOrdinatesArray()[n27];
                    }
                    for (n27 = 0; n27 < j3D_Geometry.getElemInfo().length; ++n27) {
                        nArray10[n27] = j3D_Geometry.getElemInfo()[n27];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray10, dArray8);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:curveMember>");
                }
                stringBuilder.append("</gml:MultiCurve>");
            }
        } else if (n6 == 7) {
            if (n3 == 2) {
                int n28;
                int n29 = 0;
                object = connection.prepareCall("{ ? = call mdsys.sdo_util.getnumelem(?)}");
                object.registerOutParameter(1, 4);
                object.setObject(2, JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                object.execute();
                n29 = object.getInt(1);
                object.close();
                object = null;
                object2 = new ArrayList();
                int n30 = jGeometry.getSRID();
                jGeometry.setSRID(0);
                for (n28 = 1; n28 <= n29; ++n28) {
                    CallableStatement callableStatement = connection.prepareCall("{ ? = call mdsys.sdo_util.extract(?,?)}");
                    callableStatement.registerOutParameter(1, 2002, "MDSYS.SDO_GEOMETRY");
                    callableStatement.setObject(2, (Object)JGeometry.store((Connection)connection, (JGeometry)jGeometry));
                    callableStatement.setInt(3, n28);
                    callableStatement.execute();
                    object = JGeometry.loadJS((Struct)((Struct)callableStatement.getObject(1)));
                    object.setSRID(n30);
                    object2.add(object);
                    callableStatement.close();
                    continue;
                }
                jGeometry.setSRID(n30);
                for (n28 = 0; n28 < object2.size(); ++n28) {
                    stringBuilder.append("<gml:surfaceMember>");
                    preparedStatement = (JGeometry)object2.get(n28);
                    ++n;
                    for (int i = 1; i < preparedStatement.getElemInfo().length / 3; ++i) {
                        if (preparedStatement.getElemInfo()[3 * i + 1] != 1003) continue;
                        preparedStatement.getElemInfo()[3 * i + 1] = 2003;
                    }
                    this.toGML(n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:surfaceMember>");
                }
                stringBuilder.append("</gml:" + string2 + ">");
            } else {
                int n31;
                int[] nArray11 = new int[1];
                int[] nArray12 = new int[jGeometry.getElemInfo().length];
                double[] dArray9 = new double[jGeometry.getOrdinatesArray().length];
                for (n31 = 0; n31 < jGeometry.getOrdinatesArray().length; ++n31) {
                    dArray9[n31] = jGeometry.getOrdinatesArray()[n31];
                }
                for (n31 = 0; n31 < jGeometry.getElemInfo().length; ++n31) {
                    nArray12[n31] = jGeometry.getElemInfo()[n31];
                }
                resultSet = new J3D_Geometry(7, 0, nArray12, dArray9);
                if (n != 0) {
                    stringBuilder.append("<gml:MultiSurface" + this.getNextGMLID() + ">");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                object2 = new ElementExtractor((J3D_Geometry)resultSet);
                nArray11[0] = 0;
                while ((object = object2.nextElement(nArray11)) != null) {
                    if (nArray11[0] == 2) continue;
                    arrayList.add(object);
                }
                for (n31 = 0; n31 < arrayList.size(); ++n31) {
                    int n32;
                    stringBuilder.append("<gml:surfaceMember>");
                    J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList.get(n31);
                    int[] nArray13 = new int[j3D_Geometry.getElemInfo().length];
                    double[] dArray10 = new double[j3D_Geometry.getOrdinatesArray().length];
                    for (n32 = 0; n32 < j3D_Geometry.getOrdinatesArray().length; ++n32) {
                        dArray10[n32] = j3D_Geometry.getOrdinatesArray()[n32];
                    }
                    for (n32 = 0; n32 < j3D_Geometry.getElemInfo().length; ++n32) {
                        nArray13[n32] = j3D_Geometry.getElemInfo()[n32];
                    }
                    preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray13, dArray10);
                    this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                    stringBuilder.append("</gml:surfaceMember>");
                }
                stringBuilder.append("</gml:MultiSurface>");
            }
        } else if (n6 == 8 && nArray[1] % 1000 == 7) {
            J3D_Geometry j3D_Geometry;
            J3D_Geometry j3D_Geometry2;
            J3D_Geometry j3D_Geometry3;
            int n33;
            int[] nArray14 = new int[1];
            ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
            int[] nArray15 = new int[jGeometry.getElemInfo().length];
            double[] dArray11 = new double[jGeometry.getOrdinatesArray().length];
            for (n33 = 0; n33 < jGeometry.getOrdinatesArray().length; ++n33) {
                dArray11[n33] = jGeometry.getOrdinatesArray()[n33];
            }
            for (n33 = 0; n33 < jGeometry.getElemInfo().length; ++n33) {
                nArray15[n33] = jGeometry.getElemInfo()[n33];
            }
            object = new J3D_Geometry(8, 0, nArray15, dArray11);
            if (n != 0) {
                stringBuilder.append("<gml:Solid" + this.getNextGMLID() + ">");
            }
            ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
            ArrayList<J3D_Geometry> arrayList3 = new ArrayList<J3D_Geometry>();
            object2 = new ElementExtractor((J3D_Geometry)object, 0, 2, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry3 = object2.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList.add(j3D_Geometry3);
            }
            j3D_Geometry3 = (J3D_Geometry)arrayList.get(0);
            preparedStatement = new ElementExtractor(j3D_Geometry3, 0, 1, 3);
            nArray14[0] = 0;
            while ((j3D_Geometry2 = preparedStatement.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) {
                    arrayList2.add(j3D_Geometry2);
                    continue;
                }
                arrayList3.add(j3D_Geometry2);
            }
            J3D_Geometry j3D_Geometry4 = (J3D_Geometry)arrayList3.get(0);
            resultSet = new ElementExtractor(j3D_Geometry4, 0, 0, 3);
            ArrayList<J3D_Geometry> arrayList4 = new ArrayList<J3D_Geometry>();
            nArray14[0] = 0;
            while ((j3D_Geometry = resultSet.nextElement(nArray14)) != null) {
                if (nArray14[0] == 2) continue;
                arrayList4.add(j3D_Geometry);
            }
            stringBuilder.append("<gml:exterior><gml:CompositeSurface" + this.getNextGMLID() + ">");
            for (n33 = 0; n33 < arrayList4.size(); ++n33) {
                j3D_Geometry = (J3D_Geometry)arrayList4.get(n33);
                stringBuilder.append("<gml:surfaceMember><gml:Polygon" + this.getNextGMLID() + ">" + GML_OUTER_BOUNDARY_OPEN + GML_LINEAR_RING_OPEN);
                stringBuilder.append("<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuilder);
                stringBuilder.append(GML_COORD_CLOSE);
                stringBuilder.append("</gml:LinearRing></gml:exterior></gml:Polygon></gml:surfaceMember>");
            }
            stringBuilder.append("</gml:CompositeSurface></gml:exterior>");
            for (n33 = 0; n33 < arrayList2.size(); ++n33) {
                J3D_Geometry j3D_Geometry5 = (J3D_Geometry)arrayList2.get(n33);
                stringBuilder.append("<gml:interior><gml:CompositeSurface" + this.getNextGMLID() + ">");
                resultSet = new ElementExtractor(j3D_Geometry5, 0, 0, 3);
                arrayList4 = new ArrayList();
                nArray14[0] = 0;
                while ((j3D_Geometry = resultSet.nextElement(nArray14)) != null) {
                    if (nArray14[0] != 2) continue;
                    arrayList4.add(j3D_Geometry);
                }
                for (int i = 0; i < arrayList4.size(); ++i) {
                    j3D_Geometry = (J3D_Geometry)arrayList4.get(i);
                    stringBuilder.append("<gml:surfaceMember><gml:Polygon" + this.getNextGMLID() + ">" + GML_OUTER_BOUNDARY_OPEN + GML_LINEAR_RING_OPEN);
                    stringBuilder.append("<gml:posList srsDimension=\"" + jGeometry.getDimensions() + "\">");
                    this.outputCoordinates(3, j3D_Geometry.getOrdinatesArray().length / 3, j3D_Geometry.getOrdinatesArray(), 0, stringBuilder);
                    stringBuilder.append(GML_COORD_CLOSE);
                    stringBuilder.append("</gml:LinearRing></gml:exterior></gml:Polygon></gml:surfaceMember>");
                }
                stringBuilder.append("</gml:CompositeSurface></gml:interior>");
            }
            stringBuilder.append("</gml:Solid>");
        } else if (n6 == 8 && nArray[1] % 1000 == 8) {
            int n34;
            int[] nArray16 = new int[1];
            int[] nArray17 = new int[jGeometry.getElemInfo().length];
            double[] dArray12 = new double[jGeometry.getOrdinatesArray().length];
            for (n34 = 0; n34 < jGeometry.getOrdinatesArray().length; ++n34) {
                dArray12[n34] = jGeometry.getOrdinatesArray()[n34];
            }
            for (n34 = 0; n34 < jGeometry.getElemInfo().length; ++n34) {
                nArray17[n34] = jGeometry.getElemInfo()[n34];
            }
            resultSet = new J3D_Geometry(8, 0, nArray17, dArray12);
            if (n != 0) {
                stringBuilder.append("<gml:CompositeSolid" + this.getNextGMLID() + ">");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object2 = new ElementExtractor((J3D_Geometry)resultSet);
            nArray16[0] = 0;
            while ((object = object2.nextElement(nArray16)) != null) {
                if (nArray16[0] == 2) continue;
                arrayList.add(object);
            }
            for (n34 = 0; n34 < arrayList.size(); ++n34) {
                int n35;
                stringBuilder.append("<gml:solidMember>");
                object = (J3D_Geometry)arrayList.get(n34);
                int[] nArray18 = new int[object.getElemInfo().length];
                double[] dArray13 = new double[object.getOrdinatesArray().length];
                for (n35 = 0; n35 < object.getOrdinatesArray().length; ++n35) {
                    dArray13[n35] = object.getOrdinatesArray()[n35];
                }
                for (n35 = 0; n35 < object.getElemInfo().length; ++n35) {
                    nArray18[n35] = object.getElemInfo()[n35];
                }
                preparedStatement = new JGeometry(3008, 0, nArray18, dArray13);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                stringBuilder.append("</gml:solidMember>");
            }
            stringBuilder.append("</gml:CompositeSolid>");
        } else if (n6 == 9) {
            int n36;
            int[] nArray19 = new int[1];
            ArrayList arrayList = new ArrayList();
            int[] nArray20 = new int[jGeometry.getElemInfo().length];
            double[] dArray14 = new double[jGeometry.getOrdinatesArray().length];
            for (n36 = 0; n36 < jGeometry.getOrdinatesArray().length; ++n36) {
                dArray14[n36] = jGeometry.getOrdinatesArray()[n36];
            }
            for (n36 = 0; n36 < jGeometry.getElemInfo().length; ++n36) {
                nArray20[n36] = jGeometry.getElemInfo()[n36];
            }
            resultSet = new J3D_Geometry(9, 0, nArray20, dArray14);
            if (n != 0) {
                stringBuilder.append("<gml:MultiSolid" + this.getNextGMLID() + ">");
            }
            ArrayList<Object> arrayList5 = new ArrayList<Object>();
            object2 = new ElementExtractor((J3D_Geometry)resultSet);
            nArray19[0] = 0;
            while ((object = object2.nextElement(nArray19)) != null) {
                if (nArray19[0] == 2) continue;
                arrayList5.add(object);
            }
            for (n36 = 0; n36 < arrayList5.size(); ++n36) {
                int n37;
                stringBuilder.append("<gml:solidMember>");
                J3D_Geometry j3D_Geometry = (J3D_Geometry)arrayList5.get(n36);
                int[] nArray21 = new int[j3D_Geometry.getElemInfo().length];
                double[] dArray15 = new double[j3D_Geometry.getOrdinatesArray().length];
                for (n37 = 0; n37 < j3D_Geometry.getOrdinatesArray().length; ++n37) {
                    dArray15[n37] = j3D_Geometry.getOrdinatesArray()[n37];
                }
                for (n37 = 0; n37 < j3D_Geometry.getElemInfo().length; ++n37) {
                    nArray21[n37] = j3D_Geometry.getElemInfo()[n37];
                }
                preparedStatement = new JGeometry(3000 + j3D_Geometry.getType(), 0, nArray21, dArray15);
                this.toGML(++n, (JGeometry)preparedStatement, stringBuilder, string);
                stringBuilder.append("</gml:solidMember>");
            }
            stringBuilder.append("</gml:MultiSolid>");
        }
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuilder stringBuilder, String string, int n2) throws SQLException, IOException, DataException, Exception, GeometryExceptionWithContext {
        if (n2 != 0) {
            if (n2 == 1) {
                int n3 = GML3g.reverseAxisOrder(n2, jGeometry.getSRID(), _conn);
                if (n3 == 1) {
                    jGeometry = GML3g.switchXYOrdinates(jGeometry);
                }
            } else if (n2 == 2) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            } else {
                throw new Exception("Wrong value for coordOrder parameter: please choose among [0,1,2]");
            }
        }
        this.toGML(n, jGeometry, stringBuilder, string);
    }

    protected void toGML(int n, JGeometry jGeometry, StringBuilder stringBuilder, String string, int n2, Connection connection) throws SQLException, IOException, DataException, Exception, GeometryExceptionWithContext {
        if (n2 != 0) {
            if (n2 == 1) {
                int n3 = GML3g.reverseAxisOrder(n2, jGeometry.getSRID(), connection);
                if (n3 == 1) {
                    jGeometry = GML3g.switchXYOrdinates(jGeometry);
                }
            } else if (n2 == 2) {
                jGeometry = GML3g.switchXYOrdinates(jGeometry);
            } else {
                throw new Exception("Wrong value for coordOrder parameter: please choose among [0,1,2]");
            }
        }
        this.toGML(n, jGeometry, stringBuilder, string, connection);
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML3.to_GML3Geometry(sTRUCT);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_GML3GeometryCLOB(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML3.to_GML3Geometry(struct);
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return cLOB;
    }

    public static String to_GML3Geometry(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        return GML3.to_GML3Geometry(struct, string, string2, null);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        return GML3.to_GML3Geometry(sTRUCT, string, string2, null);
    }

    public static String to_GML3Geometry(Struct struct, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        String string4 = GML3.to_GML3Geometry(struct, string3);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        String string4 = GML3.to_GML3Geometry(sTRUCT, string3);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(Struct struct) throws SQLException, IOException {
        return GML3.to_GML3Geometry(struct, null);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT) throws SQLException, IOException {
        return GML3.to_GML3Geometry(sTRUCT, null);
    }

    public static String to_GML3Geometry(Struct struct, String string) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML3.to_GML3Geometry(jGeometry, string);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML3.to_GML3Geometry(jGeometry, string);
    }

    public static String to_GML3_2Geometry(Struct struct, String string) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML3.to_GML3Geometry(jGeometry, string, GMLVersion.GML3_2_1);
    }

    public static String to_GML3_2Geometry(Struct struct) throws SQLException, IOException {
        return GML3.to_GML3_2Geometry(struct, null);
    }

    public static CLOB to_GML3_2GeometryCLOB(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        CLOB cLOB = GML3.getCLOB(GML3.to_GML3_2Geometry(struct));
        GML3.cleanAttributes();
        return cLOB;
    }

    public static String to_GML3_2Geometry(Struct struct, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        String string4 = GML3.to_GML3_2Geometry(struct, string3);
        GML3.cleanAttributes();
        return string4;
    }

    public static String to_GML3_2Geometry(STRUCT sTRUCT, String string, String string2, String string3) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        String string4 = GML3.to_GML3_2Geometry(sTRUCT, string3);
        GML3.cleanAttributes();
        return string4;
    }

    public static String to_GML3_2Geometry(STRUCT sTRUCT, String string, String string2) throws SQLException, IOException, Exception {
        return GML3.to_GML3_2Geometry(sTRUCT, string, string2, null);
    }

    public static String to_GML3_2Geometry(STRUCT sTRUCT) throws SQLException, IOException {
        return GML3.to_GML3_2Geometry(sTRUCT, null);
    }

    public static String to_GML3_2Geometry(STRUCT sTRUCT, String string) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML3.to_GML3Geometry(jGeometry, string, GMLVersion.GML3_2_1);
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML3.to_GML3Geometry(sTRUCT);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GML3GeometryCLOB(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML3.to_GML3Geometry(struct);
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static String to_GML3Geometry(JGeometry jGeometry) throws SQLException, IOException {
        return GML3.to_GML3Geometry(jGeometry, null, null);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, GMLVersion gMLVersion) throws SQLException, IOException {
        return GML3.to_GML3Geometry(jGeometry, null, gMLVersion);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string) throws SQLException, IOException {
        return GML3.to_GML3Geometry(jGeometry, string, null);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string, GMLVersion gMLVersion) throws SQLException, IOException {
        GML3 gML3 = new GML3();
        gML3.setGmlVersion(gMLVersion);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            gML3.toGML(n, jGeometry, stringBuilder, string);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML3.to_GML3Geometry(sTRUCT, nUMBER.intValue());
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GML3GeometryCLOB(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string = GML3.to_GML3Geometry(struct, nUMBER.intValue());
        if (string != null) {
            cLOB.setString(1L, string.toString());
            cLOB.close();
            return cLOB;
        }
        cLOB.close();
        return null;
    }

    public static CLOB to_GML3GeometryCLOB(STRUCT sTRUCT, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML3.to_GML3Geometry(sTRUCT, nUMBER.intValue());
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_GML3GeometryCLOB(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        String string3 = GML3.to_GML3Geometry(struct, nUMBER.intValue());
        cLOB.setString(1L, string3.toString());
        cLOB.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return cLOB;
    }

    public static CLOB to_GML3_2GeometryCLOB(STRUCT sTRUCT, NUMBER nUMBER) throws SQLException, IOException, Exception {
        return GML3.to_GML3_2GeometryCLOB(sTRUCT, null, null, nUMBER);
    }

    public static CLOB to_GML3_2GeometryCLOB(STRUCT sTRUCT, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        CLOB cLOB = GML3.getCLOB(GML3.to_GML3Geometry(sTRUCT, null, nUMBER.intValue(), GMLVersion.GML3_2_1));
        GML3.cleanAttributes();
        return cLOB;
    }

    public static CLOB to_GML3_2GeometryCLOB(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        return GML3.to_GML3_2GeometryCLOB(struct, null, null, nUMBER);
    }

    public static CLOB to_GML3_2GeometryCLOB(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        CLOB cLOB = GML3.getCLOB(GML3.to_GML3Geometry(struct, null, nUMBER.intValue(), GMLVersion.GML3_2_1));
        GML3.cleanAttributes();
        return cLOB;
    }

    private static CLOB getCLOB(String string) throws SQLException {
        CLOB cLOB = CLOB.createTemporary((Connection)((OracleConnection)_conn), (boolean)true, (int)10);
        cLOB.open(1);
        cLOB.setString(1L, string);
        cLOB.close();
        return cLOB;
    }

    public static String to_GML3Geometry(Struct struct, int n) throws SQLException, IOException {
        return GML3.to_GML3Geometry(struct, null, n);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, int n) throws SQLException, IOException {
        return GML3.to_GML3Geometry(sTRUCT, null, n);
    }

    public static String to_GML3Geometry(Struct struct, String string, int n) throws SQLException, IOException {
        return GML3.to_GML3Geometry(struct, string, n, (GMLVersion)null);
    }

    public static String to_GML3Geometry(Struct struct, String string, int n, GMLVersion gMLVersion) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML3.to_GML3Geometry(jGeometry, string, n, gMLVersion);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, int n) throws SQLException, IOException {
        return GML3.to_GML3Geometry(sTRUCT, string, n, (GMLVersion)null);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, int n, GMLVersion gMLVersion) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        if (_conn == null) {
            throw new RuntimeException("database connection is null.");
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML3.to_GML3Geometry(jGeometry, string, n, gMLVersion);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string, int n) throws SQLException, IOException {
        return GML3.to_GML3Geometry(jGeometry, string, n, (GMLVersion)null);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string, int n, GMLVersion gMLVersion) throws SQLException, IOException {
        GML3 gML3 = new GML3();
        gML3.setGmlVersion(gMLVersion);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            gML3.toGML(n2, jGeometry, stringBuilder, string, n);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String to_GML3Geometry(Struct struct, String string, String string2, String string3, int n) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        String string4 = GML3.to_GML3Geometry(struct, string3, n);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2, String string3, int n) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        String string4 = GML3.to_GML3Geometry(sTRUCT, string3, n);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(Struct struct, String string, String string2, String string3, int n, Connection connection) throws SQLException, IOException, Exception {
        return GML3.to_GML3Geometry(struct, string, string2, string3, n, null, connection);
    }

    public static String to_GML3Geometry(Struct struct, String string, String string2, String string3, int n, GMLVersion gMLVersion, Connection connection) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        String string4 = GML3.to_GML3Geometry(struct, string3, n, gMLVersion, connection);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2, String string3, int n, Connection connection) throws SQLException, IOException, Exception {
        return GML3.to_GML3Geometry(sTRUCT, string, string2, string3, n, null, connection);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, String string2, String string3, int n, GMLVersion gMLVersion, Connection connection) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        String string4 = GML3.to_GML3Geometry(sTRUCT, string3, n, gMLVersion, connection);
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return string4;
    }

    public static String to_GML3Geometry(Struct struct, String string, int n, Connection connection) throws SQLException, IOException {
        return GML3.to_GML3Geometry(struct, string, n, null, connection);
    }

    public static String to_GML3Geometry(Struct struct, String string, int n, GMLVersion gMLVersion, Connection connection) throws SQLException, IOException {
        if (struct == null) {
            return null;
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        return GML3.to_GML3Geometry(jGeometry, string, n, gMLVersion, connection);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, int n, Connection connection) throws SQLException, IOException {
        return GML3.to_GML3Geometry(sTRUCT, string, n, null, connection);
    }

    public static String to_GML3Geometry(STRUCT sTRUCT, String string, int n, GMLVersion gMLVersion, Connection connection) throws SQLException, IOException {
        if (sTRUCT == null) {
            return null;
        }
        JGeometry jGeometry = JGeometry.load((STRUCT)sTRUCT);
        return GML3.to_GML3Geometry(jGeometry, string, n, gMLVersion, connection);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string, int n, Connection connection) throws SQLException, IOException {
        return GML3.to_GML3Geometry(jGeometry, string, n, null, connection);
    }

    public static String to_GML3Geometry(JGeometry jGeometry, String string, int n, GMLVersion gMLVersion, Connection connection) throws SQLException, IOException {
        GML3 gML3 = new GML3();
        gML3.setGmlVersion(gMLVersion);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            gML3.toGML(n2, jGeometry, stringBuilder, string, n, connection);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLegacy(int n, Connection connection) throws SQLException {
        logger.finest("srId : " + n);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string = null;
        String string2 = null;
        try {
            string2 = "select IS_LEGACY from MDSYS.SDO_COORD_REF_SYS where SRID = ?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setInt(1, n);
            logger.finest("sqlStmt in GML2.isLegacy: " + string2);
            logger.finest("Parameter 1 : " + n);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (string == null) {
            return true;
        }
        return string.equalsIgnoreCase("true");
    }

    public static OracleClob to_GML3GeometryCLOBJS(Struct struct) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string = GML3.to_GML3Geometry(struct);
        if (string != null) {
            oracleClob.setString(1L, string.toString());
            oracleClob.close();
            return oracleClob;
        }
        oracleClob.close();
        return null;
    }

    public static OracleClob to_GML3GeometryCLOBJS(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string = GML3.to_GML3Geometry(struct, nUMBER.intValue());
        if (string != null) {
            oracleClob.setString(1L, string.toString());
            oracleClob.close();
            return oracleClob;
        }
        oracleClob.close();
        return null;
    }

    public static OracleClob to_GML3GeometryCLOBJS(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string3 = GML3.to_GML3Geometry(struct);
        oracleClob.setString(1L, string3.toString());
        oracleClob.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return oracleClob;
    }

    public static OracleClob to_GML3GeometryCLOBJS(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        String string3 = GML3.to_GML3Geometry(struct, nUMBER.intValue());
        oracleClob.setString(1L, string3.toString());
        oracleClob.close();
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
        return oracleClob;
    }

    public static OracleClob to_GML3_2GeometryCLOBJS(Struct struct) throws SQLException, IOException, Exception {
        return GML3.to_GML3_2GeometryCLOBJS(struct, null, null);
    }

    public static OracleClob to_GML3_2GeometryCLOBJS(Struct struct, String string, String string2) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        OracleClob oracleClob = GML3.getOracleClob(GML3.to_GML3Geometry(JGeometry.loadJS((Struct)struct), GMLVersion.GML3_2_1));
        GML3.cleanAttributes();
        return oracleClob;
    }

    public static OracleClob to_GML3_2GeometryCLOBJS(Struct struct, NUMBER nUMBER) throws SQLException, IOException, Exception {
        return GML3.to_GML3_2GeometryCLOBJS(struct, null, null, nUMBER);
    }

    public static OracleClob to_GML3_2GeometryCLOBJS(Struct struct, String string, String string2, NUMBER nUMBER) throws SQLException, IOException, Exception {
        GML3.setAttributes(string, string2);
        OracleClob oracleClob = GML3.getOracleClob(GML3.to_GML3Geometry(struct, null, nUMBER.intValue(), GMLVersion.GML3_2_1));
        GML3.cleanAttributes();
        return oracleClob;
    }

    private static OracleClob getOracleClob(String string) throws SQLException {
        OracleClob oracleClob = (OracleClob)_conn.createClob();
        oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
        oracleClob.setString(1L, string);
        oracleClob.close();
        return oracleClob;
    }

    private static void setAttributes(String string, String string2) throws Exception {
        GML3.setsrsNameSpace(string);
        GML3.setsrsAlias(string2);
        Connection connection = null;
        if (_conn == null) {
            connection = DriverManager.getConnection("jdbc:default:connection:");
            GML3.setConnection(connection);
        }
    }

    private static void cleanAttributes() {
        GML3.setsrsNameSpace(null);
        GML3.setsrsAlias(null);
    }

    static {
        _srsAlias = "Non-SDO";
    }

    public static enum GMLVersion {
        GML3_1_1("http://www.opengis.net/gml"),
        GML3_2_1("http://www.opengis.net/gml/3.2");

        private final String namespace;

        private GMLVersion(String string2) {
            this.namespace = string2;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

