/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Logger {
    public static final int LEVEL_FATAL = 9;
    public static final int LEVEL_ERROR = 7;
    public static final int LEVEL_WARN = 5;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_DEBUG = 3;
    public static final int LEVEL_FINEST = 0;
    public static final int LOG_THREAD_NAME = 1;
    public static final int LOG_TIME = 2;
    static Hashtable globalLoggers = new Hashtable(37);
    static int globalLevel = 4;
    static int globalFlags = 0;
    static PrintStream[] globalHandlers = new PrintStream[]{System.out};
    int mLevel = globalLevel;
    int mFlags = globalFlags;
    PrintStream[] mHandlers = new PrintStream[]{System.out};
    String mName = "global";

    protected Logger() {
    }

    public static Logger getLogger(String string) {
        Logger logger = new Logger();
        logger.mName = string;
        logger.mHandlers = new PrintStream[globalHandlers.length];
        for (int i = 0; i < globalHandlers.length; ++i) {
            logger.mHandlers[i] = globalHandlers[i];
        }
        globalLoggers.put(string, logger);
        return logger;
    }

    public static Logger getLogger(String string, int n) {
        Logger logger = new Logger();
        logger.mName = string;
        logger.mLevel = n;
        globalLoggers.put(string, logger);
        return logger;
    }

    public static void setGlobalLevel(int n) {
        globalLevel = n;
        Logger[] loggerArray = Logger.getAllLoggers();
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].mLevel = n;
        }
    }

    public static void setGlobalLevel(int n, String string) {
        Logger[] loggerArray = Logger.getAllLoggers(string);
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].mLevel = n;
        }
    }

    public static int getGlobalLevel() {
        return globalLevel;
    }

    public static void setGlobalFlags(int n) {
        globalFlags = n;
        Logger[] loggerArray = Logger.getAllLoggers();
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].mFlags = n;
        }
    }

    public static void setGlobalFlags(int n, String string) {
        Logger[] loggerArray = Logger.getAllLoggers(string);
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].mFlags = n;
        }
    }

    public static int getGlobalFlags() {
        return globalFlags;
    }

    public static void readGlobalConfig(Properties properties) {
        String string;
        String string2 = properties.getProperty("log_level");
        int n = 4;
        if (string2 != null) {
            n = string2.equalsIgnoreCase("FATAL") ? 9 : (string2.equalsIgnoreCase("ERROR") ? 7 : (string2.equalsIgnoreCase("WARN") ? 5 : (string2.equalsIgnoreCase("INFO") ? 4 : (string2.equalsIgnoreCase("DEBUG") ? 3 : (string2.equalsIgnoreCase("FINEST") ? 0 : 4)))));
        }
        if ((string = properties.getProperty("log_thread")) == null) {
            string = properties.getProperty("log_thread_name");
        }
        String string3 = properties.getProperty("log_time");
        int n2 = 0;
        if (string != null && string.equalsIgnoreCase("true")) {
            n2 |= 1;
        }
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            n2 |= 2;
        }
        Logger.setGlobalLevel(n);
        Logger.setGlobalFlags(n2);
    }

    public static void setGlobalOutputStream(PrintStream printStream) {
        globalHandlers = new PrintStream[1];
        Logger.globalHandlers[0] = printStream;
        Logger[] loggerArray = Logger.getAllLoggers();
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].setOutputStream(printStream);
        }
    }

    public static void setGlobalOutputStream(PrintStream printStream, String string) {
        Logger[] loggerArray = Logger.getAllLoggers(string);
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].setOutputStream(printStream);
        }
    }

    public static int addGlobalOutputStream(PrintStream printStream) {
        PrintStream[] printStreamArray = globalHandlers;
        globalHandlers = new PrintStream[printStreamArray.length + 1];
        System.arraycopy(printStreamArray, 0, globalHandlers, 0, printStreamArray.length);
        Logger.globalHandlers[printStreamArray.length] = printStream;
        Logger[] loggerArray = Logger.getAllLoggers();
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].addOutputStream(printStream);
        }
        return globalHandlers.length;
    }

    public static int addGlobalOutputStream(PrintStream printStream, String string) {
        Logger[] loggerArray = Logger.getAllLoggers(string);
        for (int i = 0; i < loggerArray.length; ++i) {
            loggerArray[i].addOutputStream(printStream);
        }
        return globalHandlers.length;
    }

    public void fatal(String string) {
        if (this.mLevel > 9) {
            return;
        }
        this.print("FATAL", string);
    }

    public void fatal(Exception exception) {
        if (this.mLevel > 9) {
            return;
        }
        this.print("FATAL", Logger.dumpException(exception));
    }

    public void fatal(String string, String string2, String string3) {
        if (this.mLevel > 9) {
            return;
        }
        this.print("FATAL", string, string2, string3);
    }

    public void error(String string) {
        if (this.mLevel > 7) {
            return;
        }
        this.print("ERROR", string);
    }

    public void error(String string, String string2, String string3) {
        if (this.mLevel > 7) {
            return;
        }
        this.print("ERROR", string, string2, string3);
    }

    public void error(Exception exception) {
        if (this.mLevel > 7) {
            return;
        }
        this.print("ERROR", Logger.dumpException(exception));
    }

    public void warn(String string) {
        if (this.mLevel > 5) {
            return;
        }
        this.print("WARN", string);
    }

    public void warn(String string, String string2, String string3) {
        if (this.mLevel > 5) {
            return;
        }
        this.print("WARN", string, string2, string3);
    }

    public void warn(Exception exception) {
        if (this.mLevel > 5) {
            return;
        }
        this.print("WARN", Logger.dumpException(exception));
    }

    public void info(String string) {
        if (this.mLevel > 4) {
            return;
        }
        this.print("INFO", string);
    }

    public void info(String string, String string2, String string3) {
        if (this.mLevel > 4) {
            return;
        }
        this.print("INFO", string, string2, string3);
    }

    public void info(Exception exception) {
        if (this.mLevel > 4) {
            return;
        }
        this.print("INFO", Logger.dumpException(exception));
    }

    public void debug(String string) {
        if (this.mLevel > 3) {
            return;
        }
        this.print("DEBUG", string);
    }

    public void debug(String string, String string2, String string3) {
        if (this.mLevel > 3) {
            return;
        }
        this.print("DEBUG", string, string2, string3);
    }

    public void debug(Exception exception) {
        if (this.mLevel > 3) {
            return;
        }
        this.print("DEBUG", Logger.dumpException(exception));
    }

    public void finest(String string) {
        if (this.mLevel > 0) {
            return;
        }
        this.print("FINEST", string);
    }

    public void finest(String string, String string2, String string3) {
        if (this.mLevel > 0) {
            return;
        }
        this.print("FINEST", string, string2, string3);
    }

    public void finest(Exception exception) {
        if (this.mLevel > 0) {
            return;
        }
        this.print("FINEST", Logger.dumpException(exception));
    }

    public void setLevel(int n) {
        this.mLevel = n;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public void setFlags(int n) {
        this.mFlags = n;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setOutputStream(PrintStream printStream) {
        if (printStream == null) {
            this.mHandlers = new PrintStream[0];
            return;
        }
        this.mHandlers = new PrintStream[1];
        this.mHandlers[0] = printStream;
    }

    public int addOutputStream(PrintStream printStream) {
        PrintStream[] printStreamArray = this.mHandlers;
        this.mHandlers = new PrintStream[printStreamArray.length + 1];
        System.arraycopy(printStreamArray, 0, this.mHandlers, 0, printStreamArray.length);
        this.mHandlers[printStreamArray.length] = printStream;
        return this.mHandlers.length;
    }

    private void print(String string, String string2) {
        String string3 = null;
        if (this.mFlags == 0) {
            string3 = "[" + this.mName + ", " + string + "] " + string2;
        } else if ((this.mFlags & 2) != 0 && (this.mFlags & 1) != 0) {
            string3 = "[" + this.mName + ", " + new Date() + ",#" + Thread.currentThread().getName() + ", " + string + "] " + string2;
        } else if ((this.mFlags & 1) != 0) {
            string3 = "[" + this.mName + ", #" + Thread.currentThread().getName() + "," + string + "] " + string2;
        } else if ((this.mFlags & 2) != 0) {
            string3 = "[" + this.mName + ", " + new Date() + ", " + string + "] " + string2;
        }
        for (int i = 0; i < this.mHandlers.length; ++i) {
            if (this.mHandlers[i] == null) continue;
            this.mHandlers[i].println(string3);
            this.mHandlers[i].flush();
        }
    }

    private void print(String string, String string2, String string3, String string4) {
        String string5 = null;
        if (this.mFlags == 0) {
            string5 = "[" + string3 + "::" + string4 + ", " + string + "] " + string2;
        } else if ((this.mFlags & 2) != 0 && (this.mFlags & 1) != 0) {
            string5 = "[" + string3 + "::" + string4 + ", " + new Date() + ", #" + Thread.currentThread().getName() + ", " + string + "] " + string2;
        } else if ((this.mFlags & 1) != 0) {
            string5 = "[" + string3 + "::" + string4 + ", #" + Thread.currentThread().getName() + ", " + string + "] " + string2;
        } else if ((this.mFlags & 2) != 0) {
            string5 = "[" + string3 + "::" + string4 + ", " + new Date() + ", " + string + "]" + string2;
        }
        for (int i = 0; i < this.mHandlers.length; ++i) {
            if (this.mHandlers[i] == null) continue;
            this.mHandlers[i].println(string5);
            this.mHandlers[i].flush();
        }
    }

    private static Logger[] getAllLoggers() {
        return globalLoggers.values().toArray(new Logger[0]);
    }

    private static Logger[] getAllLoggers(String string) {
        ArrayList arrayList = new ArrayList(10);
        Enumeration enumeration = globalLoggers.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2 == null || string2.indexOf(string) != 0) continue;
            arrayList.add(globalLoggers.get(string2));
        }
        return arrayList.toArray(new Logger[0]);
    }

    private static String dumpException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

