/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.ByteOrder;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.WKAdapter;
import oracle.spatial.util.WKInputStream;
import oracle.sql.STRUCT;

public abstract class WKBasis
implements WKAdapter {
    protected static final int LABEL_WKB_POINT = 1;
    protected static final int LABEL_WKB_LINESTRING = 2;
    protected static final int LABEL_WKB_CIRCULARSTRING = 1000001;
    protected static final int LABEL_WKB_COMPOUNDCURVE = 1000002;
    protected static final int LABEL_WKB_POLYGON = 3;
    protected static final int LABEL_WKB_CURVEPOLYGON = 1000003;
    protected static final int LABEL_WKB_MULTIPOINT = 4;
    protected static final int LABEL_WKB_MULTICURVE = 1000004;
    protected static final int LABEL_WKB_MULTILINESTRING = 5;
    protected static final int LABEL_WKB_MULTISURFACE = 1000005;
    protected static final int LABEL_WKB_MULTIPOLYGON = 6;
    protected static final int LABEL_WKB_GEOMETRYCOLLECTION = 7;
    protected static final int LABEL_WKB_NURBSCURVE = 21;
    protected static final int LABEL_WKT_DEGREE = 91;
    protected static final int LABEL_WKT_CONTROLPOINTS = 92;
    protected static final int LABEL_WKT_NURBSPOINT = 93;
    protected static final int LABEL_WKT_WEIGHTEDPOINT = 94;
    protected static final int LABEL_WKT_WEIGHT = 95;
    protected static final int LABEL_WKT_KNOTS = 96;
    protected static final int LABEL_WKT_KNOT = 97;
    protected static final int LABEL_WKT_VALUE = 98;
    protected static final int LABEL_WKT_MULTIPLICITY = 99;
    protected final ByteOrder m_defaultByteOrder;

    public WKBasis(ByteOrder byteOrder) {
        this.m_defaultByteOrder = byteOrder;
    }

    public WKBasis() {
        this(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public byte[] fromJGeometry(JGeometry jGeometry) throws GeometryExceptionWithContext {
        if (jGeometry == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.fromJGeometry(jGeometry, 0, new DataOutputStream(byteArrayOutputStream), this.m_defaultByteOrder);
        return byteArrayOutputStream.toByteArray();
    }

    protected void fromJGeometry(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2;
        switch (jGeometry.getType()) {
            case 4: 
            case 2004: 
            case 3004: {
                n2 = this.fromJGeometry_GTYPE_COLLECTION(jGeometry, n, dataOutputStream, byteOrder);
                break;
            }
            case 2: 
            case 2002: 
            case 3002: {
                n2 = this.fromJGeometry_GTYPE_CURVE(jGeometry, n, dataOutputStream, byteOrder, -1);
                break;
            }
            case 6: 
            case 2006: 
            case 3006: {
                n2 = this.fromJGeometry_GTYPE_MULTICURVE(jGeometry, n, dataOutputStream, byteOrder);
                break;
            }
            case 5: 
            case 2005: 
            case 3005: {
                n2 = this.fromJGeometry_GTYPE_MULTIPOINT(jGeometry, n, dataOutputStream, byteOrder, false);
                break;
            }
            case 7: 
            case 2007: 
            case 3007: {
                n2 = this.fromJGeometry_GTYPE_MULTIPOLYGON(jGeometry, n, dataOutputStream, byteOrder);
                break;
            }
            case 1: 
            case 2001: 
            case 3001: {
                n2 = this.fromJGeometry_GTYPE_POINT(jGeometry, n, dataOutputStream, byteOrder, -1);
                break;
            }
            case 3: 
            case 2003: 
            case 3003: {
                n2 = this.fromJGeometry_GTYPE_POLYGON(jGeometry, n, dataOutputStream, byteOrder, -1);
                break;
            }
            default: {
                throw new GeometryExceptionWithContext(null, "Invalid gType (or not 2-dimensional or 3-dimensional): " + jGeometry.getType(), null);
            }
        }
        if (jGeometry.getType() == 2001 && n2 != jGeometry.getElemInfo().length) {
            throw new GeometryExceptionWithContext(null, "For a GTYPE_POINT, no further records should follow in the elemInfoArray.", null);
        }
    }

    protected void fromJGeometry_CollectionElement(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2, int[] nArray) throws GeometryExceptionWithContext {
        switch (jGeometry.getElemInfo()[n + 1]) {
            case 1: {
                nArray[0] = this.fromJGeometry_GTYPE_MULTIPOINT(jGeometry, n, dataOutputStream, byteOrder, true);
                break;
            }
            case 2: 
            case 4: {
                nArray[0] = this.fromJGeometry_GTYPE_CURVE(jGeometry, n, dataOutputStream, byteOrder, n2);
                break;
            }
            case 1003: {
                nArray[0] = this.fromJGeometry_GTYPE_POLYGON(jGeometry, n, dataOutputStream, byteOrder, n2);
                break;
            }
            default: {
                throw new GeometryExceptionWithContext(null, "Unsupported collection element: elemInfo type " + jGeometry.getElemInfo()[n + 1], null);
            }
        }
    }

    @Override
    public final STRUCT toSTRUCT(byte[] byArray, Connection connection) throws SQLException, GeometryExceptionWithContext {
        return JGeometry.store((JGeometry)this.toJGeometry(byArray), (Connection)connection);
    }

    @Override
    public final byte[] fromSTRUCT(STRUCT sTRUCT) throws SQLException, GeometryExceptionWithContext {
        return this.fromJGeometry(JGeometry.load((STRUCT)sTRUCT));
    }

    public final Struct toStruct(byte[] byArray, Connection connection) throws SQLException, GeometryExceptionWithContext {
        return JGeometry.storeJS((JGeometry)this.toJGeometry(byArray), (Connection)connection);
    }

    public final byte[] fromStruct(Struct struct) throws SQLException, GeometryExceptionWithContext {
        return this.fromJGeometry(JGeometry.loadJS((Struct)struct));
    }

    protected void fromJGeometry_ETYPE_1_1(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.writeByteOrder(dataOutputStream);
        this.writeLabel(dataOutputStream, 1, -1, byteOrder);
        if (jGeometry.getPoint() != null) {
            this.writeBeginningOfList(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, jGeometry.getPoint()[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, jGeometry.getPoint()[1]);
            if (jGeometry.getDimensions() == 3) {
                this.writeXYSeparator(dataOutputStream);
                this.writeDouble(byteOrder, dataOutputStream, jGeometry.getPoint()[2]);
            }
            this.writeEndOfList(dataOutputStream);
        } else {
            int n2 = jGeometry.getElemInfo()[n] - 1;
            double[] dArray = jGeometry.getOrdinatesArray();
            this.writeBeginningOfList(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            if (jGeometry.getDimensions() == 3) {
                this.writeXYSeparator(dataOutputStream);
                this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            }
            this.writeEndOfList(dataOutputStream);
        }
    }

    protected void fromJGeometry_ETYPE_1_n_internal(JGeometry jGeometry, int n, int n2, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n3 = jGeometry.getDimensions();
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            this.writeByteOrder(dataOutputStream);
            this.writeLabel(dataOutputStream, 1, 4, byteOrder);
            this.writeBeginningOfList(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, jGeometry.getOrdinatesArray()[n + n3 * i]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, jGeometry.getOrdinatesArray()[n + n3 * i + 1]);
            if (n3 == 3) {
                this.writeXYSeparator(dataOutputStream);
                this.writeDouble(byteOrder, dataOutputStream, jGeometry.getOrdinatesArray()[n + n3 * i + 2]);
            }
            this.writeEndOfList(dataOutputStream);
        }
    }

    protected int fromJGeometry_ETYPE_1_n(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, boolean bl) throws GeometryExceptionWithContext {
        int n2;
        int n3 = jGeometry.getElemInfo()[n + 0] - 1;
        int n4 = 0;
        if (bl) {
            n4 = jGeometry.getElemInfo()[n + 2];
            n2 = n + 3;
        } else {
            n2 = n;
            while ((n2 < jGeometry.getElemInfo().length ? jGeometry.getElemInfo()[n2 + 1] : 0) == 1) {
                n4 += jGeometry.getElemInfo()[n2 + 2];
                n2 += 3;
            }
        }
        if (n4 == 1) {
            this.fromJGeometry_ETYPE_1_1(jGeometry, n, dataOutputStream, byteOrder);
        } else {
            this.writeByteOrder(dataOutputStream);
            this.writeLabel(dataOutputStream, 4, -1, byteOrder);
            this.writeBeginningOfList(byteOrder, dataOutputStream, n4);
            this.fromJGeometry_ETYPE_1_n_internal(jGeometry, n3, n4, dataOutputStream, byteOrder);
            this.writeEndOfList(dataOutputStream);
        }
        return n2;
    }

    protected void fromJGeometry_ETYPE_2(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, int n2, ByteOrder byteOrder, int n3) throws GeometryExceptionWithContext {
        int n4 = jGeometry.getDimensions();
        switch (n2) {
            case 2: 
            case 1000001: {
                this.writeByteOrder(dataOutputStream);
                this.writeLabel(dataOutputStream, n2, n3, byteOrder);
                int n5 = this.getStartPosInOrdinateArray(jGeometry, n);
                int n6 = this.getEndPosInOrdinateArray(jGeometry, n);
                this.writeBeginningOfList(byteOrder, dataOutputStream, (n6 - n5) / n4);
                double[] dArray = jGeometry.getOrdinatesArray();
                for (int i = n5; i < n6; i += n4) {
                    if (i > n5) {
                        this.writeCoordPairSeparator(dataOutputStream);
                    }
                    this.writeDouble(byteOrder, dataOutputStream, dArray[i]);
                    this.writeXYSeparator(dataOutputStream);
                    this.writeDouble(byteOrder, dataOutputStream, dArray[i + 1]);
                    if (n4 != 3) continue;
                    this.writeXYSeparator(dataOutputStream);
                    this.writeDouble(byteOrder, dataOutputStream, dArray[i + 2]);
                }
                this.writeEndOfList(dataOutputStream);
                break;
            }
            case 21: {
                int n7;
                if (n3 != 1000002) {
                    this.writeByteOrder(dataOutputStream);
                    this.writeLabel(dataOutputStream, n2, n3, byteOrder);
                }
                this.writeBeginningOfList(dataOutputStream);
                int n8 = this.getStartPosInOrdinateArray(jGeometry, n);
                int n9 = this.getEndPosInOrdinateArray(jGeometry, n);
                double[] dArray = jGeometry.getOrdinatesArray();
                this.writeInnerLabel(dataOutputStream, 91, 21);
                int n10 = Double.valueOf(dArray[n8]).intValue();
                this.writeByte(dataOutputStream, n10);
                this.writeCoordPairSeparator(dataOutputStream);
                this.writeInnerLabel(dataOutputStream, 92, 21);
                int n11 = Double.valueOf(dArray[n8 + 1]).intValue();
                this.writeBeginningOfList(byteOrder, dataOutputStream, n11);
                for (n7 = n8 + 2; n7 < n8 + n11 * 3 + 2; n7 += 3) {
                    this.writeInnerLabel(dataOutputStream, 93, 21);
                    this.writeBeginningOfList(dataOutputStream);
                    this.writeInnerLabel(dataOutputStream, 94, 21);
                    this.writeBeginningOfList(dataOutputStream);
                    this.writeDouble(byteOrder, dataOutputStream, dArray[n7]);
                    this.writeXYSeparator(dataOutputStream);
                    this.writeDouble(byteOrder, dataOutputStream, dArray[n7 + 1]);
                    this.writeEndOfList(dataOutputStream);
                    this.writeCoordPairSeparator(dataOutputStream);
                    this.writeInnerLabel(dataOutputStream, 95, 21);
                    this.writeDouble(byteOrder, dataOutputStream, dArray[n7 + 2]);
                    this.writeEndOfList(dataOutputStream);
                    if (n7 != n8 + n11 * 3 - 1) {
                        this.writeCoordPairSeparator(dataOutputStream);
                        continue;
                    }
                    this.writeEndOfList(dataOutputStream);
                }
                this.writeCoordPairSeparator(dataOutputStream);
                this.writeInnerLabel(dataOutputStream, 96, 21);
                n7 = Double.valueOf(dArray[n8 + n11 * 3 + 2]).intValue();
                this.writeBeginningOfList(byteOrder, dataOutputStream, n7);
                int n12 = 1;
                for (int i = n8 + n11 * 3 + 3; i < n9; ++i) {
                    if (n12 == 1) {
                        this.writeInnerLabel(dataOutputStream, 97, 21);
                        this.writeBeginningOfList(dataOutputStream);
                        this.writeInnerLabel(dataOutputStream, 98, 21);
                        this.writeDouble(byteOrder, dataOutputStream, dArray[i]);
                    }
                    if (i != n9 - 1 && dArray[i] == dArray[i + 1]) {
                        ++n12;
                        continue;
                    }
                    this.writeCoordPairSeparator(dataOutputStream);
                    this.writeInnerLabel(dataOutputStream, 99, 21);
                    this.writeByte(dataOutputStream, n12);
                    this.writeEndOfList(dataOutputStream);
                    if (i != n9 - 1) {
                        this.writeCoordPairSeparator(dataOutputStream);
                    }
                    n12 = 1;
                }
                this.writeEndOfList(dataOutputStream);
                this.writeEndOfList(dataOutputStream);
                break;
            }
        }
    }

    protected void fromJGeometry_ETYPE_2_2(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.fromJGeometry_ETYPE_2(jGeometry, n, dataOutputStream, 1000001, byteOrder, n2);
    }

    protected void fromJGeometry_ETYPE_x005(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2 = jGeometry.getElemInfo()[n + 2];
        this.writeLabel(dataOutputStream, 1000002, 1000003, byteOrder);
        this.writeBeginningOfList(byteOrder, dataOutputStream, n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = this.getStartPosInOrdinateArray(jGeometry, n + 3 * (i + 1));
            int n4 = this.getEndPosInOrdinateArray(jGeometry, n + 3 * (i + 1));
            if (i < n2 - 1) {
                ++n4;
            }
            if (i > 0) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            if (jGeometry.getElemInfo()[n + 3 * (i + 1) + 2] == 2) {
                this.writeLabel(dataOutputStream, 1000001, 1000003, byteOrder);
            }
            this.writeBeginningOfList(byteOrder, dataOutputStream, (n4 - n3) / 2);
            double[] dArray = jGeometry.getOrdinatesArray();
            for (int j = n3; j < n4; j += 2) {
                if (j > n3) {
                    this.writeCoordPairSeparator(dataOutputStream);
                }
                this.writeDouble(byteOrder, dataOutputStream, dArray[j]);
                this.writeXYSeparator(dataOutputStream);
                this.writeDouble(byteOrder, dataOutputStream, dArray[j + 1]);
            }
            this.writeEndOfList(dataOutputStream);
        }
        this.writeEndOfList(dataOutputStream);
    }

    protected void fromJGeometry_ETYPE_x003(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2 = this.getStartPosInOrdinateArray(jGeometry, n);
        int n3 = this.getEndPosInOrdinateArray(jGeometry, n);
        int n4 = jGeometry.getDimensions();
        if (jGeometry.getElemInfo()[n + 2] == 2) {
            this.writeLabel(dataOutputStream, 1000001, 1000003, byteOrder);
        }
        this.writeBeginningOfList(byteOrder, dataOutputStream, (n3 - n2) / n4);
        double[] dArray = jGeometry.getOrdinatesArray();
        for (int i = n2; i < n3; i += n4) {
            if (i > n2) {
                this.writeCoordPairSeparator(dataOutputStream);
            }
            this.writeDouble(byteOrder, dataOutputStream, dArray[i]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[i + 1]);
            if (n4 != 3) continue;
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[i + 2]);
        }
        this.writeEndOfList(dataOutputStream);
    }

    protected void fromJGeometry_ETYPE_x003_optimized_circle(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, boolean bl) throws GeometryExceptionWithContext {
        int n2 = this.getStartPosInOrdinateArray(jGeometry, n);
        int n3 = this.getEndPosInOrdinateArray(jGeometry, n);
        if (n3 - n2 != 6) {
            throw new GeometryExceptionWithContext(null, "In an optimized circle, the number of ordinates is expected to be 6, not " + (n3 - n2) + ".", null);
        }
        this.writeBeginningOfList(byteOrder, dataOutputStream, 5);
        double[] dArray = jGeometry.getOrdinatesArray();
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        this.determineCenterAndRadiusForArc(dArray[n2], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5], dArray2, dArray3, dArray4);
        if (bl) {
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] - dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0] + dArray4[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] + dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0] - dArray4[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] - dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
        } else {
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] - dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0] - dArray4[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] + dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0] + dArray4[0]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray2[0] - dArray4[0]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray3[0]);
        }
        this.writeEndOfList(dataOutputStream);
    }

    protected void fromJGeometry_ETYPE_x003_optimized_rectangle(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, boolean bl) throws GeometryExceptionWithContext {
        int n2 = this.getStartPosInOrdinateArray(jGeometry, n);
        int n3 = this.getEndPosInOrdinateArray(jGeometry, n);
        int n4 = jGeometry.getDimensions();
        if (n4 == 2 && n3 - n2 != 4) {
            throw new GeometryExceptionWithContext(null, "In a 2D optimized rectangle, the number of ordinates is expected to be 4, not " + (n3 - n2) + ".", null);
        }
        if (n4 == 3 && n3 - n2 != 6) {
            throw new GeometryExceptionWithContext(null, "In a 3D optimized rectangle, the number of ordinates is expected to be 6, not " + (n3 - n2) + ".", null);
        }
        this.writeBeginningOfList(byteOrder, dataOutputStream, 5);
        double[] dArray = jGeometry.getOrdinatesArray();
        if (n4 == 2 && bl) {
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
        } else if (n4 == 2 && !bl) {
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
        } else if (n4 == 3 && bl) {
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 4]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 5]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 4]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 5]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
        } else if (n4 == 3 && !bl) {
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 3]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 4]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 5]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 4]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 5]);
            this.writeCoordPairSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 1]);
            this.writeXYSeparator(dataOutputStream);
            this.writeDouble(byteOrder, dataOutputStream, dArray[n2 + 2]);
        }
        this.writeEndOfList(dataOutputStream);
    }

    protected void fromJGeometry_ETYPE_4_n(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.fromJGeometry_ETYPE_4(jGeometry, n, dataOutputStream, byteOrder, n2);
    }

    protected void fromJGeometry_ETYPE_4(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.writeByteOrder(dataOutputStream);
        this.writeLabel(dataOutputStream, 1000002, n2, byteOrder);
        int n3 = jGeometry.getElemInfo()[n + 2];
        this.writeBeginningOfList(byteOrder, dataOutputStream, n3);
        for (int i = 0; i < n3; ++i) {
            switch (jGeometry.getElemInfo()[n + 3 * (i + 1) + 2]) {
                case 1: {
                    this.writeLabel(dataOutputStream, 2, 1000002, byteOrder);
                    break;
                }
                case 2: {
                    this.writeLabel(dataOutputStream, 1000001, 1000002, byteOrder);
                    break;
                }
                case 3: {
                    this.writeLabel(dataOutputStream, 21, 1000002, byteOrder);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            switch (jGeometry.getElemInfo()[n + 3 * (i + 1) + 2]) {
                case 1: 
                case 2: {
                    int n4 = this.getStartPosInOrdinateArray(jGeometry, n + 3 * (i + 1));
                    int n5 = this.getEndPosInOrdinateArray(jGeometry, n + 3 * (i + 1));
                    if (i < n3 - 1 && jGeometry.getElemInfo()[n + 3 * (i + 2) + 2] != 3) {
                        n5 += 2;
                    }
                    this.writeBeginningOfList(byteOrder, dataOutputStream, (n5 - n4) / 2);
                    double[] dArray = jGeometry.getOrdinatesArray();
                    for (int j = n4; j < n5; j += 2) {
                        if (j > n4) {
                            this.writeCoordPairSeparator(dataOutputStream);
                        }
                        this.writeDouble(byteOrder, dataOutputStream, dArray[j]);
                        this.writeXYSeparator(dataOutputStream);
                        this.writeDouble(byteOrder, dataOutputStream, dArray[j + 1]);
                    }
                    this.writeEndOfList(dataOutputStream);
                    break;
                }
                case 3: {
                    this.fromJGeometry_ETYPE_2_3(jGeometry, n + 3 * (i + 1), dataOutputStream, byteOrder, 1000002);
                }
            }
            if (i >= n3 - 1) continue;
            this.writeGeometrySeparator(dataOutputStream);
        }
        this.writeEndOfList(dataOutputStream);
    }

    protected void fromJGeometry_ETYPE_2_1(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.fromJGeometry_ETYPE_2(jGeometry, n, dataOutputStream, 2, byteOrder, n2);
    }

    protected void fromJGeometry_ETYPE_2_3(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.fromJGeometry_ETYPE_2(jGeometry, n, dataOutputStream, 21, byteOrder, n2);
    }

    protected int fromJGeometry_GTYPE_COLLECTION(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.writeByteOrder(dataOutputStream);
        this.writeLabel(dataOutputStream, 7, -1, byteOrder);
        int[] nArray = jGeometry.getElemInfo();
        int[] nArray2 = new int[]{n};
        int n2 = (nArray.length - n) / 3;
        this.writeBeginningOfList(byteOrder, dataOutputStream, n2);
        int n3 = n;
        while (n3 < jGeometry.getElemInfo().length) {
            if (n3 > n) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            this.fromJGeometry_CollectionElement(jGeometry, n3, dataOutputStream, byteOrder, 7, nArray2);
            n3 = nArray2[0];
        }
        this.writeEndOfList(dataOutputStream);
        return n3;
    }

    protected int fromJGeometry_GTYPE_CURVE(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        int n3 = jGeometry.getDimensions();
        if (this.hasType(jGeometry, n, -1, 2, 1)) {
            this.fromJGeometry_ETYPE_2_1(jGeometry, n, dataOutputStream, byteOrder, n2);
        } else if (this.hasType(jGeometry, n, -1, 2, 2)) {
            if (n3 == 3) {
                throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
            }
            this.fromJGeometry_ETYPE_2_2(jGeometry, n, dataOutputStream, byteOrder, n2);
        } else if (this.hasType(jGeometry, n, -1, 2, 3)) {
            if (n3 == 3) {
                throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
            }
            this.fromJGeometry_ETYPE_2_3(jGeometry, n, dataOutputStream, byteOrder, n2);
        } else if (this.hasType(jGeometry, n, -1, 4, -1)) {
            if (n3 == 3) {
                throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
            }
            this.fromJGeometry_ETYPE_4_n(jGeometry, n, dataOutputStream, byteOrder, n2);
        } else {
            throw new GeometryExceptionWithContext(null, "For GTYPE_CURVE, the eType must be 2 and interpretation either 1, 2 or 3.", null);
        }
        return n + 3;
    }

    protected int fromJGeometry_GTYPE_MULTICURVE(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2;
        int n3;
        int n4;
        this.writeByteOrder(dataOutputStream);
        boolean bl = true;
        for (n4 = 0; n4 < jGeometry.getElemInfo().length; n4 += 3) {
            if (jGeometry.getElemInfo()[n4 + 2] != 1) {
                bl = false;
                continue;
            }
            if (jGeometry.getElemInfo()[n4 + 2] <= 3) continue;
            throw new GeometryExceptionWithContext(null, "For GTYPE_CURVE, the interpretation must be either 1, 2 or 3", null);
        }
        if (bl) {
            n3 = 5;
            this.writeLabel(dataOutputStream, 5, -1, byteOrder);
        } else {
            n3 = 1000004;
            this.writeLabel(dataOutputStream, 1000004, -1, byteOrder);
        }
        n4 = n;
        int n5 = jGeometry.getElemInfo().length;
        this.writeBeginningOfList(byteOrder, dataOutputStream, (n5 - n4) / 3);
        for (n2 = n; n2 < jGeometry.getElemInfo().length; n2 += 3) {
            if (n2 > n) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            this.fromJGeometry_GTYPE_CURVE(jGeometry, n2, dataOutputStream, byteOrder, n3);
        }
        this.writeEndOfList(dataOutputStream);
        return n2;
    }

    protected int fromJGeometry_GTYPE_MULTIPOINT(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, boolean bl) throws GeometryExceptionWithContext {
        return this.fromJGeometry_ETYPE_1_n(jGeometry, n, dataOutputStream, byteOrder, bl);
    }

    protected int fromJGeometry_GTYPE_MULTIPOLYGON(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2;
        int n3;
        this.writeByteOrder(dataOutputStream);
        switch (jGeometry.getElemInfo()[2]) {
            case 1: {
                n3 = 6;
                this.writeLabel(dataOutputStream, 6, -1, byteOrder);
                break;
            }
            case 2: {
                n3 = 1000005;
                this.writeLabel(dataOutputStream, 1000005, -1, byteOrder);
                break;
            }
            default: {
                throw new GeometryExceptionWithContext(null, "For GTYPE_MULTIPOLYGON, interpretation should be 1 or 2", null);
            }
        }
        int[] nArray = jGeometry.getElemInfo();
        int n4 = 0;
        for (n2 = n; n2 < nArray.length; n2 += 3) {
            if (nArray[n2 + 1] != 1003) continue;
            ++n4;
        }
        this.writeBeginningOfList(byteOrder, dataOutputStream, n4);
        n2 = n;
        for (int i = n; i < jGeometry.getElemInfo().length; i += 3) {
            if (jGeometry.getElemInfo()[i + 1] != 1003) continue;
            if (i > n) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            n2 = this.fromJGeometry_GTYPE_POLYGON(jGeometry, i, dataOutputStream, byteOrder, n3);
        }
        this.writeEndOfList(dataOutputStream);
        return n2;
    }

    protected int fromJGeometry_GTYPE_POINT(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.fromJGeometry_ETYPE_1_1(jGeometry, n, dataOutputStream, byteOrder);
        return n + 3;
    }

    protected void determineCenterAndRadiusForArc(double d, double d2, double d3, double d4, double d5, double d6, double[] dArray, double[] dArray2, double[] dArray3) {
        double d7 = d - d3;
        double d8 = d2 - d4;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = d5 - d3;
        double d12 = d6 - d4;
        double d13 = d7 - d9;
        double d14 = d9 - d11;
        double d15 = d8 - d10;
        double d16 = d10 - d12;
        double d17 = d7 + d9;
        double d18 = d9 + d11;
        double d19 = d8 + d10;
        double d20 = d10 + d12;
        double d21 = d7 * d7 + d8 * d8;
        double d22 = d9 * d9 + d10 * d10;
        double d23 = d11 * d11 + d12 * d12;
        if (this.MDCGEQ(d14 * d15, d13 * d16, 1.0E-12)) {
            throw new RuntimeException("3 points forming a circle are on a common line");
        }
        dArray[0] = (d16 * d21 - (d15 + d16) * d22 + d15 * d23) / (d13 * d16 - d14 * d15);
        dArray2[0] = this.MDCGEQ(d4, d6, 1.0E-16) ? d19 + (d17 - dArray[0]) * d13 / d15 : d20 + (d18 - dArray[0]) * d14 / d16;
        dArray[0] = dArray[0] / 2.0;
        dArray2[0] = dArray2[0] / 2.0;
        dArray3[0] = Math.sqrt(dArray[0] * dArray[0] + dArray2[0] * dArray2[0]);
        dArray[0] = dArray[0] + d3;
        dArray2[0] = dArray2[0] + d4;
    }

    protected boolean MDCGEQ(double d, double d2, double d3) {
        return Math.abs(d - d2) < (d3 < 1.0E-16 ? 1.0E-16 : d3);
    }

    protected int fromJGeometry_GTYPE_POLYGON(JGeometry jGeometry, int n, DataOutputStream dataOutputStream, ByteOrder byteOrder, int n2) throws GeometryExceptionWithContext {
        this.writeByteOrder(dataOutputStream);
        if (this.hasType(jGeometry, n, -1, 1003, 3) || this.hasType(jGeometry, n, -1, 2003, 3)) {
            this.writeLabel(dataOutputStream, 3, n2, byteOrder);
            int n3 = 1;
            this.writeBeginningOfList(byteOrder, dataOutputStream, n3);
            this.fromJGeometry_ETYPE_x003_optimized_rectangle(jGeometry, n, dataOutputStream, byteOrder, jGeometry.getElemInfo()[n + 1] / 1000 == 2);
            this.writeEndOfList(dataOutputStream);
            return n + 3 * n3;
        }
        if (this.hasType(jGeometry, n, -1, 1003, 4) || this.hasType(jGeometry, n, -1, 2003, 4)) {
            this.writeLabel(dataOutputStream, 1000003, n2, byteOrder);
            int n4 = 1;
            this.writeBeginningOfList(byteOrder, dataOutputStream, n4);
            this.fromJGeometry_ETYPE_x003_optimized_circle(jGeometry, n, dataOutputStream, byteOrder, jGeometry.getElemInfo()[n + 1] / 1000 == 2);
            this.writeEndOfList(dataOutputStream);
            return n + 3 * n4;
        }
        boolean bl = false;
        if (jGeometry.getElemInfo()[n + 2] == 2) {
            bl = true;
        }
        int n5 = 0;
        for (int i = 0; n + 3 * i < jGeometry.getElemInfo().length && (i == 0 || this.isInnerRing(jGeometry.getElemInfo()[n + 3 * i + 1])); ++i) {
            if (this.hasType(jGeometry, n + 3 * i, -1, 1003, 2) || this.hasType(jGeometry, n + 3 * i, -1, 2003, 2)) {
                bl = true;
            } else if (this.hasType(jGeometry, n + 3 * i, -1, 1005, -1) || this.hasType(jGeometry, n + 3 * i, -1, 2005, -1) || this.hasType(jGeometry, n + 3 * i, -1, 5, -1)) {
                i += jGeometry.getElemInfo()[n + 3 * i + 2];
                bl = true;
            }
            ++n5;
        }
        if (bl) {
            if (jGeometry.getDimensions() == 3) {
                throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
            }
            this.writeLabel(dataOutputStream, 1000003, n2, byteOrder);
        } else {
            this.writeLabel(dataOutputStream, 3, n2, byteOrder);
        }
        this.writeBeginningOfList(byteOrder, dataOutputStream, n5);
        for (int i = 0; i < n5; ++i) {
            if (i > 0) {
                this.writeGeometrySeparator(dataOutputStream);
            }
            if (this.hasType(jGeometry, n + 3 * i, -1, 1003, -1) || this.hasType(jGeometry, n + 3 * i, -1, 2003, -1) || this.hasType(jGeometry, n + 3 * i, -1, 3, -1)) {
                this.fromJGeometry_ETYPE_x003(jGeometry, n + 3 * i, dataOutputStream, byteOrder);
                continue;
            }
            if (this.hasType(jGeometry, n + 3 * i, -1, 1005, -1) || this.hasType(jGeometry, n + 3 * i, -1, 2005, -1) || this.hasType(jGeometry, n + 3 * i, -1, 5, -1)) {
                this.fromJGeometry_ETYPE_x005(jGeometry, n + 3 * i, dataOutputStream, byteOrder);
                continue;
            }
            throw new RuntimeException();
        }
        this.writeEndOfList(dataOutputStream);
        return n + 3 * n5;
    }

    protected boolean isInnerRing(int n) {
        switch (n) {
            case 2: 
            case 1003: 
            case 1005: {
                return false;
            }
            case 2003: 
            case 2005: {
                return true;
            }
        }
        throw new RuntimeException();
    }

    protected boolean hasType(JGeometry jGeometry, int n, int n2, int n3, int n4) {
        if (jGeometry.getElemInfo() == null) {
            return false;
        }
        if (n2 != -1 && n2 != jGeometry.getType()) {
            return false;
        }
        if (n3 != -1 && n3 != jGeometry.getElemInfo()[n + 1]) {
            return false;
        }
        return n4 == -1 || n4 == jGeometry.getElemInfo()[n + 2];
    }

    protected int getStartPosInOrdinateArray(JGeometry jGeometry, int n) {
        return jGeometry.getElemInfo()[n] - 1;
    }

    protected int getEndPosInOrdinateArray(JGeometry jGeometry, int n) {
        if (n + 3 < jGeometry.getElemInfo().length) {
            return jGeometry.getElemInfo()[n + 3] - 1;
        }
        return jGeometry.getOrdinatesArray().length;
    }

    @Override
    public JGeometry toJGeometry(byte[] byArray) throws GeometryExceptionWithContext {
        if (byArray == null) {
            return null;
        }
        WKInputStream wKInputStream = this.getWKInputStream(byArray);
        int n = wKInputStream.getDimensions();
        VectorOfInt vectorOfInt = new VectorOfInt();
        VectorOfInt vectorOfInt2 = new VectorOfInt();
        VectorOfDouble vectorOfDouble = new VectorOfDouble();
        VectorOfDouble vectorOfDouble2 = new VectorOfDouble();
        this.toJGeometry(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, false, -1);
        if (vectorOfDouble.size() > 0) {
            if (n == 2) {
                return new JGeometry(vectorOfDouble.get(0), vectorOfDouble.get(1), 0);
            }
            return new JGeometry(vectorOfDouble.get(0), vectorOfDouble.get(1), vectorOfDouble.get(2), 0);
        }
        return new JGeometry(vectorOfInt.get(0), 0, vectorOfInt2.getArray(), vectorOfDouble2.getArray());
    }

    protected void toJGeometry(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, boolean bl, int n) throws GeometryExceptionWithContext {
        int n2 = wKInputStream.getDimensions();
        ByteOrder byteOrder = this.readByteOrder(wKInputStream);
        int n3 = this.readLabel(wKInputStream, byteOrder, n);
        switch (n3) {
            case 1: {
                this.toJGeometry_WKB_POINT(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, bl, byteOrder, n);
                break;
            }
            case 2: {
                this.toJGeometry_WKB_LINESTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 1000001: {
                this.toJGeometry_WKB_CIRCULARSTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 1000002: {
                if (n2 == 3) {
                    throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
                }
                this.toJGeometry_WKB_COMPOUNDCURVE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, n, 0);
                break;
            }
            case 21: {
                if (n2 == 3) {
                    throw new GeometryExceptionWithContext(null, "3D Geometry cannot have Arcs", null);
                }
                this.toJGeometry_WKB_NURBSCURVE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 3: {
                this.toJGeometry_WKB_POLYGON(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 1000003: {
                this.toJGeometry_WKB_CURVEPOLYGON(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 4: {
                this.toJGeometry_WKB_MULTIPOINT(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 1000004: {
                this.toJGeometry_WKB_MULTICURVE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 5: {
                this.toJGeometry_WKB_MULTILINESTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 1000005: {
                this.toJGeometry_WKB_MULTISURFACE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 6: {
                this.toJGeometry_WKB_MULTIPOLYGON(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            case 7: {
                this.toJGeometry_WKB_COLLECTION(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                break;
            }
            default: {
                throw new GeometryExceptionWithContext(null, "Unknown WKB label: " + n3 + ".", null);
            }
        }
    }

    protected void toJGeometry_WKB_POINT(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, boolean bl, ByteOrder byteOrder, int n) throws GeometryExceptionWithContext {
        int n2 = wKInputStream.getDimensions();
        vectorOfInt.add(n2 * 1000 + 1);
        if (bl) {
            if (n != 4) {
                vectorOfInt2.add(vectorOfDouble2.size() + 1);
                vectorOfInt2.add(1);
                vectorOfInt2.add(1);
            }
            this.readStartList(wKInputStream);
            vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            if (n2 == 3) {
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            }
            this.readEndList(wKInputStream);
        } else {
            this.readStartList(wKInputStream);
            vectorOfDouble.add(this.readDouble(byteOrder, wKInputStream));
            vectorOfDouble.add(this.readDouble(byteOrder, wKInputStream));
            if (n2 == 3) {
                vectorOfDouble.add(this.readDouble(byteOrder, wKInputStream));
            }
            this.readEndList(wKInputStream);
        }
    }

    protected void toJGeometry_WKB_LINESTRING(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_XXXSTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, 1, byteOrder);
    }

    protected void toJGeometry_WKB_XXXSTRING(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, int n, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n2 = wKInputStream.getDimensions();
        vectorOfInt.add(n2 * 1000 + 2);
        vectorOfInt2.add(vectorOfDouble2.size() + 1);
        vectorOfInt2.add(2);
        vectorOfInt2.add(n);
        int n3 = this.readStartList(byteOrder, wKInputStream);
        for (int i = 0; i < n3; ++i) {
            if (i > 0) {
                this.readSeparator(wKInputStream);
            }
            vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            if (n2 != 3) continue;
            vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
        }
        this.readEndList(wKInputStream);
    }

    protected void toJGeometry_WKB_NURBSCURVE(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        int n5 = 0;
        vectorOfInt.add(2002);
        vectorOfInt2.add(vectorOfDouble2.size() + 1);
        vectorOfInt2.add(2);
        vectorOfInt2.add(3);
        this.readStartList(wKInputStream);
        n4 = this.readInnerLabel(wKInputStream);
        if (n4 != 91 && n4 != -1) {
            throw new GeometryExceptionWithContext(null, "DEGREE label missing in WKT", null);
        }
        n = n4 == -1 ? this.readByte(wKInputStream) : Double.valueOf(this.readDouble(byteOrder, wKInputStream)).intValue();
        vectorOfDouble2.add(n);
        this.readSeparator(wKInputStream);
        n4 = this.readInnerLabel(wKInputStream);
        if (n4 != 92 && n4 != -1) {
            throw new GeometryExceptionWithContext(null, "CONTROLPOINTS label missing in WKT", null);
        }
        this.readStartList(wKInputStream);
        if (n4 != 92) {
            int n6;
            n2 = this.readStartList(byteOrder, wKInputStream);
            vectorOfDouble2.add(n2);
            for (n6 = 0; n6 < n2; ++n6) {
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            }
            vectorOfDouble2.add(n3);
            for (n3 = this.readStartList(byteOrder, wKInputStream); n3 != 0; n3 -= n5) {
                d = this.readDouble(byteOrder, wKInputStream);
                n5 = this.readByte(wKInputStream);
                for (n6 = 0; n6 < n5; ++n6) {
                    vectorOfDouble2.add(d);
                }
            }
        } else {
            while ((n4 = this.readInnerLabel(wKInputStream)) == 93) {
                ++n2;
                this.readStartList(wKInputStream);
                n4 = this.readInnerLabel(wKInputStream);
                this.readStartList(wKInputStream);
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                this.readEndList(wKInputStream);
                this.readSeparator(wKInputStream);
                n4 = this.readInnerLabel(wKInputStream);
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                this.readEndList(wKInputStream);
                this.readEndListOrSeparator(wKInputStream);
            }
            vectorOfDouble2.add(vectorOfDouble2.size() - 3 * n2, n2);
            n4 = this.readInnerLabel(wKInputStream);
            if (n4 != 96) {
                throw new GeometryExceptionWithContext(null, "KNOTS label missing in WKT", null);
            }
            this.readStartList(wKInputStream);
            while ((n4 = this.readInnerLabel(wKInputStream)) == 97) {
                this.readStartList(wKInputStream);
                n4 = this.readInnerLabel(wKInputStream);
                if (n4 != 98) {
                    throw new GeometryExceptionWithContext(null, "VALUE label missing in WKT", null);
                }
                d = this.readDouble(byteOrder, wKInputStream);
                this.readSeparator(wKInputStream);
                n4 = this.readInnerLabel(wKInputStream);
                if (n4 != 99) {
                    throw new GeometryExceptionWithContext(null, "MULTIPLICITY label missing in WKT", null);
                }
                n5 = Double.valueOf(this.readDouble(byteOrder, wKInputStream)).intValue();
                for (int i = 0; i < n5; ++i) {
                    vectorOfDouble2.add(d);
                }
                n3 += n5;
                this.readEndList(wKInputStream);
                this.readEndListOrSeparator(wKInputStream);
            }
            vectorOfDouble2.add(vectorOfDouble2.size() - n3, n3);
        }
    }

    protected void toJGeometry_WKB_MULTIPOINT(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n = this.readStartList(byteOrder, wKInputStream);
        int n2 = vectorOfDouble2.size();
        int n3 = wKInputStream.getDimensions();
        vectorOfInt.add(n3 * 1000 + 5);
        vectorOfInt2.add(n2 + 1);
        vectorOfInt2.add(1);
        vectorOfInt2.add(n);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.readSeparator(wKInputStream);
            }
            this.toJGeometry(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, true, 4);
        }
        this.readEndList(wKInputStream);
    }

    protected void toJGeometry_WKB_MULTILINESTRING(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_MULTIXXXSTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, 5);
    }

    protected void toJGeometry_WKB_MULTICURVE(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_MULTIXXXSTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, 1000004);
    }

    protected void toJGeometry_WKB_MULTIXXXSTRING(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder, int n) throws GeometryExceptionWithContext {
        int n2;
        int n3 = this.readStartList(byteOrder, wKInputStream);
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 > 0) {
                this.readSeparator(wKInputStream);
            }
            this.toJGeometry(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, true, n);
        }
        this.readEndList(wKInputStream);
        vectorOfInt.clear();
        n2 = wKInputStream.getDimensions();
        vectorOfInt.add(n2 * 1000 + 6);
    }

    protected void toJGeometry_WKB_MULTIPOLYGON(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_MULTIXXXPOLYGON(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, 6);
    }

    protected void toJGeometry_WKB_MULTISURFACE(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_MULTIXXXPOLYGON(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, 1000005);
    }

    protected void toJGeometry_WKB_MULTIXXXPOLYGON(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder, int n) throws GeometryExceptionWithContext {
        int n2;
        int n3 = this.readStartList(byteOrder, wKInputStream);
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 > 0) {
                this.readSeparator(wKInputStream);
            }
            this.toJGeometry(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, true, n);
        }
        this.readEndList(wKInputStream);
        vectorOfInt.clear();
        n2 = wKInputStream.getDimensions();
        vectorOfInt.add(n2 * 1000 + 7);
    }

    protected void toJGeometry_WKB_COLLECTION(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n;
        int n2 = this.readStartList(byteOrder, wKInputStream);
        for (n = 0; n < n2; ++n) {
            if (n > 0) {
                this.readSeparator(wKInputStream);
            }
            this.toJGeometry(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, true, 7);
        }
        this.readEndList(wKInputStream);
        vectorOfInt.clear();
        n = wKInputStream.getDimensions();
        vectorOfInt.add(n * 1000 + 4);
    }

    protected void toJGeometry_WKB_POLYGON(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        int n = wKInputStream.getDimensions();
        vectorOfInt.add(n * 1000 + 3);
        int n2 = this.readStartList(byteOrder, wKInputStream);
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                this.readSeparator(wKInputStream);
            }
            int n3 = 0;
            n3 = this.readStartList(byteOrder, wKInputStream);
            vectorOfInt2.add(vectorOfDouble2.size() + 1);
            vectorOfInt2.add(i == 0 ? 1003 : 2003);
            vectorOfInt2.add(1);
            for (int j = 0; j < n3; ++j) {
                if (j > 0) {
                    this.readSeparator(wKInputStream);
                }
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                if (n != 3) continue;
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            }
            this.readEndList(wKInputStream);
        }
        this.readEndList(wKInputStream);
    }

    protected void toJGeometry_WKB_COMPOUNDCURVE(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder, int n, int n2) throws GeometryExceptionWithContext {
        vectorOfInt.add(2002);
        int n3 = this.readStartList(byteOrder, wKInputStream);
        boolean bl = false;
        vectorOfInt2.add(vectorOfDouble2.size() + 1);
        if (n == 1000003) {
            vectorOfInt2.add(n2 == 0 ? 1005 : 2005);
        } else {
            vectorOfInt2.add(4);
        }
        vectorOfInt2.add(n3);
        for (int i = 0; i < n3; ++i) {
            if (i > 0) {
                this.readSeparator(wKInputStream);
            }
            int n4 = 1;
            switch (this.readLabel(wKInputStream, byteOrder, 1000002)) {
                case 2: {
                    n4 = 1;
                    break;
                }
                case 1000001: {
                    n4 = 2;
                    break;
                }
                case 21: {
                    this.toJGeometry_WKB_NURBSCURVE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder);
                    n4 = 3;
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (n4 == 3) continue;
            int n5 = this.readStartList(byteOrder, wKInputStream);
            if (bl && i > 0) {
                vectorOfInt2.add(vectorOfDouble2.size() - 1);
            } else {
                vectorOfInt2.add(vectorOfDouble2.size() + 1);
            }
            vectorOfInt2.add(2);
            vectorOfInt2.add(n4);
            for (int j = 0; j < n5; ++j) {
                if (j > 0) {
                    this.readSeparator(wKInputStream);
                }
                if (bl && j == 0) {
                    this.readDouble(byteOrder, wKInputStream);
                    this.readDouble(byteOrder, wKInputStream);
                    continue;
                }
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            }
            this.readEndList(wKInputStream);
            bl = true;
        }
        this.readEndList(wKInputStream);
    }

    protected void toJGeometry_WKB_CURVEPOLYGON(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        vectorOfInt.add(2003);
        int n = this.readStartList(byteOrder, wKInputStream);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.readSeparator(wKInputStream);
            }
            int n2 = 1;
            switch (this.readLabel(wKInputStream, byteOrder, 1000003)) {
                case 2: {
                    n2 = 1;
                    break;
                }
                case 1000001: {
                    n2 = 2;
                    break;
                }
                case 1000002: {
                    this.toJGeometry_WKB_COMPOUNDCURVE(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, byteOrder, 1000003, i);
                    return;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            int n3 = this.readStartList(byteOrder, wKInputStream);
            vectorOfInt2.add(vectorOfDouble2.size() + 1);
            vectorOfInt2.add(i == 0 ? 1003 : 2003);
            vectorOfInt2.add(n2);
            for (int j = 0; j < n3; ++j) {
                if (j > 0) {
                    this.readSeparator(wKInputStream);
                }
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
                vectorOfDouble2.add(this.readDouble(byteOrder, wKInputStream));
            }
            this.readEndList(wKInputStream);
        }
        this.readEndList(wKInputStream);
    }

    protected void toJGeometry_WKB_CIRCULARSTRING(WKInputStream wKInputStream, VectorOfInt vectorOfInt, VectorOfDouble vectorOfDouble, VectorOfInt vectorOfInt2, VectorOfDouble vectorOfDouble2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        this.toJGeometry_WKB_XXXSTRING(wKInputStream, vectorOfInt, vectorOfDouble, vectorOfInt2, vectorOfDouble2, 2, byteOrder);
    }

    protected void readSeparator(WKInputStream wKInputStream) {
        wKInputStream.readSeparator();
    }

    protected void readEndList(WKInputStream wKInputStream) {
        wKInputStream.readEndList();
    }

    protected void readEndListOrSeparator(WKInputStream wKInputStream) {
        wKInputStream.readEndListOrSeparator();
    }

    protected double readDouble(ByteOrder byteOrder, WKInputStream wKInputStream) {
        return wKInputStream.readDouble(byteOrder);
    }

    protected void readStartList(WKInputStream wKInputStream) throws GeometryExceptionWithContext {
        wKInputStream.readStartList();
    }

    protected int readStartList(ByteOrder byteOrder, WKInputStream wKInputStream) throws GeometryExceptionWithContext {
        int n = 0;
        try {
            n = wKInputStream.readStartList(byteOrder);
        }
        catch (RuntimeException runtimeException) {
            throw new GeometryExceptionWithContext(null, runtimeException.getMessage(), null);
        }
        return n;
    }

    protected int readByte(WKInputStream wKInputStream) throws GeometryExceptionWithContext {
        int n = 0;
        try {
            n = wKInputStream.readByte();
        }
        catch (RuntimeException runtimeException) {
            throw new GeometryExceptionWithContext(null, runtimeException.getMessage(), null);
        }
        return n;
    }

    protected int readLabel(WKInputStream wKInputStream, ByteOrder byteOrder, int n) {
        return wKInputStream.readLabel(byteOrder, n);
    }

    protected int readInnerLabel(WKInputStream wKInputStream) {
        return wKInputStream.readInnerLabel();
    }

    protected ByteOrder readByteOrder(WKInputStream wKInputStream) throws GeometryExceptionWithContext {
        return wKInputStream.readByteOrder();
    }

    protected abstract void writeLabel(DataOutputStream var1, int var2, int var3, ByteOrder var4) throws GeometryExceptionWithContext;

    protected abstract void writeInnerLabel(DataOutputStream var1, int var2, int var3) throws GeometryExceptionWithContext;

    protected abstract void writeBeginningOfList(ByteOrder var1, DataOutputStream var2, int var3) throws GeometryExceptionWithContext;

    protected abstract void writeBeginningOfList(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected abstract void writeDouble(ByteOrder var1, DataOutputStream var2, double var3) throws GeometryExceptionWithContext;

    protected abstract void writeXYSeparator(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected abstract void writeEndOfList(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected abstract void writeGeometrySeparator(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected abstract void writeCoordPairSeparator(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected abstract WKInputStream getWKInputStream(byte[] var1);

    protected abstract void writeByte(DataOutputStream var1, int var2) throws GeometryExceptionWithContext;

    protected abstract void writeByteOrder(DataOutputStream var1) throws GeometryExceptionWithContext;

    protected class VectorOfInt {
        protected int[] m_values = new int[1024];
        protected int m_size = 0;

        public void add(int n) {
            if (this.m_size == this.m_values.length) {
                this.extend();
            }
            this.m_values[this.m_size++] = n;
        }

        public int get(int n) {
            if (n < this.m_size) {
                return this.m_values[n];
            }
            throw new RuntimeException();
        }

        public int size() {
            return this.m_size;
        }

        public void clear() {
            this.m_size = 0;
        }

        protected void extend() {
            int[] nArray = new int[this.m_values.length * 2];
            for (int i = 0; i < this.m_values.length; ++i) {
                nArray[i] = this.m_values[i];
            }
            this.m_values = nArray;
        }

        public int[] getArray() {
            int[] nArray = new int[this.m_size];
            for (int i = 0; i < this.m_size; ++i) {
                nArray[i] = this.m_values[i];
            }
            return nArray;
        }
    }

    protected class VectorOfDouble {
        protected double[] m_values = new double[1024];
        protected int m_size = 0;

        public void add(double d) {
            if (this.m_size == this.m_values.length) {
                this.extend();
            }
            this.m_values[this.m_size++] = d;
        }

        public void add(int n, double d) {
            if (this.m_size == this.m_values.length) {
                this.extend();
            }
            for (int i = this.m_size++; i > n; --i) {
                this.m_values[i] = this.m_values[i - 1];
            }
            this.m_values[n] = d;
        }

        public double get(int n) {
            if (n < this.m_size) {
                return this.m_values[n];
            }
            throw new RuntimeException();
        }

        public int size() {
            return this.m_size;
        }

        public void clear() {
            this.m_size = 0;
        }

        protected void extend() {
            double[] dArray = new double[this.m_values.length * 2];
            for (int i = 0; i < this.m_values.length; ++i) {
                dArray[i] = this.m_values[i];
            }
            this.m_values = dArray;
        }

        public double[] getArray() {
            double[] dArray = new double[this.m_size];
            for (int i = 0; i < this.m_size; ++i) {
                dArray[i] = this.m_values[i];
            }
            return dArray;
        }
    }
}

