/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.library.helpset;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import oracle.help.common.TopicNameConvention;
import oracle.help.common.util.Canonicalizer;
import oracle.help.common.util.LocaleUtils;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;

public class XMLMapParser {
    public static final String TAG_MAP = "map";
    public static final String TAG_MAPID = "mapid";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_URL = "url";
    public static final String PARAM_WINTYPE = "wintype";
    public static final String TAG_TOPIC_NAME_CONVENTION = "topicNameConvention";
    public static final String TAG_TEXT = "text";
    public static final String TAG_FILENAME = "filename";
    public static final String PARAM_URLBASE = "urlBase";
    public static final String PARAM_SEPARATOR = "separator";
    private byte[] buffer = new byte[256];
    private final int BUF_SIZE = 256;

    public static void getMappingTables(URL url, String encoding, HashMap topicHashMap, HashMap windowHashMap) {
        XMLMapParser.getMappingTables(url, encoding, topicHashMap, windowHashMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMappingTables(URL url, String encoding, HashMap topicHashMap, HashMap windowHashMap, TopicNameConvention convention) {
        XMLMapParser parser = new XMLMapParser();
        BufferedReader reader = null;
        try {
            InputStream inStream = XMLMapParser.openInputStream(url);
            reader = new BufferedReader(LocaleUtils.createInputStreamReader(inStream, encoding));
            String baseURL = url.toString();
            Canonicalizer.fixSeparators(baseURL);
            baseURL = baseURL.substring(0, baseURL.lastIndexOf(47) + 1);
            if (convention != null) {
                convention.setURLBase(baseURL);
            }
            parser.parseMap(reader, baseURL, topicHashMap, windowHashMap, convention);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private XMLMapParser() {
    }

    void parseMap(BufferedReader reader, String baseURL, HashMap topicHashMap, HashMap windowHashMap) throws IOException, XMLParseException {
        this.parseMap(reader, baseURL, topicHashMap, windowHashMap, null);
    }

    void parseMap(BufferedReader reader, String baseURL, HashMap topicHashMap, HashMap windowHashMap, TopicNameConvention convention) throws IOException, XMLParseException {
        boolean newFormat = true;
        String line = "";
        reader.mark(1024);
        line = reader.readLine();
        while (line != null && line.length() == 0) {
            line = reader.readLine();
        }
        if (line == null) {
            return;
        }
        newFormat = line.toLowerCase().indexOf("<?xml") != -1;
        reader.reset();
        if (newFormat) {
            Parser parser = ParserFactory.createParser(reader, baseURL);
            XMLNode xmlRoot = parser.getRoot();
            this._handleMap(xmlRoot.getFirstChild(), baseURL, topicHashMap, windowHashMap, convention);
        } else {
            this.parseOldFormat(reader, baseURL, topicHashMap, windowHashMap);
        }
    }

    private void _handleMap(XMLNode node, String baseURL, HashMap topicHashMap, HashMap windowHashMap, TopicNameConvention convention) throws XMLParseException {
        if (!node.getTokenValue().equalsIgnoreCase(TAG_MAP)) {
            throw new XMLParseException("Toplevel tag is not MAP: " + node.getTokenValue());
        }
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            String target;
            if (node.getTokenValue().equalsIgnoreCase(TAG_TOPIC_NAME_CONVENTION)) {
                this._handleTopicConvention(node, convention);
            }
            if (!node.getTokenValue().equalsIgnoreCase(TAG_MAPID)) continue;
            URL completeURL = null;
            String relativeURL = node.getTokenProperty(PARAM_URL);
            if (relativeURL != null) {
                try {
                    completeURL = Canonicalizer.getAbsoluteURL(baseURL, relativeURL);
                }
                catch (MalformedURLException e) {
                    completeURL = null;
                }
            }
            if (completeURL == null || (target = node.getTokenProperty(PARAM_TARGET)) == null) continue;
            String windowType = node.getTokenProperty(PARAM_WINTYPE);
            if (windowType != null) {
                windowHashMap.put(completeURL, windowType);
            }
            topicHashMap.put(target, completeURL);
        }
    }

    private static InputStream openInputStream(URL url) throws IOException {
        InputStream inStream = null;
        if (url.getProtocol().equals("file")) {
            try {
                inStream = new FileInputStream(url.getFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (inStream == null) {
            inStream = url.openStream();
        }
        return inStream;
    }

    private void parseOldFormat(BufferedReader reader, String baseURL, HashMap topicHashMap, HashMap windowHashMap) throws IOException {
        while (true) {
            int equalsLocation;
            String line = "";
            String target = "";
            String relativeURL = "";
            URL completeURL = null;
            line = reader.readLine();
            if (line == null) break;
            if (line.length() == 0 || line.charAt(0) == ';' || (equalsLocation = line.indexOf(61)) == -1) continue;
            target = line.substring(0, equalsLocation).trim();
            if (target.charAt(0) == '\"') {
                target = target.substring(1, target.length() - 1);
            }
            relativeURL = line.substring(equalsLocation + 1).trim();
            int colonLocation = target.indexOf(58);
            if (colonLocation != -1) {
                relativeURL = relativeURL.substring(0, colonLocation).trim();
            }
            if (relativeURL.charAt(0) == '\"') {
                relativeURL = relativeURL.substring(1, relativeURL.length() - 1);
            }
            if (relativeURL.length() > 0) {
                try {
                    completeURL = Canonicalizer.getAbsoluteURL(baseURL, relativeURL);
                }
                catch (MalformedURLException e) {
                    completeURL = null;
                }
            }
            if (completeURL == null) continue;
            topicHashMap.put(target, completeURL);
        }
    }

    private void _handleTopicConvention(XMLNode conventionNode, TopicNameConvention convention) {
        String urlBase = conventionNode.getTokenProperty(PARAM_URLBASE);
        if (urlBase != null && !urlBase.equals("")) {
            convention.setURLBase(urlBase);
        }
        try {
            String first = null;
            XMLNode currentNode = conventionNode.getFirstChild();
            do {
                String nodeName = currentNode.getTokenValue();
                String nodeValue = currentNode.getString();
                if (nodeName.equals(TAG_TEXT)) {
                    convention.setBeginningText(nodeValue);
                } else {
                    first = nodeName;
                    convention.setFirst(nodeName);
                    this._considerFileSeparator(currentNode, convention);
                }
                currentNode = currentNode.getNextSibling();
            } while (first == null);
            convention.setMiddleText(currentNode.getString());
            currentNode = currentNode.getNextSibling();
            this._considerFileSeparator(currentNode, convention);
            currentNode = currentNode.getNextSibling();
            if (currentNode != null) {
                convention.setEndingText(currentNode.getString());
            }
        }
        catch (TopicNameConvention.MalformedConventionException mce) {
            mce.printStackTrace();
        }
    }

    private void _considerFileSeparator(XMLNode node, TopicNameConvention convention) {
        String separator;
        if (TAG_FILENAME.equals(node.getTokenValue()) && (separator = node.getTokenProperty(PARAM_SEPARATOR)) != null && !separator.equals("")) {
            convention.setFileSeparator(separator);
        }
    }
}

