/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.sparql.language;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLCountingTokenManager;
import oracle.dbtools.rdfgraph.sparql.language.SPARQLLexicalError;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.SqlTokens;
import oracle.javatools.parser.plsql.syntax.ParserException;
import oracle.javatools.parser.util.KeywordTable;
import oracle.spatial.rdf.server.parser.sparql.SimpleCharStream;
import oracle.spatial.rdf.server.parser.sparql.Token;
import oracle.spatial.rdf.server.parser.sparql.TokenMgrError;

public class BaseSPARQLLexer
extends AbstractLexer
implements SqlTokens {
    protected int lastToken;
    protected int last_token_abs_pos = -1;
    protected int loop_cnt = 0;
    protected final int MAX_RETRYS = 10;
    protected int startOffset;
    protected int endOffset;
    protected int hash;
    private boolean skipComments;
    private KeywordTable keywordTable;
    private SPARQLCountingTokenManager tokenManager = null;
    private String lastText = "";
    InputStream input_stream;
    List<SPARQLLexicalError> lexical_errors = new ArrayList<SPARQLLexicalError>();

    public void setLexical_errors(List<SPARQLLexicalError> list) {
        this.lexical_errors = list;
    }

    public List<SPARQLLexicalError> getLexical_errors() {
        return this.lexical_errors;
    }

    public void setTextBuffer(ReadTextBuffer readTextBuffer) {
        super.setTextBuffer(readTextBuffer);
        if (readTextBuffer != null) {
            String string = this.textBuffer.getString(0, this.textBuffer.getLength() - 1);
            this.input_stream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            if (this.tokenManager != null) {
                this.tokenManager.ReInit(new SimpleCharStream(this.input_stream));
            } else {
                this.tokenManager = new SPARQLCountingTokenManager(new SimpleCharStream(this.input_stream));
            }
            this.lexical_errors.clear();
            this.currentPos = 0;
            this.loop_cnt = 0;
        }
    }

    protected BaseSPARQLLexer(KeywordTable keywordTable) {
        this.keywordTable = keywordTable;
        this.lastToken = -1;
        this.startOffset = 0;
        this.endOffset = -1;
        this.skipComments = false;
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public int lex(LexerToken lexerToken) {
        Token token = null;
        try {
            token = this.tokenManager.getNextToken();
            int n = 3;
        }
        catch (TokenMgrError tokenMgrError) {
            int n;
            this.lastToken = 8;
            int n2 = this.tokenManager.getCurrentTokenAbsolutePosition();
            if (n2 == this.last_token_abs_pos) {
                ++this.loop_cnt;
            }
            if (this.loop_cnt >= 10) {
                this.lastToken = 0;
                this.startOffset = this.currentPos = this.textBuffer.getLength();
                this.endOffset = this.currentPos;
                return this.fillLexerToken(lexerToken);
            }
            this.last_token_abs_pos = n2;
            int n3 = n2 - 1;
            int n4 = n = n2 + this.tokenManager.getInputStream().GetImage().length() - 1;
            this.lexical_errors.add(new SPARQLLexicalError(n3, n4, tokenMgrError.getMessage()));
            this.startOffset = n3;
            this.endOffset = n4;
            return this.fillLexerToken(lexerToken);
        }
        switch (token.kind) {
            case 0: {
                this.lastToken = 0;
                this.startOffset = this.currentPos = this.textBuffer.getLength();
                this.endOffset = this.currentPos;
                break;
            }
            case 127: {
                this.lastToken = 18;
                break;
            }
            case 139: {
                this.lastToken = 33;
                break;
            }
            case 124: 
            case 125: {
                this.lastToken = 33;
                break;
            }
            case 123: 
            case 126: {
                this.lastToken = 123;
                break;
            }
            case 129: 
            case 132: 
            case 135: {
                this.lastToken = 32;
                break;
            }
            case 5: {
                this.lastToken = 5;
                break;
            }
            default: {
                this.lastToken = 16;
            }
        }
        if (this.lastToken != 0) {
            this.startOffset = token.absoluteBeginColumn - 1;
            this.endOffset = token.absoluteEndColumn - 1;
        }
        return this.fillLexerToken(lexerToken);
    }

    public void backup() {
        throw new ParserException("Unsupported operation");
    }

    private int fillLexerToken(LexerToken lexerToken) {
        if (lexerToken == null) {
            return this.lastToken;
        }
        AbstractLexer.DefaultLexerToken defaultLexerToken = (AbstractLexer.DefaultLexerToken)lexerToken;
        defaultLexerToken.setToken(this.lastToken);
        defaultLexerToken.setStartOffset(this.startOffset);
        defaultLexerToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public void setSkipComments(boolean bl) {
        this.skipComments = bl;
    }
}

