/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.actions.LongActionDialog;
import oracle.dbtools.rdfgraph.utils.PLSQLBlockTemplate;

public class BulkLoadFromStagingActionDialog
extends LongActionDialog {
    private String title;
    String uname = "";
    Connection conn;
    SqlComboBoxActionControl txtModelName;
    BooleanCheckBoxActionControl chkCreateModel;
    TextBoxActionControl txtTableOwner;
    SqlComboBoxActionControl txtTableName;
    SpinnerActionControl spinDOP;
    SpinnerActionControl spinMBVParts;
    BooleanCheckBoxActionControl chkDelDups;
    BooleanCheckBoxActionControl chkMBVMethod;
    BooleanCheckBoxActionControl chkParse;
    TextBoxActionControl txtFlags;
    BooleanCheckBoxActionControl chkIdxRebuild;
    BooleanCheckBoxActionControl chkDebug;
    BooleanCheckBoxActionControl chkDebugETAB;
    TextBoxActionControl txtStartComment;
    TextBoxActionControl txtEndComment;

    public void setTitle(String string) {
        this.title = string;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setUname(String string) {
        this.uname = string;
    }

    public String getUname() {
        return this.uname;
    }

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public Connection getConn() {
        return this.conn;
    }

    public BulkLoadFromStagingActionDialog(String string) {
        this.title = string;
    }

    public BulkLoadFromStagingActionDialog() {
        this(RdfgraphArb.getString("BULK_LOAD_MODEL_FROM_STAGING_TABLE"));
    }

    @Override
    protected List<ActionControl> createControls(Connection connection) {
        this.setConn(connection);
        HashMap hashMap = new HashMap();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.uname = dBUtil.executeOracleReturnOneCol(this.getQuery(connection, "getUser"), hashMap);
        String string = "SELECT model_name FROM MDSYS.RDF_MODEL$";
        this.txtModelName = new SqlComboBoxActionControl("model_name", RdfgraphArb.getString("MODEL"), connection, string, "model_name");
        this.txtModelName.enableEditBox();
        this.chkCreateModel = new BooleanCheckBoxActionControl("create_model", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_MODEL"), true);
        this.txtTableOwner = new TextBoxActionControl("table_owner", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_OWNER_"), this.uname);
        String string2 = "SELECT table_name FROM user_tab_cols WHERE column_name = 'RDF$STC_SUB'";
        this.txtTableName = new SqlComboBoxActionControl("table_name", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.STAGING_TABLE_NAME_"), connection, string2);
        this.spinDOP = new SpinnerActionControl("dop", "PARALLEL:", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        this.spinMBVParts = new SpinnerActionControl("mbv_parts", "MBV_PARTITIONS:", Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(512), Integer.valueOf(1));
        this.chkDelDups = new BooleanCheckBoxActionControl("del_dups", "DEL_BATCH_DUPS=USE_INSERT", false);
        this.chkMBVMethod = new BooleanCheckBoxActionControl("mbv_method", "MBV_METHOD=SHADOW", false);
        this.chkParse = new BooleanCheckBoxActionControl("parse", "PARSE=T", true);
        this.chkParse.getUI().setEnabled(false);
        this.txtFlags = new TextBoxActionControl("flags", "Additional flags:", " ");
        this.chkDebugETAB = new BooleanCheckBoxActionControl("create_et_tab", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.CREATE_EVENT_TRACE_TABLE"), false);
        this.chkIdxRebuild = new BooleanCheckBoxActionControl("atabIdxRebuild", "Rebuild application table indexes:", true);
        this.chkDebug = new BooleanCheckBoxActionControl("debug", RdfgraphArb.getString("BulkLoadFromStagingActionDialog.DEBUG_"), false);
        this.txtStartComment = new TextBoxActionControl("start_comment", RdfgraphArb.getString("START_COMMENT_"), "");
        this.txtEndComment = new TextBoxActionControl("end_comment", RdfgraphArb.getString("END_COMMENT_"), "");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(BulkLoadFromStagingActionDialog.this.txtModelName);
                this.add(BulkLoadFromStagingActionDialog.this.chkCreateModel);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableOwner);
                this.add(BulkLoadFromStagingActionDialog.this.txtTableName);
                this.add(BulkLoadFromStagingActionDialog.this.spinDOP);
                this.add(BulkLoadFromStagingActionDialog.this.chkMBVMethod);
                this.add(BulkLoadFromStagingActionDialog.this.chkDelDups);
                this.add(BulkLoadFromStagingActionDialog.this.spinMBVParts);
                this.add(BulkLoadFromStagingActionDialog.this.chkParse);
                this.add(BulkLoadFromStagingActionDialog.this.chkIdxRebuild);
                this.add(BulkLoadFromStagingActionDialog.this.txtFlags);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebugETAB);
                this.add(BulkLoadFromStagingActionDialog.this.chkDebug);
                this.add(BulkLoadFromStagingActionDialog.this.txtStartComment);
                this.add(BulkLoadFromStagingActionDialog.this.txtEndComment);
            }
        };
        return arrayList;
    }

    @Override
    protected String getScript(LongActionDialog.Values values) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = values.get("create_model").equals("true");
        boolean bl2 = values.get("create_et_tab").equals("true");
        boolean bl3 = values.get("atabIdxRebuild").equals("true");
        boolean bl4 = values.get("del_dups").equals("true");
        boolean bl5 = values.get("mbv_method").equals("true");
        boolean bl6 = values.get("parse").equals("true");
        PLSQLBlockTemplate pLSQLBlockTemplate = new PLSQLBlockTemplate(this.getQuery(this.conn, "FULL_SIMPLE_CREATE_SEM_MODEL"));
        pLSQLBlockTemplate.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate.setEndingSlash(true);
        if (bl) {
            stringBuilder.append(pLSQLBlockTemplate.toString());
        }
        PLSQLBlockTemplate pLSQLBlockTemplate2 = new PLSQLBlockTemplate(this.getQuery(this.conn, "CREATE_ET_TAB"));
        if (bl2) {
            stringBuilder.append(pLSQLBlockTemplate2.toString());
        }
        int n2 = Integer.parseInt(values.get("dop"));
        String string = values.get("flags");
        if (n2 > 1) {
            string = string + " PARALLEL=" + n2 + " ";
        }
        if ((n = Integer.parseInt(values.get("mbv_parts"))) > 1) {
            string = string + " MBV_PARTITIONS=" + n + " ";
        }
        if (bl4) {
            string = string + " DEL_BATCH_DUPS=USE_INSERT ";
        }
        if (bl5) {
            string = string + " MBV_METHOD=SHADOW ";
        }
        if (bl6) {
            string = string + " PARSE ";
        }
        PLSQLBlockTemplate pLSQLBlockTemplate3 = new PLSQLBlockTemplate(this.getQuery(this.conn, "APP_TAB_IDX_UNUSABLE"));
        pLSQLBlockTemplate3.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate3.setEndingSlash(true);
        if (bl3) {
            stringBuilder.append(pLSQLBlockTemplate3.toString());
        }
        PLSQLBlockTemplate pLSQLBlockTemplate4 = new PLSQLBlockTemplate(this.getQuery(this.conn, "BULK_LOAD_FROM_STAGING_TABLE"));
        pLSQLBlockTemplate4.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#table_owner#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#table_name#", values.get("table_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#table_owner_raw#", values.get("table_owner"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate4.replaceToken("#table_name_raw#", values.get("table_name"), PLSQLBlockTemplate.ParamType.RAW);
        pLSQLBlockTemplate4.replaceToken("#flags#", string, PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#start_comment#", values.get("start_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.replaceToken("#end_comment#", values.get("end_comment"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate4.setEndingSlash(true);
        stringBuilder.append(pLSQLBlockTemplate4.toString());
        PLSQLBlockTemplate pLSQLBlockTemplate5 = new PLSQLBlockTemplate(this.getQuery(this.conn, "APP_TAB_IDX_REBUILD"));
        pLSQLBlockTemplate5.replaceToken("#model_name#", values.get("model_name"), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate5.replaceToken("#parallel#", Integer.toString(n2), PLSQLBlockTemplate.ParamType.STRING);
        pLSQLBlockTemplate5.setEndingSlash(true);
        if (bl3) {
            stringBuilder.append(pLSQLBlockTemplate5.toString());
        }
        return stringBuilder.toString();
    }
}

