/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.rdfgraph.RdfgraphArb;
import oracle.dbtools.rdfgraph.ui.SearchAndSelectActionControl;
import oracle.dbtools.rdfgraph.ui.SearchShuttleControl;
import oracle.dbtools.rdfgraph.utils.ParamListGenerator;

public class CreateVirtualModelActionDialog
extends ActionDialog {
    private Connection connection;
    private String title;
    SearchShuttleControl srchModels;
    SearchAndSelectActionControl srchRulebases;
    StringShuttleControl shtModels;
    StringShuttleControl shtRulebases;
    private TextBoxActionControl txtVMName;
    private TextBoxActionControl txtOptions;

    public void setTitle(String string) {
        this.title = string;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.setConnection(connection);
        this.txtVMName = new TextBoxActionControl("vm_name", RdfgraphArb.getString("CreateVirtualModelActionDialog.VIRTUAL_MODEL_NAME"), "vm_model");
        this.txtOptions = new TextBoxActionControl("options", RdfgraphArb.getString("OPTIONS"), "REPLACE=T");
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
            {
                this.add(CreateVirtualModelActionDialog.this.txtVMName);
                this.add(CreateVirtualModelActionDialog.this.txtOptions);
            }
        };
        return arrayList;
    }

    protected List<ActionDialogTab> createAdditionalTabs() {
        final ActionDialogTab actionDialogTab = new ActionDialogTab("models_in", RdfgraphArb.getString("MODELS")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        String string = "SELECT model_name from MDSYS.RDF_MODEL$";
                        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("MODEL_NAME")).collect(Collectors.toList());
                        CreateVirtualModelActionDialog.this.shtModels = new StringShuttleControl("models", "", list, Collections.emptyList());
                        this.add(CreateVirtualModelActionDialog.this.shtModels);
                    }
                };
                return arrayList;
            }
        };
        final ActionDialogTab actionDialogTab2 = new ActionDialogTab("rulebases_in", RdfgraphArb.getString("RULEBASES")){

            protected List<ActionControl> createControls(final Connection connection) {
                ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>(){
                    {
                        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                        String string = "SELECT RULEBASE_NAME from MDSYS.SEM_RULEBASE_INFO";
                        List list = dBUtil.executeReturnList(string, Collections.emptyMap()).stream().map(map -> (String)map.get("RULEBASE_NAME")).collect(Collectors.toList());
                        CreateVirtualModelActionDialog.this.shtRulebases = new StringShuttleControl("rulebases", "", list, Collections.emptyList());
                        this.add(CreateVirtualModelActionDialog.this.shtRulebases);
                    }
                };
                return arrayList;
            }
        };
        ArrayList<ActionDialogTab> arrayList = new ArrayList<ActionDialogTab>(){
            {
                this.add(actionDialogTab);
                this.add(actionDialogTab2);
            }
        };
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getQuery(this.connection, "CREATE_VIRTUAL_MODEL");
        string = string.replaceAll("#vm_name#", values.get("vm_name"));
        List list = this.shtModels.getValue().getList("selected");
        List list2 = this.shtRulebases.getValue().getList("selected");
        string = list.size() == 0 ? string.replaceAll("#models#", "null") : string.replaceAll("#models#", ParamListGenerator.genSEM_MODELS(list));
        string = list2.size() == 0 ? string.replaceAll("#rulebases#", "null") : string.replaceAll("#rulebases#", ParamListGenerator.genSEM_RULEBASES(list2));
        string = string.replaceAll("#options#", values.get("options"));
        string = string.replaceAll("#entailments#", "null");
        return string;
    }

    protected String getTitle() {
        return RdfgraphArb.getString("CreateVirtualModelActionDialog.CREATE_VIRTUAL_MODEL");
    }
}

