/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rdfgraph.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.rdfgraph.ui.FileTypeFilter;

public class JFilePicker
extends JPanel {
    private String textFieldLabel;
    private String buttonLabel;
    private JLabel label;
    private JTextField textField;
    private JButton button;
    private JFileChooser fileChooser;
    private int mode;
    public static final int MODE_OPEN = 1;
    public static final int MODE_SAVE = 2;

    public JFilePicker(String string, String string2) {
        this.textFieldLabel = string;
        this.buttonLabel = string2;
        this.fileChooser = new JFileChooser();
        this.setLayout(new FlowLayout(1, 5, 5));
        this.label = new JLabel(string);
        this.textField = new JTextField(30);
        this.button = new JButton(string2);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFilePicker.this.buttonActionPerformed(actionEvent);
            }
        });
        this.add(this.label);
        this.add(this.textField);
        this.add(this.button);
    }

    public void addFileChosenActionListener(ActionListener actionListener) {
        this.fileChooser.addActionListener(actionListener);
    }

    private void buttonActionPerformed(ActionEvent actionEvent) {
        if (this.mode == 1) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (this.mode == 2 && this.fileChooser.showSaveDialog(this) == 0) {
            this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void addFileTypeFilter(String string, String string2) {
        FileTypeFilter fileTypeFilter = new FileTypeFilter(string, string2);
        this.fileChooser.addChoosableFileFilter(fileTypeFilter);
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        this.fileChooser.setAcceptAllFileFilterUsed(bl);
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public String getSelectedFilePath() {
        return this.textField.getText();
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

