/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Map;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerEvent;
import oracle.javatools.util.Filter;
import oracle.jdevimpl.runner.debug.BreakpointMarker;

public class BreakpointMarkerUpdaterFilter
implements Filter<MarkerEvent> {
    public boolean matches(MarkerEvent value) {
        if (null == value) {
            return false;
        }
        switch (value.getEventType()) {
            case MARKERS_ADDED: 
            case MARKERS_REMOVED: {
                return false;
            }
        }
        for (Marker marker : value.getMarkers()) {
            if (!this.matches(marker)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Marker value) {
        if (!(value instanceof BreakpointMarker)) {
            return false;
        }
        Map modifiedAttrs = value.modifiedAttributes();
        if (null == modifiedAttrs) {
            return false;
        }
        return modifiedAttrs.containsKey("offset") || modifiedAttrs.containsKey("line");
    }
}

