/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.dnd.DropTargetListener;
import java.util.EventObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.UpdateableDataWindow;
import oracle.jdevimpl.runner.debug.Utils;

abstract class DataWindow
extends DebuggerWindow
implements UpdateableDataWindow {
    protected String title;
    protected String helpId;
    private Component gui;

    DataWindow(String windowId, String title, String helpId) {
        super(windowId);
        this.title = title;
        this.helpId = helpId;
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        DataPanel dataPanel = this.getDataPanel(false);
        if (dataPanel != null) {
            boolean isShowing = newState == 1;
            dataPanel.setShowing(isShowing);
            if (isShowing) {
                this.everythingChanged();
            }
        }
    }

    protected abstract DataPanel getDataPanel(boolean var1);

    private void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        DataPanel dataPanel = this.getDataPanel(false);
        if (dataPanel != null) {
            dataPanel.debugWindowSettingsChanged(dbgSettings);
        }
    }

    abstract void setUseFilters(boolean var1);

    public Component getGUI() {
        if (this.gui == null) {
            final DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            DataPanel dataPanel = this.getDataPanel(true);
            this.gui = dataPanel.getGUI();
            this.debugWindowSettingsChanged(dbgSettings);
            dataPanel.dataPanelSettingsChanged();
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            dbgSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        DataWindow.this.debugWindowSettingsChanged(dbgSettings);
                    }
                }
            });
        }
        DebuggingProcess adp = JDebugger.getInstance().getActiveDebuggingProcess();
        ((DataController)this.getController()).setVm(adp != null ? adp.getVM() : null);
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo(this.helpId);
    }

    public Controller getController() {
        return this.getDataPanel(true).getController();
    }

    public Context getContext(EventObject event) {
        return this.getDataPanel(true).getController().getContext(event);
    }

    protected DebuggerDataWindowOptions getDebuggerWindowOptions() {
        return this.getDataPanel(true).getController().getDebuggerWindowOptions();
    }

    public int getDefaultVisibility(Layout layout) {
        if (this.getDebuggerWindowOptions() != null && !this.getDebuggerWindowOptions().isInitiallyVisible()) {
            return 0;
        }
        boolean visible = JDebugger.getInstance().canShowDebuggingWindows(layout);
        int ret = visible ? 1 : 0;
        return ret;
    }

    public String getTabName() {
        if (this.getDebuggerWindowOptions() != null) {
            return this.getDebuggerWindowOptions().getTabName();
        }
        return this.title;
    }

    public String getTitleName() {
        if (this.getDebuggerWindowOptions() != null) {
            return this.getDebuggerWindowOptions().getTitleName();
        }
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this.getDataPanel(true).getDropTargetListener();
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public void shutDown() {
        ((DataController)this.getController()).setVm(null);
    }

    void everythingChanged() {
        DataPanel dataPanel = this.getDataPanel(false);
        if (dataPanel != null) {
            dataPanel.getController().everythingChanged();
        }
    }

    @Override
    public void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        DataPanel dataPanel = this.getDataPanel(debuggingProcess != null || vm != null || thread != null || frame != null);
        if (dataPanel != null) {
            dataPanel.updateData(debuggingProcess, vm, thread, frame);
        }
    }

    @Override
    public void clearData() {
        DataPanel dataPanel = this.getDataPanel(false);
        if (dataPanel != null) {
            dataPanel.clearData();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        DataPanel dataPanel = this.getDataPanel(false);
        if (dataPanel != null) {
            dataPanel.processFinished(debuggingProcess);
        }
    }

    public Toolbar getToolbar() {
        return this.getDataPanel(true).getToolbar();
    }
}

