/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.debugger.plugin.tracking.ExecutionEvent;
import oracle.ide.debugger.plugin.tracking.ExecutionEventType;
import oracle.ide.debugger.plugin.tracking.ExecutionListener;
import oracle.ide.debugger.plugin.tracking.ExecutionTrackerForDebuggingProcess;
import oracle.ide.debugger.plugin.tracking.ExecutionTrackingInfo;
import oracle.ide.debugger.plugin.tracking.ExecutionTrackingTrigger;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.runner.DebuggerEvaluator;
import oracle.ide.runner.DebuggerEventSource;
import oracle.javatools.util.Log;
import oracle.jdeveloper.debugger.plugin.tracking.ExecutionTrackerForVirtualMachine;
import oracle.jdeveloper.debugger.plugin.tracking.ExecutionTrackingVM;
import oracle.jdeveloper.debugger.plugin.tracking.VMExecutionEvent;
import oracle.jdeveloper.debugger.plugin.tracking.VMExecutionListener;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.extender.evaluator.CustomDataProvider;
import oracle.jdevimpl.debugger.extender.evaluator.EvaluatorHandle;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class ExecutionTrackerImplForDebuggingProcess
implements ExecutionTrackerForDebuggingProcess,
VMExecutionListener {
    private ExecutionTrackerForVirtualMachine et4vm;
    private DebuggingProcess debuggingProcess;
    private DebuggerEventSource eventSource;
    private List<ExecutionListener> listeners = new ArrayList<ExecutionListener>();
    private boolean isBackgroundSteppingActive = false;
    private CustomDataProvider customDataProvider = new CustomDataProvider();
    private static final Log ETLogger = new Log("ETLogger");

    ExecutionTrackerImplForDebuggingProcess(DebuggingProcess debuggingProcess, DebuggerEventSource eventSource, ExecutionTrackingVM vm) {
        this.debuggingProcess = debuggingProcess;
        this.eventSource = eventSource;
        this.et4vm = vm.getExecutionTracker(true);
        this.et4vm.addVMExecutionListener(this);
        this.listeners = debuggingProcess.getExecutionListeners();
    }

    public void startBackgroundStepping() {
        this.et4vm.startBackgroundStepping();
    }

    public void enableSteppingFromMethodEntry() {
        this.et4vm.enableSteppingFromMethodEntry();
    }

    public void stopBackgroundStepping() {
        this.et4vm.stopBackgroundStepping();
    }

    public void disableSteppingFromMethodEntry() {
        this.et4vm.disableSteppingFromMethodEntry();
    }

    public boolean isSteppingFromMethodEntryEnabled() {
        return this.et4vm.isSteppingFromMethodEntryEnabled();
    }

    public boolean isBackgroundStepping() {
        return this.isBackgroundSteppingActive;
    }

    @Override
    public void vmExecutionEvent(VMExecutionEvent evt) {
        ExecutionTrackingInfo info = evt.getTrackingInfo();
        ExecutionEventType eeType = evt.getExecutionEventType();
        DebugThreadInfo thread = this.debuggingProcess.getCurrentThread();
        String threadName = thread == null ? null : thread.getName();
        switch (eeType) {
            case DEBUGGER_STARTING: 
            case DEBUGGER_FINISHED: 
            case DEBUGGER_STOPPING: 
            case DEBUGGER_RESUMING: 
            case METHOD_ENTERED: 
            case CLASS_REDEFINED: {
                break;
            }
            case BACKGROUND_STEPPING_STARTED: {
                this.isBackgroundSteppingActive = true;
                break;
            }
            case BACKGROUND_STEPPING_STOPPED: 
            case BACKGROUND_STEP_REACHED_BACKSTOP: {
                this.isBackgroundSteppingActive = false;
            }
        }
        EventSource source = new EventSource(this.eventSource, evt.getState());
        ExecutionEvent forwardedEvent = new ExecutionEvent((ExecutionTrackerForDebuggingProcess)this, info, (DebuggerEventSource)source, eeType, threadName);
        this.sendEventToDebuggingProcess(forwardedEvent);
    }

    private void sendEventToDebuggingProcess(ExecutionEvent evt) {
        for (ExecutionListener listener : this.listeners) {
            try {
                listener.executionEvent(evt);
            }
            catch (Throwable t) {
                FeedbackManager.reportException((String)"Exception in ExecutionListener", (Throwable)t);
            }
        }
    }

    public void addTrigger(ExecutionTrackingTrigger trigger) {
        this.et4vm.addTrigger(trigger);
    }

    public void removeTrigger(ExecutionTrackingTrigger trigger) {
        this.et4vm.removeTrigger(trigger);
    }

    public DebuggerEvaluator getEvaluator() {
        EvaluatorProxy evaluator = DebugObjectFactory.create(EvaluatorProxy.class);
        evaluator.setAllowMethodInvocation(true);
        DebugVirtualMachine vm = this.debuggingProcess.getVM();
        DebugThreadInfo thread = this.debuggingProcess.getCurrentThread();
        DebugStackFrameInfo frame = this.debuggingProcess.getCurrentStackFrame();
        evaluator.setDebugContext(vm, thread, frame);
        EvaluatorHandle.EvaluatorHandleVersion12 handle = new EvaluatorHandle(evaluator, this.debuggingProcess, this.customDataProvider).new EvaluatorHandle.EvaluatorHandleVersion12();
        return handle;
    }

    class EventSource
    extends DebuggerEventSource {
        Context context;
        DebuggerEventSource.StackFrame[] stackFrames;
        int languages;
        int state;

        EventSource(DebuggerEventSource copyFrom, int state) {
            this.languages = copyFrom.getLanguages();
            this.stackFrames = copyFrom.getStackFrames();
            this.state = state;
            this.context = copyFrom.getContext();
        }

        public Context getContext() {
            return this.context;
        }

        public int getLanguages() {
            return this.languages;
        }

        public int getState() {
            return this.state;
        }

        public DebuggerEventSource.StackFrame[] getStackFrames() {
            return this.stackFrames;
        }
    }
}

