/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModelAdapter;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;

public class JTreeTableForChangeTracking
extends JFastTreeTable {
    public JTreeTableForChangeTracking(TreeTableModel treeTableModel, DataPanel panel) {
        super(treeTableModel);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        this.tree = new TreeTableCellRenderer(treeTableModel, panel);
        super.setModel((TableModel)new TreeTableModelAdapter(treeTableModel, (JTree)this.tree));
        this.tree.setSelectionModel(tsm);
        this.setDefaultRenderer(TreeTableModel.class, (TableCellRenderer)this.tree);
        this.setDefaultEditor(TreeTableModel.class, (TableCellEditor)new JFastTreeTable.TreeTableCellEditor((JFastTreeTable)this));
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.getRowHeight());
        }
    }

    public void paint(Graphics g) {
        try {
            super.paintUnoptimized(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class TreeTableCellRenderer
    extends JFastTreeTable.TreeTableCellRenderer
    implements TableCellRenderer {
        private final DataPanel dataPanel;

        public TreeTableCellRenderer(TreeTableModel model, DataPanel panel) {
            super((JFastTreeTable)JTreeTableForChangeTracking.this, (TreeModel)model);
            this.dataPanel = panel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DataItem dataItem = this.dataPanel.getDataItemForRow(row);
            if (dataItem instanceof VersionedDataItem && ((VersionedDataItem)dataItem).getChange() == VersionedDataItem.Change.ADDED) {
                this.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
            } else {
                this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            }
            this.setOpaque(true);
            this.table = table;
            this.hasFocus = hasFocus;
            this.isSelected = isSelected;
            this.currentRow = row;
            this.currentColumn = column;
            return this;
        }
    }
}

