/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

public final class LocalsWindowSettingsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private DataPanelSettingsPanel dataPanel = new DataPanelSettingsPanel("Debugger.LocalsWindow");
    private JCheckBox sortVarsByNameCheckBox = new JCheckBox();
    private Map<String, Boolean> sortVarsByNameMap = new HashMap<String, Boolean>();
    private JCheckBox showStaticFolderCheckBox = new JCheckBox();
    private JCheckBox showOutOfScopeVarsCheckBox = new JCheckBox();
    private JLabel spacerLabel = new JLabel();
    private JComboBox vmChooser;
    private JLabel vmChooserLabel;
    private MultiLineLabel disclaimerLabel;
    private transient LocalsWindowSettings settings;
    private JPanel spacer;
    private JPanel optionPanel;
    private String currentVM;

    public LocalsWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_datawindowsettingspanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.sortVarsByNameCheckBox, (String)DbgArb.getString(681));
        ResourceUtils.resButton((AbstractButton)this.showStaticFolderCheckBox, (String)DbgArb.getString(688));
        ResourceUtils.resButton((AbstractButton)this.showOutOfScopeVarsCheckBox, (String)DbgArb.getString(686));
        this.sortVarsByNameCheckBox.addActionListener(this);
        this.spacerLabel.setEnabled(false);
        this.spacer = new JPanel();
        this.optionPanel = new JPanel(new GridBagLayout());
        this.disclaimerLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), DbgArb.format(862, DbgArb.getString(539)));
        this.vmChooser = new JComboBox();
        this.vmChooserLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.vmChooserLabel, (Component)this.vmChooser, (String)DbgArb.getString(861));
    }

    private LocalsWindowSettings getData(TraversableContext tc) {
        return LocalsWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.settings = this.getData(tc);
        DataPanelSettings dpSettings = this.settings.getDataPanelSettings();
        HashStructure hash = dpSettings.getHash();
        this.removeAll();
        this.add((Component)this.disclaimerLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(6, 0, 16, 0), 0, 0));
        this.dataPanel.onEntry(this.settings.getDataPanelSettings());
        this.vmChooser.removeAllItems();
        int y = 1;
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                this.vmChooser.addItem(vmName);
                boolean[] visibilities = new boolean[8];
                for (int j = 0; j < 8; ++j) {
                    visibilities[j] = WindowSettingsColumnManager.getColumnVisible(hash, vmName, j);
                }
                this.sortVarsByNameMap.put(vmName, this.settings.isSortVarsByName(vmName));
            }
            this.vmChooser.setEditable(false);
            if (vmNames.size() > 1) {
                this.add(this.vmChooserLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 8, 8), 0, 0));
                this.add(this.vmChooser, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 8, 0), 0, 0));
            }
            this.add(this.optionPanel, new GridBagConstraints(0, y++, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
            constraints.insets.top = 8;
            constraints.gridy = y;
            ArrayList<JCheckBox> otherCheckBoxes = new ArrayList<JCheckBox>();
            otherCheckBoxes.add(this.showStaticFolderCheckBox);
            otherCheckBoxes.add(this.showOutOfScopeVarsCheckBox);
            this.add(this.dataPanel.makeShowPanel(otherCheckBoxes), constraints);
            ++constraints.gridy;
            this.add(this.dataPanel.makeViewSelectPanel(), constraints);
            ++constraints.gridy;
            constraints.weighty = 1.0;
            this.add(this.spacerLabel, constraints);
            this.vmChooser.addActionListener(this);
            this.vmChooser.setSelectedIndex(0);
        } else {
            this.add(this.spacer, new GridBagConstraints(0, y, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.showStaticFolderCheckBox.setSelected(this.settings.isShowStaticFolder());
        this.showOutOfScopeVarsCheckBox.setSelected(!this.settings.isHideOutOfScopeVars());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        LocalsWindowSettings settings = this.getData(tc);
        this.dataPanel.onExit(settings.getDataPanelSettings());
        for (String vmName : this.sortVarsByNameMap.keySet()) {
            settings.setSortVarsByName(vmName, this.sortVarsByNameMap.get(vmName));
        }
        settings.setShowStaticFolder(this.showStaticFolderCheckBox.isSelected());
        settings.setHideOutOfScopeVars(!this.showOutOfScopeVarsCheckBox.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.vmChooser && this.vmChooser.getSelectedIndex() != -1) {
            this.currentVM = this.vmChooser.getSelectedItem().toString();
            String window = DbgArb.getString(539);
            String title = DbgArb.format(863, window, this.currentVM);
            TitledBorder border = BorderFactory.createTitledBorder(title);
            this.optionPanel.setBorder(border);
            this.optionPanel.removeAll();
            this.optionPanel.add((Component)this.dataPanel.makeChooseColumnsPanel(this.settings.getDataPanelSettings(), this.currentVM, null), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.optionPanel.add((Component)this.dataPanel.makeSortPanel(this.currentVM, this.sortVarsByNameCheckBox), new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.optionPanel.revalidate();
            this.sortVarsByNameCheckBox.setSelected(this.settings.isSortVarsByName(this.currentVM));
        }
        if (e.getSource() == this.sortVarsByNameCheckBox) {
            this.sortVarsByNameMap.put(this.currentVM, this.sortVarsByNameCheckBox.isSelected());
            return;
        }
    }
}

