/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug.streams;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.plugin.StreamDebugger;
import oracle.jdevimpl.debugger.support.DebugDisassembleBytecode;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.streams.ExpressionInfo;
import oracle.jdevimpl.runner.debug.streams.LambdaExpressionInfo;
import oracle.jdevimpl.runner.debug.streams.MethodCallExpressionInfo;
import oracle.jdevimpl.runner.debug.streams.StreamOpTypeEnum;

public class StreamOperationExpressionInfo
extends MethodCallExpressionInfo {
    private StreamOpTypeEnum streamOpType;
    private int invokeBytecodeOffset;
    private int highestBytecodeOffset = 0;

    public void setStreamOpType(StreamOpTypeEnum sop) {
        this.streamOpType = sop;
    }

    public boolean isStreamOperation() {
        return this.streamOpType != StreamOpTypeEnum.NOT_A_STREAM_OP;
    }

    public StreamOpTypeEnum getStreamOpType() {
        return this.streamOpType;
    }

    public int getInvocationOffset() {
        return this.invokeBytecodeOffset;
    }

    public int getHighestOffset() {
        return this.highestBytecodeOffset;
    }

    public int getLambdaArgumentEntryOffset() {
        for (ExpressionInfo methodArgument : this.getArgumentList()) {
            if (!(methodArgument instanceof LambdaExpressionInfo)) continue;
            return ((LambdaExpressionInfo)methodArgument).getHelperMethodEntryOffset();
        }
        return -1;
    }

    public int getLambdaArgumentExitOffset() {
        for (ExpressionInfo methodArgument : this.getArgumentList()) {
            if (!(methodArgument instanceof LambdaExpressionInfo)) continue;
            return ((LambdaExpressionInfo)methodArgument).getHelperMethodExitOffset();
        }
        return -1;
    }

    public String getLambdaArgumentHelperMethodName() {
        for (ExpressionInfo methodArgument : this.getArgumentList()) {
            if (!(methodArgument instanceof LambdaExpressionInfo)) continue;
            return ((LambdaExpressionInfo)methodArgument).getLambdaHelperMethodName();
        }
        return null;
    }

    @Override
    public String toString() {
        return "StreamOperationExpressionInfo: " + this.expressionText + " (line " + this.lineNumber + " source " + this.sourceOffset + ") type " + this.streamOpType.name();
    }

    @Override
    public int attachBytecodes(List<DebugDisassembleBytecode> ddbs, DebugMethodInfo currentMethod) {
        Log logger = StreamDebugger.getLogger();
        this.methodSignature = currentMethod.getName();
        int consumed = 0;
        Iterator<DebugDisassembleBytecode> ddbiter = ddbs.iterator();
        while (ddbiter.hasNext()) {
            DebugDisassembleBytecode ddb = ddbiter.next();
            int offset = ddb.getOffset();
            if (offset > this.highestBytecodeOffset) {
                this.highestBytecodeOffset = offset;
            }
            if (!ddb.getBytecode().startsWith("invokeinterface")) continue;
            this.invokeBytecodeOffset = offset;
            ddbiter.remove();
            ++consumed;
            logger.trace("StreamOperationExpressionInfo.attachBytescodes to " + this.getText() + " consumes " + ddb.getOffset() + " " + ddb.getBytecode());
        }
        return consumed;
    }
}

