/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.ceditor.bookmarks.CodeEditorBookmark;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public final class BookmarkController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        int number = BookmarkConstants.getCmdIDToggleBookmarkNumber((int)action.getCommandId());
        if (action.getCommandId() == BookmarkConstants.TOGGLE_BOOKMARK_CMD_ID || number != -1) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                URL url = context.getNode().getURL();
                int line = ((CodeEditor)view).getCaretLine();
                this.toggleBookmark(url, line, number);
                view.activate();
                return true;
            }
            if (view instanceof CodeEditorGutterView) {
                URL url = context.getNode().getURL();
                int line = CodeEditorGutter.getLineForContext((Context)context);
                this.toggleBookmark(url, line, number);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        int number = BookmarkConstants.getCmdIDToggleBookmarkNumber((int)action.getCommandId());
        if (commandId == BookmarkConstants.TOGGLE_BOOKMARK_CMD_ID || number != -1) {
            CodeEditor codeEditor = null;
            View view = context.getView();
            if (view != null) {
                if (view instanceof CodeEditor) {
                    codeEditor = (CodeEditor)view;
                } else if (view instanceof CodeEditorGutterView) {
                    codeEditor = (CodeEditor)view.owner();
                }
            }
            action.setEnabled(codeEditor != null);
            return true;
        }
        return false;
    }

    private CodeEditorBookmark getBookmark(URL url, int line) {
        Collection bookmarks = BookmarkManager.getBookmarkManager().getAllBookmarks();
        for (Bookmark bookmark : bookmarks) {
            CodeEditorBookmark CodeEditorBookmark2;
            if (!(bookmark instanceof CodeEditorBookmark) || (CodeEditorBookmark2 = (CodeEditorBookmark)bookmark).getLine() != line || !CodeEditorBookmark2.getURL().equals(url)) continue;
            return CodeEditorBookmark2;
        }
        return null;
    }

    private void toggleBookmark(URL url, int line, int number) {
        int existingNumber;
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager();
        CodeEditorBookmark bookmark = this.getBookmark(url, line);
        int n = existingNumber = bookmark == null ? -1 : bookmarkManager.getBookmarkNumber((Bookmark)bookmark);
        if (bookmark != null && (number == -1 || existingNumber == number)) {
            bookmarkManager.removeBookmark((Bookmark)bookmark);
            bookmark = null;
        } else if (bookmark == null) {
            bookmark = new CodeEditorBookmark(url, line);
            bookmarkManager.addBookmark((Bookmark)bookmark);
        }
        if (bookmark != null && number != -1) {
            bookmarkManager.setBookmarkNumber((Bookmark)bookmark, number);
        }
    }
}

