/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteDisplayableListener;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteListener;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteWindow;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteHandler;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerShutdownHook;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteUI;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.model.Item;
import oracle.ideimpl.palette.pageprovider.DeclaredPalette1Pages;
import oracle.ideimpl.palette.wizard.WizardManager;

public class PaletteManagerImpl
extends PaletteManager
implements Controller {
    private PaletteWindowImpl paletteWindow;
    private final PaletteImpl palette = PaletteImpl.getInstance();
    private final HashMap _editorPageMappings = new HashMap();
    private final ArrayList _paletteDisplayableList = new ArrayList();
    private PaletteContext universalContext = null;

    public static PaletteManagerImpl getInstance() {
        return (PaletteManagerImpl)PaletteManager.getPaletteManager();
    }

    public PaletteManagerImpl() {
        this._editorPageMappings.put("jsp", "HTML");
        this._editorPageMappings.put("html", "HTML");
        ExitCommand.addShutdownHook((ShutdownHook)new PaletteManagerShutdownHook());
    }

    void addDeferredPages() {
        ExtensionRegistry extReg = ExtensionRegistry.getOracleRegistry();
        PaletteHandler paletteHandler = (PaletteHandler)extReg.getHook(PaletteHandler.ELEMENT);
        paletteHandler.createPages(this.palette);
    }

    public void initialize() {
    }

    @Override
    public PaletteWindow getPaletteWindow() {
        if (this.paletteWindow == null) {
            this.paletteWindow = PaletteWindowImpl.getInstance();
        }
        return this.paletteWindow;
    }

    @Override
    public Palette getPalette() {
        return this.palette;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == PaletteController.NEW_PALETTE_CMD_ID) {
            PaletteWindowImpl.getInstance().show();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == PaletteController.NEW_PALETTE_CMD_ID) {
            if (PaletteWindowImpl.instanceExists() && PaletteWindowImpl.getInstance().isVisible()) {
                action.setState(true);
            } else {
                action.setState(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerPaletteWizard(String type, Invokable wizard) {
        WizardManager.register(type, wizard);
    }

    @Override
    public boolean showPalettePage(String pageName) {
        PaletteUI ui = (PaletteUI)this.getPaletteWindow().getGUI();
        if (ui != null) {
            return ui.showPalettePage(pageName);
        }
        return false;
    }

    @Override
    public boolean removePage(String pageName) {
        return this.getPalette().removePage(pageName);
    }

    @Override
    public void addPaletteItem(String pageName, String icon, String info, boolean isPersistent, String longLabel, String shortLabel, String type, String editor, String library, String helpable, boolean updatePaletteUI) {
        PalettePage page = this.getPalette().getPalettePage(pageName);
        if (page != null) {
            Item item = PalettePageImpl.createPaletteItem(icon, info, isPersistent, longLabel, shortLabel, type, editor, library);
            item.setHelpable(helpable);
            PaletteItemImpl paletteItem = new PaletteItemImpl(item);
            page.add(paletteItem);
        }
        if (updatePaletteUI) {
            this.updatePaletteUI();
        }
    }

    @Override
    public void removePaletteItem(String pageName, String itemName, boolean updatePaletteUI) {
        PalettePage page = this.getPalette().getPalettePage(pageName);
        if (page != null) {
            page.remove(this.getItemFromPage(itemName, pageName));
        }
        if (updatePaletteUI) {
            this.updatePaletteUI();
        }
    }

    @Override
    public void updatePaletteUI() {
        PaletteController controller = PaletteController.getInstance();
        PaletteUI ui = controller.getPaletteUI();
        if (ui != null) {
            IconPanel panel = ui.getActiveIconPanel();
            if (panel != null) {
                panel.refreshList();
            }
            ui.refreshCombo();
        }
    }

    public PalettePage addPage(String pageName, String showForTypes, String type, boolean canRemove, boolean listView, boolean isPersistent) {
        return this.getPalette().addPage(pageName, showForTypes, type, canRemove, listView, isPersistent);
    }

    @Override
    public PalettePage getPage(String pageName) {
        return this.getPalette().getPalettePage(pageName);
    }

    @Override
    public void setPageAsDefault(String documentSuffix, String palettePage) {
        this._editorPageMappings.put(documentSuffix, palettePage);
        DeclaredPalette1Pages.getInstance().setPageAsDefault(documentSuffix, palettePage);
    }

    public String getPageForDocument(String documentSuffix) {
        if (this._editorPageMappings.containsKey(documentSuffix)) {
            return (String)this._editorPageMappings.get(documentSuffix);
        }
        return null;
    }

    @Override
    public void resetPalette() {
        PaletteController _paletteController = PaletteController.getInstance();
        _paletteController.setStickyMode(false);
        _paletteController.reset();
    }

    @Override
    public final void activateItem(PaletteItem item, boolean stickyMode) {
        PaletteController controller = PaletteController.getInstance();
        Enumeration<AbstractButton> elemEnum = controller.getPaletteUI().getButtonGroup().getElements();
        while (elemEnum.hasMoreElements()) {
            PaletteItemUI b = (PaletteItemUI)elemEnum.nextElement();
            if (b.getItem() == item) {
                if (stickyMode) {
                    b.showStickyMode();
                    continue;
                }
                b.showSelectedMode();
                continue;
            }
            b.showAsUnselected();
        }
    }

    @Override
    public final PaletteItem getItemFromPage(String itemName, String pageName) {
        PaletteItemImpl paletteItem = (PaletteItemImpl)this.palette.getPaletteItem(itemName, pageName);
        return paletteItem;
    }

    @Override
    public void markDirty(boolean dirty) {
        this.palette.setDirty(dirty);
    }

    @Override
    public void syncPalette(Context context) {
        if (this.getPaletteWindow() != null) {
            if (context != null) {
                ((PaletteWindowImpl)this.getPaletteWindow())._syncPalette(context);
            } else {
                ((PaletteWindowImpl)this.getPaletteWindow())._syncPalette();
            }
        }
    }

    @Override
    public void addPaletteListener(PaletteListener listener) {
        this.getPaletteWindow().addPaletteListener(listener);
    }

    @Override
    public void removePaletteListener(PaletteListener listener) {
        this.getPaletteWindow().removePaletteListener(listener);
    }

    public void setUniversalContext(PaletteContext universalContext) {
        this.universalContext = universalContext;
    }

    public PaletteContext getUniversalContext() {
        return this.universalContext;
    }

    @Override
    public void addPaletteDisplayableListener(PaletteDisplayableListener listener) {
        this._paletteDisplayableList.add(listener);
    }

    @Override
    public void removePaletteDisplayableListener(PaletteDisplayableListener listener) {
        this._paletteDisplayableList.remove(listener);
    }

    protected Iterator getPaletteDisplayables() {
        return this._paletteDisplayableList.iterator();
    }

    @Override
    public Iterator getPalettePagesByType(String type) {
        ArrayList<PalettePage> list = new ArrayList<PalettePage>();
        Iterator iter = this.getPalette().getChildren();
        while (iter.hasNext()) {
            PalettePage page = (PalettePage)iter.next();
            if (!ModelUtil.areEqual((Object)page.getType(), (Object)type)) continue;
            list.add(page);
        }
        return list.iterator();
    }

    @Override
    public void refreshPalette() {
        PaletteController.getInstance().refreshPalette();
    }

    @Override
    public void refreshPaletteUI() {
        PaletteController.getInstance().refreshPaletteUI();
    }

    @Override
    public PalettePage addPage(String pageName, String showForTypes, String type, boolean canRemove, boolean listView, boolean isPersistent, boolean palette1Only) {
        return this.palette.addPage(pageName, showForTypes, type, canRemove, listView, isPersistent, palette1Only);
    }
}

