/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.bali.xml.model.ServiceProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class DomModelContext
implements ServiceProvider {
    private final CopyOnWriteArrayList<ServiceProvider> _serviceProviders = new CopyOnWriteArrayList();
    private final ConcurrentHashMap _serviceCache = new ConcurrentHashMap(5);
    private static final Object _NO_SERVICE = new Object();

    public abstract String getTranslatedString(String var1);

    public abstract Locale getLocale();

    public abstract Node remapNode(Document var1, Node var2);

    @Override
    public final Object getService(Object selector) {
        Object service = this._serviceCache.get(selector);
        if (service == null) {
            service = this.getServiceImpl(selector);
            if (service == null) {
                service = _NO_SERVICE;
            }
            this._serviceCache.put(selector, service);
        }
        if (service == _NO_SERVICE) {
            return null;
        }
        return service;
    }

    public final void registerServiceProvider(ServiceProvider provider) {
        this._serviceProviders.add(provider);
    }

    protected Object getServiceImpl(Object selector) {
        for (ServiceProvider provider : this._serviceProviders) {
            Object service = provider.getService(selector);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    protected void flushPendingEvents() {
    }
}

