/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.textsync;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.buffer.textsync.BufferChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.javatools.buffer.TextBuffer;

public class InsertBufferChange
extends BufferChange {
    private final int _start;
    private final String _text;
    private static final Logger _LOGGER = Logger.getLogger(InsertBufferChange.class.getName());

    public InsertBufferChange(DomChange domChange, int start, String text) {
        super(domChange);
        this._start = start;
        this._text = text;
    }

    @Override
    public void apply(TextBuffer buffer) {
        int textLen = this._text.length();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Insert {0} chars [{1}] at {2}", new Object[]{String.valueOf(textLen), this._text, String.valueOf(this._start)});
        }
        int bufferSizeBefore = buffer.getLength();
        buffer.insert(this._start, this._text.toCharArray());
        int bufferSizeAfter = buffer.getLength();
        int bufferSizeChange = bufferSizeAfter - bufferSizeBefore;
        if (bufferSizeChange != textLen) {
            _LOGGER.log(Level.SEVERE, "Insertion did not change buffer length as expected! Locators are probably off. textLen={0} bufferSizeChange={1} text=[{2}]", new Object[]{String.valueOf(textLen), String.valueOf(bufferSizeChange), this._text});
        }
    }

    @Override
    public int getInsertionLength() {
        return this._text.length();
    }
}

