/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.view.proxy;

import oracle.bali.xml.dom.util.DummyNode;
import oracle.bali.xml.dom.view.proxy.ViewNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ContainerViewNode
extends ViewNode {
    private Node _firstChild;
    private Node _lastChild;
    private int _childCount;
    private DeferredNodeList _nodeList;

    ContainerViewNode(Node proxiedNode) {
        super(proxiedNode);
        this.invalidateChildInfo();
    }

    @Override
    protected void invalidateChildInfo() {
        this._firstChild = DummyNode.INSTANCE;
        this._lastChild = DummyNode.INSTANCE;
        this._childCount = -1;
        this._nodeList = null;
    }

    @Override
    public NodeList getChildNodes() {
        if (this._nodeList == null) {
            this._nodeList = new DeferredNodeList();
        }
        return this._nodeList;
    }

    @Override
    public Node getFirstChild() {
        if (this._firstChild == DummyNode.INSTANCE) {
            this._firstChild = this.getViewDocument().calculateFirstChild(this);
        }
        return this._firstChild;
    }

    @Override
    public Node getLastChild() {
        if (this._lastChild == DummyNode.INSTANCE) {
            this._lastChild = this.getViewDocument().calculateLastChild(this);
        }
        return this._lastChild;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.getProxiedNode().cloneNode(deep);
    }

    private int _getChildCount() {
        if (this._childCount == -1) {
            int childCount = 0;
            for (Node currNode = this.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
                ++childCount;
            }
            this._childCount = childCount;
        }
        return this._childCount;
    }

    private Node _getChildAt(int index) {
        Node currNode;
        if (index < 0) {
            return null;
        }
        for (currNode = this.getFirstChild(); currNode != null && index > 0; currNode = currNode.getNextSibling(), --index) {
        }
        return currNode;
    }

    private class DeferredNodeList
    implements NodeList {
        private DeferredNodeList() {
        }

        @Override
        public Node item(int index) {
            return ContainerViewNode.this._getChildAt(index);
        }

        @Override
        public int getLength() {
            return ContainerViewNode.this._getChildCount();
        }
    }
}

