/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.datatransfer.operation.DataAndPositions;
import oracle.bali.xml.model.datatransfer.operation.Operation;
import oracle.bali.xml.model.datatransfer.operation.OperationManager;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.RefCounter;
import oracle.bali.xml.share.TransactionToken;
import oracle.bali.xml.share.UnmodifiableIterator;
import oracle.javatools.datatransfer.ExtendedTransferable;
import oracle.javatools.logging.LogUtils;

public class OperationProcessor {
    public static final int SHOW_ALL_OPERATIONS = -1;
    private TransactionOptions _transOptions;
    private ExtendedTransferable _transferable = null;
    private int _actionMask = -1;
    private boolean _editable = true;
    private AbstractModel _targetModel = null;
    private transient List _potentialOps = null;
    private transient Map _currentInfo = null;
    private final Map _locationsToInfoCache = new HashMap();
    private static final Logger _LOGGER = Logger.getLogger(OperationProcessor.class.getName());
    private static final Map _OPERATING_WAS_REJECTED = new AbstractMap(){

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }
    };
    private static final Comparator _BY_RANK_COMPARATOR = new Comparator(){

        public int compare(Object a, Object b) {
            Operation opA = (Operation)a;
            Operation opB = (Operation)b;
            float rankDiff = opB.getSuitabilityRank() - opA.getSuitabilityRank();
            if (rankDiff < 0.0f) {
                return -1;
            }
            if (rankDiff > 0.0f) {
                return 1;
            }
            if (opA.equals(opB)) {
                return 0;
            }
            return opA.hashCode() - opB.hashCode();
        }
    };

    public OperationProcessor(AbstractModel targetModel) {
        this._targetModel = targetModel;
    }

    public void setTransferable(ExtendedTransferable transferable) {
        if (transferable != this._transferable) {
            this._transferable = transferable;
            this._clearCaches();
        }
    }

    public void setTargetModel(AbstractModel targetModel) {
        if (this._targetModel != targetModel) {
            this._targetModel = targetModel;
            this._clearCaches();
        }
    }

    public void setActionMask(int actionMask) {
        if (actionMask != this._actionMask) {
            this._actionMask = actionMask;
            this._clearCaches();
        }
    }

    public void setEditable(boolean editable) {
        if (editable != this._editable) {
            this._editable = editable;
            this._clearCaches();
        }
    }

    public void update(List positions) {
        Map info = (Map)this._locationsToInfoCache.get(positions);
        if (info == null) {
            this._targetModel.acquireReadLock();
            try {
                info = this._computeInfo(positions);
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "Computed info for {0}: {1}", new Object[]{positions, info});
                }
            }
            finally {
                this._targetModel.releaseReadLock();
            }
            positions = new ArrayList(positions);
            this._locationsToInfoCache.put(positions, info);
        }
        if (info != this._currentInfo) {
            this._currentInfo = info;
        }
    }

    public boolean hasSupportedOperation() {
        return this._currentInfo != null && !this._currentInfo.isEmpty();
    }

    public DomPosition getRepresentativeOperationPosition() {
        if (this._currentInfo != null) {
            RefCounter counter = new RefCounter();
            for (List dapList : this._currentInfo.values()) {
                for (DataAndPositions dataAndPos : dapList) {
                    counter.addCount(dataAndPos.getPositions().get(0));
                }
            }
            return (DomPosition)counter.getMaxValue();
        }
        return null;
    }

    public Iterator getSupportedOperations() {
        if (this._currentInfo != null) {
            return new UnmodifiableIterator(this._currentInfo.keySet().iterator());
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List getListOfDataAndPositions(Operation operation) {
        if (this._currentInfo != null) {
            return (List)this._currentInfo.get(operation);
        }
        return null;
    }

    public boolean wasExplicitlyRejected() {
        return this._currentInfo != null && this._currentInfo == _OPERATING_WAS_REJECTED;
    }

    public boolean forceSimpleApplyWithoutTokenDispatch(TransactionToken token) throws XmlCommitException, IOException {
        if (token == null) {
            throw new IllegalArgumentException("token must be non-null");
        }
        return this._forceSimpleApplyImpl(token, null, null);
    }

    public final boolean forceSimpleApply(TransactionToken token) throws XmlCommitException, IOException {
        return this.forceSimpleApply(token, null);
    }

    public final boolean forceSimpleApply(TransactionToken token, String txnName) throws XmlCommitException, IOException {
        return this.forceSimpleApply(token, txnName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceSimpleApply(TransactionToken token, String txnName, TransactionOptions transOptions) throws XmlCommitException, IOException {
        if (this._targetModel.getBaseModel().isInTransaction()) {
            throw new IllegalStateException("model is in transaction!");
        }
        if (!this.hasSupportedOperation()) {
            throw new IllegalStateException("! hasSupportedOperation()");
        }
        if (token == null && (token = this._targetModel.getContext().createTransactionToken()) != null) {
            token.setOwnerIfUnset(this);
        }
        boolean applySuccess = false;
        try {
            applySuccess = this._forceSimpleApplyImpl(token, txnName, transOptions);
        }
        finally {
            TransactionToken.dispatch(token, this, applySuccess);
        }
        return applySuccess;
    }

    public boolean hasMoreThanOneOperationWithHighestRank() {
        Iterator itor = this.getSupportedOperations();
        if (!itor.hasNext()) {
            return false;
        }
        Operation firstOp = (Operation)itor.next();
        if (itor.hasNext()) {
            Operation nextOp = (Operation)itor.next();
            if (firstOp.getSuitabilityRank() == nextOp.getSuitabilityRank()) {
                return true;
            }
        }
        return false;
    }

    private boolean _forceSimpleApplyImpl(final TransactionToken token, String txnName, final TransactionOptions transOptions) throws XmlCommitException, IOException {
        boolean ok;
        final Operation op = (Operation)this.getSupportedOperations().next();
        List listOfDap = this.getListOfDataAndPositions(op);
        final DataAndPositions dap = (DataAndPositions)listOfDap.get(0);
        final DomPosition pos = (DomPosition)dap.getPositions().iterator().next();
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Calling op {0}, data {1}, pos {2} in forceSimplyApply", new Object[]{op, dap.getData(), pos});
        }
        if (txnName == null) {
            ok = this._apply(token, op, dap, pos);
        } else {
            final Object[] holder = new Object[1];
            new FixedNameTransactionTask(txnName){

                @Override
                protected TransactionOptions getTransactionOptions(String txnName) {
                    if (transOptions != null) {
                        return transOptions;
                    }
                    return super.getTransactionOptions(txnName);
                }

                @Override
                protected void performTask(AbstractModel ignored) throws XmlCommitException {
                    try {
                        boolean innerOK = OperationProcessor.this._apply(token, op, dap, pos);
                        holder[0] = innerOK;
                    }
                    catch (IOException e) {
                        holder[0] = e;
                    }
                }
            }.runThrowingXCE(this._targetModel);
            if (holder[0] instanceof IOException) {
                throw (IOException)holder[0];
            }
            ok = (Boolean)holder[0];
        }
        if (ok) {
            _LOGGER.finer("last apply succeeded");
        } else {
            _LOGGER.finer("last apply returned false");
        }
        return ok;
    }

    private boolean _apply(TransactionToken token, Operation op, DataAndPositions dap, DomPosition pos) throws IOException, XmlCommitException {
        return op.apply(this._targetModel, pos, dap.getData(), token);
    }

    private Map _computeInfo(List positions) {
        float highestRankOpThatRejected = Float.MIN_VALUE;
        TreeMap<Operation, List> opsMap = null;
        for (Operation operation : this._getPotentialOperations()) {
            boolean considerOp;
            if (!this._editable && operation.doesActionMutateModel() || !(considerOp = this._actionMask == -1 || (this._actionMask & operation.getSupportedActions()) > 0)) continue;
            try {
                List list = operation.getApplicableDataAndPositions(this._targetModel, positions, this._transferable);
                if (list.isEmpty()) continue;
                if (opsMap == null) {
                    opsMap = new TreeMap<Operation, List>(_BY_RANK_COMPARATOR);
                }
                opsMap.put(operation, list);
            }
            catch (Operation.RejectOperatingAndDontQueryLowerRankedOps rejected) {
                highestRankOpThatRejected = Math.max(highestRankOpThatRejected, operation.getSuitabilityRank());
            }
            catch (Exception e) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception querying operation {0}", (Object)operation, (Throwable)e);
            }
        }
        if (opsMap == null || opsMap.isEmpty()) {
            if (highestRankOpThatRejected > Float.MIN_VALUE) {
                return _OPERATING_WAS_REJECTED;
            }
            return Collections.EMPTY_MAP;
        }
        Operation highestRankInMap = (Operation)opsMap.firstKey();
        if (highestRankInMap.getSuitabilityRank() < highestRankOpThatRejected) {
            return _OPERATING_WAS_REJECTED;
        }
        return opsMap;
    }

    private List _getPotentialOperations() {
        if (this._potentialOps == null) {
            if (this._transferable == null) {
                return Collections.EMPTY_LIST;
            }
            OperationManager manager = this._targetModel.getContext().getOperationManager();
            this._potentialOps = manager.createApplicableOperations(this._transferable);
        }
        return this._potentialOps;
    }

    private void _clearCaches() {
        _LOGGER.finer("clearing caches");
        this._potentialOps = null;
        this._currentInfo = null;
        this._locationsToInfoCache.clear();
    }
}

