/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.id.Scope;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IdGenerationContext {
    private final XmlModel _model;
    private final NodeChangeDetails _details;
    private final Map<Scope, Set<String>> _idSetMap = new HashMap<Scope, Set<String>>();
    private final Set<Scope> _knownScopeSet = new LinkedHashSet<Scope>();
    private final Map<Object, Object> _contextPropertyMap = new HashMap<Object, Object>();
    private Set<Element> _elementsInNewSubtrees = null;

    public IdGenerationContext(XmlModel model, NodeChangeDetails details) {
        if (model == null || details == null) {
            throw new IllegalArgumentException("Null argument passed to constructor");
        }
        this._model = model;
        this._details = details;
    }

    public XmlModel getModel() {
        return this._model;
    }

    public NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    public Set<Element> getElementsInNewSubtrees() {
        if (this._elementsInNewSubtrees == null) {
            this._elementsInNewSubtrees = this._getElementsInNewSubtrees();
        }
        return this._elementsInNewSubtrees;
    }

    public boolean recordKnownScope(Scope scope) {
        return this._knownScopeSet.add(scope);
    }

    public void recordUsedId(Scope scope, String usedId) {
        if (scope == null) {
            throw new IllegalArgumentException("Required scope argument was null");
        }
        if (usedId == null) {
            throw new IllegalArgumentException("Required usedId argument was null");
        }
        this._getOrCreateIdSet(scope).add(usedId);
    }

    public void recordUsedIds(Scope scope, Set<String> usedIds) {
        if (scope == null) {
            throw new IllegalArgumentException("Required scope argument was null");
        }
        if (usedIds == null) {
            throw new IllegalArgumentException("Required usedIds argument was null");
        }
        this._getOrCreateIdSet(scope).addAll(usedIds);
    }

    public boolean isUsedInScope(Scope scope, String idToTest) {
        if (scope == null) {
            throw new IllegalArgumentException("Required scope argument was null");
        }
        if (idToTest == null) {
            throw new IllegalArgumentException("Required idToTest argument was null");
        }
        return this._getOrCreateIdSet(scope).contains(idToTest);
    }

    public Object getProperty(Object key) {
        return this._contextPropertyMap.get(key);
    }

    public void putProperty(Object key, Object value) {
        this._contextPropertyMap.put(key, value);
    }

    private Set<String> _getOrCreateIdSet(Scope scope) {
        Set<String> idSet = this._idSetMap.get(scope);
        if (idSet == null) {
            idSet = new HashSet<String>();
            this._idSetMap.put(scope, idSet);
        }
        return idSet;
    }

    private Set<Element> _getElementsInNewSubtrees() {
        Set<Element> newElements = Collections.emptySet();
        NodeChangeDetails details = this.getNodeChangeDetails();
        if (details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            Set addedNodes = details.getAddedNodes();
            Set removedNodes = details.getRemovedNodes();
            if (!addedNodes.isEmpty()) {
                newElements = new LinkedHashSet<Element>(addedNodes.size());
                for (Node added : addedNodes) {
                    if (!DomUtils.isElement((Node)added)) continue;
                    boolean isCloneOfRemovedElement = false;
                    for (Node removed : removedNodes) {
                        if (!removed.isEqualNode(added)) continue;
                        isCloneOfRemovedElement = true;
                        break;
                    }
                    if (isCloneOfRemovedElement) continue;
                    Set nodesInNewSubtree = DomUtils.getNodesInSubtree((TreeTraversal)this.getModel().getTreeTraversal(), (Node)added);
                    for (Node nodeInNewSubtree : nodesInNewSubtree) {
                        if (!DomUtils.isElement((Node)nodeInNewSubtree)) continue;
                        newElements.add((Element)nodeInNewSubtree);
                    }
                }
            }
        }
        return newElements;
    }
}

