/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.message;

import java.util.logging.Level;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.SimpleMessage;
import oracle.bali.xml.model.message.SimpleXmlModelMessageIssueList;
import oracle.bali.xml.model.message.ValidationExceptionMessage;
import oracle.bali.xml.model.message.XmlModelMessage;
import oracle.bali.xml.validator.ValidationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationHandler
extends SimpleXmlModelMessageIssueList
implements ErrorHandler {
    private final MessageCategory _category;
    private final XmlModel _model;

    public ValidationHandler(XmlModel model, MessageCategory category) {
        this._model = model;
        this._category = category;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        Level level = XmlModelMessage.WARNING;
        if (this._isWarningActuallyInfo(exception)) {
            level = XmlModelMessage.INFO;
        }
        this._create(exception, level);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this._create(exception, XmlModelMessage.ERROR);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this._create(exception, XmlModelMessage.ERROR);
    }

    private boolean _isWarningActuallyInfo(SAXParseException exception) {
        ValidationException valEx;
        int exType;
        return exception instanceof ValidationException && (exType = (valEx = (ValidationException)exception).getType()) == 11;
    }

    private void _create(SAXParseException exception, Level level) {
        XmlModelMessage msg = exception instanceof ValidationException ? new ValidationExceptionMessage(this._model, (ValidationException)exception, level) : new SimpleMessage(this._model, this._category, level, exception.getLocalizedMessage(), exception);
        this.addMessage(msg);
    }
}

