/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.preference;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import oracle.bali.xml.preference.Preference;
import oracle.bali.xml.preference.PreferenceChangeEvent;
import oracle.bali.xml.share.SafePropertyChangeSupport;

public class XmlPreferenceManager {
    private transient SafePropertyChangeSupport _propSupport;
    private HashMap _preferenceMap;
    private String _preferenceManagerName;

    public XmlPreferenceManager() {
    }

    public XmlPreferenceManager(String preferenceManagerName) {
        this(preferenceManagerName, null, null);
    }

    private XmlPreferenceManager(String preferenceManagerName, HashMap preferenceMap, SafePropertyChangeSupport propSupport) {
        this._preferenceManagerName = preferenceManagerName;
        this._preferenceMap = preferenceMap;
        if (propSupport == null) {
            propSupport = new SafePropertyChangeSupport(this);
        }
        this._propSupport = propSupport;
    }

    public XmlPreferenceManager copy() {
        return new XmlPreferenceManager(this.getPreferenceManagerName(), (HashMap)this.getPreferences().clone(), this._propSupport);
    }

    public void storePreferenceManagerToMemory() {
    }

    public void storePreferenceManagerToDisk() {
        this.storePreferenceManagerToMemory();
    }

    public Object getPreferenceValue(Preference preference) {
        Object value = this.getPreferences().get(preference.getName());
        if (value == null) {
            value = preference.getDefaultValue();
        }
        return value;
    }

    public void setPreferenceValue(Preference preference, Object value) {
        Object oldValue = this.getPreferenceValue(preference);
        if (!oldValue.equals(value)) {
            this.getPreferences().put(preference.getName(), value);
            if (this._propSupport != null) {
                this._propSupport.firePropertyChange(new PreferenceChangeEvent(preference, oldValue, value));
            }
        }
    }

    public void addPreferenceChangeListener(PropertyChangeListener listener) {
        if (this._propSupport == null) {
            this._propSupport = new SafePropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(listener);
        this.storePreferenceManagerToMemory();
    }

    public void removePreferenceChangeListener(PropertyChangeListener listener) {
        if (this._propSupport != null) {
            this._propSupport.removePropertyChangeListener(listener);
        }
        this.storePreferenceManagerToMemory();
    }

    public HashMap getPreferences() {
        if (this._preferenceMap == null) {
            this._preferenceMap = new HashMap();
        }
        return this._preferenceMap;
    }

    public void setPreferences(HashMap preferenceMap) {
        this._preferenceMap = preferenceMap;
    }

    public String getPreferenceManagerName() {
        return this._preferenceManagerName;
    }

    public void setPreferenceManagerName(String preferenceManagerName) {
        this._preferenceManagerName = preferenceManagerName;
    }

    protected SafePropertyChangeSupport getPropertyChangeSupport() {
        return this._propSupport;
    }

    protected void setPropertyChangeSupport(SafePropertyChangeSupport propSupport) {
        this._propSupport = propSupport;
    }
}

