/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.lbs.mapclient.GeoFeature;
import oracle.lbs.mapclient.MapDefinition;
import oracle.lbs.mapclient.MapViewer;
import oracle.lbs.mapclient.ScaleBarDef;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.lbs.mapclient.ThemeIdentify;
import oracle.lbs.mapcommon.MapResponse;
import oracle.mapviewer.share.ArrayParameter;
import oracle.mapviewer.share.NorthArrow;
import oracle.mapviewer.share.RenderingRule;
import oracle.mapviewer.share.ext.NsDpInfo;

public class ClientMapRequest
implements Serializable {
    static final long serialVersionUID = 133933289466235682L;
    static final int DEFAULT_MAP_WIDTH = 500;
    static final int DEFAULT_MAP_HEIGHT = 375;
    MapDefinition mapDef = null;
    GeoFeature center = null;
    double size = 0.0;
    long mapScale = Long.MAX_VALUE;
    Dimension deviceSize = new Dimension(500, 375);
    Color backgroundColor = new Color(166, 202, 240);
    String bgImageURL = null;
    boolean antiAliase = false;
    boolean verbose = false;
    boolean imageScaling = true;
    String defCenterStyleName = null;
    String defCenterLabelStyleName = null;
    String defCenterLabel = null;
    double[] defCenterRadii = null;
    double[] queryWindow = null;
    int imageFormat = 9;
    String srs = null;
    GeoFeature[] geoFeatures;
    String mapLegend = null;
    boolean isBgTransparent = false;
    ThemeIdentify themeIdentify = null;
    int SRid = 0;
    String mapFileName = null;
    Hashtable dynamicStyles = null;
    private double svgZoomRatio = 1.0;
    private boolean showSVGNavBar = true;
    private int svgZoomLevels = 4;
    private double svgZoomFactor = 2.0;
    private boolean svgShowInfo = true;
    private String onClick = null;
    private String onMouseMove = null;
    private boolean renderRasterBaseMap = false;
    private String onRectangleSelect = null;
    private String onPolygonSelect = null;
    private int svgFragmentType = -1;
    private boolean svgFragmentInDeviceCoord = true;
    private boolean snapToCachedZoomLevel = false;
    private boolean useCachedBaseMap = false;
    private boolean wrapAround = false;
    String[] boundingThemes = null;
    float boundingThemeBorderMargin = 0.05f;
    boolean boundingThemeKeepAspectRatio = true;
    double boundingSizeHint = 0.0;
    ScaleBarDef scaleBar = null;
    Hashtable customProp = null;
    boolean keepThemesOrder = false;
    Vector nsdps = null;
    Hashtable themeModifiers = new Hashtable(3);
    int boundsSrid = 0;
    String svgInfoFont = null;
    boolean disableMapPieces = false;
    String footnote = null;
    String titleStyle = null;
    String footnoteStyle = null;
    boolean isTileRequest = false;
    private double rotation = 0.0;
    private NorthArrow northArrow = null;
    private boolean preserveBoxAspect = false;
    private String deviceSizeUnit = null;
    private int dpi = 0;

    public ClientMapRequest() {
        this.dynamicStyles = new Hashtable(17);
    }

    public void setCenterAndSize(double d, double d2, double d3) {
        this.center = new GeoFeature(d, d2);
        this.size = d3;
        this.queryWindow = null;
        this.boundsSrid = 0;
        this.mapScale = Long.MAX_VALUE;
    }

    public void setCenterAndSizeWithSrid(double d, double d2, double d3, int n) {
        this.setCenterAndSize(d, d2, d3);
        this.boundsSrid = n;
    }

    public void setCenterAndScale(double d, double d2, long l) {
        this.center = new GeoFeature(d, d2);
        this.size = 0.0;
        this.queryWindow = null;
        this.boundsSrid = 0;
        this.mapScale = Math.abs(l);
    }

    public void setCenterAndScaleWithSrid(double d, double d2, long l, int n) {
        this.setCenterAndScale(d, d2, l);
        this.boundsSrid = n;
    }

    public void setCenter(GeoFeature geoFeature) {
        this.center = geoFeature;
        this.queryWindow = null;
        this.boundsSrid = 0;
    }

    public void setCenter(double d, double d2) {
        this.center = new GeoFeature(d, d2);
        this.queryWindow = null;
        this.boundsSrid = 0;
    }

    public void setSize(double d) {
        this.size = d;
        this.mapScale = Long.MAX_VALUE;
        this.queryWindow = null;
    }

    public void setScale(long l) {
        this.size = 0.0;
        this.mapScale = Math.abs(l);
        this.queryWindow = null;
    }

    public GeoFeature getCenter() {
        return this.center;
    }

    public void setBox(double d, double d2, double d3, double d4) {
        if (this.queryWindow == null) {
            this.queryWindow = new double[4];
        }
        this.queryWindow[0] = d;
        this.queryWindow[1] = d2;
        this.queryWindow[2] = d3;
        this.queryWindow[3] = d4;
        this.center = null;
        this.size = d4 - d2;
        this.boundsSrid = 0;
        this.mapScale = Long.MAX_VALUE;
    }

    public void setBox(double[] dArray) {
        this.queryWindow = dArray;
        this.center = null;
        if (dArray != null) {
            this.size = dArray[3] - dArray[1];
        }
        this.boundsSrid = 0;
        this.mapScale = Long.MAX_VALUE;
    }

    public void setBoxWithSrid(double d, double d2, double d3, double d4, int n) {
        this.setBox(d, d2, d3, d4);
        this.boundsSrid = n;
    }

    public void setBox(double d, double d2, double d3, double d4, int n, boolean bl) {
        this.setBoxWithSrid(d, d2, d3, d4, n);
        this.preserveBoxAspect = bl;
    }

    public double[] getBox() {
        return this.queryWindow;
    }

    public boolean preserveBoxAspectRatio() {
        return this.preserveBoxAspect;
    }

    public double getSize() {
        return this.size;
    }

    public double getScale() {
        return this.mapScale;
    }

    public void setDefaultCenterRenderStyleName(String string) {
        this.defCenterStyleName = string;
    }

    public String getDefaultCenterRenderStyleName() {
        return this.defCenterStyleName;
    }

    public void setDefaultCenterLabelStyleName(String string) {
        this.defCenterLabelStyleName = string;
    }

    public String getDefaultCenterLabelStyleName() {
        return this.defCenterLabelStyleName;
    }

    public void setDefaultCenterLabel(String string) {
        this.defCenterLabel = string;
    }

    public String getDefaultCenterLabel() {
        return this.defCenterLabel;
    }

    public void setDefaultCenterRadii(double[] dArray) {
        this.defCenterRadii = dArray;
    }

    public double[] getDefaultCenterRadii() {
        return this.defCenterRadii;
    }

    public void setMapDefinition(MapDefinition mapDefinition) {
        this.mapDef = mapDefinition;
    }

    public MapDefinition getMapDefinition() {
        return this.mapDef;
    }

    public boolean isBgTransparent() {
        return this.isBgTransparent;
    }

    public void setBgTransparent(boolean bl) {
        this.isBgTransparent = bl;
    }

    public void setDeviceSize(Dimension dimension) {
        this.deviceSize = dimension;
    }

    public Dimension getDeviceSize() {
        return this.deviceSize;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundImageURL(String string) {
        this.bgImageURL = string;
    }

    public String getBackgroundImageURL() {
        return this.bgImageURL;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliase = bl;
    }

    public boolean getAntiAliasing() {
        return this.antiAliase;
    }

    public void setImageScaling(boolean bl) {
        this.imageScaling = bl;
    }

    public boolean getImageScaling() {
        return this.imageScaling;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setImageFormat(int n) {
        this.imageFormat = n;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public String getTitle() {
        if (this.mapDef != null) {
            return this.mapDef.getTitle();
        }
        return null;
    }

    public void setTitle(String string) {
        this.mapDef.setTitle(string);
    }

    public String getTitleStyleName() {
        return this.titleStyle;
    }

    public void setTitleStyleName(String string) {
        this.titleStyle = string;
    }

    public String getBaseMap() {
        if (this.mapDef != null) {
            return this.mapDef.getBaseMap();
        }
        return null;
    }

    public String getMapDataSource() {
        if (this.mapDef != null) {
            return this.mapDef.getMapDataSource();
        }
        return null;
    }

    public boolean getWrapAround() {
        if (this.mapDef != null) {
            return this.mapDef.getWrapAround();
        }
        return false;
    }

    public void setGeoFeatures(GeoFeature[] geoFeatureArray) {
        this.geoFeatures = geoFeatureArray;
    }

    public GeoFeature[] getGeoFeatures() {
        return this.geoFeatures;
    }

    public ThemeIdentify getThemeIdentify() {
        return this.themeIdentify;
    }

    public void setThemeIdentify(ThemeIdentify themeIdentify) {
        this.themeIdentify = themeIdentify;
    }

    public void setMapLegend(String string) {
        this.mapLegend = string;
    }

    public String getMapLegend() {
        return this.mapLegend;
    }

    public void addDynamicStyle(String string, String string2) {
        this.dynamicStyles.put(string.toUpperCase(), string2);
    }

    public String getDynamicStyle(String string) {
        return (String)this.dynamicStyles.get(string.toUpperCase());
    }

    public void removeDynamicStyle(String string) {
        try {
            this.dynamicStyles.remove(string.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllDynamicStyles() {
        this.dynamicStyles.clear();
    }

    public String[] listAllDynamicStyles() {
        String[] stringArray = new String[this.dynamicStyles.size()];
        int n = 0;
        Enumeration enumeration = this.dynamicStyles.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public void setScaleBar(ScaleBarDef scaleBarDef) {
        this.scaleBar = scaleBarDef;
    }

    public ScaleBarDef getScaleBar() {
        return this.scaleBar;
    }

    public void setNorthArrow(NorthArrow northArrow) {
        this.northArrow = northArrow;
    }

    public NorthArrow getNorthArrow() {
        return this.northArrow;
    }

    public String toXMLString() {
        ThemeDescriptor[] themeDescriptorArray;
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n<map_request\n");
        boolean bl = false;
        String string2 = this.SRid != 0 ? "  srid=\"" + this.SRid + "\"\n" : "";
        String string3 = this.keepThemesOrder ? " keepthemesorder=\"true\"\n" : "";
        String string4 = this.isBgTransparent ? "  transparent=\"true\" \n" : "";
        String string5 = this.backgroundColor == null ? "" : "  bgcolor=\"#" + Integer.toHexString(this.backgroundColor.getRGB()).substring(2) + "\"\n";
        String string6 = string = this.isTileRequest ? "  istilereq=\"true\" \n" : "";
        if (this.getTitle() != null && this.getTitle().length() > 0) {
            stringBuffer.append("  title=\"" + MapViewer.doXMLEscape(this.getTitle()) + "\"\n");
        }
        if (this.getTitleStyleName() != null && this.getTitleStyleName().length() > 0) {
            stringBuffer.append("  title_style=\"" + MapViewer.doXMLEscape(this.getTitleStyleName()) + "\"\n");
        }
        if (this.getBaseMap() != null && this.getBaseMap().length() > 0) {
            stringBuffer.append("  basemap=\"" + this.getBaseMap() + "\"\n");
        }
        if (this.getMapDataSource() != null && this.getMapDataSource().length() > 0) {
            stringBuffer.append("  datasource=\"" + this.getMapDataSource() + "\"\n");
        }
        stringBuffer.append(string2 + string3 + "  width=\"" + (int)this.deviceSize.getWidth() + "\"\n" + "  height=\"" + (int)this.deviceSize.getHeight() + "\"\n" + (this.deviceSizeUnit != null ? "  width_height_unit=\"" + this.deviceSizeUnit + "\"\n" : "") + (this.dpi > 0 ? "  dpi=\"" + this.dpi + "\"\n" : "") + (this.rotation != 0.0 ? "  rotation=\"" + this.rotation + "\"\n" : "") + string5 + string4 + string + (this.bgImageURL != null ? "  bgimage=\"" + MapViewer.doXMLEscape(this.bgImageURL) + "\"\n" : "") + "  antialiase=\"" + this.antiAliase + "\"\n" + (!this.imageScaling ? " imagescaling=\"false\"\n" : "") + (this.mapFileName != null ? " mapfilename=\"" + this.mapFileName + "\"\n" : "") + (this.getWrapAround() ? "  wraparound=\"true\"\n" : "") + "  format=\"" + MapResponse.getImageFormatString(this.imageFormat) + "\"" + "\n" + (this.onClick != null ? " onclick=\"" + this.onClick + "\"\n" : "") + (this.onMouseMove != null ? " onmousemove=\"" + this.onMouseMove + "\"\n" : "") + (this.onRectangleSelect != null ? " onrectselect=\"" + this.onRectangleSelect + "\"\n" : "") + (this.onPolygonSelect != null ? " onpolyselect=\"" + this.onPolygonSelect + "\"\n" : "") + (this.renderRasterBaseMap ? " rasterbasemap=\"true\"\n" : "") + (this.useCachedBaseMap ? " use_cached_basemap=\"true\"\n" : "") + (this.snapToCachedZoomLevel ? " snap_to_tile_scale=\"true\"\n" : "") + (this.snapToCachedZoomLevel ? " snap_to_cache_scale=\"true\"\n" : "") + (this.disableMapPieces ? " disablemappieces=\"true\"\n" : "") + (this.footnote != null ? " footnote=\"" + this.footnote + "\"\n" : "") + (this.footnoteStyle != null ? " footnote_style=\"" + this.footnoteStyle + "\"\n" : "") + ">\n" + this.centerOrBox());
        stringBuffer.append(this.convertCustomProps());
        stringBuffer.append(this.themeModifiers());
        stringBuffer.append(this.boundingThemes());
        if (this.geoFeatures != null) {
            for (int i = 0; i < this.geoFeatures.length; ++i) {
                if (this.geoFeatures[i] == null) continue;
                stringBuffer.append(this.geoFeatures[i].toXMLString());
            }
        }
        if (this.mapLegend != null && this.mapLegend.length() > 10) {
            stringBuffer.append(this.escapeLegendText(this.mapLegend) + "\n");
        }
        if (this.northArrow != null) {
            stringBuffer.append("  <north_arrow>\n    <style> " + this.northArrow.getStyle() + " </style>\n" + "    <location> " + this.northArrow.getLocationX() + "," + this.northArrow.getLocationY() + " </location>\n" + "    <size> " + this.northArrow.getWidth() + "," + this.northArrow.getHeight() + " </size>\n" + "  </north_arrow>\n");
        }
        if (this.scaleBar != null) {
            stringBuffer.append(this.convertScaleBar());
        }
        if ((themeDescriptorArray = this.mapDef.getThemes()) == null) {
            themeDescriptorArray = new ThemeDescriptor[]{};
        }
        if (themeDescriptorArray.length > 1 || themeDescriptorArray.length == 1 && themeDescriptorArray[0].type != 3) {
            stringBuffer.append("  <themes>\n");
            bl = true;
        }
        block16: for (int i = 0; i < themeDescriptorArray.length; ++i) {
            if (!themeDescriptorArray[i].enabled) continue;
            switch (themeDescriptorArray[i].type) {
                case 1: {
                    stringBuffer.append(this.convertPT(themeDescriptorArray[i]));
                    continue block16;
                }
                case 2: {
                    stringBuffer.append(this.convertJDBCTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 4: {
                    stringBuffer.append(this.convertImageTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 5: {
                    stringBuffer.append(this.convertGeoRasterTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 6: {
                    stringBuffer.append(this.convertNetworkTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 7: {
                    stringBuffer.append(this.convertTopologyTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 8: {
                    stringBuffer.append(this.convertWMSMapTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 14: {
                    stringBuffer.append(this.convertWMTSTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 15: {
                    stringBuffer.append(this.convertLRSTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 9: {
                    stringBuffer.append(this.convertMapCacheTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 10: {
                    stringBuffer.append(this.convertWFSTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 12: {
                    stringBuffer.append(this.convertAnnotationTextTheme(themeDescriptorArray[i]));
                    continue block16;
                }
                case 11: {
                    stringBuffer.append(this.convertCustomGeometryTheme(themeDescriptorArray[i]));
                    continue block16;
                }
            }
        }
        if (bl) {
            stringBuffer.append("  </themes>\n");
        }
        stringBuffer.append(this.convertNsDps());
        if (this.dynamicStyles.size() > 0) {
            stringBuffer.append("  <styles>\n");
            Enumeration enumeration = this.dynamicStyles.elements();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (string7 == null) continue;
                stringBuffer.append(string7 + "\n");
            }
            stringBuffer.append("  </styles>\n");
        }
        stringBuffer.append("</map_request>");
        return stringBuffer.toString();
    }

    private String boundingThemes() {
        String string = "";
        if (this.center != null || this.queryWindow != null || this.boundingThemes == null || this.boundingThemes.length == 0) {
            return string;
        }
        for (int i = 1; i < this.boundingThemes.length; ++i) {
            string = string + "," + this.boundingThemes[i];
        }
        string = this.boundingSizeHint <= 0.0 ? "  <bounding_themes border_margin=\"" + this.boundingThemeBorderMargin + "\"\n" + "    preserve_aspect_ratio=\"" + this.boundingThemeKeepAspectRatio + "\">" + this.boundingThemes[0] + string + "</bounding_themes>\n" : "  <bounding_themes border_margin=\"" + this.boundingThemeBorderMargin + "\"\n" + "    preserve_aspect_ratio=\"" + this.boundingThemeKeepAspectRatio + "\"" + " size_hint=\"" + this.boundingSizeHint + "\">" + this.boundingThemes[0] + string + "</bounding_themes>\n";
        return string;
    }

    private String themeModifiers() {
        String string = "";
        if (this.themeModifiers.size() == 0) {
            return string;
        }
        string = "  <theme_modifiers>\n";
        String[] stringArray = new String[this.themeModifiers.size()];
        int n = 0;
        Enumeration<Object> enumeration = this.themeModifiers.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        n = 0;
        enumeration = this.themeModifiers.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            if (hashtable == null || hashtable.size() == 0) continue;
            string = string + "    <theme_decorations name=\"" + stringArray[n++].toLowerCase() + "\"";
            String[] stringArray2 = new String[hashtable.size()];
            int n2 = 0;
            Enumeration<Object> enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                stringArray2[n2++] = (String)enumeration2.nextElement();
            }
            n2 = 0;
            enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                string = string + " " + stringArray2[n2++].toLowerCase() + "=\"" + string2 + "\"";
            }
            string = string + "/>\n";
        }
        string = string + "  </theme_modifiers>\n";
        return string;
    }

    public void setSRS(String string) {
        this.srs = string;
    }

    public String getSRS() {
        return this.srs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("MapRequest=\n");
        stringBuffer.append("\n center=" + this.center);
        stringBuffer.append("\n size=" + this.size);
        stringBuffer.append("\n scale=" + this.mapScale);
        stringBuffer.append("\n verbose=" + this.verbose);
        stringBuffer.append("\n srid=" + this.SRid);
        stringBuffer.append("\n queryWindow=" + this.queryWindow);
        stringBuffer.append("\n imageFormat=" + this.imageFormat);
        stringBuffer.append("\n backgroundColor=" + this.backgroundColor);
        stringBuffer.append("\n bgImageURL=" + this.bgImageURL);
        stringBuffer.append("\n antialise=" + this.antiAliase);
        stringBuffer.append("\n deviceSize=" + this.deviceSize);
        stringBuffer.append("\n srs=" + this.srs);
        stringBuffer.append("\n geoFeatures=" + this.geoFeatures);
        stringBuffer.append("\n mapDefinition=" + this.mapDef);
        return stringBuffer.toString();
    }

    private String escapeLegendText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        int n = string.indexOf("text=\"");
        while (n >= 0) {
            int n2 = string.indexOf("\"", n + 6);
            String string2 = string.substring(n + 6, n2);
            string = string.substring(0, n + 6) + MapViewer.doXMLEscape(string2) + string.substring(n2);
            n = string.indexOf("text=\"", n + 6);
        }
        return string;
    }

    private String convertPTParameters(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("     <binding_parameters>\n");
        for (int i = 0; i < objectArray.length; ++i) {
            String string = objectArray[i].getClass().getName();
            if (string.indexOf(".") > 0) {
                string = string.substring(string.lastIndexOf(".") + 1);
            }
            if (!string.equalsIgnoreCase("ArrayParameter")) {
                stringBuffer.append("       <parameter value=\"" + objectArray[i].toString() + "\" type=\"" + string + "\"/>\n");
                continue;
            }
            string = ((ArrayParameter)objectArray[i]).getTypeName();
            Object object = ((ArrayParameter)objectArray[i]).getValue();
            if (object == null) continue;
            try {
                Object[] objectArray2 = (Object[])object;
                if (objectArray2.length < 1) continue;
                String string2 = objectArray2[0].toString();
                for (int j = 1; j < objectArray2.length; ++j) {
                    string2 = string2 + "," + objectArray2[j].toString();
                }
                stringBuffer.append("       <parameter value=\"" + string2 + "\" type=\"" + string + "\"/>\n");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuffer.append("     </binding_parameters>\n");
        return stringBuffer.toString();
    }

    private String getScaleParameters(ThemeDescriptor themeDescriptor) {
        if (themeDescriptor == null) {
            return "";
        }
        return "" + (Double.isInfinite(themeDescriptor.minScale) || themeDescriptor.minScale == Double.POSITIVE_INFINITY ? "" : " min_scale=\"" + themeDescriptor.minScale + "\"") + (Double.isInfinite(themeDescriptor.maxScale) || themeDescriptor.maxScale == Double.NEGATIVE_INFINITY ? "" : " max_scale=\"" + themeDescriptor.maxScale + "\"") + (Double.isInfinite(themeDescriptor.minLabelScale) || themeDescriptor.minLabelScale == Double.POSITIVE_INFINITY ? "" : " label_min_scale=\"" + themeDescriptor.minLabelScale + "\"") + (Double.isInfinite(themeDescriptor.maxLabelScale) || themeDescriptor.maxLabelScale == Double.NEGATIVE_INFINITY ? "" : " label_max_scale=\"" + themeDescriptor.maxLabelScale + "\"") + (themeDescriptor.scaleType != null && themeDescriptor.scaleType.equalsIgnoreCase("RATIO") ? " scale_mode=\"" + themeDescriptor.scaleType.toLowerCase() + "\"" : "");
    }

    private String convertPT(ThemeDescriptor themeDescriptor) {
        String string = themeDescriptor.dataSource == null ? "" : " datasource=\"" + themeDescriptor.dataSource + "\"";
        return "    <theme name=\"" + themeDescriptor.name + "\"" + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"true\"" : "") + (themeDescriptor.minDistBetweenPoints != 0.5 ? " min_dist=\"" + themeDescriptor.minDistBetweenPoints + "\"" : "") + (!themeDescriptor.visibleInSVG ? " visible_in_svg=\"false\"" : "") + (themeDescriptor.selectableInSVG ? " selectable_in_svg=\"true\"" : "") + (themeDescriptor.fixedSVGLabel ? " fixed_svglabel=\"true\"" : "") + (themeDescriptor.onClickInSVG != null ? " onclick=\"" + themeDescriptor.onClickInSVG + "\"" : "") + (themeDescriptor.onMouseMoveInSVG != null ? " onmousemove=\"" + themeDescriptor.onMouseMoveInSVG + "\"" : "") + (themeDescriptor.onMouseOverInSVG != null ? " onmouseover=\"" + themeDescriptor.onMouseOverInSVG + "\"" : "") + (themeDescriptor.onMouseOutInSVG != null ? " onmouseout=\"" + themeDescriptor.onMouseOutInSVG + "\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (themeDescriptor.noRepetitiveLabel ? " no_repetitive_label=\"true\"" : "") + (!themeDescriptor.allowNakedPoints ? " allow_naked_points=\"false\"" : "") + this.getWorkspaceParameters(themeDescriptor) + (themeDescriptor.partOfBaseMap ? " part_of_basemap=\"true\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.templateTheme != null ? " template_theme=\"" + themeDescriptor.templateTheme + "\"" : "") + string + (themeDescriptor.snapToTileScale ? " snap_to_tile_scale=\"true\"" : "") + (!themeDescriptor.tileResizingOption.equalsIgnoreCase("unbiased") ? " tile_resizing_option=\"" + themeDescriptor.tileResizingOption + "\"" : "") + (themeDescriptor.currentThreads != 8 ? " current_threads=\"" + themeDescriptor.currentThreads + "\"" : "") + (!(themeDescriptor.dynamicParameters != null && themeDescriptor.dynamicParameters.length != 0 || themeDescriptor.operationNames != null && themeDescriptor.operationNames.length != 0 || themeDescriptor.renderRules != null && themeDescriptor.renderRules.length != 0 || themeDescriptor.bitmapMasks != null && themeDescriptor.bitmapMasks.length != 0 || themeDescriptor.providerRuntimeProperties != null && themeDescriptor.providerRuntimeProperties.size() != 0) ? " />\n" : ">\n" + this.convertPTParameters(themeDescriptor.dynamicParameters) + this.convertThemeOperations(themeDescriptor) + this.convertGeoRasterThemeBitmapMasks(themeDescriptor) + this.convertRenderingRules(themeDescriptor) + this.convertCustomGeometryThemeParameters(themeDescriptor) + "    </theme>\n");
    }

    private String convertJDBCTheme(ThemeDescriptor themeDescriptor) {
        return "    <theme name=\"" + themeDescriptor.name + "\"" + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.minDistBetweenPoints != 0.5 ? " min_dist=\"" + themeDescriptor.minDistBetweenPoints + "\"" : "") + (!themeDescriptor.visibleInSVG ? " visible_in_svg=\"false\"" : "") + (themeDescriptor.selectableInSVG ? " selectable_in_svg=\"true\"" : "") + (themeDescriptor.fixedSVGLabel ? " fixed_svglabel=\"true\"" : "") + (themeDescriptor.onClickInSVG != null ? " onclick=\"" + themeDescriptor.onClickInSVG + "\"" : "") + (themeDescriptor.onMouseMoveInSVG != null ? " onmousemove=\"" + themeDescriptor.onMouseMoveInSVG + "\"" : "") + (themeDescriptor.onMouseOverInSVG != null ? " onmouseover=\"" + themeDescriptor.onMouseOverInSVG + "\"" : "") + (themeDescriptor.onMouseOutInSVG != null ? " onmouseout=\"" + themeDescriptor.onMouseOutInSVG + "\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (themeDescriptor.noRepetitiveLabel ? " no_repetitive_label=\"true\"" : "") + (!themeDescriptor.allowNakedPoints ? " allow_naked_points=\"false\"" : "") + this.getWorkspaceParameters(themeDescriptor) + (themeDescriptor.partOfBaseMap ? " part_of_basemap=\"true\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"" + themeDescriptor.labelAlwaysOn + "\"" : "") + ">\n" + "       <jdbc_query\n" + (themeDescriptor.labelColumn != null ? "         label_column=\"" + themeDescriptor.labelColumn + "\"\n" : "") + (themeDescriptor.spatialColumn != null ? "         spatial_column=\"" + themeDescriptor.spatialColumn + "\"\n" : "") + (themeDescriptor.keyColumn != null ? "         key_column=\"" + themeDescriptor.keyColumn + "\"\n" : "") + (themeDescriptor.labelStyleName != null ? "         label_style=\"" + themeDescriptor.labelStyleName + "\"\n" : "") + (themeDescriptor.renderStyleName != null ? "         render_style=\"" + themeDescriptor.renderStyleName + "\"\n" : "") + (themeDescriptor.xColumn != null ? "         x_column=\"" + themeDescriptor.xColumn + "\"\n" : "") + (themeDescriptor.yColumn != null ? "         y_column=\"" + themeDescriptor.yColumn + "\"\n" : "") + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + "         asis=\"" + themeDescriptor.passThrough + "\">" + MapViewer.doXMLEscape(themeDescriptor.query) + (themeDescriptor.hiddenInfoDef == null ? "" : themeDescriptor.hiddenInfoDef) + "\n       </jdbc_query>\n" + this.convertRenderingRules(themeDescriptor) + "     </theme>\n";
    }

    private String convertTopologyTheme(ThemeDescriptor themeDescriptor) {
        if (!themeDescriptor.isDebugTheme) {
            return "    <theme name=\"" + themeDescriptor.name + "\" " + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (themeDescriptor.noRepetitiveLabel ? " no_repetitive_label=\"true\"" : "") + (!themeDescriptor.allowNakedPoints ? " allow_naked_points=\"false\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.partOfBaseMap ? " part_of_basemap=\"true\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"" + themeDescriptor.labelAlwaysOn + "\"" : "") + ">\n" + "       <jdbc_topology_query\n" + "         topology_name=\"" + themeDescriptor.topologyName + "\"\n" + "         feature_table=\"" + themeDescriptor.featureTableName + "\"\n" + (themeDescriptor.labelColumn != null ? "         label_column=\"" + themeDescriptor.labelColumn + "\"\n" : "") + "         spatial_column=\"" + themeDescriptor.spatialColumn + "\"\n" + (themeDescriptor.labelStyleName != null ? "         label_style=\"" + themeDescriptor.labelStyleName + "\"\n" : "") + (themeDescriptor.renderStyleName != null ? "         render_style=\"" + themeDescriptor.renderStyleName + "\"\n" : "") + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + (themeDescriptor.topoView != null && themeDescriptor.topoViewColumn != null ? "         view_name=\"" + themeDescriptor.topoView + "\"\n" + "         view_column=\"" + themeDescriptor.topoViewColumn + "\"\n" : "") + "         asis=\"" + themeDescriptor.passThrough + "\">" + MapViewer.doXMLEscape(themeDescriptor.query) + "\n       </jdbc_topology_query>\n" + this.convertRenderingRules(themeDescriptor) + "     </theme>\n";
        }
        return "    <theme name=\"" + themeDescriptor.name + "\" mode=\"debug\" " + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"" + themeDescriptor.labelAlwaysOn + "\"" : "") + ">\n" + "       <jdbc_topology_query\n" + "         topology_name=\"" + themeDescriptor.topologyName + "\"\n" + (themeDescriptor.featureTableName != null ? "         feature_table=\"" + themeDescriptor.featureTableName + "\"\n" : "") + (themeDescriptor.linkStyle != null ? "         edge_style=\"" + themeDescriptor.linkStyle + "\"\n" : "") + (themeDescriptor.edgeLabelStyle != null ? "         edge_label_style=\"" + themeDescriptor.edgeLabelStyle + "\"\n" : "") + (themeDescriptor.directionStyle != null ? "         edge_marker_style=\"" + themeDescriptor.directionStyle + "\"\n" + "         edge_marker_size=\"" + themeDescriptor.directionMarkerSize + "\"\n" : "") + (themeDescriptor.nodeStyle != null ? "         node_style=\"" + themeDescriptor.nodeStyle + "\"\n" : "") + (themeDescriptor.nodeLabelStyle != null ? "         node_label_style=\"" + themeDescriptor.nodeLabelStyle + "\"\n" : "") + (themeDescriptor.faceStyle != null ? "         face_style=\"" + themeDescriptor.faceStyle + "\"\n" : "") + (themeDescriptor.faceLabelStyle != null ? "         face_label_style=\"" + themeDescriptor.faceLabelStyle + "\"\n" : "") + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + "         asis=\"" + themeDescriptor.passThrough + "\">\n" + "       </jdbc_topology_query>\n" + "     </theme>\n";
    }

    private String convertImageTheme(ThemeDescriptor themeDescriptor) {
        return "    <theme name=\"" + themeDescriptor.name + "\"" + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + ">\n" + "      <jdbc_image_query\n" + "         image_column=\"" + themeDescriptor.imageColumn + "\"\n" + "         image_mbr_column=\"" + themeDescriptor.imageMBRColumn + "\"\n" + "         image_format=\"" + themeDescriptor.imageFormat + "\"\n" + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.imageResUnit != null ? "         image_unit=\"" + themeDescriptor.imageResUnit + "\"\n" + "         image_resolution=\"" + themeDescriptor.imageResolution + "\"\n" : "") + ((double)themeDescriptor.imageAlpha != 1.0 ? "         image_alpha=\"" + themeDescriptor.imageAlpha + "\"\n" : "") + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + "         asis=\"" + themeDescriptor.passThrough + "\">" + MapViewer.doXMLEscape(themeDescriptor.query) + "      </jdbc_image_query>\n" + "    </theme>\n";
    }

    private String convertGeoRasterTheme(ThemeDescriptor themeDescriptor) {
        String string = null;
        if (themeDescriptor.polygonMask != null) {
            for (int i = 0; i < themeDescriptor.polygonMask.length; ++i) {
                String string2 = String.valueOf(themeDescriptor.polygonMask[i]);
                string = i > 0 ? string + "," + string2 : string2;
            }
        }
        return "    <theme name=\"" + themeDescriptor.name + "\"" + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + ">\n" + "      <jdbc_georaster_query\n" + "         georaster_table=\"" + themeDescriptor.geoRasterTable + "\"\n" + "         georaster_column=\"" + themeDescriptor.geoRasterColumn + "\"\n" + (themeDescriptor.rasterTable != null ? "         raster_table=\"" + themeDescriptor.rasterTable + "\"\n" : "") + (themeDescriptor.rasterID != null ? "         raster_id=\"" + themeDescriptor.rasterID + "\"\n" : "") + (themeDescriptor.pyramidLevel != null ? "         raster_pyramid=\"" + themeDescriptor.pyramidLevel + "\"\n" : "") + (themeDescriptor.bands != null ? "         raster_bands=\"" + themeDescriptor.bands + "\"\n" : "") + (themeDescriptor.alphaBand > -1 ? "         alpha_band=\"" + themeDescriptor.alphaBand + "\"\n" : "") + (themeDescriptor.transparentNodata ? "         transparent_nodata=\"true\"\n" : "") + (themeDescriptor.reprojMode != null && !themeDescriptor.reprojMode.equalsIgnoreCase("bilinear") ? "         reproj_mode=\"" + themeDescriptor.reprojMode + "\"\n" : "") + (themeDescriptor.filterReprojResult ? "         filter_reproj=\"true\"\n" : "") + (themeDescriptor.renderInterpolationHint != null && !themeDescriptor.renderInterpolationHint.equalsIgnoreCase("nearest_neighbor") ? "         render_interpolation_hint=\"" + themeDescriptor.renderInterpolationHint + "\"\n" : "") + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + (themeDescriptor.imageResUnit != null ? "         image_unit=\"" + themeDescriptor.imageResUnit + "\"\n" + "         image_resolution=\"" + themeDescriptor.imageResolution + "\"\n" : "") + ((double)themeDescriptor.imageAlpha != 1.0 ? "         image_alpha=\"" + themeDescriptor.imageAlpha + "\"\n" : "") + (themeDescriptor.polygonMask != null ? "         polygon_mask=\"" + string + "\"\n" : "") + (themeDescriptor.polygonMaskSRID > 0 ? "         polygon_mask_srid=\"" + themeDescriptor.polygonMaskSRID + "\"\n" : "") + (themeDescriptor.pmaskTable != null ? "         polygon_mask_table=\"" + themeDescriptor.pmaskTable + "\"\n" : "") + (themeDescriptor.pmaskGeomColumn != null ? "         polygon_mask_geomcolumn=\"" + themeDescriptor.pmaskGeomColumn + "\"\n" : "") + (themeDescriptor.pmaskQCondition != null ? "         polygon_mask_condition=\"" + themeDescriptor.pmaskQCondition + "\"\n" : "") + (themeDescriptor.pmaskJoinColumn != null ? "         polygon_mask_joingeomcolumn=\"" + themeDescriptor.pmaskJoinColumn + "\"\n" : "") + (themeDescriptor.pmaskJoinGeorColumn != null ? "         polygon_mask_joingeorcolumn=\"" + themeDescriptor.pmaskJoinGeorColumn + "\"\n" : "") + "         asis=\"" + themeDescriptor.passThrough + "\">" + (themeDescriptor.query != null ? MapViewer.doXMLEscape(themeDescriptor.query) : "") + "\n       </jdbc_georaster_query>\n" + this.convertThemeOperations(themeDescriptor) + this.convertGeoRasterThemeBitmapMasks(themeDescriptor) + this.convertPTParameters(themeDescriptor.dynamicParameters) + "    </theme>\n";
    }

    private String convertNetworkTheme(ThemeDescriptor themeDescriptor) {
        String string = String.valueOf((int)themeDescriptor.directionMarkerSize);
        if (!(themeDescriptor.directionStyle == null && themeDescriptor.bidirectionStyle == null || themeDescriptor.directionMarkerSizeUnit == null || themeDescriptor.directionMarkerSizeUnit.equalsIgnoreCase("pt") || themeDescriptor.directionMarkerSizeUnit.equalsIgnoreCase("px"))) {
            string = String.valueOf(themeDescriptor.directionMarkerSize) + themeDescriptor.directionMarkerSizeUnit;
        }
        String string2 = String.valueOf((int)themeDescriptor.nodeMarkerSize);
        if (themeDescriptor.nodeStyle != null && themeDescriptor.nodeMarkerSizeUnit != null && !themeDescriptor.nodeMarkerSizeUnit.equalsIgnoreCase("pt") && !themeDescriptor.nodeMarkerSizeUnit.equalsIgnoreCase("px")) {
            string2 = String.valueOf(themeDescriptor.nodeMarkerSize) + themeDescriptor.nodeMarkerSizeUnit;
        }
        return "    <theme name=\"" + themeDescriptor.name + "\" " + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (themeDescriptor.noRepetitiveLabel ? " no_repetitive_label=\"true\"" : "") + (!themeDescriptor.allowNakedPoints ? " allow_naked_points=\"false\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.partOfBaseMap ? " part_of_basemap=\"true\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"" + themeDescriptor.labelAlwaysOn + "\"" : "") + ">\n" + "       <jdbc_network_query\n" + "         network_name=\"" + themeDescriptor.networkName + "\"\n" + "         network_level=\"" + themeDescriptor.networkLevel + "\"\n" + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "         jdbc_host=\"" + themeDescriptor.host + "\"\n" + "         jdbc_port=\"" + themeDescriptor.port + "\"\n" + "         jdbc_sid=\"" + themeDescriptor.sid + "\"\n" + "         jdbc_mode=\"" + themeDescriptor.mode + "\"\n" + "         jdbc_user=\"" + themeDescriptor.user + "\"\n" + "         jdbc_password=\"" + themeDescriptor.passwd + "\"\n") + (themeDescriptor.linkStyle != null ? "         link_style=\"" + themeDescriptor.linkStyle + "\"\n" : "") + (themeDescriptor.directionStyle != null ? "         direction_style=\"" + themeDescriptor.directionStyle + "\"\n" : "") + (themeDescriptor.bidirectionStyle != null ? "         bidirection_style=\"" + themeDescriptor.bidirectionStyle + "\"\n" : "") + (themeDescriptor.directionStyle != null || themeDescriptor.bidirectionStyle != null ? "         direction_position=\"" + themeDescriptor.directionPosition + "\"\n" + "         direction_markersize=\"" + string + "\"\n" : "") + (themeDescriptor.multipleMarker ? "         direction_multimarker=\"true\"\n" : "") + (themeDescriptor.nodeStyle != null ? "         node_style=\"" + themeDescriptor.nodeStyle + "\"\n" + "         node_markersize=\"" + string2 + "\"\n" : "") + (themeDescriptor.pathIds != null ? "         path_ids=\"" + themeDescriptor.pathIds + "\"\n" : "") + (themeDescriptor.pathStyles != null ? "         path_styles=\"" + themeDescriptor.pathStyles + "\"\n" : "") + (themeDescriptor.linksLabelStyle != null && themeDescriptor.linksLabelColumn != null ? "         link_labelstyle=\"" + themeDescriptor.linksLabelStyle + "\"\n" + "         link_labelcolumn=\"" + themeDescriptor.linksLabelColumn + "\"\n" : "") + (themeDescriptor.nodesLabelStyle != null && themeDescriptor.nodesLabelColumn != null ? "         node_labelstyle=\"" + themeDescriptor.nodesLabelStyle + "\"\n" + "         node_labelcolumn=\"" + themeDescriptor.nodesLabelColumn + "\"\n" : "") + (themeDescriptor.pathsLabelStyle != null && themeDescriptor.pathsLabelColumn != null ? "         path_labelstyle=\"" + themeDescriptor.pathsLabelStyle + "\"\n" + "         path_labelcolumn=\"" + themeDescriptor.pathsLabelColumn + "\"\n" : "") + (themeDescriptor.spAlgorithm != null && (themeDescriptor.spAlgorithm.equalsIgnoreCase("DIJKSTRA") || themeDescriptor.spAlgorithm.equalsIgnoreCase("ASEARCH")) ? "         analysis_algorithm=\"" + themeDescriptor.spAlgorithm + "\"\n" + "         shortestpath_style=\"" + themeDescriptor.spStyle + "\"\n" + "         shortestpath_startnode=\"" + themeDescriptor.spStartNode + "\"\n" + "         shortestpath_endnode=\"" + themeDescriptor.spEndNode + "\"\n" : "") + (themeDescriptor.spAlgorithm != null && themeDescriptor.spStartStyle != null && (themeDescriptor.spAlgorithm.equalsIgnoreCase("DIJKSTRA") || themeDescriptor.spAlgorithm.equalsIgnoreCase("ASEARCH")) ? "         shortestpath_startstyle=\"" + themeDescriptor.spStartStyle + "\"\n" : "") + (themeDescriptor.spAlgorithm != null && themeDescriptor.spEndStyle != null && (themeDescriptor.spAlgorithm.equalsIgnoreCase("DIJKSTRA") || themeDescriptor.spAlgorithm.equalsIgnoreCase("ASEARCH")) ? "         shortestpath_endstyle=\"" + themeDescriptor.spEndStyle + "\"\n" : "") + (themeDescriptor.spAlgorithm != null && themeDescriptor.spAlgorithm.equalsIgnoreCase("WITHINCOST") ? "         analysis_algorithm=\"WITHINCOST\"\n         withincost_style=\"" + themeDescriptor.spStyle + "\"\n" + "         withincost_startnode=\"" + themeDescriptor.spStartNode + "\"\n" + "         withincost_cost=\"" + themeDescriptor.spCost + "\"\n" : "") + (themeDescriptor.spAlgorithm != null && themeDescriptor.spStartStyle != null && themeDescriptor.spAlgorithm.equalsIgnoreCase("WITHINCOST") ? "         withincost_startstyle=\"" + themeDescriptor.spStartStyle + "\"\n" : "") + "         asis=\"" + themeDescriptor.passThrough + "\">\n" + "       </jdbc_network_query>\n" + "     </theme>\n";
    }

    private String convertWMSMapTheme(ThemeDescriptor themeDescriptor) {
        String[] stringArray;
        int n;
        StringBuffer stringBuffer = null;
        String string = null;
        String string2 = "    </theme>\n";
        String string3 = "       </wms_getmap_request>\n";
        String string4 = "           </vendor_specific_parameters>\n";
        String string5 = "           </service_url>\n";
        String string6 = "           </version>\n";
        String string7 = "           </format>\n";
        String string8 = "           </srs>\n";
        String string9 = "           </bgcolor>\n";
        String string10 = "           </exceptions>\n";
        String string11 = "           </transparent>\n";
        String string12 = "           </layers>\n";
        String string13 = "           </styles>\n";
        String string14 = "       <wms_getmap_request ";
        String string15 = "           <vendor_specific_parameters>\n";
        String string16 = "           <service_url>\n";
        String string17 = "           <version>\n";
        String string18 = "           <format>\n";
        String string19 = "           <srs>\n";
        String string20 = "           <bgcolor>\n";
        String string21 = "           <exceptions>\n";
        String string22 = "           <transparent>\n";
        String string23 = "           <layers>\n";
        String string24 = "           <styles>\n";
        String string25 = "                <vsp>\n";
        String string26 = "                </vsp>\n";
        String string27 = "                    <name>\n";
        String string28 = "                    <value>\n";
        String string29 = "                    </name>\n";
        String string30 = "                    </value>\n";
        stringBuffer = new StringBuffer("    <theme name=\"" + themeDescriptor.name + "\"" + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + (Double.isInfinite(themeDescriptor.minScale) || themeDescriptor.minScale == Double.POSITIVE_INFINITY ? "" : " min_scale=\"" + themeDescriptor.minScale + "\"") + (Double.isInfinite(themeDescriptor.maxScale) || themeDescriptor.maxScale == Double.NEGATIVE_INFINITY ? "" : " max_scale=\"" + themeDescriptor.maxScale + "\"") + (themeDescriptor.scaleType != null && themeDescriptor.scaleType.equalsIgnoreCase("RATIO") ? " scale_mode=\"" + themeDescriptor.scaleType.toLowerCase() + "\"" : "") + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.visibleInSVG ? " visible_in_svg=\"false\"" : "") + " >\n");
        stringBuffer.append(string14 + " isBackgroundTheme=\"" + (themeDescriptor.WMS_IsBackgroundImage ? "true" : "false") + "\" >\n");
        if (themeDescriptor.authUser != null) {
            stringBuffer.append("           <user> " + themeDescriptor.authUser + " </user>\n");
        }
        if (themeDescriptor.authPassword != null) {
            stringBuffer.append("           <password> " + themeDescriptor.authPassword + " </password>\n");
        }
        stringBuffer.append(string16 + "\t\t " + themeDescriptor.WMS_ServiceURLPrefix + "\n" + string5);
        stringBuffer.append(string17 + "\t\t " + themeDescriptor.WMS_Version + "\n" + string6);
        stringBuffer.append(string18 + "\t\t " + themeDescriptor.WMS_Format + "\n" + string7);
        stringBuffer.append(string19 + "\t\t " + themeDescriptor.WMS_SRS + "\n" + string8);
        stringBuffer.append(string20 + "\t\t " + themeDescriptor.WMS_BgColor + "\n" + string9);
        stringBuffer.append(string22 + "\t\t " + themeDescriptor.WMS_Transparent + "\n" + string11);
        stringBuffer.append(string21 + "\t\t " + themeDescriptor.WMS_Exceptions + "\n" + string10);
        if (themeDescriptor.WMS_Layers != null) {
            stringBuffer.append(string23);
            for (n = 0; n < themeDescriptor.WMS_Layers.length; ++n) {
                stringArray = themeDescriptor.WMS_Layers[n];
                stringArray = URLEncoder.encode((String)stringArray);
                if (n == 0) {
                    stringBuffer.append("\t\t " + (String)stringArray);
                    continue;
                }
                stringBuffer.append("," + (String)stringArray);
            }
            stringBuffer.append("\n" + string12);
        }
        if (themeDescriptor.WMS_Styles != null) {
            stringBuffer.append(string24);
            for (n = 0; n < themeDescriptor.WMS_Styles.length; ++n) {
                if (n == 0) {
                    stringBuffer.append("\t\t " + themeDescriptor.WMS_Styles[n]);
                    continue;
                }
                stringBuffer.append("," + themeDescriptor.WMS_Styles[n]);
            }
            stringBuffer.append("\n" + string13);
        }
        if (themeDescriptor.WMS_VendorSpecificParameters != null && themeDescriptor.WMS_VendorSpecificParameters.length > 0) {
            stringBuffer.append(string15);
            for (n = 0; n < themeDescriptor.WMS_VendorSpecificParameters.length; ++n) {
                stringArray = (String[])themeDescriptor.WMS_VendorSpecificParameters[n];
                stringBuffer.append(string25);
                stringBuffer.append(string27);
                stringBuffer.append("\t\t\t " + stringArray[0] + "\n");
                stringBuffer.append(string29);
                stringBuffer.append(string28);
                stringBuffer.append("\t\t\t " + stringArray[1] + "\n");
                stringBuffer.append(string30);
                stringBuffer.append(string26);
            }
            stringBuffer.append(string4);
        }
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        string = new String(stringBuffer);
        return string;
    }

    private String convertMapCacheTheme(ThemeDescriptor themeDescriptor) {
        String string = themeDescriptor.dataSource == null ? "" : " datasource=\"" + themeDescriptor.dataSource + "\"";
        return "    <theme name=\"" + themeDescriptor.name + "\"" + string + (Double.isInfinite(themeDescriptor.minScale) || themeDescriptor.minScale == Double.POSITIVE_INFINITY ? "" : " min_scale=\"" + themeDescriptor.minScale + "\"") + (Double.isInfinite(themeDescriptor.maxScale) || themeDescriptor.maxScale == Double.NEGATIVE_INFINITY ? "" : " max_scale=\"" + themeDescriptor.maxScale + "\"") + (themeDescriptor.scaleType != null && themeDescriptor.scaleType.equalsIgnoreCase("RATIO") ? " scale_mode=\"" + themeDescriptor.scaleType.toLowerCase() + "\"" : "") + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + ">\n" + "      <map_cache_theme map_cache_name=\"" + themeDescriptor.cacheMapSource + "\" " + "snap_to_cache_scale=\"" + themeDescriptor.snapToCacheScale + "\" " + "tile_resizing_option=\"" + themeDescriptor.tileResizingOption + "\" " + (themeDescriptor.externalMapViewerURL != null ? "mapviewer_url=\"" + themeDescriptor.externalMapViewerURL + "\" " : "") + "/>" + "    </theme>";
    }

    private String convertWFSTheme(ThemeDescriptor themeDescriptor) {
        String string = null;
        if (themeDescriptor.WFS_attributeList != null) {
            string = themeDescriptor.WFS_attributeList[0];
            for (int i = 1; i < themeDescriptor.WFS_attributeList.length; ++i) {
                string = string + "," + themeDescriptor.WFS_attributeList[i];
            }
        }
        String string2 = null;
        if (themeDescriptor.renderStyleAttributes != null) {
            string2 = themeDescriptor.renderStyleAttributes[0];
            for (int i = 1; i < themeDescriptor.renderStyleAttributes.length; ++i) {
                string2 = string2 + "," + themeDescriptor.renderStyleAttributes[i];
            }
        }
        String string3 = null;
        if (themeDescriptor.WFS_featureIds != null) {
            string3 = themeDescriptor.WFS_featureIds[0];
            for (int i = 1; i < themeDescriptor.WFS_featureIds.length; ++i) {
                string3 = string3 + "," + themeDescriptor.WFS_featureIds[i];
            }
        }
        return "    <theme name=\"" + themeDescriptor.name + "\"" + this.getScaleParameters(themeDescriptor) + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + " >\n" + "       <wfs_feature_request \n" + (themeDescriptor.WFS_version != null && !themeDescriptor.WFS_version.equals("1.0.0") ? "         version=\"" + themeDescriptor.WFS_version + "\"\n" : "") + (themeDescriptor.WFS_outputFormat != null && !themeDescriptor.WFS_outputFormat.equals("GML2") ? "         format=\"" + themeDescriptor.WFS_outputFormat + "\"\n" : "") + (themeDescriptor.WFS_url != null ? "         service_url=\"" + themeDescriptor.WFS_url + "\"\n" : "") + (themeDescriptor.WMS_SRS != null ? "         srs=\"" + themeDescriptor.WMS_SRS + "\"\n" : "") + (themeDescriptor.featureTableName != null ? "         feature_name=\"" + themeDescriptor.featureTableName + "\"\n" : "") + (themeDescriptor.spatialColumn != null ? "         spatial_column=\"" + themeDescriptor.spatialColumn + "\"\n" : "") + (themeDescriptor.renderStyleName != null ? "         render_style=\"" + themeDescriptor.renderStyleName + "\"\n" : "") + (themeDescriptor.labelColumn != null ? "         label_column=\"" + themeDescriptor.labelColumn + "\"\n" : "") + (themeDescriptor.labelStyleName != null ? "         label_style=\"" + themeDescriptor.labelStyleName + "\"\n" : "") + (string != null ? "         feature_attributes=\"" + string + "\"\n" : "") + (string2 != null ? "         render_attributes=\"" + string2 + "\"\n" : "") + (string3 != null ? "         feature_ids=\"" + string3 + "\"\n" : "") + (themeDescriptor.authUser != null ? "         user=\"" + themeDescriptor.authUser + "\"\n" : "") + (themeDescriptor.authPassword != null ? "         password=\"" + themeDescriptor.authPassword + "\"\n" : "") + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\"\n" : "") + "      />\n" + "    </theme>\n";
    }

    private String convertWMTSTheme(ThemeDescriptor themeDescriptor) {
        StringBuffer stringBuffer = null;
        String string = null;
        String string2 = "    </theme>\n";
        String string3 = "       </wmts_gettile_request>\n";
        String string4 = "           </matrix_set_id>\n";
        String string5 = "           </service_url>\n";
        String string6 = "           </version>\n";
        String string7 = "           </format>\n";
        String string8 = "           </layer>\n";
        String string9 = "           </style>\n";
        String string10 = "           </top_left_corner_x>\n";
        String string11 = "           </top_left_corner_y>\n";
        String string12 = "       <wmts_gettile_request ";
        String string13 = "           <matrix_set_id>\n";
        String string14 = "           <service_url>\n";
        String string15 = "           <version>\n";
        String string16 = "           <format>\n";
        String string17 = "           <layer>\n";
        String string18 = "           <style>\n";
        String string19 = "           <top_left_corner_x>\n";
        String string20 = "           <top_left_corner_y>\n";
        stringBuffer = new StringBuffer("    <theme name=\"" + themeDescriptor.name + "\"" + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + (Double.isInfinite(themeDescriptor.minScale) || themeDescriptor.minScale == Double.POSITIVE_INFINITY ? "" : " min_scale=\"" + themeDescriptor.minScale + "\"") + (Double.isInfinite(themeDescriptor.maxScale) || themeDescriptor.maxScale == Double.NEGATIVE_INFINITY ? "" : " max_scale=\"" + themeDescriptor.maxScale + "\"") + (themeDescriptor.scaleType != null && themeDescriptor.scaleType.equalsIgnoreCase("RATIO") ? " scale_mode=\"" + themeDescriptor.scaleType.toLowerCase() + "\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.visibleInSVG ? " visible_in_svg=\"false\"" : "") + (themeDescriptor.snapToTileScale ? " snap_to_tile_scale=\"true\"" : "") + (!themeDescriptor.tileResizingOption.equalsIgnoreCase("unbiased") ? " tile_resizing_option=\"" + themeDescriptor.tileResizingOption + "\"" : "") + (themeDescriptor.currentThreads != 8 ? " current_threads=\"" + themeDescriptor.currentThreads + "\"" : "") + " >\n");
        stringBuffer.append(string12 + " isBackgroundTheme=\"" + (themeDescriptor.WMTS_IsBackgroundImage ? "true" : "false") + "\" >\n");
        if (themeDescriptor.authUser != null) {
            stringBuffer.append("           <user> " + themeDescriptor.authUser + " </user>\n");
        }
        if (themeDescriptor.authPassword != null) {
            stringBuffer.append("           <password> " + themeDescriptor.authPassword + " </password>\n");
        }
        stringBuffer.append(string14 + "\t\t " + themeDescriptor.WMTS_ServiceURLPrefix + "\n" + string5);
        stringBuffer.append(string15 + "\t\t " + themeDescriptor.WMTS_Version + "\n" + string6);
        stringBuffer.append(string16 + "\t\t " + themeDescriptor.WMTS_Format + "\n" + string7);
        stringBuffer.append(string17);
        stringBuffer.append("\t\t " + themeDescriptor.WMTS_Layer);
        stringBuffer.append("\n" + string8);
        stringBuffer.append(string13);
        stringBuffer.append("\t\t " + themeDescriptor.WMTS_MatrixSetID);
        stringBuffer.append("\n" + string4);
        stringBuffer.append(string18);
        if (themeDescriptor.WMTS_Style != null) {
            stringBuffer.append("\t\t " + themeDescriptor.WMTS_Style);
        } else {
            stringBuffer.append("\t\t default");
        }
        stringBuffer.append("\n" + string9);
        if (!Double.isNaN(themeDescriptor.WMTS_TopLeftCornerX) && !Double.isNaN(themeDescriptor.WMTS_TopLeftCornerY)) {
            stringBuffer.append(string19);
            stringBuffer.append("\t\t " + themeDescriptor.WMTS_TopLeftCornerX);
            stringBuffer.append("\n" + string10);
            stringBuffer.append(string20);
            stringBuffer.append("\t\t " + themeDescriptor.WMTS_TopLeftCornerY);
            stringBuffer.append("\n" + string11);
        }
        stringBuffer.append(string3);
        stringBuffer.append(string2);
        string = new String(stringBuffer);
        return string;
    }

    private String convertCustomGeometryTheme(ThemeDescriptor themeDescriptor) {
        String string = null;
        if (themeDescriptor.WFS_attributeList != null) {
            string = themeDescriptor.WFS_attributeList[0];
            for (int i = 1; i < themeDescriptor.WFS_attributeList.length; ++i) {
                string = string + "," + themeDescriptor.WFS_attributeList[i];
            }
        }
        String string2 = this.convertCustomGeometryThemeParameters(themeDescriptor);
        return "    <theme name=\"" + themeDescriptor.name + "\"" + this.getScaleParameters(themeDescriptor) + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + " >\n" + "       <custom_geom_theme \n" + (themeDescriptor.providerId != null ? "         provider_id=\"" + themeDescriptor.providerId + "\"\n" : "") + "         srid=\"" + themeDescriptor.SRID + "\"\n" + (themeDescriptor.renderStyleName != null ? "         render_style=\"" + themeDescriptor.renderStyleName + "\"\n" : "") + (themeDescriptor.labelColumn != null ? "         label_column=\"" + themeDescriptor.labelColumn + "\"\n" : "") + (themeDescriptor.labelStyleName != null ? "         label_style=\"" + themeDescriptor.labelStyleName + "\"\n" : "") + (themeDescriptor.keyColumn != null ? "         key_column=\"" + themeDescriptor.keyColumn + "\"\n" : "") + (string != null ? "         feature_attributes=\"" + string + "\"\n" : "") + (themeDescriptor.WFS_queryCondition != null ? "         query_condition=\"" + themeDescriptor.WFS_queryCondition + "\"\n" : "") + "         asis=\"" + themeDescriptor.passThrough + "\"\n" + (themeDescriptor.dataSource != null ? "         datasource=\"" + themeDescriptor.dataSource + "\">\n" : "") + string2 + "      </custom_geom_theme>\n" + "    </theme>\n";
    }

    private String convertLRSTheme(ThemeDescriptor themeDescriptor) {
        String string = themeDescriptor.dataSource == null ? "" : " datasource=\"" + themeDescriptor.dataSource + "\"";
        String string2 = "    <theme name=\"" + themeDescriptor.name + "\" " + "type=\"lrs\" " + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getScaleParameters(themeDescriptor) + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + this.getTimeout(themeDescriptor) + (!themeDescriptor.fastUnpickle ? " fast_unpickle=\"false\"" : "") + (!themeDescriptor.upsideDownLabels ? "" : " upside_down_labels=\"true\"") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.labelAlwaysOn ? " label_always_on=\"true\"" : "") + (themeDescriptor.minDistBetweenPoints != 0.5 ? " min_dist=\"" + themeDescriptor.minDistBetweenPoints + "\"" : "") + (!themeDescriptor.visibleInSVG ? " visible_in_svg=\"false\"" : "") + (themeDescriptor.selectableInSVG ? " selectable_in_svg=\"true\"" : "") + (themeDescriptor.fixedSVGLabel ? " fixed_svglabel=\"true\"" : "") + (themeDescriptor.onClickInSVG != null ? " onclick=\"" + themeDescriptor.onClickInSVG + "\"" : "") + (themeDescriptor.onMouseMoveInSVG != null ? " onmousemove=\"" + themeDescriptor.onMouseMoveInSVG + "\"" : "") + (themeDescriptor.onMouseOverInSVG != null ? " onmouseover=\"" + themeDescriptor.onMouseOverInSVG + "\"" : "") + (themeDescriptor.onMouseOutInSVG != null ? " onmouseout=\"" + themeDescriptor.onMouseOutInSVG + "\"" : "") + (themeDescriptor.minimumFeatureSizePx > 0 ? " minimum_pixels=\"" + themeDescriptor.minimumFeatureSizePx + "\"" : "") + (!themeDescriptor.simplifiedShapes ? " simplify_shapes=\"false\"" : "") + (themeDescriptor.noRepetitiveLabel ? " no_repetitive_label=\"true\"" : "") + (!themeDescriptor.allowNakedPoints ? " allow_naked_points=\"false\"" : "") + this.getWorkspaceParameters(themeDescriptor) + (themeDescriptor.partOfBaseMap ? " part_of_basemap=\"true\"" : "") + (!themeDescriptor.renderLabels ? " render_labels=\"false\"" : "") + (themeDescriptor.templateTheme != null ? " template_theme=\"" + themeDescriptor.templateTheme + "\"" : "") + string + (themeDescriptor.snapToTileScale ? " snap_to_tile_scale=\"true\"" : "") + (!themeDescriptor.tileResizingOption.equalsIgnoreCase("unbiased") ? " tile_resizing_option=\"" + themeDescriptor.tileResizingOption + "\"" : "") + (themeDescriptor.currentThreads != 8 ? " current_threads=\"" + themeDescriptor.currentThreads + "\"" : "") + (!(themeDescriptor.dynamicParameters != null && themeDescriptor.dynamicParameters.length != 0 || themeDescriptor.operationNames != null && themeDescriptor.operationNames.length != 0 || themeDescriptor.renderRules != null && themeDescriptor.renderRules.length != 0 || themeDescriptor.bitmapMasks != null && themeDescriptor.bitmapMasks.length != 0 || themeDescriptor.providerRuntimeProperties != null && themeDescriptor.providerRuntimeProperties.size() != 0) ? " />\n" : ">\n" + this.convertPTParameters(themeDescriptor.dynamicParameters) + this.convertThemeOperations(themeDescriptor) + this.convertGeoRasterThemeBitmapMasks(themeDescriptor) + this.convertRenderingRules(themeDescriptor) + this.convertCustomGeometryThemeParameters(themeDescriptor) + "    </theme>\n");
        return string2;
    }

    private String convertCustomGeometryThemeParameters(ThemeDescriptor themeDescriptor) {
        if (themeDescriptor == null) {
            return "";
        }
        if (themeDescriptor.providerRuntimeProperties == null || themeDescriptor.providerRuntimeProperties.size() == 0) {
            return "";
        }
        String string = "       <parameters>\n";
        if (themeDescriptor.providerRuntimeProperties != null && themeDescriptor.providerRuntimeProperties.size() > 0) {
            Enumeration<?> enumeration = themeDescriptor.providerRuntimeProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = themeDescriptor.providerRuntimeProperties.getProperty(string2);
                string = string + "        <parameter name=\"" + string2 + "\" value=\"" + string3 + "\"/>\n";
            }
        }
        string = string + "       </parameters>\n";
        return string;
    }

    private String convertAnnotationTextTheme(ThemeDescriptor themeDescriptor) {
        return "    <theme name=\"" + themeDescriptor.name + "\"" + (Double.isInfinite(themeDescriptor.minScale) || themeDescriptor.minScale == Double.POSITIVE_INFINITY ? "" : " min_scale=\"" + themeDescriptor.minScale + "\"") + (Double.isInfinite(themeDescriptor.maxScale) || themeDescriptor.maxScale == Double.NEGATIVE_INFINITY ? "" : " max_scale=\"" + themeDescriptor.maxScale + "\"") + (themeDescriptor.scaleType != null && themeDescriptor.scaleType.equalsIgnoreCase("RATIO") ? " scale_mode=\"" + themeDescriptor.scaleType.toLowerCase() + "\"" : "") + (themeDescriptor.fetchSize > 0 && themeDescriptor.fetchSize != 100 ? " fetch_size=\"" + themeDescriptor.fetchSize + "\"" : "") + (themeDescriptor.clickable ? " user_clickable=\"true\"" : "") + (themeDescriptor.opacity >= 0.0f && themeDescriptor.opacity < 1.0f ? " transparency=\"" + themeDescriptor.opacity + "\"" : "") + this.getWorkspaceParameters(themeDescriptor) + " >\n" + "       <jdbc_annotation_query\n" + "         annotation_table=\"" + themeDescriptor.featureTableName + "\"\n" + "         annotation_column=\"" + themeDescriptor.spatialColumn + "\"\n" + (themeDescriptor.labelColumn != null ? "         textexpr_column=\"" + themeDescriptor.labelColumn + "\"\n" : "") + (themeDescriptor.keyColumn != null ? "         key_column=\"" + themeDescriptor.keyColumn + "\"\n" : "") + (themeDescriptor.renderStyleName != null ? "         leaderline_style=\"" + themeDescriptor.renderStyleName + "\"\n" : "") + (themeDescriptor.highlightTextColor != null ? "         highlight_text_color=\"" + themeDescriptor.highlightTextColor + "\"\n" : "") + (themeDescriptor.highlightLeaderLineColor != null ? "         highlight_leaderline_color=\"" + themeDescriptor.highlightLeaderLineColor + "\"\n" : "") + "         jdbc_srid=\"" + themeDescriptor.SRID + "\"\n" + "         datasource=\"" + themeDescriptor.dataSource + "\"\n" + "         asis=\"" + themeDescriptor.passThrough + "\">" + MapViewer.doXMLEscape(themeDescriptor.query) + "\n       </jdbc_annotation_query>\n" + "     </theme>\n";
    }

    private String convertThemeOperations(ThemeDescriptor themeDescriptor) {
        String string = "";
        if (themeDescriptor == null) {
            return string;
        }
        if (themeDescriptor.operationNames == null) {
            return string;
        }
        string = string + "      <operations>\n";
        for (int i = 0; i < themeDescriptor.operationNames.length; ++i) {
            string = string + "        <operation name=\"" + themeDescriptor.operationNames[i] + "\">\n";
            if (themeDescriptor.operationParameters == null) {
                string = string + "        </operation>\n";
                continue;
            }
            Hashtable hashtable = (Hashtable)themeDescriptor.operationParameters.get(themeDescriptor.operationNames[i]);
            if (hashtable == null || hashtable.size() < 1) {
                string = string + "        </operation>\n";
                continue;
            }
            String[] stringArray = new String[hashtable.size()];
            int n = 0;
            Object[] objectArray = hashtable.keys();
            while (objectArray.hasMoreElements()) {
                stringArray[n] = (String)objectArray.nextElement();
                ++n;
            }
            objectArray = hashtable.values().toArray();
            for (int j = 0; j < hashtable.size(); ++j) {
                string = string + "            <parameter name=\"" + stringArray[j] + "\"" + " value=\"" + objectArray[j].toString() + "\"/>\n";
            }
            string = string + "        </operation>\n";
        }
        string = string + "      </operations>\n";
        return string;
    }

    private String convertGeoRasterThemeBitmapMasks(ThemeDescriptor themeDescriptor) {
        String string = "";
        if (themeDescriptor == null) {
            return string;
        }
        if (themeDescriptor.bitmapMasks == null) {
            return string;
        }
        string = string + "      <bitmap_masks>\n";
        for (int i = 0; i < themeDescriptor.bitmapMasks.length; ++i) {
            if (themeDescriptor.bitmapMasks[i].getLayers() == null) continue;
            String string2 = null;
            int[] nArray = themeDescriptor.bitmapMasks[i].getLayers();
            for (int j = 0; j < themeDescriptor.bitmapMasks[i].getLayers().length; ++j) {
                String string3 = String.valueOf(nArray[j]);
                string2 = j > 0 ? string2 + "," + string3 : string3;
            }
            string = string + "        <mask raster_id=\"" + themeDescriptor.bitmapMasks[i].getRasterId() + "\"" + " raster_table=\"" + themeDescriptor.bitmapMasks[i].getRasterDataTableName() + "\"" + " layers=\"" + string2 + "\"" + " zeromapping=\"" + themeDescriptor.bitmapMasks[i].getZeroMapping() + "\"" + " onemapping=\"" + themeDescriptor.bitmapMasks[i].getOneMapping() + "\" />\n";
        }
        string = string + "      </bitmap_masks>\n";
        return string;
    }

    private String convertCenter() {
        Point2D point2D = this.center == null ? null : this.center.getCenterAsPoint2D();
        String string = this.center.getRenderStyleName() != null ? this.center.getRenderStyleName() : this.defCenterStyleName;
        String string2 = this.center.getLabelStyleName() != null ? this.center.getLabelStyleName() : this.defCenterLabelStyleName;
        String string3 = this.center.getLabel() != null ? this.center.getLabel() : this.defCenterLabel;
        double[] dArray = this.center.getRadius() != null ? this.center.getRadius() : this.defCenterRadii;
        String string4 = "";
        if (dArray != null && dArray.length > 0) {
            string4 = " radius=\"";
            for (int i = 0; i < dArray.length - 1; ++i) {
                string4 = string4 + dArray[i] + ",";
            }
            string4 = string4 + dArray[dArray.length - 1] + "\"";
        }
        String string5 = this.boundsSrid == 0 ? "" : " srsName=\"SDO:" + this.boundsSrid + "\"";
        String string6 = " size=\"" + this.size + "\"";
        if (this.size == 0.0 && this.mapScale != Long.MAX_VALUE) {
            string6 = " scale=\"" + Math.abs(this.mapScale) + "\"";
        }
        return "  <center" + string6 + ">\n" + "    <geoFeature" + (string != null ? " render_style=\"" + string + "\"" : "") + (string3 != null && string2 != null ? " text_style=\"" + string2 + "\" label=\"" + string3 + "\"" : "") + string4 + ">\n" + "      <geometricProperty typeName=\"center\">\n" + "        <Point" + string5 + ">\n" + "          <coordinates>" + point2D.getX() + "," + point2D.getY() + "</coordinates>\n" + "        </Point>\n" + "      </geometricProperty>\n" + "    </geoFeature>\n" + "  </center>\n";
    }

    private String convertBox() {
        String string = this.boundsSrid == 0 ? "" : " srsName=\"SDO:" + this.boundsSrid + "\"";
        String string2 = "";
        if (this.preserveBoxAspect) {
            string2 = " preserve_aspect_ratio=\"true\"";
        }
        return "  <box" + string + string2 + ">\n" + "    <coordinates>" + this.queryWindow[0] + "," + this.queryWindow[1] + " " + this.queryWindow[2] + "," + this.queryWindow[3] + "</coordinates>\n" + "  </box>\n";
    }

    private String centerOrBox() {
        if (this.center != null) {
            return this.convertCenter();
        }
        if (this.queryWindow != null) {
            return this.convertBox();
        }
        return "";
    }

    private String convertRenderingRules(ThemeDescriptor themeDescriptor) {
        String string = "";
        if (themeDescriptor == null) {
            return string;
        }
        RenderingRule[][] renderingRuleArray = themeDescriptor.renderRules;
        if (renderingRuleArray == null) {
            return string;
        }
        for (int i = 0; i < renderingRuleArray.length; ++i) {
            string = "       <rendering>\n";
            for (int j = 0; j < renderingRuleArray[i].length; ++j) {
                Object object;
                String string2 = renderingRuleArray[i][j].getStyleName();
                if (string2 == null) continue;
                string = string + "        <style name=\"" + string2 + "\"";
                if (renderingRuleArray[i][j].getStyleColumns() != null) {
                    object = renderingRuleArray[i][j].getStyleColumns();
                    string = string + " value_columns=\"" + object[0];
                    for (int k = 1; k < ((String[])object).length; ++k) {
                        string = string + "," + object[k];
                    }
                    string = string + "\"";
                }
                if ((object = renderingRuleArray[i][j].getSubStyleName()) == null) {
                    string = string + "/>\n";
                    continue;
                }
                string = string + ">\n";
                string = string + "         <substyle name=\"" + (String)object + "\"";
                if (renderingRuleArray[i][j].getSubStyleColumns() != null) {
                    String[] stringArray = renderingRuleArray[i][j].getSubStyleColumns();
                    string = string + " value_columns=\"" + stringArray[0];
                    for (int k = 1; k < stringArray.length; ++k) {
                        string = string + "," + stringArray[k];
                    }
                    string = string + "\"";
                }
                string = string + " changes=\"" + renderingRuleArray[i][j].getSubStyleChangeProperty() + "\"/>\n";
                string = string + "        </style>\n";
            }
            string = string + "       </rendering>\n";
        }
        return string;
    }

    public void setMapLegend(String string, String string2, String string3, String string4, String string5, String string6, String[][][] stringArray) {
        string6 = string6 == null ? "" : " font=\"" + string6 + "\"";
        this.mapLegend = "  <legend bgstyle=\"fill:" + string + ";fill-opacity:" + string2 + ";stroke:" + string3 + "\" " + "profile=\"" + string4 + "\" position=\"" + string5 + "\"" + string6 + ">\n";
        this.mapLegend = this.mapLegend + this.getLegendContents(stringArray);
        this.mapLegend = this.mapLegend + "  </legend>\n";
    }

    public void setMapLegend(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String[][][] stringArray) {
        string6 = string6 == null ? "" : " font=\"" + string6 + "\"";
        this.mapLegend = "  <legend bgstyle=\"fill:" + string + ";fill-opacity:" + string2 + ";stroke:" + string3 + "\" " + "profile=\"" + string4 + "\" position=\"" + string5 + "\"" + " offset_x=\"" + n + "\" offset_y=\"" + n2 + "\"" + string6 + ">\n";
        this.mapLegend = this.mapLegend + this.getLegendContents(stringArray);
        this.mapLegend = this.mapLegend + "  </legend>\n";
    }

    public void setMapLegend(String string, String string2, String string3, String string4, int n, int n2, String string5, String[][][] stringArray) {
        string5 = string5 == null ? "" : " font=\"" + string5 + "\"";
        this.mapLegend = "  <legend bgstyle=\"fill:" + string + ";fill-opacity:" + string2 + ";stroke:" + string3 + "\" " + "profile=\"" + string4 + "\" location_x=\"" + n + "\"" + " location_y=\"" + n2 + "\"" + string5 + ">\n";
        this.mapLegend = this.mapLegend + this.getLegendContents(stringArray);
        this.mapLegend = this.mapLegend + "  </legend>\n";
    }

    public void setMapLegendFromThemes(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String[] stringArray) {
        string6 = string6 == null ? "" : " font=\"" + string6 + "\"";
        this.mapLegend = "  <legend bgstyle=\"fill:" + string + ";fill-opacity:" + string2 + ";stroke:" + string3 + "\" " + "profile=\"" + string4 + "\" position=\"" + string5 + "\"" + " offset_x=\"" + n + "\" offset_y=\"" + n2 + "\"" + string6 + ">\n";
        if (stringArray != null && stringArray.length > 0) {
            this.mapLegend = this.mapLegend + "    <themes>\n";
            for (int i = 0; i < stringArray.length; ++i) {
                this.mapLegend = this.mapLegend + "     <theme name=\"" + stringArray[i] + "\" />\n";
            }
            this.mapLegend = this.mapLegend + "    </themes>\n";
        }
        this.mapLegend = this.mapLegend + "  </legend>\n";
    }

    public void setMapLegendFromThemes(String string, String string2, String string3, String string4, int n, int n2, String string5, String[] stringArray) {
        string5 = string5 == null ? "" : " font=\"" + string5 + "\"";
        this.mapLegend = "  <legend bgstyle=\"fill:" + string + ";fill-opacity:" + string2 + ";stroke:" + string3 + "\" " + "profile=\"" + string4 + "\" location_x=\"" + n + "\"" + " location_y=\"" + n2 + "\"" + string5 + ">\n";
        if (stringArray != null && stringArray.length > 0) {
            this.mapLegend = this.mapLegend + "    <themes>\n";
            for (int i = 0; i < stringArray.length; ++i) {
                this.mapLegend = this.mapLegend + "     <theme name=\"" + stringArray[i] + "\" />\n";
            }
            this.mapLegend = this.mapLegend + "    </themes>\n";
        }
        this.mapLegend = this.mapLegend + "  </legend>\n";
    }

    private String getLegendContents(String[][][] stringArray) {
        String string = "";
        if (stringArray == null) {
            return string;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "    <column>\n";
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (stringArray[i][j][2].equalsIgnoreCase("true")) {
                    string = string + "      <entry ";
                    if (stringArray[i][j][1] != null) {
                        string = string + "style=\"" + stringArray[i][j][1] + "\" ";
                    }
                    if (stringArray[i][j][0] != null) {
                        string = string + "text=\"" + stringArray[i][j][0] + "\" ";
                    }
                    string = string + "is_title=\"true\" />\n";
                    continue;
                }
                if (stringArray[i][j][4].equalsIgnoreCase("true")) {
                    string = string + "      <entry is_separator=\"true\" />\n";
                    continue;
                }
                string = string + "      <entry ";
                if (stringArray[i][j][1] != null) {
                    string = string + "style=\"" + stringArray[i][j][1] + "\" ";
                }
                if (stringArray[i][j][0] != null) {
                    string = string + "text=\"" + stringArray[i][j][0] + "\" ";
                }
                if (stringArray[i][j][3] != null) {
                    string = string + "tab=\"" + stringArray[i][j][3] + "\" ";
                }
                string = string + "/>\n";
            }
            string = string + "    </column>\n";
        }
        return string;
    }

    public void deleteMapLegend() {
        this.mapLegend = null;
    }

    public void setSRID(int n) {
        this.SRid = n < 0 ? 0 : n;
    }

    public int getSRID() {
        return this.SRid;
    }

    public void setMapFileName(String string) {
        this.mapFileName = string;
    }

    public String getMapFileName() {
        return this.mapFileName;
    }

    public void setSVGZoomRatio(double d) {
        this.svgZoomRatio = d;
    }

    public void setShowSVGNavBar(boolean bl) {
        this.showSVGNavBar = bl;
    }

    public void setSVGZoomLevels(int n) {
        this.svgZoomLevels = n;
    }

    public void setSVGShowInfo(boolean bl) {
        this.svgShowInfo = bl;
    }

    public void setSVGZoomFactor(double d) {
        this.svgZoomFactor = d;
    }

    public void setSVGOnClick(String string) {
        this.onClick = string;
    }

    public void setSVGOnMouseMove(String string) {
        this.onMouseMove = string;
    }

    public void setSVGOnRectangleSelect(String string) {
        this.onRectangleSelect = string;
    }

    public void setSVGOnPolygonSelect(String string) {
        this.onPolygonSelect = string;
    }

    public void setRenderRasterBaseMapInSVG(boolean bl) {
        this.renderRasterBaseMap = bl;
    }

    public void setBoundingThemes(String[] stringArray, float f, boolean bl) {
        if (stringArray == null) {
            this.boundingThemes = null;
            return;
        }
        this.boundingThemes = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.boundingThemes[i] = stringArray[i];
        }
        this.boundingThemeBorderMargin = f < 0.0f ? 0.05f : f;
        this.boundingThemeKeepAspectRatio = bl;
    }

    public void setBoundingThemesSizeHint(double d) {
        this.boundingSizeHint = d;
    }

    public String[] getBoundingThemes() {
        return this.boundingThemes;
    }

    public float getBorderMarginForBoundingThemes() {
        return this.boundingThemeBorderMargin;
    }

    public boolean boundingThemesRespectAspectRatio() {
        return this.boundingThemeKeepAspectRatio;
    }

    public double getBoundingThemesSizeHint() {
        return this.boundingSizeHint;
    }

    public void clearBoundingThemes() {
        this.boundingThemes = null;
    }

    public void setSVGFragmentType(int n) {
        this.svgFragmentType = n;
        this.imageFormat = 16;
    }

    public void setSVGFragmentInDeviceCoord(boolean bl) {
        this.svgFragmentInDeviceCoord = bl;
    }

    private String getWorkspaceParameters(ThemeDescriptor themeDescriptor) {
        return "" + (themeDescriptor.workspaceName != null ? "  workspace_name=\"" + themeDescriptor.workspaceName + "\" " : "") + (themeDescriptor.workspaceName != null && themeDescriptor.workspaceSavedPoint != null ? "  workspace_savepoint=\"" + themeDescriptor.workspaceSavedPoint + "\" " : "") + (themeDescriptor.workspaceName != null && themeDescriptor.workspaceDate != null ? "  workspace_date=\"" + themeDescriptor.workspaceDate + "\" " : "") + (themeDescriptor.workspaceName != null && themeDescriptor.workspaceDate != null && !themeDescriptor.workspaceDateFormat.equals("mmddyyyyhh24miss") ? "  workspace_date_format=\"" + themeDescriptor.workspaceDateFormat + "\" " : "") + (themeDescriptor.workspaceName != null && themeDescriptor.workspaceDate != null && themeDescriptor.workspaceDateNlsParam != null ? "  workspace_date_nlsparam=\"" + themeDescriptor.workspaceDateNlsParam + "\" " : "") + (themeDescriptor.workspaceName != null && themeDescriptor.workspaceDate != null && themeDescriptor.workspaceDateTsWtz ? "  workspace_date_tswtz=\"" + themeDescriptor.workspaceDateTsWtz + "\" " : "");
    }

    private String getTimeout(ThemeDescriptor themeDescriptor) {
        return themeDescriptor.requestTimeout > 0L ? " timeout=\"" + themeDescriptor.requestTimeout + "\" " : "";
    }

    private String convertScaleBar() {
        if (this.scaleBar == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("  <scale_bar \n");
        stringBuffer.append("    position=\"" + this.scaleBar.getPosition() + "\"\n");
        if (this.scaleBar.getOffsetX() > 0) {
            stringBuffer.append("    offset_x=\"" + this.scaleBar.getOffsetX() + "\"\n");
        }
        if (this.scaleBar.getOffsetY() > 0) {
            stringBuffer.append("    offset_y=\"" + this.scaleBar.getOffsetY() + "\"\n");
        }
        if (this.scaleBar.getLabelPosition() != null && this.scaleBar.getLabelPosition().equalsIgnoreCase("BOTTOM")) {
            stringBuffer.append("    label_position=\"" + this.scaleBar.getLabelPosition() + "\"\n");
        }
        stringBuffer.append("    mode=\"" + this.scaleBar.getMode() + "\"\n");
        if (this.scaleBar.getLengthHint() > 0) {
            stringBuffer.append("    length_hint=\"" + this.scaleBar.getLengthHint() + "\"\n");
        }
        if (this.scaleBar.getColor1() != ScaleBarDef.DEFAULT_COLOR1) {
            stringBuffer.append("    color1=\"#" + Integer.toHexString(this.scaleBar.getColor1().getRGB()).substring(2) + "\"\n");
            if (this.scaleBar.getColor1().getAlpha() < 255) {
                stringBuffer.append("    color1_opacity=\"" + this.scaleBar.getColor1().getAlpha() + "\"\n");
            }
        }
        if (this.scaleBar.getColor2() != ScaleBarDef.DEFAULT_COLOR2) {
            stringBuffer.append("    color2=\"#" + Integer.toHexString(this.scaleBar.getColor2().getRGB()).substring(2) + "\"\n");
            if (this.scaleBar.getColor2().getAlpha() < 255) {
                stringBuffer.append("    color2_opacity=\"" + this.scaleBar.getColor2().getAlpha() + "\"\n");
            }
        }
        stringBuffer.append("    label_color=\"#" + Integer.toHexString(this.scaleBar.getLabelColor().getRGB()).substring(2) + "\"\n");
        if (this.scaleBar.getLabelColor().getAlpha() < 255) {
            stringBuffer.append("    label_color_opacity=\"" + this.scaleBar.getLabelColor().getAlpha() + "\"\n");
        }
        if (this.scaleBar.getLabelFont() != ScaleBarDef.DEFAULT_FONT) {
            stringBuffer.append("    label_font_family=\"" + this.scaleBar.getLabelFont().getFamily() + "\"\n");
            stringBuffer.append("    label_font_size=\"" + this.scaleBar.getLabelFont().getSize() + "\"\n");
            if (this.scaleBar.getLabelFont().getStyle() != 0) {
                if (this.scaleBar.getLabelFont().isItalic()) {
                    stringBuffer.append("    label_font_style=\"italic\"\n");
                }
                if (this.scaleBar.getLabelFont().isBold()) {
                    stringBuffer.append("    label_font_weight=\"bold\"\n");
                }
            }
        }
        if (this.scaleBar.getLabelHaloSize() > 0.0f) {
            stringBuffer.append("    label_halo_size=\"" + this.scaleBar.getLabelHaloSize() + "\"\n");
        }
        stringBuffer.append(" />\n");
        return stringBuffer.toString();
    }

    public Object putCustomProperty(Object object, Object object2) {
        if (this.customProp == null) {
            this.customProp = new Hashtable(13);
        }
        return this.customProp.put(object, object2);
    }

    public Object getCustomProperty(Object object) {
        return this.customProp == null ? null : this.customProp.get(object);
    }

    private String convertCustomProps() {
        if (this.customProp == null || this.customProp.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        Enumeration enumeration = this.customProp.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.customProp.get(k);
            stringBuffer.append("  <custom_property name=\"" + k + "\">");
            stringBuffer.append("" + v);
            stringBuffer.append("</custom_property>\n");
        }
        return stringBuffer.toString();
    }

    public Object removeCustomProperty(Object object) {
        return this.customProp == null ? null : this.customProp.remove(object);
    }

    public void clearCustomProperties() {
        if (this.customProp != null) {
            this.customProp.clear();
        }
        this.customProp = null;
    }

    public boolean getKeepThemesOrder() {
        return this.keepThemesOrder;
    }

    public void setKeepThemesOrder(boolean bl) {
        this.keepThemesOrder = bl;
    }

    public void addNsDp(NsDpInfo nsDpInfo) {
        if (this.nsdps == null) {
            this.nsdps = new Vector();
        }
        this.nsdps.add(nsDpInfo);
    }

    public void removeNsDp(NsDpInfo nsDpInfo) {
        if (this.nsdps == null || this.nsdps.size() == 0) {
            return;
        }
        this.nsdps.remove(nsDpInfo);
    }

    public void removeAllNsDps() {
        if (this.nsdps != null) {
            this.nsdps.removeAllElements();
        }
    }

    public Vector getNsDps() {
        return this.nsdps;
    }

    public void setUseCachedBaseMap(boolean bl) {
        this.useCachedBaseMap = bl;
    }

    public void setSnapToCachedZoomLevel(boolean bl) {
        this.snapToCachedZoomLevel = bl;
    }

    private String convertNsDps() {
        if (this.nsdps == null || this.nsdps.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nsdps.size(); ++i) {
            NsDpInfo nsDpInfo = (NsDpInfo)this.nsdps.get(i);
            stringBuffer.append("  <ns_data_provider provider_id=\"" + nsDpInfo.getDpId() + "\">\n");
            stringBuffer.append("    <for_theme name=\"" + nsDpInfo.getTheme() + "\"/>\n");
            stringBuffer.append("    <join spatial_key_column=\"" + nsDpInfo.getJoinColumnSpatial() + "\"/>\n");
            stringBuffer.append("    <custom_rendering_style name=\"" + nsDpInfo.getCustomRenderStyle() + "\"/>\n");
            stringBuffer.append("    <parameters>\n");
            Properties properties = nsDpInfo.getDpParams();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                stringBuffer.append("     <parameter name=\"" + string + "\" value=\"" + string2 + "\"/>\n");
            }
            stringBuffer.append("    </parameters>\n");
            stringBuffer.append("  </ns_data_provider>\n");
        }
        return stringBuffer.toString();
    }

    public Hashtable getThemeModifiers() {
        return this.themeModifiers;
    }

    public void addThemeModifier(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return;
        }
        Hashtable<String, String> hashtable = (Hashtable<String, String>)this.themeModifiers.get(string.toUpperCase());
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>(3);
            this.themeModifiers.put(string.toUpperCase(), hashtable);
        }
        hashtable.put(string2, string3);
    }

    public void removeThemeModifier(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.themeModifiers.get(string.toUpperCase());
        if (hashtable == null) {
            return;
        }
        hashtable.remove(string2);
        if (hashtable.size() == 0) {
            this.removeThemeModifiers(string);
        }
    }

    public void removeThemeModifiers(String string) {
        if (string == null) {
            return;
        }
        this.themeModifiers.remove(string.toUpperCase());
    }

    public void removeAllThemeModifiers() {
        this.themeModifiers.clear();
    }

    public void setSVGInfoFont(String string) {
        this.svgInfoFont = string;
    }

    public void setMapPiecesRendered(boolean bl) {
        this.disableMapPieces = !bl;
    }

    public boolean isMapPiecesRendered() {
        return !this.disableMapPieces;
    }

    public void setFootnote(String string) {
        this.footnote = string;
    }

    public String getFootnote() {
        return this.footnote;
    }

    public String getFootnoteStyleName() {
        return this.footnoteStyle;
    }

    public void setFootnoteStyleName(String string) {
        this.footnoteStyle = string;
    }

    public void setIsTileRequest(boolean bl) {
        this.isTileRequest = bl;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String getDeviceSizeUnit() {
        return this.deviceSizeUnit;
    }

    public void setDeviceSizeUnit(String string) {
        this.deviceSizeUnit = string;
    }

    public int getDeviceDPI() {
        return this.dpi;
    }

    public void setDeviceDPI(int n) {
        if (n < 0) {
            return;
        }
        this.dpi = n;
    }
}

