/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapcommon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.mapviewer.share.MapFormats;
import oracle.sdovis.LiveFeature;

public class MapResponse
implements Serializable,
MapFormats {
    static final long serialVersionUID = -3854084457594740563L;
    protected Object imageData = null;
    protected Throwable exception = null;
    protected AffineTransform transform = null;
    protected double rotation = 0.0;
    protected double[] mbr = null;
    protected String status = "SUCCESS";
    protected Dimension deviceSize = null;
    protected double currentScale = 0.0;
    protected String[] themeNames = null;
    protected int imageFormat = 9;
    protected int imageSize = 0;
    protected LiveFeature[] liveFeatures = new LiveFeature[0];
    protected double[] proj;
    protected int srid = 0;
    private static Component sComponent = null;
    private static MediaTracker sTracker = null;
    private static int sID = 0;

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setAffineTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public AffineTransform getAffineTransform() {
        return this.transform;
    }

    public void setMapProjectionParams(double[] dArray) {
        this.proj = dArray;
    }

    public double[] getMapProjectionParams() {
        return this.proj;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable throwable) {
        this.exception = throwable;
    }

    public double[] getMBR() {
        return this.mbr;
    }

    public Dimension getDeviceSize() {
        return this.deviceSize;
    }

    public void setDeviceSize(Dimension dimension) {
        this.deviceSize = dimension;
    }

    public double getCurrentScale() {
        return this.currentScale;
    }

    public void setCurrentScale(double d) {
        this.currentScale = d;
    }

    public String[] getThemeNames() {
        return this.themeNames;
    }

    public void setThemeNames(String[] stringArray) {
        this.themeNames = stringArray;
    }

    public double[] getMbr() {
        return this.mbr;
    }

    public void setMbr(double[] dArray) {
        this.mbr = dArray;
    }

    public LiveFeature[] getLiveFeatures() {
        return this.liveFeatures;
    }

    public void setLiveFeatures(LiveFeature[] liveFeatureArray) {
        this.liveFeatures = liveFeatureArray;
    }

    public int getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(int n) {
        this.imageFormat = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int n;
        if (sTracker == null) {
            sComponent = new Component(){};
            sTracker = new MediaTracker(sComponent);
        }
        Component component = sComponent;
        synchronized (component) {
            n = sID++;
        }
        sTracker.addImage(image, n);
        try {
            sTracker.waitForID(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace(System.err);
            return false;
        }
        return !sTracker.isErrorID(n);
    }

    public static void removeImageFromTracker(Image image) {
        if (image != null && sTracker != null) {
            sTracker.removeImage(image);
        }
    }

    public Image getImage() {
        if (this.imageData == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        Image image = null;
        int n = (int)this.deviceSize.getWidth();
        int n2 = (int)this.deviceSize.getHeight();
        switch (this.imageFormat) {
            case 1: {
                image = Toolkit.getDefaultToolkit().createImage((byte[])this.imageData);
                MapResponse.waitForImage(image);
                break;
            }
            case 9: {
                try {
                    if (this.imageData != null && this.imageData instanceof byte[]) {
                        this.imageData = this.unzipIntArray((byte[])this.imageData, this.imageSize);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                    return null;
                }
            }
            case 0: {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                ColorModel colorModel = ColorModel.getRGBdefault();
                image = toolkit.createImage(new MemoryImageSource(n, n2, colorModel, (int[])this.imageData, 0, n));
                break;
            }
            case 29: {
                return (Image)this.imageData;
            }
            default: {
                return null;
            }
        }
        long l2 = System.currentTimeMillis();
        return image;
    }

    public byte[] getGIFImage() {
        if (this.imageFormat != 1 && this.imageFormat != 7) {
            return null;
        }
        return (byte[])this.imageData;
    }

    public String getImageURL() {
        if (this.imageFormat != 3) {
            return null;
        }
        return (String)this.imageData;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.imageData);
        objectOutputStream.writeObject(this.exception);
        objectOutputStream.writeObject(this.transform);
        objectOutputStream.writeObject(this.mbr);
        objectOutputStream.writeObject(this.status);
        objectOutputStream.writeObject(this.deviceSize);
        objectOutputStream.writeDouble(this.currentScale);
        objectOutputStream.writeObject(this.themeNames);
        objectOutputStream.writeInt(this.imageFormat);
        objectOutputStream.writeInt(this.imageSize);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeObject(this.proj);
        objectOutputStream.writeObject(this.liveFeatures);
        objectOutputStream.writeDouble(this.rotation);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.imageData = objectInputStream.readObject();
        this.exception = (Throwable)objectInputStream.readObject();
        this.transform = (AffineTransform)objectInputStream.readObject();
        this.mbr = (double[])objectInputStream.readObject();
        this.status = (String)objectInputStream.readObject();
        this.deviceSize = (Dimension)objectInputStream.readObject();
        this.currentScale = objectInputStream.readDouble();
        this.themeNames = (String[])objectInputStream.readObject();
        this.imageFormat = objectInputStream.readInt();
        this.imageSize = objectInputStream.readInt();
        this.srid = objectInputStream.readInt();
        this.proj = (double[])objectInputStream.readObject();
        this.liveFeatures = (LiveFeature[])objectInputStream.readObject();
        this.rotation = objectInputStream.readDouble();
    }

    public static byte[] zipIntArray(int[] nArray) throws IOException {
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            int n = i * 4;
            int n2 = nArray[i];
            byArray[n] = (byte)n2;
            byArray[n + 1] = (byte)(n2 >>= 8);
            byArray[n + 2] = (byte)(n2 >>= 8);
            byArray[n + 3] = (byte)(n2 >>= 8);
        }
        long l = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(nArray.length / 2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
        zipOutputStream.putNextEntry(new ZipEntry("image"));
        zipOutputStream.write(byArray);
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        long l2 = System.currentTimeMillis();
        return byArray2;
    }

    private final int[] unzipIntArray(byte[] byArray, int n) throws IOException {
        long l = System.currentTimeMillis();
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        int n2 = 0;
        int n3 = 0;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[4096];
        while (zipInputStream.getNextEntry() != null) {
            while ((n2 = zipInputStream.read(byArray3)) > 0) {
                System.arraycopy(byArray3, 0, byArray2, n3, n2);
                n3 += n2;
            }
        }
        zipInputStream.close();
        if (n3 != n) {
            System.err.println("**** unzip error ****");
            return null;
        }
        int[] nArray = new int[n / 4];
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < n / 4; ++i) {
            int n4 = i * 4;
            int n5 = 0xFF & byArray2[n4];
            int n6 = 0xFF & byArray2[n4 + 1];
            int n7 = 0xFF & byArray2[n4 + 2];
            int n8 = 0xFF & byArray2[n4 + 3];
            nArray[i] = (n5 | n6 << 8 | n7 << 16 | n8 << 24) & 0xFFFFFFFF;
        }
        return nArray;
    }

    public void clearImage() {
        this.imageData = null;
    }

    public void setImageData(Object object) {
        this.imageData = object;
    }

    public Object getImageData() {
        return this.imageData;
    }

    public void setImageSize(int n) {
        this.imageSize = n;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(" MapResponse=");
        stringBuffer.append("\n  status=" + this.status);
        stringBuffer.append("\n  imageFormat=" + this.imageFormat);
        if (this.imageFormat == 3) {
            stringBuffer.append("\n  image url=" + (String)this.imageData);
        }
        stringBuffer.append("\n  transform=" + this.transform);
        stringBuffer.append("\n  rotation=" + this.rotation);
        stringBuffer.append("\n  mbr=" + this.mbr);
        stringBuffer.append("\n  currentScale=" + this.currentScale);
        stringBuffer.append("\n  deviceSize=" + this.deviceSize);
        stringBuffer.append("\n  imageSize=" + this.imageSize);
        stringBuffer.append("\n  srid=" + this.srid);
        stringBuffer.append("\n  themeNames=" + this.themeNames);
        if (this.themeNames != null) {
            for (int i = 0; i < this.themeNames.length; ++i) {
                stringBuffer.append("\n    " + this.themeNames[i]);
            }
        }
        return stringBuffer.toString();
    }

    public static String getImageFormatString(int n) {
        switch (n) {
            case 25: {
                return "PNG8_URL";
            }
            case 26: {
                return "PNG8_STREAM";
            }
            case 17: {
                return "SVGTINY_URL";
            }
            case 18: {
                return "SVGTINY_STREAM";
            }
            case 15: {
                return "SVG_URL";
            }
            case 27: {
                return "SVGZ_URL";
            }
            case 16: {
                return "SVG_STREAM";
            }
            case 13: {
                return "PNG_URL";
            }
            case 14: {
                return "PNG_STREAM";
            }
            case 1: {
                return "GIF";
            }
            case 0: {
                return "JAVA_IMAGE";
            }
            case 2: {
                return "BMP";
            }
            case 3: {
                return "GIF_URL";
            }
            case 7: {
                return "GIF_STREAM";
            }
            case 4: {
                return "BMP_URL";
            }
            case 9: {
                return "JAVA_IMAGE_COMPRESSED";
            }
            case 22: {
                return "JPEG_STREAM";
            }
            case 21: {
                return "JPEG_URL";
            }
            case 51: {
                return "PDF_URL";
            }
            case 53: {
                return "PDF_STREAM";
            }
            case 29: {
                return "BUFFERED_IMAGE";
            }
        }
        return "GIF_URL";
    }
}

