/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.awt.Color;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.stylex.AbstractBucketStyleModel;
import oracle.mapviewer.share.stylex.BucketSeries;

public class ColorSchemeStyleModel
extends AbstractBucketStyleModel {
    static final long serialVersionUID = -5145336353321496194L;
    Color baseColor = null;
    Color strokeColor = null;
    float strokeWidth = 1.0f;

    public ColorSchemeStyleModel() {
        this.type = 9;
        this.bucketSeries = new BucketSeries();
        this.baseColor = Color.black;
        this.strokeColor = Color.blue;
    }

    public ColorSchemeStyleModel(BucketSeries bucketSeries) {
        this.type = 9;
        this.bucketSeries = bucketSeries;
        this.baseColor = Color.black;
        this.strokeColor = Color.blue;
    }

    @Override
    public Object clone() {
        ColorSchemeStyleModel colorSchemeStyleModel = (ColorSchemeStyleModel)super.clone();
        return colorSchemeStyleModel;
    }

    @Override
    public String getTypeName() {
        return "ADVANCED";
    }

    @Override
    public String toXMLString() {
        String string = "<?xml version=\"1.0\" ?>\n";
        string = string + "<AdvancedStyle>\n   <ColorSchemeStyle";
        if (this.baseColor != null) {
            string = string + " basecolor=\"" + StyleUtils.getHexidecimalString(this.baseColor) + "\"";
            if (this.baseColor.getAlpha() != 255) {
                string = string + " basecolor_opacity=\"" + this.baseColor.getAlpha() + "\"";
            }
        }
        if (this.strokeColor != null) {
            string = string + " strokecolor=\"" + StyleUtils.getHexidecimalString(this.strokeColor) + "\"";
            if (this.strokeColor.getAlpha() != 255) {
                string = string + " strokecolor_opacity=\"" + this.strokeColor.getAlpha() + "\"";
            }
            if (this.strokeWidth > 1.0f) {
                string = string + " strokewidth=\"" + this.strokeWidth + "\"";
            }
        }
        string = string + ">\n";
        string = string + this.getBucketSeries().toXMLString();
        string = string + "\n   </ColorSchemeStyle>\n</AdvancedStyle>\n";
        return string;
    }

    public void setBaseColor(Color color) {
        this.baseColor = color;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setStrokeColor(Color color) {
        this.strokeColor = color;
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeWidth(float f) {
        this.strokeWidth = f < 1.0f ? 1.0f : f;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public String[] getStyleDependency() {
        return null;
    }
}

