/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSetMetaData;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoResultSet;

public class MongoResultSet
extends AMongoResultSet {
    private RESULTSETTYPE _resultSetType = RESULTSETTYPE.doc;
    private MongoResultSetMetaData _rsMetaData = null;
    Iterator _iterator = null;
    Object _currentObj = null;
    boolean _firstRead = true;
    Statement _stmt = null;

    public MongoResultSet(Object object, RESULTSETTYPE rESULTSETTYPE, Statement statement) {
        this._resultSetType = rESULTSETTYPE;
        this._stmt = statement;
        try {
            if (object instanceof Set) {
                this._iterator = ((Set)object).iterator();
                this.firstNext();
            } else if (object instanceof Double) {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            } else if (object instanceof DBCursor) {
                this._iterator = (DBCursor)object;
                this.firstNext();
            } else if (object instanceof BasicDBList) {
                this._iterator = ((BasicDBList)object).iterator();
                this.firstNext();
            } else if (object instanceof BasicDBObject) {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            } else if (object instanceof CommandResult) {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            } else if (object instanceof List) {
                this._iterator = ((List)object).iterator();
                this.firstNext();
            } else {
                this._iterator = this.makeOneItemIterator(object);
                this.firstNext();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Iterator makeOneItemIterator(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList.iterator();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._rsMetaData == null) {
            this._rsMetaData = new MongoResultSetMetaData(this._currentObj, this._resultSetType);
        }
        return this._rsMetaData;
    }

    @Override
    public boolean next() throws SQLException {
        if (this._firstRead) {
            this._firstRead = false;
            return this._currentObj != null;
        }
        if (this._iterator.hasNext()) {
            this._currentObj = this._iterator.next();
            return true;
        }
        return false;
    }

    public void firstNext() throws SQLException {
        if (this._iterator.hasNext()) {
            this._currentObj = this._iterator.next();
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        Object object = this._currentObj;
        if (this._currentObj instanceof String) {
            object = this._currentObj;
        } else if (this._currentObj instanceof BasicDBObject) {
            object = ((BasicDBObject)this._currentObj).get(this._rsMetaData.getColumnName(n));
            if (object == null && this._rsMetaData.getColumnName(n).equalsIgnoreCase("json")) {
                object = ((BasicDBObject)this._currentObj).toString();
            }
        } else if (this._currentObj instanceof Object[]) {
            object = ((Object[])this._currentObj)[n - 1];
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (this._currentObj instanceof BasicDBObject) {
            return ((BasicDBObject)this._currentObj).get(string);
        }
        return this._currentObj.toString();
    }

    @Override
    public String getString(int n) throws SQLException {
        return this.getObject(n).toString();
    }

    public String toString() {
        return this._currentObj.toString();
    }

    public void setResultSetType(RESULTSETTYPE rESULTSETTYPE) {
        this._resultSetType = rESULTSETTYPE;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._stmt;
    }

    @Override
    public void close() throws SQLException {
        if (this._iterator instanceof DBCursor) {
            ((DBCursor)this._iterator).close();
        }
        this._rsMetaData = null;
        this._currentObj = null;
        this._iterator = null;
        this._stmt = null;
    }

    @Override
    public String getString(String string) throws SQLException {
        return null;
    }

    public static enum RESULTSETTYPE {
        doc,
        table;

    }
}

