/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.graphics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;

public class AnimatedStroke
implements Stroke {
    public static final int MODE_ONEWAY = 0;
    public static final int MODE_TWOWAY = 1;
    private static final int DEFAULT_MODE = 0;
    private static final float[] DEFAULT_DASH = new float[]{5.0f, 3.0f};
    private static final float DEFAULT_SPEED = 0.009f;
    private static final float DEFAULT_WIDTH = 1.0f;
    private static final Color DEFAULT_COLOR = Color.black;
    private float width;
    private int cap;
    private int join;
    private float miterLimit;
    private float[] dash;
    private float speed;
    private float dashSum;
    private Color color;
    private float phase = 0.0f;
    private int mode = 0;
    private boolean backwardFlag = false;

    public AnimatedStroke() {
        this.initDefaults();
    }

    public AnimatedStroke(Color c) {
        this.initDefaults();
        this.color = c;
    }

    public AnimatedStroke(Color c, float speed) {
        this.initDefaults();
        this.color = c;
        this.speed = speed / 1000.0f;
    }

    private void initDefaults() {
        this.color = DEFAULT_COLOR;
        this.dash = DEFAULT_DASH;
        this.speed = 0.009f;
        this.width = 1.0f;
        this.cap = 0;
        this.join = 2;
        this.miterLimit = 1.0f;
        this.dashSum = this.dash[0] + this.dash[1];
    }

    public int getCap() {
        return this.cap;
    }

    public void setCap(int cap) {
        this.cap = cap;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float[] getDash() {
        return this.dash;
    }

    public void setDash(float[] dash) {
        this.dash = dash;
        this.dashSum = 0.0f;
        for (int i = 0; i < dash.length; ++i) {
            this.dashSum += dash[i];
        }
    }

    public int getJoin() {
        return this.join;
    }

    public void setJoin(int join) {
        this.join = join;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(float miterLimit) {
        this.miterLimit = miterLimit;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed / 1000.0f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void update(long elapsedTime) {
        if (this.mode == 0) {
            if (this.backwardFlag) {
                this.phase += (float)elapsedTime * this.speed;
                this.phase %= this.dashSum;
            } else {
                this.phase -= (float)elapsedTime * this.speed;
                if (this.phase < 0.0f) {
                    this.phase = this.dashSum;
                }
            }
            return;
        }
        if (this.mode == 1) {
            float dash1 = this.dash[0];
            this.phase = this.backwardFlag ? (this.phase += (float)elapsedTime * this.speed) : (this.phase -= (float)elapsedTime * this.speed);
            if (this.phase > dash1) {
                this.phase = dash1;
                this.backwardFlag = false;
            } else if (this.phase < 0.0f) {
                this.phase = 0.0f;
                this.backwardFlag = true;
            }
            return;
        }
    }

    public float getPhase() {
        return this.phase;
    }

    public Stroke getStroke() {
        return new BasicStroke(this.width, this.cap, this.join, this.miterLimit, this.dash, this.phase);
    }

    @Override
    public Shape createStrokedShape(Shape p) {
        return this.getStroke().createStrokedShape(p);
    }

    public void setBackwardFlag(boolean backwardFlag) {
        this.backwardFlag = backwardFlag;
    }

    public boolean isBackwardFlag() {
        return this.backwardFlag;
    }
}

