/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.List;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.layer.BasicLayer;

public class PointLayer
extends BasicLayer
implements EditableLayer {
    protected GeoObject[] points;
    protected Image defaultMarker;
    protected Image selectedMarker;
    private GeoDataProducer geoDataProducer;

    public PointLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
    }

    @Override
    public void setEditable(boolean editable) {
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(editable));
    }

    @Override
    public boolean isEditable() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.EditableLayer.editable"));
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean save() {
        return false;
    }

    @Override
    public void clearChanges() {
    }

    @Override
    public void addEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void removeEditChangeListener(EditChangeListener l) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public GeoObject deleteObject(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean insertObject(Object key, GeoObject obj) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GeoObject updateObject(Object key, GeoObject changedObject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GeoObject getObject(Object key) {
        if (this.points == null || this.points.length == 0) {
            return null;
        }
        for (int i = 0; i < this.points.length; ++i) {
            GeoObject o = this.points[i];
            if (o.getKey() == null || key == null || !key.equals(o.getKey())) continue;
            return o;
        }
        return null;
    }

    @Override
    public GeoObject[] getObjects() {
        return this.points;
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GeoDataProducer getGeoDataProducer() {
        return this.geoDataProducer;
    }

    public void setGeoDataProducer(GeoDataProducer producer) {
        this.geoDataProducer = producer;
    }

    @Override
    public boolean propagateEvent(EventObject evt) {
        return false;
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isMyEvent(EventObject evt) {
        return true;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        MapRegion region;
        if (this.geoDataProducer != null && (region = this.canvas.getMapRegion()) != null) {
            this.geoDataProducer.loadData(region.getDataWindow(), region.getDataWindowSrid());
        }
    }

    @Override
    public long render(Graphics2D g) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rectangle2D getDataMBR() {
        if (this.geoDataProducer != null) {
            return this.geoDataProducer.getDataMBR();
        }
        return null;
    }
}

