/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.tools.BasicTool;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologySet;

public class TopoChildFeaturePickTool
extends BasicTool {
    public static final String ASSIGNCHILDFEATURE = "assignchildfeature";
    public static final String UNASSIGNCHIDLFEATURE = "removechildfeature";
    private String modifier = null;
    public static int ADD_EDIT_MODE = 1;
    public static int REMOVE_EDIT_MODE = 2;
    private boolean hoverAlwaysOn = true;
    private Layer targetLayer = null;
    private SelectableLayer selectionLayer = null;
    private int editMode = 0;
    private TopoChildFeatureDescriptor topoElem = null;
    private MainAppPanel mainApp = null;

    public TopoChildFeaturePickTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "topochildfeature-pick");
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        if (this.canvas == null || this.editMode != 1 && this.editMode != 2) {
            return propagate;
        }
        if (evt instanceof MouseEvent) {
            this.targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
            if (this.targetLayer == null || !this.targetLayer.isVisible() || !(this.targetLayer instanceof TopologySetLayer)) {
                return propagate;
            }
            TopologySetLayer tplayer = (TopologySetLayer)this.targetLayer;
            TopologySet set = (TopologySet)tplayer.getIndexedDataSet().getDataSet();
            TopologyMetadata metadata = set.getMetadata();
            if (metadata == null) {
                return propagate;
            }
            String topology = metadata.getTopology();
            int layerLevel = metadata.getTopoLayerLevel();
            if (layerLevel == 0) {
                return propagate;
            }
            int childLayerId = metadata.getChildLayerId();
            this.selectionLayer = null;
            for (Layer layer : this.canvas.getLayerManager()) {
                try {
                    TopologySetLayer tpl;
                    TopologySet tpset;
                    TopologyMetadata meta;
                    if (!(layer instanceof TopologySetLayer) || (meta = (tpset = (TopologySet)(tpl = (TopologySetLayer)layer).getIndexedDataSet().getDataSet()).getMetadata()) == null || !meta.getTopology().equalsIgnoreCase(topology) || meta.getTopoLayerId() != childLayerId) continue;
                    this.selectionLayer = (SelectableLayer)layer;
                    break;
                }
                catch (Throwable ex) {
                    return propagate;
                }
            }
            if (this.selectionLayer == null) {
                return propagate;
            }
            MouseEvent e = (MouseEvent)evt;
            int granularity = 0;
            int id = e.getID();
            if (id == 503) {
                TopologyGeometry tpgeom;
                GeoObject hoverShape;
                this.topoElem = null;
                List<GeoObject> hits = this.selectionLayer.hitTest(e.getX(), e.getY(), granularity);
                GeoObject geoObject = hoverShape = hits.isEmpty() ? null : hits.get(0);
                if (hoverShape != null && (tpgeom = ((TopologyFeature)hoverShape).getSpatialAttribute()) != null) {
                    this.topoElem = new TopoChildFeatureDescriptor();
                    this.topoElem.setLayerId(tpgeom.getLayerId());
                    this.topoElem.setFeatureId(tpgeom.getId());
                }
            } else if (id == 500) {
                if (this.selectionLayer != null && this.selectionLayer instanceof TopologySetLayer) {
                    ((TopologySetLayer)this.selectionLayer).clearHover();
                }
                this.processMouseClicked();
                propagate = false;
                this.finish();
            }
        }
        return propagate;
    }

    public void setEditMode(int mode) {
        this.editMode = mode;
    }

    public TopoChildFeatureDescriptor getTopoChildFeature() {
        return this.topoElem;
    }

    @Override
    public void clear() {
        this.topoElem = null;
        this.selectionLayer = null;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    private void processMouseClicked() {
        TopologyFeature tfeat;
        TopoChildFeatureDescriptor tpdesc = this.getTopoChildFeature();
        if (tpdesc == null) {
            return;
        }
        TopoChildFeatureDescriptor tpd = new TopoChildFeatureDescriptor();
        tpd.setLayerId(tpdesc.getLayerId());
        tpd.setFeatureId(tpdesc.getFeatureId());
        this.clear();
        Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer == null) {
            this.clear();
            return;
        }
        TopologySetLayer tl = (TopologySetLayer)targetLayer;
        List<GeoObject> selected = tl.getSelection();
        if (selected == null || selected.size() > 1) {
            this.clear();
            return;
        }
        String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
        if (this.getModifier().equals(ASSIGNCHILDFEATURE)) {
            TopologyFeature tfeat2 = (TopologyFeature)selected.get(0);
            String fkey = tfeat2.getAttribute(keyColumn).getValue().toString();
            try {
                tl.assignChildFeatureToFeature(fkey, tpd.getLayerId(), tpd.getFeatureId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
            }
        } else if (this.getModifier().equals(UNASSIGNCHIDLFEATURE) && selected.size() == 1 && (tfeat = (TopologyFeature)selected.get(0)) != null) {
            if (tfeat.getNumberOfChildFeatures() == 1) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Cannot remove topo child feature from a feature with just one child element.", MessagesBundle.getMessage("Warning"), 2);
            } else {
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                try {
                    tl.removeChildFeatureFromFeature(fkey, tpd.getLayerId(), tpd.getFeatureId());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 2);
                }
            }
        }
    }

    private void finish() {
        TopologyFeature tfeat;
        TopoChildFeatureDescriptor tpdesc = this.getTopoChildFeature();
        if (tpdesc == null) {
            return;
        }
        TopoChildFeatureDescriptor tpd = new TopoChildFeatureDescriptor();
        tpd.setLayerId(tpdesc.getLayerId());
        tpd.setFeatureId(tpdesc.getFeatureId());
        this.clear();
        Layer targetLayer = this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer == null) {
            this.clear();
            return;
        }
        TopologySetLayer tl = (TopologySetLayer)targetLayer;
        List<GeoObject> selected = tl.getSelection();
        if (selected == null || selected.size() > 1) {
            this.clear();
            return;
        }
        String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
        if (this.getModifier().equals(ASSIGNCHILDFEATURE)) {
            TopologyFeature tfeat2 = (TopologyFeature)selected.get(0);
            String fkey = tfeat2.getAttribute(keyColumn).getValue().toString();
            try {
                tl.assignChildFeatureToFeature(fkey, tpd.getLayerId(), tpd.getFeatureId());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
            }
        } else if (this.getModifier().equals(UNASSIGNCHIDLFEATURE) && selected.size() == 1 && (tfeat = (TopologyFeature)selected.get(0)) != null) {
            if (tfeat.getNumberOfChildFeatures() == 1) {
                JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), "Cannot remove topo child feature from a feature with just one child element.", "Warning", 2);
            } else {
                String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                try {
                    tl.removeChildFeatureFromFeature(fkey, tpd.getLayerId(), tpd.getFeatureId());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                }
            }
        }
    }
}

