/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class TextGenericAttrsPanel
extends JPanel {
    private JLabel jLabel7 = new JLabel();
    private JTextField letterSpacing = new JTextField();
    private JLabel wdspacingLabel = new JLabel();
    private JTextField wordSpacing = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel label_Filler = new JLabel();
    private JLabel textdecorLabel = new JLabel();
    private JComboBox textdecorCombo = new JComboBox();

    public TextGenericAttrsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(319, 96));
        this.setPreferredSize(new Dimension(275, 335));
        this.jLabel7.setText(MessagesBundle.getMessage("Label_letter_spacing"));
        this.letterSpacing.setText("0");
        this.letterSpacing.setToolTipText(MessagesBundle.getMessage("Tooltip_letter_spacing"));
        this.add((Component)this.label_Filler, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.letterSpacing, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.wdspacingLabel.setText(MessagesBundle.getMessage("Label_word_spacing"));
        this.add((Component)this.wdspacingLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.wordSpacing, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
        this.textdecorLabel.setText(MessagesBundle.getMessage("Label_decoration"));
        this.textdecorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextGenericAttrsPanel.this.textdecorCombo_actionPerformed(e);
            }
        });
        this.textdecorCombo.addItem("NONE");
        this.textdecorCombo.addItem("UNDERLINE");
        this.textdecorCombo.addItem("LINETHROUGH");
        this.textdecorCombo.addItem("OVERLINE");
        this.add((Component)this.textdecorLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.textdecorCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 50), 0, 0));
    }

    public void setLetterSpacing(float spacing) {
        NumberFormat nf = NumberFormat.getInstance();
        if (spacing < 0.0f) {
            this.letterSpacing.setText("0");
        } else {
            this.letterSpacing.setText(nf.format(spacing));
        }
    }

    public float getLetterSpacing() {
        String text = this.letterSpacing.getText();
        if (text == null || text.length() == 0) {
            return 0.0f;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            float spacing = nf.parse(text).floatValue();
            if (spacing < 0.0f) {
                return 0.0f;
            }
            return spacing;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void setWordSpacing(float spacing) {
        NumberFormat nf = NumberFormat.getInstance();
        if (spacing < 0.0f) {
            this.wordSpacing.setText("0");
        } else {
            this.wordSpacing.setText(nf.format(spacing));
        }
    }

    public float getWordSpacing() {
        String text = this.wordSpacing.getText();
        if (text == null || text.length() == 0) {
            return 0.0f;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            float spacing = nf.parse(text).floatValue();
            if (spacing < 0.0f) {
                return 0.0f;
            }
            return spacing;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public String getTextDecoration() {
        return this.textdecorCombo.getSelectedItem().toString();
    }

    public void setTextDecoration(String decoration) {
        if (decoration == null) {
            return;
        }
        this.textdecorCombo.setSelectedItem(decoration.toUpperCase());
    }

    private void textdecorCombo_actionPerformed(ActionEvent e) {
    }

    public void allowChanges(boolean enable) {
        this.textdecorCombo.setEnabled(enable);
        this.wordSpacing.setEnabled(enable);
        this.letterSpacing.setEnabled(enable);
    }
}

