/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.mapviewer.share.DimensionInfo;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mdeditor.ui.GeometryMetadataTableModel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.TextFieldPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.util.DataSourceMetadata;

public class TopologyMetadataPanel
extends JPanel {
    GeometryMetadataTableModel tableModel = new GeometryMetadataTableModel();
    private JTable jTable1 = new JTable(this.tableModel);
    private JScrollPane jScrollPane1 = new JScrollPane(this.jTable1);
    private JLabel tableLabel = new JLabel();
    private JTextField tableTxt = new JTextField();
    private JLabel columnLabel = new JLabel();
    private JTextField columnTxt = new JTextField();
    private JLabel sridLabel = new JLabel();
    private JTextField sridTxt = new JTextField();
    private JLabel topologyLabel = new JLabel();
    private JComboBox topologyCombo = new JComboBox();
    private JLabel topotypeLabel = new JLabel();
    private JComboBox topotypeCombo = new JComboBox();
    private JButton topoButton = new JButton();
    private JLabel dimarrayLabel = new JLabel();
    private JLabel childtableLabel = new JLabel();
    private JComboBox childtableCombo = new JComboBox();
    private AbstractDataSource dataSource = null;
    private DataSourceMetadata dsrcMetadata = null;
    private Hashtable<String, TopologyMetadata[]> topoLayers = new Hashtable();

    public TopologyMetadataPanel(AbstractDataSource dsrc) {
        this.dataSource = dsrc;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(370, 300));
        this.setPreferredSize(new Dimension(370, 300));
        this.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Metadata")));
        this.tableLabel.setText(MessagesBundle.getMessage("Label_topology_table"));
        this.columnLabel.setText(MessagesBundle.getMessage("Label_topology_column"));
        this.sridLabel.setText(MessagesBundle.getMessage("Label_srid"));
        this.topologyLabel.setText(MessagesBundle.getMessage("Label_topology"));
        this.topologyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyMetadataPanel.this.topologyCombo_actionPerformed(e);
            }
        });
        this.topotypeLabel.setText(MessagesBundle.getMessage("Label_topology_type"));
        this.topoButton.setText(MessagesBundle.getMessage("Create_topology"));
        this.topoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyMetadataPanel.this.topoButton_actionPerformed(e);
            }
        });
        this.dimarrayLabel.setText(MessagesBundle.getMessage("Dimension_array"));
        this.childtableLabel.setText(MessagesBundle.getMessage("Label_child_topology_table"));
        this.childtableCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopologyMetadataPanel.this.childtableCombo_actionPerformed(e);
            }
        });
        this.childtableCombo.addItem("N/A");
        this.topotypeCombo.addItem("POINT");
        this.topotypeCombo.addItem("LINE");
        this.topotypeCombo.addItem("POLYGON");
        this.topotypeCombo.addItem("COLLECTION");
        this.topotypeCombo.setSelectedItem("POLYGON");
        this.add((Component)this.tableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.tableTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.columnLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.columnTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.topotypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.topotypeCombo, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.sridLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.sridTxt, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.topologyLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.topologyCombo, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.topoButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.childtableLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.childtableCombo, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.dimarrayLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 7, 3, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.jTable1.setSelectionMode(0);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TopologyMetadataPanel.this.updateButtonStatus();
            }
        });
        this.jTable1.getColumnModel().getColumn(3).setCellRenderer(new NumberFormatCellRenderer());
    }

    public void setDataSource(AbstractDataSource dsrc) {
        this.dataSource = dsrc;
    }

    public void setDataSourceMetadata(DataSourceMetadata dsrcMetadata) {
        this.dsrcMetadata = dsrcMetadata;
    }

    public String getTopologyTable() {
        if (this.tableTxt.getText() == null || this.tableTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.tableTxt.getText().trim();
    }

    public void setTopologyTable(String table) {
        if (table == null) {
            return;
        }
        this.tableTxt.setText(table);
    }

    public String getTopologyColumn() {
        if (this.columnTxt.getText() == null || this.columnTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.columnTxt.getText().trim();
    }

    public void setTopologyColumn(String column) {
        if (column == null) {
            return;
        }
        this.columnTxt.setText(column);
    }

    public void setSRID(long srid) {
        NumberFormat nf = NumberFormat.getInstance();
        this.sridTxt.setText(nf.format(srid));
    }

    public long getSRID() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.sridTxt.getText()).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String getTopologyType() {
        return this.topotypeCombo.getSelectedItem().toString();
    }

    public String getTopology() {
        if (this.topologyCombo.getItemCount() == 0) {
            return null;
        }
        return this.topologyCombo.getSelectedItem().toString();
    }

    public void setTopologyNames(List<String> topologies) {
        this.topologyCombo.removeAll();
        if (topologies == null || topologies.size() == 0) {
            return;
        }
        for (int i = 0; i < topologies.size(); ++i) {
            this.topologyCombo.addItem(topologies.get(i));
        }
        this.updateTopologyLayerTables();
    }

    public void refreshTopologyTables() {
        String topology = this.getTopology();
        if (topology == null) {
            return;
        }
        this.topoLayers.remove(topology);
        this.updateTopologyLayerTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopologyLayerTables() {
        this.childtableCombo.removeAllItems();
        this.childtableCombo.addItem("N/A");
        String topology = this.getTopology();
        if (topology == null) {
            return;
        }
        TopologyMetadata[] layersMeta = this.topoLayers.get(topology);
        if (layersMeta == null) {
            if (this.dataSource == null) {
                return;
            }
            AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
            try {
                da.openConnection();
                layersMeta = da.loadTopologyLayersMetadata(topology);
                if (layersMeta != null) {
                    this.topoLayers.put(topology, layersMeta);
                }
            }
            catch (MDSException ex) {
                return;
            }
            catch (Exception ex) {
                return;
            }
            finally {
                try {
                    da.closeConnection();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        if (layersMeta != null) {
            for (int i = 0; i < layersMeta.length; ++i) {
                this.childtableCombo.addItem(layersMeta[i].getFeatureTable());
            }
        }
    }

    public String getChildTopologyTable() {
        if (this.childtableCombo.getSelectedIndex() == 0) {
            return null;
        }
        return this.childtableCombo.getSelectedItem().toString();
    }

    public void addDimension(String name, double min, double max, double tol) {
        this.tableModel.addRow(-1, name, min, max, tol);
        int count = this.tableModel.getRowCount();
        this.jTable1.setRowSelectionInterval(count - 1, count - 1);
    }

    private void adddimButton_actionPerformed(ActionEvent e) {
        this.tableModel.addRow(-1, "", 0.0, 1.0, 5.0E-6);
        int count = this.tableModel.getRowCount();
        this.jTable1.setRowSelectionInterval(count - 1, count - 1);
    }

    private void remdimButton_actionPerformed(ActionEvent e) {
        int selRow = this.jTable1.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        this.tableModel.deleteRow(selRow);
        int nrows = this.tableModel.getRowCount();
        if (nrows > 0) {
            if (selRow == nrows) {
                this.jTable1.setRowSelectionInterval(nrows - 1, nrows - 1);
            } else {
                this.jTable1.setRowSelectionInterval(selRow, selRow);
            }
        }
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
    }

    public int getNumberofDimensions() {
        return this.tableModel.getRowCount();
    }

    public String[] getDimNameValues() {
        return this.tableModel.getDimNameValues();
    }

    public double[] getMinValues() {
        return this.tableModel.getMinValues();
    }

    public double[] getMaxValues() {
        return this.tableModel.getMaxValues();
    }

    public double[] getToleranceValues() {
        return this.tableModel.getToleranceValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topoButton_actionPerformed(ActionEvent e) {
        if (this.dataSource == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_data_source"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        int srid = (int)this.getSRID();
        if (srid < 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Invalid_srid_value"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        Frame f = this.getFrameForDialog();
        TextFieldPanel txtPanel = new TextFieldPanel(MessagesBundle.getMessage("Label_topology"));
        OlafDialog d = new OlafDialog(f, MessagesBundle.getMessage("Create_topology") + " (SRID=" + srid + ")", txtPanel);
        d.setSize(new Dimension(400, 240));
        d.getHelpButton().setVisible(false);
        d.setVisible(true);
        if (!d.isCancelled()) {
            String value = txtPanel.getTextFieldValue();
            if (value == null || value.trim().length() == 0) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Undefined_topology"), MessagesBundle.getMessage("Warning"), 2);
            } else {
                this.setWaitCursor();
                String exception = null;
                AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
                try {
                    da.openConnection();
                    da.createTopology(value.trim().toUpperCase(), 5.0E-7, srid);
                }
                catch (MDSException ex) {
                    exception = ex.getDetails();
                }
                catch (Exception ex) {
                    exception = ex.getMessage();
                }
                finally {
                    try {
                        da.closeConnection();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    this.setDefaultCursor();
                }
                if (exception != null) {
                    JOptionPane.showMessageDialog(this, exception, MessagesBundle.getMessage("Error"), 0);
                } else {
                    this.topologyCombo.addItem(value.trim().toUpperCase());
                    this.topologyCombo.setSelectedItem(value.trim().toUpperCase());
                    if (this.dsrcMetadata != null) {
                        SpatialTableMetadata metaNode = new SpatialTableMetadata();
                        metaNode.setName(value.trim().toUpperCase() + "_NODE$");
                        metaNode.setType("geometry");
                        metaNode.setSpatialColumn("geometry");
                        metaNode.setSRID(srid);
                        metaNode.addDimensionInfo(new DimensionInfo("X", -180.0, 180.0, 5.0E-6));
                        metaNode.addDimensionInfo(new DimensionInfo("Y", -90.0, 90.0, 5.0E-6));
                        this.dsrcMetadata.addSpatialTableMetadata(metaNode);
                        SpatialTableMetadata metaEdge = new SpatialTableMetadata();
                        metaEdge.setName(value.trim().toUpperCase() + "_EDGE$");
                        metaEdge.setType("geometry");
                        metaEdge.setSpatialColumn("geometry");
                        metaEdge.setSRID(srid);
                        metaEdge.addDimensionInfo(new DimensionInfo("X", -180.0, 180.0, 5.0E-6));
                        metaEdge.addDimensionInfo(new DimensionInfo("Y", -90.0, 90.0, 5.0E-6));
                        this.dsrcMetadata.addSpatialTableMetadata(metaEdge);
                        SpatialTableMetadata metaFace = new SpatialTableMetadata();
                        metaFace.setName(value.trim().toUpperCase() + "_FACE$");
                        metaFace.setType("geometry");
                        metaFace.setSpatialColumn("mbr_geometry");
                        metaFace.setSRID(srid);
                        metaFace.addDimensionInfo(new DimensionInfo("X", -180.0, 180.0, 5.0E-6));
                        metaFace.addDimensionInfo(new DimensionInfo("Y", -90.0, 90.0, 5.0E-6));
                        this.dsrcMetadata.addSpatialTableMetadata(metaFace);
                    }
                }
            }
        }
        d.dispose();
    }

    private void setWaitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Frame getFrameForDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    private void topologyCombo_actionPerformed(ActionEvent e) {
        this.updateTopologyLayerTables();
    }

    private void childtableCombo_actionPerformed(ActionEvent e) {
        String childtableType = this.getChildTableType();
        if (childtableType != null) {
            this.topotypeCombo.setSelectedItem(childtableType);
        }
    }

    public String getChildTableType() {
        if (this.childtableCombo.getSelectedIndex() < 1) {
            return null;
        }
        String topology = this.getTopology();
        if (topology == null) {
            return null;
        }
        TopologyMetadata[] layers = this.topoLayers.get(topology);
        if (layers == null || layers.length == 0) {
            return null;
        }
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getFeatureTable().equalsIgnoreCase(this.childtableCombo.getSelectedItem().toString())) continue;
            return layers[i].getTopoLayerType();
        }
        return null;
    }

    public int getChildTableId() {
        if (this.childtableCombo.getSelectedIndex() < 1) {
            return -1;
        }
        String topology = this.getTopology();
        if (topology == null) {
            return -1;
        }
        TopologyMetadata[] layers = this.topoLayers.get(topology);
        if (layers == null || layers.length == 0) {
            return -1;
        }
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getFeatureTable().equalsIgnoreCase(this.childtableCombo.getSelectedItem().toString())) continue;
            return layers[i].getTopoLayerId();
        }
        return -1;
    }

    private class NumberFormatCellRenderer
    extends DefaultTableCellRenderer {
        DecimalFormat decimalFormat = new DecimalFormat("0.E0");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(this.decimalFormat.format(value));
            return this;
        }
    }
}

