/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.tools.FeatureRectangleTool;
import oracle.maps.tools.PenTool;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;

public class DrawingToolsPane
extends BasicToolsPane {
    private JToggleButton point = new JToggleButton(Icons.getIcon("createpoint_dwn.png"));
    private JToggleButton penline = new JToggleButton(Icons.getIcon("pencreateline.png"));
    private JToggleButton penpolygon = new JToggleButton(Icons.getIcon("pencreatepolygon_dwn.png"));
    private JToggleButton rectangle = new JToggleButton(Icons.getIcon("createsquarerectangle_dwn.png"));
    private JToggleButton circle = new JToggleButton(Icons.getIcon("createellipse_dwn.png"));

    public DrawingToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.point, this.penline, this.penpolygon, this.rectangle, this.circle};
        this.setName(MessagesBundle.getMessage("Drawing_tools"));
        this.point.setToolTipText(MessagesBundle.getMessage("Tooltip_draw_point"));
        this.point.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = DrawingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setModifier("penpoint");
                    penTool.setMainApp(DrawingToolsPane.this.getMainApp());
                    DrawingToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.rectangle.setToolTipText(MessagesBundle.getMessage("Tooltip_draw_rectangle"));
        this.rectangle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = DrawingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    FeatureRectangleTool rectTool = new FeatureRectangleTool(canvas);
                    rectTool.setNewGeom(FeatureRectangleTool.Rectangle);
                    rectTool.setMainApp(DrawingToolsPane.this.getMainApp());
                    DrawingToolsPane.this.getMainApp().setTool(rectTool);
                }
            }
        });
        this.circle.setToolTipText(MessagesBundle.getMessage("Tooltip_draw_circle"));
        this.circle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = DrawingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    FeatureRectangleTool rectTool = new FeatureRectangleTool(canvas);
                    rectTool.setNewGeom(FeatureRectangleTool.Circle);
                    rectTool.setMainApp(DrawingToolsPane.this.getMainApp());
                    DrawingToolsPane.this.getMainApp().setTool(rectTool);
                }
            }
        });
        this.penline.setToolTipText(MessagesBundle.getMessage("Tooltip_draw_line"));
        this.penline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = DrawingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPath(false);
                    penTool.setModifier("penline");
                    penTool.setMainApp(DrawingToolsPane.this.getMainApp());
                    DrawingToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.penpolygon.setToolTipText(MessagesBundle.getMessage("Tooltip_draw_polygon"));
        this.penpolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = DrawingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPath(true);
                    penTool.setModifier("penpolygon");
                    penTool.setMainApp(DrawingToolsPane.this.getMainApp());
                    DrawingToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        List<GeoObject> targetSelected;
        EditSession editSession = this.mainApp.getEditSessionPanel().getEditSession();
        if (editSession == null) {
            return;
        }
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null || canvas.getMapRegion() == null || canvas.getMapRegion().getDataWindow() == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer targetLayer = lm.getLayerByTag("targetLayer");
        if (!(targetLayer instanceof EditableLayer) || !((EditableLayer)targetLayer).isEditable()) {
            return;
        }
        if (targetLayer instanceof GeometrySetLayer) {
            List<GeoObject> targetSelected2 = ((GeometrySetLayer)targetLayer).getSelection();
            if (targetSelected2.size() <= 1) {
                this.point.setEnabled(true);
                this.rectangle.setEnabled(true);
                this.circle.setEnabled(true);
                this.penline.setEnabled(true);
                this.penpolygon.setEnabled(true);
            }
        } else if (targetLayer instanceof TopologyPrimitiveLayer && (targetSelected = ((TopologyPrimitiveLayer)targetLayer).getSelection()).size() == 0) {
            int type = ((TopologyPrimitiveLayer)targetLayer).getPrimitiveType();
            if (type == TopologyPrimitiveLayer.NODE_TYPE) {
                this.point.setEnabled(true);
            } else if (type == TopologyPrimitiveLayer.EDGE_TYPE) {
                this.penline.setEnabled(true);
                this.penpolygon.setEnabled(true);
            }
        }
    }
}

