/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.ui.ProgressIndicatorLayer;
import oracle.mapviewer.share.TopologyEdge;
import oracle.mapviewer.share.TopologyFace;
import oracle.mapviewer.share.TopologyNode;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.spatial.edit.index.topology.IndexedTopologyModel;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.producer.AbstractDataSetProducer;

public class TopologyPrimitivesProducer
extends AbstractDataSetProducer {
    private AbstractDataSource dataSource = null;
    private TopologyPrimitiveLayer nodesLayer = null;
    private TopologyPrimitiveLayer edgesLayer = null;
    private TopologyPrimitiveLayer facesLayer = null;
    private IndexedTopologyModel indexedModel = null;

    public TopologyPrimitivesProducer(AbstractDataSource dsrc, IndexedTopologyModel model) {
        super(null);
        this.dataSource = dsrc;
        this.indexedModel = model;
    }

    public TopologyPrimitiveLayer getNodesLayer() {
        return this.nodesLayer;
    }

    public void setNodesLayer(TopologyPrimitiveLayer ndLayer) {
        this.nodesLayer = ndLayer;
    }

    public TopologyPrimitiveLayer getEdgesLayer() {
        return this.edgesLayer;
    }

    public void setEdgesLayer(TopologyPrimitiveLayer edLayer) {
        this.edgesLayer = edLayer;
    }

    public TopologyPrimitiveLayer getFacesLayer() {
        return this.facesLayer;
    }

    public void setFacesLayer(TopologyPrimitiveLayer fcLayer) {
        this.facesLayer = fcLayer;
    }

    @Override
    protected String buildQuery(Area queryArea, int srid) {
        return null;
    }

    @Override
    protected String getSpatialType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadPrimitives(Rectangle2D queryWin, int qwSrid, Layer parentLayer) {
        if (this.indexedModel == null) {
            System.out.println(this.getClass().getSimpleName() + ": Indexed topology model is null.");
            return;
        }
        AbstractDataAccessObject dataAccess = null;
        Object prog = null;
        try {
            TopologyModel topoModel = this.indexedModel.getTopologyModel();
            if (this.dataSource != null) {
                if (this.loadedArea.isEmpty() || !this.loadedArea.contains(queryWin)) {
                    dataAccess = this.dataSource.getDataAccessObject();
                    dataAccess.openConnection();
                    String topology = topoModel.getName();
                    if (parentLayer == null) {
                        System.out.println("(" + this.getClass().getSimpleName() + ")" + ": Topology primitives query-loading: started...");
                    } else {
                        System.out.println(parentLayer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": Topology primitives query-loading: started...");
                    }
                    long t1 = System.currentTimeMillis();
                    TopologyPrimitives primitives = dataAccess.loadTopologyPrimitives(topology, queryWin, ((TopologySetLayer)parentLayer).getWorkspace());
                    if (primitives != null) {
                        TopologyFace[] faces;
                        TopologyEdge[] edges;
                        Hashtable<String, Integer> deletedNodes = topoModel.getDeletedNodes();
                        Hashtable<String, Integer> deletedEdges = topoModel.getDeletedEdges();
                        Hashtable<String, Integer> deletedFaces = topoModel.getDeletedFaces();
                        TopologyNode[] nodes = primitives.getNodes();
                        if (nodes != null) {
                            for (int i = 0; i < nodes.length; ++i) {
                                int id = nodes[i].getId();
                                if (topoModel.getNode(id) != null || deletedNodes != null && deletedNodes.get("" + id) != null) continue;
                                topoModel.insertNode(nodes[i]);
                            }
                        }
                        if ((edges = primitives.getEdges()) != null) {
                            for (int i = 0; i < edges.length; ++i) {
                                int id = edges[i].getId();
                                if (topoModel.getEdge(id) != null || deletedEdges != null && deletedEdges.get("" + id) != null) continue;
                                topoModel.insertEdge(edges[i]);
                            }
                        }
                        if ((faces = primitives.getFaces()) != null) {
                            for (int i = 0; i < faces.length; ++i) {
                                int id = faces[i].getId();
                                if (topoModel.getFace(id) != null || deletedFaces != null && deletedFaces.get("" + id) != null) continue;
                                topoModel.insertFace(faces[i]);
                            }
                        }
                    }
                    long t2 = System.currentTimeMillis();
                    if (parentLayer == null) {
                        System.out.println("(" + this.getClass().getSimpleName() + ")" + ": Topology primitives loading: finished after " + (t2 - t1) + " ms.");
                    } else {
                        System.out.println(parentLayer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": Topology primitives loading: finished after " + (t2 - t1) + " ms.");
                    }
                    this.loadedArea.add(new Area(queryWin));
                } else if (parentLayer == null) {
                    System.out.println("(" + this.getClass().getSimpleName() + ")" + ": Topology primitives area already loaded.");
                } else {
                    System.out.println(parentLayer.getName() + "(" + this.getClass().getSimpleName() + ")" + ": Topology primitives area already loaded.");
                }
            }
            if (this.nodesLayer != null) {
                this.nodesLayer.onDataReady(this);
            }
            if (this.edgesLayer != null) {
                this.edgesLayer.onDataReady(this);
            }
            if (this.facesLayer != null) {
                this.facesLayer.onDataReady(this);
            }
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception ex) {}
            }
        }
    }

    private class DataGetterThread
    extends Thread {
        private TopologyPrimitivesProducer parentProducer = null;
        private Rectangle2D queryWindow = null;
        private Layer parentLayer = null;

        public DataGetterThread(Rectangle2D queryWindow, TopologyPrimitivesProducer parentProducer, Layer parentLayer) {
            this.parentProducer = parentProducer;
            this.queryWindow = (Rectangle2D)queryWindow.clone();
            this.parentLayer = parentLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TopologyPrimitivesProducer topologyPrimitivesProducer = this.parentProducer;
            synchronized (topologyPrimitivesProducer) {
                Object dataAccess = null;
                ProgressIndicatorLayer prog = null;
                MapCanvas canvas = null;
                if (TopologyPrimitivesProducer.this.nodesLayer != null) {
                    canvas = TopologyPrimitivesProducer.this.nodesLayer.getCanvas();
                }
                if (canvas == null && TopologyPrimitivesProducer.this.edgesLayer != null) {
                    canvas = TopologyPrimitivesProducer.this.edgesLayer.getCanvas();
                }
                if (canvas == null && TopologyPrimitivesProducer.this.facesLayer != null) {
                    canvas = TopologyPrimitivesProducer.this.facesLayer.getCanvas();
                }
                if (canvas != null) {
                    prog = canvas.getProgressIndicator();
                }
                if (prog != null) {
                    prog.taskStarted();
                }
                this.parentProducer.loadPrimitives(this.queryWindow, 0, this.parentLayer);
                if (prog != null) {
                    prog.taskCompleted();
                }
            }
        }
    }
}

