/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.session;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.ui.FeatureTipLayer;
import oracle.maps.layer.ui.ManipulatorLayer;
import oracle.maps.layer.ui.MapNavLayer;
import oracle.maps.layer.ui.PointerLocationLayer;
import oracle.maps.layer.ui.ScaleBarLayer;
import oracle.maps.layer.ui.SimpleBGLayer;
import oracle.maps.tools.FeaturePickTool;
import oracle.maps.tools.configurable.DrawToolsConfigurable;
import oracle.maps.tools.configurable.FeatureSelectionConfigurable;
import oracle.maps.tools.configurable.VertexToolsConfigurable;
import oracle.maps.util.PropertySupportObject;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.EditorAppletInfo;
import oracle.mdeditor.MapConstants;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.EditSessionProvider;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.CreateSessionPanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.ui.MVServerConnectionPanel;
import oracle.spatial.edit.util.MVConnection;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MDSEditSessionProvider
implements EditSessionProvider {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected MainAppPanel mainApp = null;
    protected ArrayList<MVConnection> connections = null;
    protected EmptyNonLeaf rootNode = new EmptyNonLeaf(this);
    protected static final String ADDCONNECTION = MessagesBundle.getMessage("Connect_to_server");
    protected static final String NEWSESSION = MessagesBundle.getMessage("Create_edit_session");

    public MDSEditSessionProvider(MainAppPanel mainApp) {
        this(mainApp, new ArrayList<MVConnection>());
    }

    public MDSEditSessionProvider(MainAppPanel mainApp, ArrayList<MVConnection> connections) {
        this.mainApp = mainApp;
        this.connections = connections;
    }

    @Override
    public String getProviderName() {
        return "MapViewer sessions";
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EditSession getEditorObject(TreePath selectionPath) {
        MDSEditSession ed;
        Hashtable<String, MDSEditSession> cache;
        block47: {
            AbstractDataSource dataSource;
            String sessionName;
            block46: {
                DefaultMutableTreeNode sessionNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                DefaultMutableTreeNode dsNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(selectionPath.getPathCount() - 2);
                sessionName = (String)sessionNode.getUserObject();
                MVConnection.DataSource ds = (MVConnection.DataSource)dsNode.getUserObject();
                dataSource = ds.getDataSource();
                cache = null;
                try {
                    cache = ds.getEditSessions();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (cache == null || dataSource == null) {
                    return null;
                }
                ed = null;
                ed = cache.get(sessionName);
                if (ed == null) break block46;
                if (ed != MVConnection.DataSource.NULLSESSIONMARKER) break block47;
            }
            String definitionXML = "";
            AbstractDataAccessObject dao = dataSource.getDataAccessObject();
            StringReader reader = null;
            Throwable exception = null;
            try {
                log.info("Getting edit session definition [" + sessionName + "] ...");
                dao.openConnection();
                definitionXML = dao.getEditSession(sessionName);
                log.info("End getting session definition [" + sessionName + "].");
            }
            catch (MDSException ex) {
                exception = ex;
            }
            catch (Exception ex) {
                exception = ex;
            }
            finally {
                if (dao != null) {
                    try {
                        dao.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    reader.close();
                }
            }
            if (exception != null) {
                ErrorDialog.showErrorDialog(exception, this.mainApp.getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_toload_edit_session", sessionName), MessagesBundle.getMessage("Error"), 0);
                return null;
            }
            if ("<session_definition/>".equals(definitionXML.trim())) {
                ed = this.getDefaultEditSession(dataSource, sessionName, "", false);
                log.info("Default edit session loaded.");
            } else {
                Element sessionElem = null;
                try {
                    DOMParser parser = new DOMParser();
                    parser.setValidationMode(0);
                    parser.setPreserveWhitespace(false);
                    reader = new StringReader(definitionXML);
                    parser.parse((Reader)reader);
                    XMLDocument sessionDoc = parser.getDocument();
                    sessionElem = sessionDoc.getDocumentElement();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (SAXException ex) {
                    ex.printStackTrace();
                }
                if (sessionElem != null) {
                    Element lmNode;
                    NodeList entryNodeList;
                    Properties p;
                    Properties props = new Properties();
                    NodeList propsNodeList = sessionElem.getElementsByTagName("properties");
                    if (propsNodeList != null && propsNodeList.getLength() > 0) {
                        try {
                            PropertySupportObject.fromXMLElement((XMLElement)propsNodeList.item(0), props);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (!sessionName.equals(props.getProperty("oracle.mdeditor.session.EditSession.name"))) {
                        props.setProperty("oracle.mdeditor.session.EditSession.name", sessionName);
                    }
                    log.info("Edit session to be created [" + sessionName + "].");
                    ed = new MDSEditSession(dataSource, this.mainApp.getFrameForDialog(), props);
                    String proxyHost = ed.getProperty("oracle.spatial.edit.session.MDSEditSession.proxyhost");
                    String proxyPort = ed.getProperty("oracle.spatial.edit.session.MDSEditSession.proxyport");
                    if (proxyHost != null && !proxyHost.equalsIgnoreCase("null") && proxyPort != null && !proxyPort.equalsIgnoreCase("null")) {
                        p = new Properties(System.getProperties());
                        p.put("proxySet", "true");
                        p.put("proxyHost", proxyHost);
                        p.put("proxyPort", proxyPort);
                    } else {
                        p = new Properties(System.getProperties());
                        p.remove("proxySet");
                        p.remove("proxyHost");
                        p.remove("proxyPort");
                    }
                    NodeList lmNodeList = sessionElem.getElementsByTagName("layerManager");
                    if (lmNodeList != null && lmNodeList.getLength() > 0 && (entryNodeList = (lmNode = (Element)lmNodeList.item(0)).getElementsByTagName("entry")) != null) {
                        LayerEntry[] layers = new LayerEntry[entryNodeList.getLength()];
                        for (int i = 0; i < entryNodeList.getLength(); ++i) {
                            Element layerElem;
                            Layer layer;
                            Element entryElem = (Element)entryNodeList.item(i);
                            NodeList layerNodeList = entryElem.getElementsByTagName("layer");
                            if (layerNodeList == null || layerNodeList.getLength() <= 0) continue;
                            LayerProvider prov = null;
                            String providerID = entryElem.getAttribute("providerID");
                            if (providerID == null || providerID.trim().isEmpty()) {
                                providerID = "oracle.mdeditor.defaultLayerProvider";
                            }
                            if ((prov = this.mainApp.getLayerProviders().get(providerID)) == null || (layer = prov.createLayer(layerElem = (Element)layerNodeList.item(0))) == null) continue;
                            LayerEntry le = new LayerEntry();
                            le.layer = layer;
                            le.position = Integer.parseInt(entryElem.getAttribute("position"));
                            NodeList tagNodeList = entryElem.getElementsByTagName("tag");
                            if (tagNodeList != null && tagNodeList.getLength() > 0) {
                                ArrayList<String> tagList = new ArrayList<String>();
                                for (int j = 0; j < tagNodeList.getLength(); ++j) {
                                    String cTag = tagNodeList.item(j).getTextContent();
                                    if (cTag.equals("selectionLayer")) continue;
                                    tagList.add(cTag);
                                }
                                le.tags = tagList.toArray(new String[tagList.size()]);
                            }
                            int order = Integer.parseInt(entryElem.getAttribute("order"));
                            layers[order] = le;
                        }
                        for (LayerEntry e : layers) {
                            if (e == null) continue;
                            log.finest("Adding layer [" + e.layer.getName() + "] to session ...");
                            ed.addLayer(e.layer, e.position, e.tags);
                            log.finest("Layer [" + e.layer.getName() + "] added.");
                        }
                    }
                }
            }
        }
        if (ed != null) {
            LayerManager lm = ed.getLayers();
            Rectangle2D area = ed.getArea();
            if (area == null) {
                Layer l;
                Iterator<Layer> itr = lm.iterator();
                while (itr.hasNext() && (area = (l = itr.next()).getFullExtent()) == null) {
                }
            }
            if (area != null) {
                ed.getMapCanvas().getMapRegion().setDataWindow(area);
            }
            Layer oldTool = lm.getLayerByTag("toolLayer");
            lm.remove(oldTool);
            FeaturePickTool pickTool = new FeaturePickTool(ed.getMapCanvas());
            lm.add(pickTool, MapConstants.POSITION_OVERDATA_LAYERS);
            lm.tag((Layer)pickTool, "toolLayer");
            cache.put(ed.getName(), ed);
        }
        return ed;
    }

    @Override
    public EditSession removeEditorObject(TreePath selectionPath) {
        DefaultMutableTreeNode sessionNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode dsNode = (DefaultMutableTreeNode)selectionPath.getPathComponent(selectionPath.getPathCount() - 2);
        String sessionName = (String)sessionNode.getUserObject();
        MVConnection.DataSource ds = (MVConnection.DataSource)dsNode.getUserObject();
        Hashtable<String, MDSEditSession> cache = null;
        try {
            cache = ds.getEditSessions();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (cache == null) {
            return null;
        }
        EditSession session = cache.remove(sessionName);
        return session;
    }

    @Override
    public DefaultMutableTreeNode getProviderRootNode() {
        return this.rootNode;
    }

    private MDSEditSession getDefaultEditSession(AbstractDataSource dataSource, String name, String description, boolean versionEnabled) {
        MDSEditSession ed = new MDSEditSession(dataSource, this.mainApp.getFrameForDialog(), null);
        ed.setName(name);
        ed.setVersioned(versionEnabled);
        if (description != null) {
            ed.setDescription(description);
        }
        MapCanvas canvas = ed.getMapCanvas();
        LayerManager layerManager = canvas.getLayerManager();
        FeatureSelectionConfigurable featureSelectionConfig = new FeatureSelectionConfigurable(canvas);
        layerManager.add(featureSelectionConfig, MapConstants.POSITION_BACKGROUND_LAYERS);
        layerManager.tag((Layer)featureSelectionConfig, new String[]{"controlLayer", "featureSelectionConfigLayer"});
        DrawToolsConfigurable drawToolsConfig = new DrawToolsConfigurable(canvas);
        layerManager.add(drawToolsConfig, MapConstants.POSITION_BACKGROUND_LAYERS);
        layerManager.tag((Layer)drawToolsConfig, new String[]{"controlLayer", "drawingToolsConfigLayer"});
        VertexToolsConfigurable vertexToolsConfig = new VertexToolsConfigurable(canvas);
        layerManager.add(vertexToolsConfig, MapConstants.POSITION_BACKGROUND_LAYERS);
        layerManager.tag((Layer)vertexToolsConfig, new String[]{"controlLayer", "vertexToolsConfigLayer"});
        SimpleBGLayer simpleBGLayer = new SimpleBGLayer(canvas);
        layerManager.add(simpleBGLayer, MapConstants.POSITION_BACKGROUND_LAYERS);
        layerManager.tag((Layer)simpleBGLayer, new String[]{"controlLayer", "backgroundLayer"});
        ScaleBarLayer scaleLayer = new ScaleBarLayer(canvas);
        layerManager.add(scaleLayer, MapConstants.POSITION_OVERDATA_LAYERS);
        layerManager.tag((Layer)scaleLayer, new String[]{"controlLayer", "scaleBarLayer"});
        ManipulatorLayer manipLayer = new ManipulatorLayer(canvas);
        layerManager.add(manipLayer, MapConstants.POSITION_OVERHEAD_LAYERS);
        layerManager.tag((Layer)manipLayer, new String[]{"controlLayer", "manipulatorLayer"});
        MapNavLayer mapNavLayer = new MapNavLayer(canvas);
        layerManager.add(mapNavLayer, MapConstants.POSITION_OVERHEAD_LAYERS);
        layerManager.tag((Layer)mapNavLayer, new String[]{"controlLayer", "mapNavigationLayer"});
        PointerLocationLayer pointerLayer = new PointerLocationLayer(canvas);
        layerManager.add(pointerLayer, MapConstants.POSITION_OVERHEAD_LAYERS);
        layerManager.tag((Layer)pointerLayer, new String[]{"controlLayer", "pointerLocationLayer"});
        FeatureTipLayer tipLayer = new FeatureTipLayer(canvas);
        layerManager.add(tipLayer, MapConstants.POSITION_OVERHEAD_LAYERS);
        layerManager.tag((Layer)tipLayer, new String[]{"controlLayer", "featureTipLayer"});
        return ed;
    }

    @Override
    public TreeCellRenderer getTreeCellRenderer() {
        return new MyTreeCellRenderer();
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener() {
        return new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
                Object uo = tn.getUserObject();
                int limit = 2;
                if (uo instanceof MVConnection) {
                    limit = 1;
                }
                if (tn.getChildCount() == limit) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)tn.getChildAt(0);
                    ((JTree)evt.getSource()).expandPath(new TreePath(child.getPath()));
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
            }
        };
    }

    @Override
    public TreeWillExpandListener getTreeWillExpandListener() {
        return new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                MDSEditSessionProvider.this.populate(evt);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) {
            }
        };
    }

    private void populate(TreeExpansionEvent evt) throws ExpandVetoException {
        JTree tree = (JTree)evt.getSource();
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        EmptyNonLeaf root = (EmptyNonLeaf)evt.getPath().getLastPathComponent();
        Object obj = root.getUserObject();
        if (obj == this) {
            this.rootNode.add(new DefaultMutableTreeNode(ADDCONNECTION));
            EditorAppletInfo bean = this.mainApp.getContextBean();
            if (bean != null) {
                this.addConnection(this.rootNode, tree, bean.getMapViewerBaseUrl(), bean.getUserName());
            }
            for (MVConnection conn : this.connections) {
                this.rootNode.add(new EmptyNonLeaf(conn));
            }
        } else if (obj instanceof MVConnection.DataSource) {
            MVConnection.DataSource ds = (MVConnection.DataSource)obj;
            if (root.getChildCount() == 0) {
                new GetEditSessionsWorker(ds, root, tree).execute();
                throw new ExpandVetoException(evt);
            }
            Object eds = null;
        }
    }

    @Override
    public TreeSelectionListener getTreeSelectionListener() {
        return new TreeSelectionListener(){
            boolean supressEvent = false;

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreePath newSel = evt.getNewLeadSelectionPath();
                if (!this.supressEvent && newSel != null && newSel.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)newSel.getLastPathComponent();
                    Object obj = node.getUserObject();
                    if (node instanceof EmptyNonLeaf || ADDCONNECTION == obj || NEWSESSION == obj) {
                        TreeSelectionModel selModel = ((JTree)evt.getSource()).getSelectionModel();
                        if (ADDCONNECTION == obj) {
                            MDSEditSessionProvider.this.addConnection((DefaultMutableTreeNode)newSel.getPathComponent(newSel.getPathCount() - 2), (JTree)evt.getSource(), null, null);
                        } else if (NEWSESSION == obj) {
                            MDSEditSessionProvider.this.createEditSession(newSel, (JTree)evt.getSource());
                        }
                        this.supressEvent = true;
                        selModel.removeSelectionPath(newSel);
                        this.supressEvent = false;
                    }
                }
            }
        };
    }

    private void addConnection(DefaultMutableTreeNode root, JTree tree, String serverURL, String editor) {
        String jSessionID;
        block16: {
            String authUser = null;
            String authPwd = null;
            if (serverURL == null || editor == null || editor.equalsIgnoreCase("null")) {
                String baseURL = serverURL;
                String userName = editor;
                EditorAppletInfo bean = this.mainApp.getContextBean();
                if (bean != null) {
                    baseURL = bean.getMapViewerBaseUrl();
                    userName = bean.getUserName();
                }
                MVServerConnectionPanel connPanel = new MVServerConnectionPanel(baseURL, userName);
                OlafDialog connDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Select_data_source"), connPanel);
                connDlg.getHelpButton().setVisible(false);
                connDlg.setVisible(true);
                if (connDlg.isCancelled()) {
                    return;
                }
                serverURL = connPanel.getMapViewerServer();
                editor = connPanel.getEditorName();
                authUser = connPanel.getUser();
                authPwd = connPanel.getPassword();
            }
            if (serverURL == null || serverURL.trim().isEmpty()) {
                ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            if (editor == null || editor.trim().isEmpty()) {
                ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_editor_name"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            URL url = null;
            jSessionID = null;
            HttpURLConnection connection = null;
            try {
                if (authUser == null || authPwd == null) {
                    url = new URL(serverURL);
                    break block16;
                }
                url = serverURL.endsWith("/") ? new URL(serverURL + "dataserver/j_security_check?j_username=" + authUser + "&j_password=" + authPwd) : new URL(serverURL + "/dataserver/j_security_check?j_username=" + authUser + "&j_password=" + authPwd);
                connection = (HttpURLConnection)url.openConnection();
                int idx = -1;
                int connResponse = connection.getResponseCode();
                if (connResponse == 200) {
                    if (connection.getHeaderField("Set-Cookie") != null) {
                        jSessionID = connection.getHeaderField("Set-Cookie").split(";", 2)[0];
                        if (jSessionID != null) {
                            jSessionID = jSessionID.replace("JSESSIONID=", "");
                        }
                    } else {
                        String urlString = connection.getURL().toString();
                        if (urlString != null) {
                            idx = urlString.indexOf("jsessionid");
                        }
                        if (idx > -1) {
                            jSessionID = urlString.substring(idx + 11);
                        }
                    }
                    break block16;
                }
                ErrorDialog.showErrorDialog(new Exception("Unauthorized code: " + connResponse), this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            catch (MalformedURLException ex) {
                ErrorDialog.showErrorDialog(ex, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
            catch (IOException ioex) {
                ErrorDialog.showErrorDialog(ioex, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_server"), MessagesBundle.getMessage("Error"), 0);
                return;
            }
        }
        for (MVConnection c : this.connections) {
            if (!serverURL.equalsIgnoreCase(c.getServerURL()) || !editor.equalsIgnoreCase(c.getEditor())) continue;
            ErrorDialog.showErrorDialog(null, this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Connection_exists"), MessagesBundle.getMessage("Error"), 0);
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        EmptyNonLeaf placeHolderNode = new EmptyNonLeaf("");
        placeHolderNode.setWorking(true);
        model.insertNodeInto(placeHolderNode, root, 1);
        MVConnection conn = new MVConnection(serverURL, editor, this.mainApp, jSessionID);
        new GetDataSourcesWorker(conn, placeHolderNode, tree).execute();
    }

    private void createEditSession(TreePath path, JTree tree) {
        CreateSessionPanel txtPanel = new CreateSessionPanel();
        OlafDialog txtDlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Create_edit_session"), txtPanel);
        txtDlg.setSize(300, 200);
        txtDlg.setVisible(true);
        txtDlg.dispose();
        if (txtDlg.isCancelled()) {
            return;
        }
        String name = txtPanel.getSessionName();
        if (name == null || name.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_session_name"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        name = name.toUpperCase();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 2);
        MVConnection.DataSource ds = (MVConnection.DataSource)root.getUserObject();
        Hashtable<String, MDSEditSession> cache = null;
        try {
            cache = ds.getEditSessions();
        }
        catch (Exception ex) {
            return;
        }
        if (cache.containsKey(name)) {
            JOptionPane.showMessageDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getFormattedMessage("Session_already_exists", name), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        AbstractDataSource dataSource = ds.getDataSource();
        if (dataSource == null) {
            return;
        }
        String description = txtPanel.getDescription();
        boolean versionEnabled = txtPanel.isVersionEnabled();
        MDSEditSession ed = this.getDefaultEditSession(dataSource, name, description, versionEnabled);
        EmptyNonLeaf placeHolderNode = new EmptyNonLeaf("");
        placeHolderNode.setWorking(true);
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.insertNodeInto(placeHolderNode, root, 1);
        new CreateSessionOnServerWorker(dataSource, ed, cache, tree, root, placeHolderNode).execute();
    }

    @Override
    public MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 3) {
                    JTree tree = (JTree)e.getSource();
                    TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (obj instanceof MVConnection) {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem mi = new JMenuItem(MessagesBundle.getMessage("Refresh_connection"));
                        mi.addActionListener(new ConnectionActionListener(1, (MVConnection)obj, tree, path));
                        menu.add(mi);
                        mi = new JMenuItem(MessagesBundle.getMessage("Remove_connection"));
                        mi.addActionListener(new ConnectionActionListener(2, (MVConnection)obj, tree, path));
                        menu.add(mi);
                        menu.show(tree, e.getX(), e.getY());
                    } else if (!(obj instanceof String) || obj == NEWSESSION || obj != ADDCONNECTION) {
                        // empty if block
                    }
                }
            }
        };
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public MouseWheelListener getMouseWheelListener() {
        return null;
    }

    private class LayerEntry {
        public Layer layer;
        public Integer position;
        public String[] tags;

        private LayerEntry() {
        }
    }

    private class ConnectionActionListener
    implements ActionListener {
        public static final int REFRESH = 1;
        public static final int REMOVE = 2;
        private int action = -1;
        private MVConnection connection = null;
        private JTree tree = null;
        private TreePath path = null;

        public ConnectionActionListener(int action, MVConnection connection, JTree tree, TreePath path) {
            this.action = action;
            this.connection = connection;
            this.tree = tree;
            this.path = path;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MDSEditSessionProvider.this.connections.remove(this.connection);
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            MutableTreeNode node = (MutableTreeNode)this.path.getLastPathComponent();
            model.removeNodeFromParent(node);
            if (this.action == 1) {
                EmptyNonLeaf placeHolderNode = new EmptyNonLeaf("");
                placeHolderNode.setWorking(true);
                model.insertNodeInto(placeHolderNode, MDSEditSessionProvider.this.rootNode, 1);
                MVConnection conn = new MVConnection(this.connection.getServerURL(), this.connection.getEditor(), MDSEditSessionProvider.this.mainApp, this.connection.getJSessionID());
                new GetDataSourcesWorker(conn, placeHolderNode, this.tree).execute();
            }
        }
    }

    private class CreateSessionOnServerWorker
    extends SwingWorker {
        private AbstractDataSource dataSource = null;
        private MDSEditSession ed = null;
        private Hashtable<String, MDSEditSession> cache = null;
        private JTree tree = null;
        private DefaultMutableTreeNode root = null;
        private TreeNode placeHolder = null;

        public CreateSessionOnServerWorker(AbstractDataSource dataSource, MDSEditSession ed, Hashtable<String, MDSEditSession> cache, JTree tree, DefaultMutableTreeNode root, TreeNode placeHolder) {
            this.dataSource = dataSource;
            this.ed = ed;
            this.cache = cache;
            this.tree = tree;
            this.root = root;
            this.placeHolder = placeHolder;
        }

        public Object doInBackground() {
            boolean success = false;
            Throwable exception = null;
            AbstractDataAccessObject dao = this.dataSource.getDataAccessObject();
            try {
                log.info("Creating edit session on server ...");
                dao.openConnection();
                if (dao.createEditSession(this.ed.getName(), this.ed.getDescription(), this.ed.isVersioned()) && !(success = dao.updateEditSession(this.ed))) {
                    dao.removeEditSession(this.ed.getName());
                }
                log.info("Done with creating edit session on server.");
            }
            catch (MDSException ex) {
                exception = ex;
            }
            catch (Exception ex) {
                exception = ex;
            }
            if (exception != null) {
                log.severe("Exception: " + exception.getMessage());
            }
            if (!success || exception != null) {
                ErrorDialog.showErrorDialog(exception, MDSEditSessionProvider.this.mainApp.getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_tocreate_session", this.ed.getName()), MessagesBundle.getMessage("Warning"), 0);
                this.ed = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)CreateSessionOnServerWorker.this.tree.getModel();
                    TreeSelectionModel selModel = CreateSessionOnServerWorker.this.tree.getSelectionModel();
                    int idx = CreateSessionOnServerWorker.this.root.getIndex(CreateSessionOnServerWorker.this.placeHolder);
                    model.removeNodeFromParent((MutableTreeNode)CreateSessionOnServerWorker.this.root.getChildAt(idx));
                    if (CreateSessionOnServerWorker.this.ed != null) {
                        CreateSessionOnServerWorker.this.cache.put(CreateSessionOnServerWorker.this.ed.getName(), CreateSessionOnServerWorker.this.ed);
                        DefaultMutableTreeNode sessionNode = new DefaultMutableTreeNode(CreateSessionOnServerWorker.this.ed.getName());
                        model.insertNodeInto(sessionNode, CreateSessionOnServerWorker.this.root, idx);
                        selModel.addSelectionPath(new TreePath(sessionNode.getPath()));
                    }
                }
            });
            return null;
        }
    }

    private class GetDataSourcesWorker
    extends SwingWorker {
        private MVConnection conn = null;
        private JTree tree = null;
        private EmptyNonLeaf placeHolder = null;
        private ArrayList<MVConnection.DataSource> dataSources = null;
        private EmptyNonLeaf connRoot = null;

        public GetDataSourcesWorker(MVConnection conn, EmptyNonLeaf placeHolder, JTree tree) {
            this.conn = conn;
            this.tree = tree;
            this.placeHolder = placeHolder;
        }

        public Object doInBackground() {
            Exception exception = null;
            try {
                log.info("Loading data sources ...");
                this.dataSources = this.conn.getDataSources();
                if (this.dataSources != null && this.dataSources.size() > 0) {
                    MDSEditSessionProvider.this.connections.add(this.conn);
                    this.connRoot = new EmptyNonLeaf(this.conn);
                    for (MVConnection.DataSource dataSource : this.dataSources) {
                        EmptyNonLeaf dsNode = new EmptyNonLeaf(dataSource);
                        this.connRoot.add(dsNode);
                    }
                }
                log.info("Done with loading data sources.");
            }
            catch (Exception ex) {
                log.severe("Exception: " + ex.getMessage());
                exception = ex;
            }
            if (this.connRoot == null) {
                ErrorDialog.showErrorDialog(exception, MDSEditSessionProvider.this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Undefined_editable_datasources"), MessagesBundle.getMessage("Error"), 0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetDataSourcesWorker.this.tree.getModel();
                    int idx = MDSEditSessionProvider.this.rootNode.getIndex(GetDataSourcesWorker.this.placeHolder);
                    model.removeNodeFromParent((MutableTreeNode)MDSEditSessionProvider.this.rootNode.getChildAt(idx));
                    if (GetDataSourcesWorker.this.connRoot != null) {
                        model.insertNodeInto(GetDataSourcesWorker.this.connRoot, MDSEditSessionProvider.this.rootNode, idx);
                        GetDataSourcesWorker.this.tree.expandPath(new TreePath(GetDataSourcesWorker.this.connRoot.getPath()));
                    }
                }
            });
            return null;
        }
    }

    private class GetEditSessionsWorker
    extends SwingWorker {
        private MVConnection.DataSource ds = null;
        private EmptyNonLeaf root = null;
        private JTree tree = null;
        private Hashtable<String, MDSEditSession> editSessions = null;

        public GetEditSessionsWorker(MVConnection.DataSource ds, EmptyNonLeaf root, JTree tree) {
            this.ds = ds;
            this.root = root;
            this.tree = tree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInBackground() {
            try {
                log.info("Loading edit sessions ...");
                this.root.setWorking(true);
                this.editSessions = this.ds.getEditSessions();
            }
            catch (Exception ex) {
                log.severe("Exception: " + ex.getMessage());
                ErrorDialog.showErrorDialog(ex, MDSEditSessionProvider.this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Unable_toload_editor_sessions"), MessagesBundle.getMessage("Error"), 0);
                Object var2_2 = null;
                return var2_2;
            }
            finally {
                this.root.setWorking(false);
                this.tree.repaint();
                log.info("Done with loading edit sessions.");
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultTreeModel model = (DefaultTreeModel)GetEditSessionsWorker.this.tree.getModel();
                    model.insertNodeInto(new DefaultMutableTreeNode(NEWSESSION), GetEditSessionsWorker.this.root, GetEditSessionsWorker.this.root.getChildCount());
                    if (GetEditSessionsWorker.this.editSessions != null) {
                        for (String sessionName : GetEditSessionsWorker.this.editSessions.keySet()) {
                            DefaultMutableTreeNode sessionNode = new DefaultMutableTreeNode(sessionName);
                            model.insertNodeInto(sessionNode, GetEditSessionsWorker.this.root, GetEditSessionsWorker.this.root.getChildCount());
                        }
                    }
                }
            });
            return null;
        }
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            String txt = "";
            ImageIcon icon = null;
            if (value instanceof EmptyNonLeaf && ((EmptyNonLeaf)value).isWorking()) {
                txt = "Working...";
                icon = Icons.getIcon("refresh.png");
            } else if (obj instanceof MDSEditSessionProvider) {
                txt = ((MDSEditSessionProvider)obj).getProviderName();
            } else if (obj instanceof MVConnection) {
                MVConnection conn = (MVConnection)obj;
                txt = conn.getEditor() + "@" + conn.getServerURL();
                icon = Icons.getIcon("db_connected.png");
            } else if (obj instanceof MVConnection.DataSource) {
                txt = ((MVConnection.DataSource)obj).getName().toUpperCase();
                icon = Icons.getIcon("dbuser.gif");
            } else if (obj instanceof MDSEditSession) {
                txt = ((MDSEditSession)obj).getName();
            } else if (obj != null) {
                if (ADDCONNECTION == obj) {
                    icon = Icons.getIcon("connect_ena.png");
                } else if (NEWSESSION == obj) {
                    icon = Icons.getIcon("add_sm_ena.png");
                }
                txt = obj.toString();
            }
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, txt, selected, expanded, leaf, row, hasFocus);
            if (icon != null) {
                label.setIcon(icon);
            }
            return label;
        }
    }

    private class EmptyNonLeaf
    extends DefaultMutableTreeNode {
        private boolean working;

        public EmptyNonLeaf(Object userObject) {
            super(userObject);
            this.working = false;
        }

        @Override
        public boolean isLeaf() {
            return this.isWorking();
        }

        public void setWorking(boolean working) {
            this.working = working;
        }

        public boolean isWorking() {
            return this.working;
        }
    }
}

